/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.rate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.util.BDUtil;

public class IndirectRateCalculator
implements IRateCalculator {
    @Override
    public BigDecimal calRate(BigDecimal oriAmount, BigDecimal locAmount, int precision) {
        boolean nonNull = BDUtil.checkArgumentNonNull(oriAmount, locAmount);
        if (nonNull) {
            if (locAmount.signum() == 0) {
                return BigDecimal.ZERO;
            }
            return oriAmount.divide(locAmount, precision, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public BigDecimal calOriAmount(BigDecimal rate, BigDecimal locAmount, int oriPrecision) {
        boolean nonNull = BDUtil.checkArgumentNonNull(rate, locAmount);
        if (nonNull) {
            return locAmount.multiply(rate).setScale(oriPrecision, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public BigDecimal calLocAmount(BigDecimal rate, BigDecimal oriAmount, int locPrecision) {
        boolean nonNull = BDUtil.checkArgumentNonNull(rate, oriAmount);
        if (nonNull) {
            if (rate.signum() == 0) {
                return BigDecimal.ZERO;
            }
            return oriAmount.divide(rate, locPrecision, RoundingMode.HALF_UP);
        }
        return null;
    }
}

