/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.rate;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PrecisionConfigs {
    private boolean enablePrecisionControl;
    private Integer defaultPrecision;
    private Table<Long, Long, Integer> configTable;

    public static PrecisionConfigs empty() {
        PrecisionConfigs configs = new PrecisionConfigs();
        configs.setEnablePrecisionControl(false);
        return configs;
    }

    public boolean isEnablePrecisionControl() {
        return this.enablePrecisionControl;
    }

    public void setEnablePrecisionControl(boolean enablePrecisionControl) {
        this.enablePrecisionControl = enablePrecisionControl;
    }

    public Integer getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public void setDefaultPrecision(Integer defaultPrecision) {
        this.defaultPrecision = defaultPrecision;
    }

    public Table<Long, Long, Integer> getConfigTable() {
        return this.configTable;
    }

    public void setConfigTable(Table<Long, Long, Integer> configTable) {
        this.configTable = configTable;
    }

    public Optional<Integer> findPrecisionConfig(Long originalCurrencyId, Long targetCurrencyId) {
        if (originalCurrencyId == null || targetCurrencyId == null || !this.isEnablePrecisionControl()) {
            return Optional.empty();
        }
        if (this.getConfigTable() == null || this.getConfigTable().isEmpty()) {
            return Optional.ofNullable(this.getDefaultPrecision());
        }
        Integer precision = (Integer)this.getConfigTable().get((Object)originalCurrencyId, (Object)targetCurrencyId);
        if (precision == null && (precision = (Integer)this.getConfigTable().get((Object)targetCurrencyId, (Object)originalCurrencyId)) == null) {
            precision = this.getDefaultPrecision();
        }
        return Optional.ofNullable(precision);
    }

    public Map<Long, Integer> batchFindPrecisionConfig(Collection<Long> originalCurrencyIds, Long targetCurrencyId) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(originalCurrencyIds.size());
        for (Long originalCurrencyId : originalCurrencyIds) {
            this.findPrecisionConfig(originalCurrencyId, targetCurrencyId).ifPresent(x -> result.put(originalCurrencyId, (Integer)x));
        }
        return result;
    }
}

