/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.rate;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.IndirectRateConfigs;
import kd.fi.bd.rate.PrecisionConfigs;
import kd.fi.bd.rate.RateType;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.QFBuilder;

public class RateServiceHelper {
    private static final int DEFAULT_PRECISION = 8;
    private static final String BD_EXRATE_TREE = "bd_exrate_tree";
    private static final String EXCVAL = "excval";
    private static final String INDIRECTEXRATE = "indirectexrate";
    private static final String EFFECTDATE = "effectdate";
    private static final String ORGCUR = "orgcur";
    private static final String EXCTABLE = "exctable";
    private static final String CUR = "cur";
    private static final String ENABLE = "enable";
    private static final String ID = "id";
    private static final String PRECISION = "precision";
    private static final String BD_EXRATE_CONFIG = "bd_exrate_config";
    private static final String ENTRYENTITY = "entryentity";
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String SOURCECUR = "sourcecur";
    private static final String TARGETCUR = "targetcur";
    private static final String ISINDIRECT = "isindirect";

    private RateServiceHelper() {
    }

    public static Map<Long, ExchangeRate> batchGetExchangeRate(Collection<Long> originalCurrencyIds, Long targetCurrencyId, Long rateTableId, Date effectDate) {
        Map<Long, ExchangeRate> exchangeRateMap = RateServiceHelper.innerBatchGetExchangeRate(originalCurrencyIds, targetCurrencyId, rateTableId, effectDate);
        if (!exchangeRateMap.isEmpty()) {
            Map<Long, Integer> precisionConfigs = RateServiceHelper.loadPrecisionConfigs().batchFindPrecisionConfig(exchangeRateMap.keySet(), targetCurrencyId);
            for (Map.Entry<Long, Integer> precisionEntry : precisionConfigs.entrySet()) {
                exchangeRateMap.get(precisionEntry.getKey()).setPrecision(precisionEntry.getValue());
            }
        }
        return exchangeRateMap;
    }

    private static Map<Long, ExchangeRate> innerBatchGetExchangeRate(Collection<Long> originalCurrencyIds, Long targetCurrencyId, Long rateTableId, Date effectDate) {
        Map<Long, RateType> rateTypeMap = null;
        if (originalCurrencyIds != null && !originalCurrencyIds.isEmpty()) {
            rateTypeMap = RateServiceHelper.batchGetRateType(originalCurrencyIds, targetCurrencyId, effectDate);
        }
        List<DynamicObject> rateDynList = RateServiceHelper.batchLoadExchangeRateDyn(originalCurrencyIds, targetCurrencyId, rateTableId, effectDate, Boolean.FALSE);
        Map<Long, ExchangeRate> rateMap = RateServiceHelper.getRateMap(rateDynList, Boolean.FALSE);
        if (originalCurrencyIds != null && !originalCurrencyIds.isEmpty()) {
            originalCurrencyIds.removeAll(rateMap.keySet());
            if (originalCurrencyIds.isEmpty()) {
                if (rateTypeMap != null) {
                    for (Map.Entry<Long, RateType> entry : rateTypeMap.entrySet()) {
                        ExchangeRate exchangeRate = rateMap.computeIfAbsent(entry.getKey(), k -> new ExchangeRate());
                        exchangeRate.setRateType(entry.getValue());
                    }
                }
                rateMap.put(targetCurrencyId, RateServiceHelper.getDefaultOne());
                return rateMap;
            }
        }
        List<DynamicObject> rateDynListSwap = RateServiceHelper.batchLoadExchangeRateDyn(originalCurrencyIds, targetCurrencyId, rateTableId, effectDate, Boolean.TRUE);
        Map<Long, ExchangeRate> rateMapSwap = RateServiceHelper.getRateMap(rateDynListSwap, Boolean.TRUE);
        rateMapSwap.putAll(rateMap);
        if (rateTypeMap == null) {
            Set<Long> oriCurIdSet = rateMapSwap.keySet();
            rateTypeMap = RateServiceHelper.batchGetRateType(oriCurIdSet, targetCurrencyId, effectDate);
            for (Map.Entry<Long, ExchangeRate> entry : rateMapSwap.entrySet()) {
                entry.getValue().setRateType(rateTypeMap.getOrDefault(entry.getKey(), RateType.DIRECT_RATE));
            }
        } else {
            for (Map.Entry<Long, RateType> entry : rateTypeMap.entrySet()) {
                ExchangeRate exchangeRate = rateMapSwap.computeIfAbsent(entry.getKey(), k -> new ExchangeRate());
                exchangeRate.setRateType(entry.getValue());
            }
        }
        rateMapSwap.put(targetCurrencyId, RateServiceHelper.getDefaultOne());
        return rateMapSwap;
    }

    public static Map<Long, RateType> batchGetRateType(Collection<Long> originalCurrencyIds, Long targetCurrencyId, Date effectDate) {
        if (RateServiceHelper.isEnableIndirectRateConversion()) {
            return RateServiceHelper.loadIndirectRateConfigs().batchFindIndirectRateConfig(originalCurrencyIds, targetCurrencyId, effectDate);
        }
        return originalCurrencyIds.stream().collect(Collectors.toMap(x -> x, x -> RateType.DIRECT_RATE));
    }

    private static IndirectRateConfigs loadIndirectRateConfigs() {
        return (IndirectRateConfigs)ThreadCache.get((Object)(RateServiceHelper.class.getName() + "#loadIndirectRateConfigs"), () -> {
            IndirectRateConfigs configs = IndirectRateConfigs.empty();
            DynamicObject configDyn = BusinessDataServiceHelper.loadSingleFromCache((String)BD_EXRATE_CONFIG, (QFilter[])new QFilter[0]);
            if (configDyn != null) {
                configs.setEnableIndirectRateConversion(RateServiceHelper.isEnableIndirectRateConversion());
                if (configs.isEnableIndirectRateConversion()) {
                    HashBasedTable table = HashBasedTable.create();
                    DynamicObjectCollection indirectConfigEntries = configDyn.getDynamicObjectCollection(ENTRYENTITY);
                    for (DynamicObject entry : indirectConfigEntries) {
                        DynamicObject oriCurDyn = entry.getDynamicObject(SOURCECUR);
                        DynamicObject tarCurDyn = entry.getDynamicObject(TARGETCUR);
                        long oriCurId = oriCurDyn != null ? oriCurDyn.getLong(ID) : 0L;
                        long tarCurId = tarCurDyn != null ? tarCurDyn.getLong(ID) : 0L;
                        Date date = entry.getDate(EFFECTIVEDATE);
                        RateType rateType = entry.getBoolean(ISINDIRECT) ? RateType.INDIRECT_RATE : RateType.DIRECT_RATE;
                        TreeMap<Date, RateType> treeMap = (TreeMap<Date, RateType>)table.get((Object)oriCurId, (Object)tarCurId);
                        if (treeMap == null) {
                            treeMap = new TreeMap<Date, RateType>();
                            treeMap.put(date, rateType);
                            table.put((Object)oriCurId, (Object)tarCurId, treeMap);
                            continue;
                        }
                        treeMap.put(date, rateType);
                    }
                    configs.setConfigTable((Table<Long, Long, TreeMap<Date, RateType>>)table);
                }
            }
            return configs;
        });
    }

    private static PrecisionConfigs loadPrecisionConfigs() {
        return (PrecisionConfigs)ThreadCache.get((Object)(RateServiceHelper.class.getName() + "#loadPrecisionConfigs"), () -> {
            PrecisionConfigs configs = PrecisionConfigs.empty();
            DynamicObject configDyn = BusinessDataServiceHelper.loadSingleFromCache((String)BD_EXRATE_CONFIG, (QFilter[])new QFilter[0]);
            if (configDyn != null) {
                configs.setEnablePrecisionControl(configDyn.getBoolean("precisioncontrol"));
                if (configs.isEnablePrecisionControl()) {
                    String defaultPrecision = configDyn.getString("defaultprecision");
                    if (StringUtils.isNotEmpty((String)defaultPrecision)) {
                        configs.setDefaultPrecision(Integer.valueOf(defaultPrecision));
                    }
                    HashBasedTable table = HashBasedTable.create();
                    DynamicObjectCollection precisionEntries = configDyn.getDynamicObjectCollection("int_precision_entry");
                    for (DynamicObject precisionEntry : precisionEntries) {
                        table.put((Object)precisionEntry.getLong("currency1.id"), (Object)precisionEntry.getLong("currency2.id"), (Object)precisionEntry.getInt(PRECISION));
                    }
                    configs.setConfigTable((Table<Long, Long, Integer>)table);
                }
            }
            return configs;
        });
    }

    public static boolean isEnableIndirectRateConversion() {
        return (Boolean)ThreadCache.get((Object)(RateServiceHelper.class.getName() + "#isEnableIndirectRateConversion"), BaseDataServiceHelper::isEnableIndirectRateConversion);
    }

    private static Map<Long, ExchangeRate> getRateMap(List<DynamicObject> rateDynList, boolean swap) {
        HashMap<Long, ExchangeRate> rateMap = new HashMap<Long, ExchangeRate>(rateDynList.size());
        for (DynamicObject rateDyn : rateDynList) {
            String oriCurField;
            long oriCurId = rateDyn.getLong((oriCurField = swap ? CUR : ORGCUR) + ".id");
            if (rateMap.containsKey(oriCurId)) continue;
            int precision = RateServiceHelper.getRateDisplayPrecision(rateDyn);
            BigDecimal directRate = rateDyn.getBigDecimal(EXCVAL);
            BigDecimal indirectRate = rateDyn.getBigDecimal(INDIRECTEXRATE);
            ExchangeRate exchangeRate = new ExchangeRate();
            if (swap) {
                exchangeRate.setDirectRate(indirectRate);
                exchangeRate.setIndirectRate(directRate);
            } else {
                exchangeRate.setDirectRate(directRate);
                exchangeRate.setIndirectRate(indirectRate);
            }
            exchangeRate.setPrecision(precision);
            exchangeRate.setEffectDate(rateDyn.getDate(EFFECTDATE));
            rateMap.put(oriCurId, exchangeRate);
        }
        return rateMap;
    }

    private static List<DynamicObject> batchLoadExchangeRateDyn(Collection<Long> originalCurrencyIds, Long targetCurrencyId, Long rateTableId, Date effectDate, boolean swap) {
        Optional<QFBuilder> qfBuilder = RateServiceHelper.buildQueryRateFilter(originalCurrencyIds, targetCurrencyId, rateTableId, effectDate, swap);
        if (qfBuilder.isPresent()) {
            String selectProperties = String.join((CharSequence)",", ID, EXCVAL, INDIRECTEXRATE, PRECISION, ORGCUR, CUR, EFFECTDATE);
            Map rateDynMap = BusinessDataServiceHelper.loadFromCache((String)BD_EXRATE_TREE, (String)selectProperties, (QFilter[])qfBuilder.get().toArray());
            return rateDynMap.values().stream().sorted((o1, o2) -> o2.getDate(EFFECTDATE).compareTo(o1.getDate(EFFECTDATE))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static Optional<QFBuilder> buildQueryRateFilter(Collection<Long> originalCurrencyIds, Long targetCurrencyId, Long rateTableId, Date effectDate, boolean swap) {
        boolean nonNull = BDUtil.checkArgumentNonNull(targetCurrencyId, rateTableId);
        if (!nonNull) {
            return Optional.empty();
        }
        QFBuilder qfBuilder = new QFBuilder();
        if (originalCurrencyIds != null && !originalCurrencyIds.isEmpty()) {
            if (swap) {
                qfBuilder.add(CUR, "in", originalCurrencyIds);
            } else {
                qfBuilder.add(ORGCUR, "in", originalCurrencyIds);
            }
        }
        if (swap) {
            qfBuilder.add(ORGCUR, "=", targetCurrencyId);
        } else {
            qfBuilder.add(CUR, "=", targetCurrencyId);
        }
        qfBuilder.add(EXCTABLE, "=", rateTableId);
        if (effectDate != null) {
            qfBuilder.add(EFFECTDATE, "<=", effectDate);
        }
        qfBuilder.add(ENABLE, "=", true);
        return Optional.of(qfBuilder);
    }

    public static RateType getRateType(long originalCurrencyId, long targetCurrencyId, Date effectDate) {
        if (originalCurrencyId == targetCurrencyId) {
            return RateType.DIRECT_RATE;
        }
        return RateServiceHelper.batchGetRateType(Collections.singletonList(originalCurrencyId), targetCurrencyId, effectDate).get(originalCurrencyId);
    }

    public static ExchangeRate getExchangeRate(Long originalCurrencyId, Long targetCurrencyId, Long rateTableId, Date effectDate) {
        boolean nonNull = BDUtil.checkArgumentNonNull(originalCurrencyId, targetCurrencyId, rateTableId);
        if (!nonNull) {
            return null;
        }
        if (originalCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return RateServiceHelper.getDefaultOne();
        }
        ArrayList<Long> originalCurrencyIds = new ArrayList<Long>(1);
        originalCurrencyIds.add(originalCurrencyId);
        Map<Long, ExchangeRate> rateMap = RateServiceHelper.batchGetExchangeRate(originalCurrencyIds, targetCurrencyId, rateTableId, effectDate);
        return rateMap.get(originalCurrencyId);
    }

    public static ExchangeRate getDefaultOne() {
        ExchangeRate exchangeRate = new ExchangeRate();
        exchangeRate.setDirectRate(BigDecimal.ONE);
        exchangeRate.setIndirectRate(BigDecimal.ONE);
        return exchangeRate;
    }

    public static int getRatePrecision(Long originalCurrencyId, Long targetCurrencyId, Long rateTableId, Date effectDate) {
        Optional<Integer> precisionConfig = RateServiceHelper.loadPrecisionConfigs().findPrecisionConfig(originalCurrencyId, targetCurrencyId);
        if (precisionConfig.isPresent()) {
            return precisionConfig.get();
        }
        ExchangeRate exchangeRate = RateServiceHelper.getExchangeRate(originalCurrencyId, targetCurrencyId, rateTableId, effectDate);
        return exchangeRate == null ? 8 : exchangeRate.getPrecision();
    }

    private static int getRateDisplayPrecision(DynamicObject rateDyn) {
        return rateDyn.getInt(PRECISION) == 0 ? 8 : rateDyn.getInt(PRECISION);
    }
}

