/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.rate;

import kd.fi.bd.rate.DirectRateCalculator;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.IndirectRateCalculator;

public enum RateType {
    DIRECT_RATE(Boolean.FALSE, new DirectRateCalculator(), "0"),
    INDIRECT_RATE(Boolean.TRUE, new IndirectRateCalculator(), "1");

    private final IRateCalculator rateCalculator;
    private final Boolean value;
    private final String strValue;

    private RateType(Boolean value, IRateCalculator rateCalculator, String strValue) {
        this.value = value;
        this.rateCalculator = rateCalculator;
        this.strValue = strValue;
    }

    public IRateCalculator getRateCalculator() {
        return this.rateCalculator;
    }

    public Boolean getValue() {
        return this.value;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public static RateType getRateType(String value) {
        RateType[] values;
        for (RateType rateType : values = RateType.values()) {
            if (!rateType.getStrValue().equals(value)) continue;
            return rateType;
        }
        return DIRECT_RATE;
    }
}

