/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.account;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.util.FibdApp;

public class AccountNotFoundException
extends KDBizException {
    private static final String NAME = "name";
    private static final String NUMBER = "number";

    public AccountNotFoundException(Long orgId, Long masterId, Date date) {
        super(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5728%2$s\u4e0b\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%3$s\u7684\u53ef\u4f7f\u7528\u79d1\u76ee\u3002", (String)"AccountNotFoundException_0", (String)FibdApp.instance.commonModule(), (Object[])new Object[0]), AccountNotFoundException.loadOrgName(orgId), new SimpleDateFormat("yyyy-MM-dd").format(date), AccountNotFoundException.loadAccountNumber(masterId)));
    }

    private static String loadOrgName(Long orgId) {
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)NAME);
        if (orgDyn == null) {
            return orgId.toString();
        }
        return orgDyn.getString(NAME);
    }

    private static String loadAccountNumber(Long masterId) {
        DynamicObject accountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)"bd_accountview", (String)NUMBER);
        if (accountDyn == null) {
            return masterId.toString();
        }
        return accountDyn.getString(NUMBER);
    }
}

