/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.account;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.account.AccountNotFoundException;
import kd.fi.bd.util.BDUtil;

public class AccountVersionMatchHelper {
    public static AccountMatchCollection init(Collection<Long> orgs, Collection<Long> masterIds, String selectFields) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(orgs));
        HashMap<Long, Collection<Long>> org2Accounts = new HashMap<Long, Collection<Long>>(orgs.size());
        orgs.forEach(org -> {
            Collection cfr_ignored_0 = org2Accounts.put((Long)org, new ArrayList(300));
        });
        String afterWrapSelectFileds = AccountVersionMatchHelper.wrapSelectFields(selectFields);
        SqlBuilder sql = AccountVersionMatchHelper.getSqlBuilder(orgs, masterIds);
        try (DataSet dataSet = DB.queryDataSet((String)"AccountMatchHelper.init", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                Long useOrgId = row.getLong("fuseorgid");
                Long accountId = row.getLong("id");
                if (useOrgId == 0L) {
                    org2Accounts.values().forEach(list -> list.add(accountId));
                    continue;
                }
                ((Collection)org2Accounts.get(useOrgId)).add(accountId);
            }
        }
        Map<Object, DynamicObject> pk2Dyn = AccountVersionMatchHelper.parseIdToDyn(org2Accounts, afterWrapSelectFileds);
        Map<Long, Table<Long, Tuple<Date, Date>, DynamicObject>> org2Table = org2Accounts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            HashBasedTable table = HashBasedTable.create();
            ((Collection)entry.getValue()).forEach(arg_0 -> AccountVersionMatchHelper.lambda$null$2(pk2Dyn, (Table)table, arg_0));
            return table;
        }));
        return new AccountMatchCollection(org2Table);
    }

    private static Map<Object, DynamicObject> parseIdToDyn(Map<Long, Collection<Long>> org2Accounts, String afterWrapSelectFileds) {
        Set allAccountIds = org2Accounts.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)afterWrapSelectFileds, (QFilter[])new QFilter[]{new QFilter("id", "in", allAccountIds)});
    }

    private static SqlBuilder getSqlBuilder(Collection<Long> orgs, Collection<Long> masterIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT c.fid id, u.fuseorgid FROM T_BD_ACCOUNT AS c LEFT JOIN T_BD_ACCOUNT_U AS u ON u.fdataid = c.fid WHERE", new Object[0]).append("c.fstatus='C'", new Object[0]);
        if (!masterIds.isEmpty()) {
            sql.appendIn("AND c.fmasterid", masterIds.toArray());
        }
        sql.append("AND", new Object[0]).appendIn("u.fuseorgid", orgs.toArray());
        sql.append("UNION ", new Object[0]).append("SELECT c.fid, 0 as fuseorgid FROM T_BD_ACCOUNT as c where c.fctrlstrategy='5'", new Object[0]);
        if (!masterIds.isEmpty()) {
            sql.appendIn("AND c.fmasterid", masterIds.toArray());
        }
        return sql;
    }

    private static String wrapSelectFields(String selectFileds) {
        return String.join((CharSequence)",", "startdate", "enddate", "masterid") + "," + selectFileds;
    }

    private static /* synthetic */ void lambda$null$2(Map pk2Dyn, Table table, Long acctId) {
        DynamicObject acctDyn = (DynamicObject)pk2Dyn.get(acctId);
        table.put((Object)acctDyn.getLong("masterid"), (Object)Tuple.create((Object)acctDyn.getDate("startdate"), (Object)acctDyn.getDate("enddate")), (Object)acctDyn);
    }

    public static class AccountMatchCollection
    implements Closeable {
        private final Map<Long, Table<Long, Tuple<Date, Date>, DynamicObject>> org2Table;

        AccountMatchCollection(Map<Long, Table<Long, Tuple<Date, Date>, DynamicObject>> org2Table) {
            this.org2Table = org2Table;
        }

        public DynamicObject get(long orgId, long masterId, Date date) {
            return (DynamicObject)this.org2Table.get(orgId).row((Object)masterId).entrySet().stream().filter(entry -> BDUtil.dateInRange(date, (Date)((Tuple)entry.getKey()).item1, (Date)((Tuple)entry.getKey()).item2)).findFirst().orElseThrow(() -> new AccountNotFoundException(orgId, masterId, date)).getValue();
        }

        @Override
        public void close() {
            this.org2Table.clear();
        }
    }
}

