/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.service.balance.mulcur.BalanceMulCurQueryExecutorImp;
import kd.fi.bd.service.balance.mulcur.MulCurrencyUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.DataSetHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.vo.CommonAssist;
import org.apache.commons.lang3.StringUtils;

public class BalanceQueryExecutorImp
implements BalanceQueryExecutor {
    private static final Log LOG = LogFactory.getLog(BalanceQueryExecutorImp.class);
    private static String[] amountFields = new String[]{"vdebitfor", "vdebitlocal", "vcreditfor", "vcreditlocal", "vdebitqty", "vcreditqty", "vcount", "vbeginfor", "vbeginlocal", "vbeginqty"};
    private static final String BEGIN_PROP = "beginfor,beginlocal,beginqty";
    private static final String END_PROP = "endfor,endlocal,endqty";
    private static final String YEAR_PROP = "yeardebitfor,yeardebitlocal,yeardebitqty,yearcreditfor,yearcreditlocal,yearcreditqty";
    private static final String DCP_PROP = "debitfor,debitlocal,debitqty,creditfor,creditlocal,creditqty";
    private static final String THEN = " then ";
    private static final String ELSE0END = " else 0 end";
    private static final String ELSE0_0END = " else 0.0 end";
    private Long[] orgList;
    private long beginPeriod;
    private long endPeriod;
    private String oriSelector;
    private String querySelector;
    private String acctSelector;
    private boolean showPeriod;
    private int endPeriodYear = 0;
    private QueryParam param;
    private IAccountTreeModel accountModel = null;
    private static final String TAG_LEAF = "_tag_leaf";
    private Map<String, Set<String>> entityRefMap = new HashMap<String, Set<String>>(8);
    private static final String BALANCELOG_SEl = "org,booktype,period,account,assgrp,currency,measureunit,creditqty,debitqty,debitlocal,debitfor,creditlocal,creditfor,count";
    private List<CommonAssist> commonAssist = new ArrayList<CommonAssist>(2);
    List<DynamicProperty> flexsProperty = new ArrayList<DynamicProperty>(8);
    List<String> assgrp_Flexs = new ArrayList<String>(8);
    private static final String[] fBillStatus = new String[]{"B", "C"};
    private static final String[] vamoutFileds = new String[]{"vdebitqty", "vcreditqty", "vdebitfor", "vcreditfor", "vdebitlocal", "vcreditlocal"};

    @Override
    public DataSet getBalance(String selector, Long[] orgIds, long bookTypeId, long accountTableId, long beginPeriodId, long endPeriodId, QueryParam param, IAccountTreeModel accountTreeModel) {
        this.accountModel = accountTreeModel;
        return this.getBalance(selector, orgIds, bookTypeId, accountTableId, beginPeriodId, endPeriodId, param);
    }

    @Override
    public DataSet getBalance(String selector, Long[] orgIds, long bookTypeId, long accountTableId, long beginPeriodId, long endPeriodId, QueryParam param) {
        if (param == null) {
            param = new QueryParam();
        }
        if (MulCurrencyUtil.isMulCurQueryBalance(selector)) {
            return new BalanceMulCurQueryExecutorImp().getBalance(selector, orgIds, bookTypeId, accountTableId, beginPeriodId, endPeriodId, param, this.accountModel);
        }
        PerformanceWatch watch = new PerformanceWatch(BalanceQueryExecutorImp.class, "BalanceQueryExecutorImp getBalance ", true);
        watch.start("getBalance init");
        this.init(selector, orgIds, accountTableId, beginPeriodId, endPeriodId, param);
        this.initComField(accountTableId);
        watch.stop();
        watch.start("getBalance getBalanceData");
        QFilter[] filters = this.getFilters(bookTypeId, accountTableId, param, false);
        DataSet balance = this.getBalanceData(filters);
        watch.stop();
        watch.start("getBalance getBalanceLogData");
        QFilter[] filtersLog = this.getFilters(bookTypeId, accountTableId, param, true);
        DataSet result = this.getGroupBalance(balance);
        result = this.dealBalLog(filtersLog, bookTypeId, result);
        watch.stop();
        watch.start("getBalance substractPLVoucher");
        if (param.isSubstractPL()) {
            result = this.substractPLVoucher(result, bookTypeId);
        }
        watch.stop();
        watch.start("getBalance queryAcctParentAndLeaf");
        Field[] fields = result.getRowMeta().getFields();
        HashSet<String> leftSelectSet = new HashSet<String>(10);
        boolean existAccountSelect = false;
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            if (!param.isSumAssgrp() && "assgrp".equals(name)) continue;
            if ("account".equalsIgnoreCase(name)) {
                existAccountSelect = true;
                continue;
            }
            leftSelectSet.add(name);
        }
        if (existAccountSelect) {
            result = result.join(this.accountModel.getTreeDataSet(), JoinType.INNER).on("org", "org").on("account", "masterid").select(leftSelectSet.toArray(new String[0]), new String[]{"id account"}).finish().filter("account !=0");
        }
        if (!param.isOnlyLeafAcctBal()) {
            String[] accountCols;
            result = this.levelSumAccountBalance(result);
            String acctSel = this.acctSelector;
            List<String> resultCols = BDUtil.getDataSetCols(result);
            resultCols.removeIf(str -> str.equalsIgnoreCase("parent"));
            if (acctSel.trim().length() == 0) {
                accountCols = null;
            } else {
                accountCols = acctSel.replaceFirst(", id", "").split(",");
                for (int i = 0; i < accountCols.length; ++i) {
                    String[] sel = accountCols[i].trim().split(" ");
                    if (sel.length <= 1) continue;
                    accountCols[i] = sel[1].trim();
                }
            }
            DataSet acctDataSet = this.getAccountSet(this.acctSelector, new QFilter("id", "in", this.accountModel.getDisplayAccountIds()));
            result = result.join(acctDataSet, JoinType.INNER).on("account", "id").select(resultCols.toArray(new String[0]), accountCols).finish();
            this.oriSelector = this.oriSelector.replace("account.isleaf ", "_tag_leaf ").replace("account.", "");
        }
        if (param.isAddAmountFilter()) {
            result = this.addAmountFilter(result);
        }
        watch.stop();
        watch.start("getBalance addEntityRefField");
        result = this.addEntityRefField(result);
        result = result.select(this.oriSelector);
        watch.stop();
        LOG.info(watch.show());
        if (DebugTrace.enable()) {
            LOG.info(String.format("getBalance printDataSet: %s", DataSetHelper.printDataSet(result)));
        }
        return result;
    }

    private DataSet addEntityRefField(DataSet result) {
        for (Map.Entry<String, Set<String>> entry : this.entityRefMap.entrySet()) {
            String field;
            StringBuilder sb;
            String rfield = entry.getKey();
            Set<String> fileldList = entry.getValue();
            DataSet dataSet = null;
            ArrayList<QFilter> reFilters = new ArrayList<QFilter>();
            if (rfield.startsWith("account") && this.param.isOnlyLeafAcctBal()) {
                sb = new StringBuilder("id account");
                for (String reField : fileldList) {
                    field = reField.substring(8) + " " + reField;
                    sb = sb.append(",").append(field);
                }
                if (this.param.getAccountFilter() != null) {
                    if (!this.accountModel.getFilterAccountIds().isEmpty()) {
                        reFilters.add(new QFilter("masterid", "in", this.accountModel.getFilterAccountIds()));
                    } else {
                        reFilters.add(this.getBalanceAcctFilter(this.param.getAccountFilter(), "id"));
                    }
                }
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)sb.toString(), (QFilter[])reFilters.toArray(new QFilter[reFilters.size()]), null);
            } else if (rfield.startsWith("period")) {
                sb = new StringBuilder("id period");
                for (String reField : fileldList) {
                    field = reField.substring(7) + " " + reField;
                    sb = sb.append(",").append(field);
                }
                reFilters.add(new QFilter("id", ">=", (Object)(this.endPeriod / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
                reFilters.add(new QFilter("id", "<=", (Object)this.endPeriod));
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)sb.toString(), (QFilter[])reFilters.toArray(new QFilter[reFilters.size()]), null);
            } else if (rfield.startsWith("currency")) {
                sb = new StringBuilder("id currency");
                for (String reField : fileldList) {
                    field = reField.substring(9) + " " + reField;
                    sb = sb.append(",").append(field);
                }
                Long[] currencyIds = this.param.getCurrencyIds();
                if (currencyIds != null && currencyIds.length > 0) {
                    reFilters.add(new QFilter("id", "in", (Object)currencyIds));
                }
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_currency", (String)sb.toString(), (QFilter[])reFilters.toArray(new QFilter[reFilters.size()]), null);
            } else if (rfield.startsWith("measureunit")) {
                sb = new StringBuilder("id measureunit");
                for (String reField : fileldList) {
                    field = reField.substring(12) + " " + reField;
                    sb = sb.append(",").append(field);
                }
                Long[] unitIds = this.param.getMeasureUnitIds();
                if (unitIds != null && unitIds.length > 0) {
                    reFilters.add(new QFilter("id", "in", (Object)unitIds));
                }
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_measureunits", (String)sb.toString(), (QFilter[])reFilters.toArray(new QFilter[reFilters.size()]), null);
            }
            if (dataSet == null) continue;
            List<String> leftList = this.getDSFileds(result);
            List<String> rightList = this.getDSFileds(dataSet);
            rightList.removeAll(leftList);
            if (rfield.startsWith("measureunit")) {
                result = result.join(dataSet, JoinType.LEFT).on(rfield, rfield).select(leftList.toArray(new String[leftList.size()]), rightList.toArray(new String[rightList.size()])).finish();
                continue;
            }
            result = result.join(dataSet).on(rfield, rfield).select(leftList.toArray(new String[leftList.size()]), rightList.toArray(new String[rightList.size()])).finish();
        }
        return result;
    }

    private void initComField(long accountaTableId) {
        this.commonAssist = (List)ThreadCache.get((Object)("CommonAssistInfo#" + accountaTableId), () -> {
            DynamicObjectCollection commonAssistEntry = BusinessDataServiceHelper.loadSingleFromCache((Object)accountaTableId, (String)"bd_accounttable", (String)String.join((CharSequence)", ", "comassistnumber", "comassistname", "valuesourcetype", "valuesource", "assistantvaluesource", "isrequire", "isbalance")).getDynamicObjectCollection("comassistentry");
            return CommonAssist.createComAssist(commonAssistEntry);
        }, (boolean)true);
    }

    private StringBuilder getBalLogSelectField() {
        StringBuilder sb = new StringBuilder(BALANCELOG_SEl);
        this.commonAssist.stream().forEach(x -> sb.append(",").append(x.key));
        return sb;
    }

    private DataSet addBalLog(QFilter[] filtersLog) {
        String selLog;
        if (!this.assgrp_Flexs.isEmpty()) {
            StringBuilder vSelBuilder = this.getBalLogSelectField();
            for (String flex : this.assgrp_Flexs) {
                vSelBuilder.append(",");
                vSelBuilder.append(flex);
            }
            selLog = vSelBuilder.toString();
        } else {
            selLog = this.getBalLogSelectField().toString();
        }
        MainEntityType initBalEntity = this.getMainEntityType("gl_balance_log");
        if (initBalEntity != null) {
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_balance_log", (IDataEntityType)initBalEntity);
            return orm.queryDataSet(this.getClass().getName(), "gl_balance_log", selLog, filtersLog, null);
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance_log", (String)selLog, (QFilter[])filtersLog, null);
    }

    private DataSet dealBalLog(QFilter[] filtersLog, long bookTypeId, DataSet balanceSet) {
        DataSet balanceLog = this.addBalLog(filtersLog);
        if (balanceLog.hasNext()) {
            String allPeriodSel = "id period, periodyear";
            QFilter fstperiod = new QFilter("id", ">=", (Object)(this.endPeriod / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L));
            QFilter fedperiod = new QFilter("id", "<=", (Object)this.endPeriod);
            DataSet allPeriodSet = this.getPeriodSet(allPeriodSel, new QFilter[]{fstperiod, fedperiod});
            List<String> fields = this.getDSFileds(balanceLog);
            balanceLog = balanceLog.join(allPeriodSet, JoinType.LEFT).on("period", "period").select(fields.toArray(new String[fields.size()]), new String[]{"periodyear"}).finish();
            balanceLog = balanceLog.addField("debitfor", "yeardebitfor").addField("creditfor", "yearcreditfor").addField("debitlocal", "yeardebitlocal").addField("creditlocal", "yearcreditlocal").addField("debitqty", "yeardebitqty").addField("creditqty", "yearcreditqty").addField("debitfor-creditfor", "endfor").addField("debitlocal-creditlocal", "endlocal").addField("debitqty-creditqty", "endqty").addField("debitfor-creditfor", "beginfor").addField("debitlocal-creditlocal", "beginlocal").addField("debitqty-creditqty", "beginqty");
            List<String> logList = this.getDSFileds(balanceLog);
            ArrayList<String> selList = new ArrayList<String>();
            List<String> periodList = Arrays.asList(DCP_PROP.split(","));
            List<String> startPeriodList = Arrays.asList(BEGIN_PROP.split(","));
            List<String> yearList = Arrays.asList(YEAR_PROP.split(","));
            for (String field : logList) {
                String pcase;
                if (yearList.contains(field)) {
                    String ycase = "";
                    ycase = this.showPeriod ? "case when cast(PreRowValue(periodyear) as integer ) = periodyear then cast(PreRowValue() as decimal)+" + field + " else 0 end as " + field : "case when periodyear=" + this.endPeriodYear + THEN + field + " else 0 end as " + field;
                    selList.add(ycase);
                    continue;
                }
                if (periodList.contains(field) && !this.showPeriod) {
                    pcase = "case when period>=" + this.beginPeriod + " and period<=" + this.endPeriod + THEN + field + " else 0 end as " + field;
                    selList.add(pcase);
                    continue;
                }
                if (startPeriodList.contains(field) && !this.showPeriod) {
                    pcase = "case when period<" + this.beginPeriod + THEN + field + " else 0 end as " + field;
                    selList.add(pcase);
                    continue;
                }
                selList.add(field);
            }
            balanceLog = balanceLog.select(selList.toArray(new String[selList.size()]));
            List<String> balList = this.getDSFileds(balanceSet);
            balanceLog = balanceLog.select(balList.toArray(new String[0]));
            List<String> groupList = this.getGroupList();
            groupList.remove("periodyear");
            ArrayList<String> sums = new ArrayList<String>();
            this.getAmountFieldBySet(balanceSet, new ArrayList<String>(), sums, new ArrayList<String>());
            balanceSet = balanceSet.union(balanceLog).orderBy(groupList.toArray(new String[groupList.size()]));
            GroupbyDataSet gDataSet = balanceSet.groupBy(groupList.toArray(new String[groupList.size()]));
            for (String sumField : sums) {
                gDataSet = gDataSet.sum(sumField);
            }
            balanceSet = gDataSet.finish();
        }
        return balanceSet;
    }

    private DataSet substractPLVoucher(DataSet balance, long bookTypeId) {
        DataSet voucherSet = this.initPLVoucher(bookTypeId);
        balance = this.balanceSubPLVoucher(balance, voucherSet, bookTypeId);
        return balance;
    }

    private DataSet initPLVoucher(long bookTypeId) {
        DynamicObject yearMinPeriod = PeriodUtil.getCurYearMinPeriod(this.beginPeriod);
        long yearMinPeriodId = yearMinPeriod.getLong("id");
        DataSet voucherSet = this.queryPLVoucher(bookTypeId, yearMinPeriodId);
        List<String> voucherList = this.getDSFileds(voucherSet);
        DataSet initBalance = this.getOrgInitBalance(bookTypeId, yearMinPeriodId);
        if ((initBalance = initBalance.addBalanceField("vdebitfor-vcreditfor", "vbeginfor").addBalanceField("vdebitlocal-vcreditlocal", "vbeginlocal").addBalanceField("vdebitqty-vcreditqty", "vbeginqty")).hasNext()) {
            initBalance = initBalance.select(voucherList.toArray(new String[0]));
            voucherSet = voucherSet.union(initBalance);
        }
        voucherSet = this.idToMasterId(voucherSet);
        List<String> groupList = this.getGroupList();
        if (!groupList.contains("period")) {
            groupList.add("period");
        }
        String[] amountFields = this.getAmountVoucher();
        GroupbyDataSet gVoucherSet = voucherSet.groupBy(groupList.toArray(new String[0]));
        for (String string : amountFields) {
            gVoucherSet = gVoucherSet.sum(string);
        }
        voucherSet = gVoucherSet.finish();
        if (this.showPeriod) {
            voucherSet = this.fillPeriodSet(yearMinPeriodId, voucherSet);
        }
        voucherSet = voucherSet.orderBy(groupList.toArray(new String[0]));
        String[] vamountList = this.getAmountVoucher();
        if (!this.showPeriod) {
            ArrayList<String> yearInitList = new ArrayList<String>(vamountList.length);
            for (String field : vamountList) {
                yearInitList.add(field + " year" + field);
            }
            yearInitList.addAll(groupList);
            yearInitList.addAll(Arrays.asList(vamountList));
            voucherSet = voucherSet.select(yearInitList.toArray(new String[0]));
            groupList.removeIf(x -> x.equals("period"));
            groupList.removeIf(x -> x.equals("periodyear"));
            GroupbyDataSet byVoucherSet = voucherSet.groupBy(groupList.toArray(new String[0]));
            for (String gfield : vamountList) {
                if (gfield.startsWith("vbegin")) {
                    String suffix = gfield.replace("vbegin", "");
                    byVoucherSet.sum("case when period< " + this.beginPeriod + " then vdebit" + suffix + "-vcredit" + suffix + ELSE0END, gfield);
                    continue;
                }
                byVoucherSet.sum("case when period>=" + this.beginPeriod + THEN + gfield + ELSE0END, gfield);
                byVoucherSet.sum("case when periodyear=" + this.endPeriodYear + " then year" + gfield + ELSE0END, "year" + gfield);
            }
            voucherSet = byVoucherSet.finish();
        } else {
            StringBuilder caseWhenBuf = new StringBuilder(4);
            for (String string : groupList) {
                if ("period".equals(string)) continue;
                if (caseWhenBuf.length() == 0) {
                    caseWhenBuf = caseWhenBuf.append("case when cast(PreRowValue(").append(string).append(") as long)==").append(string).append(" ");
                    continue;
                }
                caseWhenBuf = caseWhenBuf.append("and cast(PreRowValue(").append(string).append(") as long)==").append(string).append(" ");
            }
            ArrayList<String> list = new ArrayList<String>(amountFields.length);
            list.addAll(groupList);
            list.addAll(Arrays.asList(vamountList));
            for (String amount : amountFields) {
                StringBuilder selBuf = new StringBuilder();
                selBuf.append((CharSequence)caseWhenBuf);
                list.add(selBuf.append("then cast(PreRowValue(year").append(amount).append(") as decimal)+").append(amount).append(" else ").append(amount).append(" end as year").append(amount).toString());
            }
            voucherSet = voucherSet.select(list.toArray(new String[0]));
        }
        List<String> selVoucher = this.getDSFileds(voucherSet);
        voucherSet = voucherSet.select(selVoucher.toArray(new String[0]));
        selVoucher = this.getDSFileds(voucherSet);
        ArrayList<String> plSels = new ArrayList<String>(selVoucher.size());
        for (String sel : selVoucher) {
            plSels.add(sel + " PL" + sel);
        }
        return voucherSet.select(plSels.toArray(new String[0]));
    }

    private DataSet fillPeriodSet(long startPeriodId, DataSet periodSet) {
        String allPeriodSel = "id period, periodyear";
        QFilter fstperiod = new QFilter("id", ">=", (Object)startPeriodId);
        QFilter fedperiod = new QFilter("id", "<=", (Object)this.endPeriod);
        DataSet allPeriodSet = this.getPeriodSet(allPeriodSel, new QFilter[]{fstperiod, fedperiod});
        DataSet initPeriodSet = allPeriodSet.copy();
        initPeriodSet = initPeriodSet.groupBy(new String[]{"periodyear"}).finish().addField("0L", "id").select(allPeriodSel);
        allPeriodSet = initPeriodSet.union(allPeriodSet);
        List<String> groupList = this.getGroupList();
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.addAll(groupList);
        fieldList.removeIf(x -> x.equals("period"));
        fieldList.removeIf(x -> x.equals("periodyear"));
        DataSet fillPeriodSet = periodSet.copy();
        fillPeriodSet = fillPeriodSet.groupBy(fieldList.toArray(new String[0])).finish();
        allPeriodSet = allPeriodSet.join(fillPeriodSet, JoinType.CROSS).select(new String[]{"period", "periodyear"}, fieldList.toArray(new String[0])).finish();
        JoinDataSet joinSet = allPeriodSet.join(periodSet, JoinType.LEFT);
        for (String field : groupList) {
            joinSet.on(field, field);
        }
        List<String> allList = this.getDSFileds(periodSet);
        allList.removeAll(groupList);
        allPeriodSet = joinSet.select(groupList.toArray(new String[0]), allList.toArray(new String[0])).finish();
        return allPeriodSet;
    }

    private List<String> getGroupList() {
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add("org");
        groupList.add("booktype");
        if (!this.param.isOnlyLeafAcctBal() || this.querySelector.contains("account,")) {
            groupList.add("account");
        }
        if (this.querySelector.contains("currency")) {
            groupList.add("currency");
        }
        if (this.querySelector.contains("assgrp") && !this.querySelector.contains("assgrp_")) {
            groupList.add("assgrp");
        }
        if (this.querySelector.contains("assgrp_")) {
            groupList.addAll(this.assgrp_Flexs);
        }
        if (this.querySelector.contains("measureunit")) {
            groupList.add("measureunit");
        }
        if (this.showPeriod) {
            groupList.add("period");
        }
        List comField = this.commonAssist.stream().filter(x -> this.querySelector.contains(x.key)).map(x -> x.key).collect(Collectors.toList());
        groupList.addAll(comField);
        groupList.add("periodyear");
        return groupList;
    }

    private String[] getAmountVoucher() {
        return amountFields;
    }

    private DataSet balanceSubPLVoucher(DataSet balanceSet, DataSet voucherSet, long bookTypeId) {
        String[] yearFields;
        String[] endFields;
        String[] stringArray;
        String[] stringArray2;
        List<String> resultBalance = this.getDSFileds(balanceSet);
        ArrayList<String> selBalance = new ArrayList<String>();
        selBalance.addAll(resultBalance);
        List<String> plvouBalance = this.getDSFileds(voucherSet);
        List<String> groupList = this.getGroupList();
        balanceSet = this.dealZeroInitBalance(bookTypeId, balanceSet);
        JoinDataSet jVoucherSet = balanceSet.copy().join(voucherSet, JoinType.LEFT);
        groupList.removeIf(x -> x.equals("periodyear"));
        for (String string : groupList) {
            jVoucherSet = jVoucherSet.on(string, "PL" + string);
        }
        balanceSet = jVoucherSet.select(selBalance.toArray(new String[0]), plvouBalance.toArray(new String[0])).finish();
        ArrayList<String> selBalanceNonull = new ArrayList<String>();
        for (String string : this.getDSFileds(balanceSet)) {
            if ((string.endsWith("local") || string.endsWith("for") || string.endsWith("qty") || string.endsWith("count")) && plvouBalance.contains(string)) {
                selBalanceNonull.add("case when " + string + "==null then 0.0 else " + string + " end as " + string);
                continue;
            }
            selBalanceNonull.add(string);
        }
        balanceSet = balanceSet.select(selBalanceNonull.toArray(new String[0]));
        for (String begin : stringArray2 = BEGIN_PROP.split(",")) {
            if (!selBalance.contains(begin)) continue;
            resultBalance.remove(begin);
            String beginF = begin.substring(5);
            resultBalance.add("begin" + beginF + "-PLvbegin" + beginF + " begin" + beginF);
        }
        for (String period : stringArray = DCP_PROP.split(",")) {
            if (!selBalance.contains(period)) continue;
            resultBalance.remove(period);
            resultBalance.add(period + "-PLv" + period + " " + period);
        }
        for (String end : endFields = END_PROP.split(",")) {
            if (!selBalance.contains(end)) continue;
            resultBalance.remove(end);
            String endF = end.substring(3);
            resultBalance.add(end + "-PLvbegin" + endF + "-(PLvdebit" + endF + "-PLvcredit" + endF + ") " + end);
        }
        for (String year : yearFields = YEAR_PROP.split(",")) {
            if (!selBalance.contains(year)) continue;
            resultBalance.remove(year);
            resultBalance.add(year + year.replace("year", "-PLyearv") + " " + year);
        }
        if (selBalance.contains("count")) {
            resultBalance.remove("count");
            resultBalance.add("count-PLvcount count");
        }
        balanceSet = balanceSet.select(resultBalance.toArray(new String[0]));
        return balanceSet;
    }

    private void getAmountFieldBySet(DataSet ds, List<String> groups, List<String> sums, List<String> periods) {
        Field[] fields;
        for (Field field : fields = ds.getRowMeta().getFields()) {
            String name = field.getName().toLowerCase();
            if (field.getDataType() instanceof BigDecimalType || "count".equals(name)) {
                sums.add(name);
                continue;
            }
            if (name.startsWith("period")) {
                periods.add(name);
                continue;
            }
            groups.add(name);
        }
    }

    private DataSet dealZeroInitBalance(long bookTypeId, DataSet balance) {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> sums = new ArrayList<String>();
        ArrayList<String> periods = new ArrayList<String>();
        this.getAmountFieldBySet(balance, groups, sums, periods);
        List<String> balList = this.getDSFileds(balance);
        List<QFilter> initFilters = this.getPLFilters(bookTypeId, this.param, "");
        initFilters.add(new QFilter("begindebitlocal", "=", (Object)BigDecimal.ZERO).and(new QFilter("begincreditlocal", "=", (Object)BigDecimal.ZERO)));
        String balGroupsStr = ((Object)groups).toString().substring(1, ((Object)groups).toString().length() - 1);
        DataSet initBalanceSet = this.getInitBalance(balGroupsStr, initFilters.toArray(new QFilter[0]));
        for (String field : sums) {
            initBalanceSet = initBalanceSet.addField("0", field);
        }
        if (!periods.isEmpty()) {
            List<Long> periodIds = PeriodUtil.getPeriodIds(this.beginPeriod, (Long)this.endPeriod);
            QFilter fid = new QFilter("id", "in", periodIds);
            ArrayList<String> queryPeriodList = new ArrayList<String>();
            for (String alias : periods) {
                if (alias.startsWith("period.")) {
                    String field = alias.replace("period.", "");
                    queryPeriodList.add(field + " " + alias);
                    continue;
                }
                if (!alias.equals("period")) continue;
                queryPeriodList.add("id " + alias);
            }
            String periodFieldsStr = ((Object)queryPeriodList).toString().substring(1, ((Object)queryPeriodList).toString().length() - 1);
            DataSet allPeriodSet = this.getPeriodSet(periodFieldsStr, new QFilter[]{fid});
            List<String> initBalList = this.getDSFileds(initBalanceSet);
            initBalanceSet = initBalanceSet.join(allPeriodSet, JoinType.CROSS).select(initBalList.toArray(new String[0]), periods.toArray(new String[0])).finish();
            initBalanceSet = initBalanceSet.select(balList.toArray(new String[0]));
        }
        balance = initBalanceSet.union(balance);
        groups.addAll(periods);
        GroupbyDataSet groupByBalSet = balance.groupBy(groups.toArray(new String[0]));
        for (String field : sums) {
            groupByBalSet.sum(field);
        }
        DataSet ds = groupByBalSet.finish();
        return ds;
    }

    private DataSet queryPLVoucher(long bookTypeId, long yearMinPeriodId) {
        String vSel;
        StringBuilder vSelBuilder;
        QFilter fsourceType = new QFilter("sourcetype", "=", (Object)"1");
        QFilter fbeginPeriod = new QFilter("period.id", ">=", (Object)yearMinPeriodId);
        QFilter fendPeriod = new QFilter("period.id", "<=", (Object)this.endPeriod);
        QFilter billFilter = new QFilter("billstatus", "in", (Object)fBillStatus);
        List<QFilter> voucherFilters = this.getPLFilters(bookTypeId, this.param, "entries.");
        voucherFilters.add(fsourceType);
        voucherFilters.add(fbeginPeriod);
        voucherFilters.add(fendPeriod);
        voucherFilters.add(billFilter);
        if (!this.assgrp_Flexs.isEmpty()) {
            vSelBuilder = new StringBuilder("org,booktype,period,period.periodyear periodyear,entries.assgrp assgrp,entries.account account,entries.currency currency,entries.measureunit measureunit,entries.quantity quantity,entries.debitlocal vdebitlocal,entries.debitori vdebitfor,entries.creditlocal vcreditlocal,entries.creditori vcreditfor");
            for (String flex : this.assgrp_Flexs) {
                vSelBuilder.append(",entries.");
                vSelBuilder.append(flex);
                vSelBuilder.append(" ");
                vSelBuilder.append(flex);
            }
            this.voucherFlexsFilter(voucherFilters);
            this.commonAssist.stream().forEach(x -> vSelBuilder.append(",entries.").append(x.key).append(" ").append(x.key));
            vSel = vSelBuilder.toString();
        } else {
            vSelBuilder = new StringBuilder("org,booktype,period,period.periodyear periodyear,entries.account account,entries.assgrp assgrp,entries.currency currency,entries.measureunit measureunit,entries.quantity quantity,entries.debitlocal vdebitlocal,entries.debitori vdebitfor,entries.creditlocal vcreditlocal,entries.creditori vcreditfor");
            this.commonAssist.stream().forEach(x -> vSelBuilder.append(",entries.").append(x.key).append(" ").append(x.key));
            vSel = vSelBuilder.toString();
        }
        DataSet voucherSet = this.getVoucher(vSel, voucherFilters);
        String[] vamoutFields = this.getAmountVoucher();
        List<String> voucherList = this.getGroupList();
        if (!voucherList.contains("period")) {
            voucherList.add("period");
        }
        List<String> vamounList = Arrays.asList(vamoutFields);
        voucherList.addAll(vamounList);
        voucherList.add("quantity");
        voucherList.remove("vdebitqty");
        voucherList.remove("vcreditqty");
        voucherList.remove("vcount");
        voucherList.add("case when vdebitlocal!=0 then quantity else 0 end as vdebitqty");
        voucherList.add("case when vcreditlocal!=0 then quantity else 0 end as vcreditqty");
        voucherSet = voucherSet.addField("0", "vbeginfor").addField("0", "vbeginlocal").addField("0", "vbeginqty").select(voucherList.toArray(new String[0])).removeFields(new String[]{"quantity"});
        voucherSet = voucherSet.addField("1", "vcount");
        return voucherSet;
    }

    private void voucherFlexsFilter(List<QFilter> voucherFilters) {
        for (QFilter flexFilter : voucherFilters) {
            for (String flexVal : this.assgrp_Flexs) {
                String val;
                String flex = flexVal.substring(0, flexVal.lastIndexOf("."));
                String key = flexFilter.getProperty();
                if (key.startsWith(flex)) {
                    key = key.replace(flex, "entries." + flex);
                    flexFilter.__setProperty(key);
                    flexFilter.setJoinEntityPath(key);
                }
                if (flexFilter.getValue() != null && (val = flexFilter.getValue().toString()).startsWith(flex)) {
                    val = val.replace(flex, "entries." + flex);
                    flexFilter.__setValue((Object)val);
                    flexFilter.setJoinEntityPath(key);
                }
                List netQfilters = flexFilter.getNests(true);
                for (QFilter.QFilterNest netQFilter : netQfilters) {
                    String nestVal;
                    QFilter subfilter = netQFilter.getFilter();
                    String nestKey = subfilter.getProperty();
                    if (nestKey.startsWith(flex)) {
                        nestKey = nestKey.replace(flex, "entries." + flex);
                        subfilter.__setProperty(nestKey);
                        subfilter.setJoinEntityPath(key);
                    }
                    if (subfilter.getValue() == null || !(nestVal = subfilter.getValue().toString()).startsWith(flex)) continue;
                    nestVal = nestVal.replace(flex, "entries." + flex);
                    subfilter.__setValue((Object)nestVal);
                    subfilter.setJoinEntityPath(key);
                }
            }
        }
    }

    private DataSet idToMasterId(DataSet voucherSet) {
        List<String> voucherList = this.getDSFileds(voucherSet);
        int size = this.commonAssist.size();
        HashMap<Integer, Object> indexToComAssistField = new HashMap<Integer, Object>(2);
        HashMap<Integer, Set> map = new HashMap<Integer, Set>(2);
        for (int i = 1; i <= size; ++i) {
            Object comAssistField;
            if (!this.hasMasteridProp(this.commonAssist.get((int)(i - 1)).valueSource) || !voucherList.contains(comAssistField = this.commonAssist.get(i - 1).getKey())) continue;
            indexToComAssistField.put(i, comAssistField);
        }
        if (voucherList.contains("account") || !indexToComAssistField.isEmpty()) {
            HashSet<Long> acctIds = new HashSet<Long>(100);
            for (Row row : voucherSet.copy()) {
                long acctId = row.getLong("account");
                acctIds.add(acctId);
                for (Map.Entry comAssistEntry : indexToComAssistField.entrySet()) {
                    map.computeIfAbsent((Integer)comAssistEntry.getKey(), x -> new HashSet()).add(row.getLong((String)comAssistEntry.getValue()));
                }
            }
            if (voucherList.contains("account")) {
                DataSet acctSet = this.getAccountSet("id, masterid account", new QFilter("id", "in", acctIds));
                List<String> fieldList = this.getDSFileds(voucherSet);
                fieldList.remove("account");
                voucherSet = voucherSet.join(acctSet, JoinType.INNER).on("account", "id").select(fieldList.toArray(new String[0]), new String[]{"account"}).finish();
            }
            for (Map.Entry comAssistEntry : indexToComAssistField.entrySet()) {
                int i = (Integer)comAssistEntry.getKey();
                String comField = (String)comAssistEntry.getValue();
                DataSet comds = QueryServiceHelper.queryDataSet((String)"AbstractCalculator.reCalculate", (String)this.commonAssist.get((int)(i - 1)).valueSource, (String)("id " + comField + ",masterid"), (QFilter[])new QFilter[]{new QFilter("id", "in", map.get(i))}, null);
                List<String> fields = this.getDSFileds(voucherSet);
                fields.removeIf(x -> x.equals(comField));
                voucherSet = voucherSet.join(comds, JoinType.LEFT).on(comField, comField).select(fields.toArray(new String[0]), new String[]{"masterid " + comField}).finish();
            }
        }
        return voucherSet;
    }

    private boolean hasMasteridProp(String entityId) {
        if ("bos_assistantdata_detail".equals(entityId)) {
            return true;
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty masterid = type.getProperty("masterid");
        return Objects.nonNull(masterid) && Objects.nonNull(masterid.getAlias());
    }

    private String sqltList(List<String> list) {
        String sel = list.toString();
        return sel.substring(1, sel.length() - 1);
    }

    private List<QFilter> getPLFilters(long bookTypeId, QueryParam param, String prefix) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("booktype", "=", (Object)bookTypeId));
        list.add(new QFilter("org", "in", (Object)this.orgList));
        if (param.getCurrencyIds() != null) {
            list.add(new QFilter(prefix + "currency", "in", (Object)param.getCurrencyIds()));
        }
        if (param.getAssGrpIds() != null) {
            list.add(new QFilter(prefix + "assgrp", "in", param.getAssGrpIds()));
        }
        if (param.getMeasureUnitIds() != null) {
            list.add(new QFilter(prefix + "measureunit", "in", (Object)param.getMeasureUnitIds()));
        }
        if (param.getAccountFilter() != null) {
            if (!this.accountModel.getFilterAccountIds().isEmpty()) {
                list.add(new QFilter(prefix + "account.masterid", "in", this.accountModel.getFilterAccountIds()));
            } else {
                list.add(this.getBalanceAcctFilter(param.getAccountFilter(), prefix + "account"));
            }
        }
        if (param.getCustomFilter() != null) {
            for (QFilter filter : param.getCustomFilter()) {
                if (filter.getProperty().startsWith("comassist")) {
                    list.add(new QFilter(prefix + filter.getProperty(), filter.getCP(), filter.getValue()));
                    continue;
                }
                list.add(filter.copy());
            }
        }
        return list;
    }

    public List<String> getDSFileds(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> result = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            String alias = field.getAlias();
            result.add(alias);
        }
        return result;
    }

    private DataSet getOrgInitBalance(long bookTypeId, long yearMinPeriodId) {
        if (this.orgList.length == 0 || bookTypeId == 0L) {
            return null;
        }
        List<AccountBookInfo> bookList = BDUtil.getBookFromAccSys(new HashSet<Long>(Arrays.asList(this.orgList)), bookTypeId);
        HashMap<Long, Long> startMap = new HashMap<Long, Long>();
        HashSet<Long> startPeriodIds = new HashSet<Long>(10);
        for (AccountBookInfo bookInfo : bookList) {
            long startPeriodId;
            if (!bookInfo.isIsendinit() || (startPeriodId = bookInfo.getStartPeriodId()) < yearMinPeriodId || startPeriodId > this.endPeriod) continue;
            long orgId = bookInfo.getOrgId();
            startMap.put(orgId, startPeriodId);
            startPeriodIds.add(startPeriodId);
        }
        String selPeriod = "id period, periodyear";
        QFilter fperiodId = new QFilter("id", "in", startPeriodIds);
        DataSet startPeriodSet = this.getPeriodSet(selPeriod, fperiodId.toArray());
        DataSet orgPeriodSet = this.getOrgPeriodDS(startMap);
        startPeriodSet = startPeriodSet.join(orgPeriodSet, JoinType.LEFT).on("period", "period").select(new String[]{"period", "periodyear"}, new String[]{"org"}).finish();
        List<String> groupList = this.getGroupList();
        groupList.removeIf(x -> x.equals("period"));
        groupList.removeIf(x -> x.equals("periodyear"));
        String groupSel = this.sqltList(groupList);
        String initSel = groupSel + ",yeardebitqty,yearcreditqty,yeardebitfor,yearcreditfor,yeardebitlocal,yearcreditlocal,yearprofitdebitqty,yearprofitcreditqty,yearprofitdebitfor,yearprofitcreditfor,yearprofitdebitlocal,yearprofitcreditlocal";
        List<QFilter> initFilters = this.getPLFilters(bookTypeId, this.param, "");
        ArrayList<String> acctTypes = new ArrayList<String>();
        acctTypes.add("4");
        initFilters.add(new QFilter("account.accounttype.accounttype", "in", acctTypes));
        DataSet initBalanceSet = this.getInitBalance(initSel, initFilters.toArray(new QFilter[0]));
        initBalanceSet = initBalanceSet.select(groupSel + ",yeardebitqty-yearprofitdebitqty vdebitqty,yearcreditqty-yearprofitcreditqty vcreditqty,yeardebitfor-yearprofitdebitfor vdebitfor,yearcreditfor-yearprofitcreditfor vcreditfor,yeardebitlocal-yearprofitdebitlocal vdebitlocal,yearcreditlocal-yearprofitcreditlocal vcreditlocal");
        ArrayList<String> initAmountList = new ArrayList<String>();
        initAmountList.addAll(groupList);
        initAmountList.addAll(Arrays.asList(vamoutFileds));
        initBalanceSet = initBalanceSet.join(startPeriodSet, JoinType.INNER).on("org", "org").select(initAmountList.toArray(new String[0]), new String[]{"0L period", "periodyear"}).finish();
        initBalanceSet = initBalanceSet.addField("0", "vcount");
        return initBalanceSet;
    }

    private DataSet getOrgPeriodDS(Map<Long, Long> map) {
        String[] fieldNames = new String[]{"org", "period"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.LongType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            builder.append(new Object[]{entry.getKey(), entry.getValue()});
        }
        return builder.build();
    }

    private DataSet getVoucher(String vSel, List<QFilter> voucherFilters) {
        MainEntityType voucherEntity = this.getMainEntityType("gl_voucher");
        if (voucherEntity != null) {
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_voucher", (IDataEntityType)voucherEntity);
            return VoucherQueryUtils.ormQueryDataSet((IDataEntityType)voucherEntity, vSel, voucherFilters.toArray(new QFilter[0]), null, -1);
        }
        return VoucherQueryUtils.queryDataSet(vSel, voucherFilters.toArray(new QFilter[0]), null, -1);
    }

    private DataSet getInitBalance(String sel, QFilter[] filters) {
        MainEntityType initBalEntity = this.getMainEntityType("gl_initbalance");
        if (initBalEntity != null) {
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_initbalance", (IDataEntityType)initBalEntity);
            return orm.queryDataSet(this.getClass().getName(), "gl_initbalance", sel, filters, null);
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_initbalance", (String)sel, (QFilter[])filters, null);
    }

    private MainEntityType getMainEntityType(String entityId) {
        MainEntityType entityType = null;
        if (this.param.getBalEntityType() != null && this.flexsProperty != null && !this.flexsProperty.isEmpty()) {
            try {
                entityType = (MainEntityType)EntityMetadataCache.getDataEntityType((String)entityId).clone();
                if ("gl_voucher".equals(entityId)) {
                    EntityType voucherEntry = (EntityType)entityType.getAllEntities().get("entries");
                    for (DynamicProperty flex : this.flexsProperty) {
                        voucherEntry.addProperty(flex);
                    }
                } else {
                    for (DynamicProperty flex : this.flexsProperty) {
                        entityType.addProperty(flex);
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return entityType;
    }

    private DataSet getBalanceData(QFilter[] filters) {
        DataSet balance;
        if (this.param.getBalEntityType() != null) {
            MainEntityType balEntity = this.param.getBalEntityType();
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_balance", (IDataEntityType)balEntity);
            if (DebugTrace.enable()) {
                LOG.info("balance_query filters :{}, order: {}, limit: {}", new Object[]{String.join((CharSequence)" | ", Arrays.stream(filters).map(x -> StringUtils.truncate((String)x.toString(), (int)1000)).collect(Collectors.toList())), this.param.getQueryOrder(), this.param.getQueryLimit()});
            }
            balance = orm.queryDataSet(this.getClass().getName(), "gl_balance", this.querySelector, filters, this.param.getQueryOrder(), this.param.getQueryLimit());
            Map pMap = balEntity.getAllFields();
            for (Map.Entry entry : pMap.entrySet()) {
                String key = (String)entry.getKey();
                IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
                if (!key.startsWith("assgrp_")) continue;
                this.flexsProperty.add((DynamicProperty)prop);
                this.assgrp_Flexs.add(prop.getName() + ".assval");
            }
        } else {
            if (DebugTrace.enable()) {
                LOG.info("balance_query2 filters :{}, order: {}, limit: {}", new Object[]{String.join((CharSequence)" | ", Arrays.stream(filters).map(x -> StringUtils.truncate((String)x.toString(), (int)1000)).collect(Collectors.toList())), this.param.getQueryOrder(), this.param.getQueryLimit()});
            }
            String balanceEntity = "gl_balance";
            if (BalanceQueryExecutor.isEnableQueryAcctBalEntity(this.oriSelector, filters)) {
                balanceEntity = "gl_acctbalance";
            }
            balance = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)balanceEntity, (String)this.querySelector, (QFilter[])filters, (String)this.param.getQueryOrder(), (int)this.param.getQueryLimit());
        }
        return balance;
    }

    private void init(String selector, Long[] orgIds, long accountTableId, long beginPeriodId, long endPeriodId, QueryParam param) {
        this.orgList = orgIds;
        this.oriSelector = selector.replace(".id", "");
        this.beginPeriod = beginPeriodId;
        this.endPeriod = endPeriodId;
        this.param = param;
        this.setQuerySelector(this.oriSelector, param);
        if (Objects.isNull(this.accountModel)) {
            this.accountModel = IAccountTreeModel.getInstance(orgIds, accountTableId, this.getAccountVersionPeriodId(), param);
        }
        if (this.beginPeriod != 0L) {
            QFilter fid = new QFilter("id", "=", (Object)this.endPeriod);
            DataSet endPeriodSet = this.getPeriodSet("periodyear", new QFilter[]{fid});
            this.endPeriodYear = ((Row)endPeriodSet.iterator().next()).getInteger("periodyear");
        }
    }

    private void setQuerySelector(String selector, QueryParam param) {
        String[] fields = selector.split(",");
        List<String> oriSel = this.getOriSel(fields);
        LinkedHashSet<String> querySet = new LinkedHashSet<String>();
        LinkedHashSet<String> acctSet = new LinkedHashSet<String>();
        for (String sel : oriSel) {
            HashSet<String> selSet;
            if (BEGIN_PROP.contains(sel)) {
                querySet.add(sel);
                querySet.add(sel.replace("begin", "end"));
                continue;
            }
            if (sel.startsWith("account.")) {
                if (!param.isOnlyLeafAcctBal()) {
                    acctSet.add(sel.substring(8));
                    continue;
                }
                selSet = this.entityRefMap.get("account") == null ? new HashSet<String>() : this.entityRefMap.get("account");
                selSet.add(sel.trim());
                this.entityRefMap.put("account", selSet);
                querySet.add("account");
                continue;
            }
            if (sel.startsWith("currency.")) {
                selSet = this.entityRefMap.get("currency") == null ? new HashSet() : this.entityRefMap.get("currency");
                selSet.add(sel.trim());
                this.entityRefMap.put("currency", selSet);
                querySet.add("currency");
                continue;
            }
            if (sel.startsWith("period.")) {
                selSet = this.entityRefMap.get("period") == null ? new HashSet() : this.entityRefMap.get("period");
                selSet.add(sel.trim());
                this.entityRefMap.put("period", selSet);
                querySet.add("period");
                continue;
            }
            if (sel.startsWith("measureunit.")) {
                selSet = this.entityRefMap.get("measureunit") == null ? new HashSet() : this.entityRefMap.get("measureunit");
                selSet.add(sel.trim());
                this.entityRefMap.put("measureunit", selSet);
                querySet.add("measureunit");
                continue;
            }
            querySet.add(sel);
        }
        if (param.isZeroBalNoDisplay()) {
            querySet.add("endfor");
            querySet.add("endlocal");
            querySet.add("endqty");
        }
        if (param.isZeroAmtNoDisplay()) {
            querySet.add("count");
        }
        if (querySet.contains("period")) {
            this.showPeriod = true;
        }
        querySet.add("org");
        querySet.add("booktype");
        querySet.add("period");
        querySet.add("endperiod");
        if (!param.isOnlyLeafAcctBal()) {
            querySet.add("account");
        }
        String str = ((Object)querySet).toString();
        this.querySelector = str.substring(1, str.length() - 1);
        acctSet.add("id");
        str = ((Object)acctSet).toString();
        this.acctSelector = str.substring(1, str.length() - 1);
    }

    private List<String> getOriSel(String[] fields) {
        ArrayList<String> oriSel = new ArrayList<String>();
        for (String field : fields) {
            int blank = (field = field.trim().toLowerCase()).indexOf(" ");
            if (blank == -1) {
                oriSel.add(field);
                continue;
            }
            oriSel.add(field.substring(0, blank));
        }
        return oriSel;
    }

    private DataSet levelSumAccountBalance(DataSet balance) {
        boolean notSumAssgrp = false;
        Field[] fields = balance.getRowMeta().getFields();
        HashSet<String> sumFieldSet = new HashSet<String>();
        HashSet<String> groupFieldSet = new HashSet<String>();
        ArrayList<String> selectSet = new ArrayList<String>();
        HashSet<String> leftSelectSet = new HashSet<String>();
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            if (!this.param.isSumAssgrp() && "assgrp".equals(name)) {
                notSumAssgrp = true;
                continue;
            }
            selectSet.add(name);
            if (!"account".equalsIgnoreCase(name)) {
                leftSelectSet.add(name);
            }
            if (field.getDataType() instanceof BigDecimalType || "count".equalsIgnoreCase(name)) {
                sumFieldSet.add(name);
                continue;
            }
            groupFieldSet.add(name);
        }
        String[] groupFields = groupFieldSet.toArray(new String[0]);
        String[] sumFields = sumFieldSet.toArray(new String[0]);
        String[] selector = selectSet.toArray(new String[0]);
        String[] leftSelector = leftSelectSet.toArray(new String[0]);
        return this.accountSum(balance, notSumAssgrp, groupFields, sumFields, selector, leftSelector);
    }

    private DataSet accountSum(DataSet balance, boolean notSumAssgrp, String[] groupFields, String[] sumFields, String[] selector, String[] leftSelector) {
        DataSet ds;
        DataSet pacctDataSet = balance;
        DataSet sumDataSet = null;
        boolean existParent = false;
        for (Object[] acc : this.accountModel.getAccountTreeData()) {
            if (acc[2] == null) continue;
            existParent = true;
            break;
        }
        while (existParent && (ds = pacctDataSet.copy().join(this.accountModel.getTreeDataSet(), JoinType.INNER).on("org", "org").on("account", "id").select(leftSelector, new String[]{"parent account"}).finish().filter("account !=0")).hasNext()) {
            GroupbyDataSet group = ds.groupBy(groupFields);
            GroupbyDataSet groupbyDataSet = sumFields;
            int n = ((GroupbyDataSet)groupbyDataSet).length;
            for (int i = 0; i < n; ++i) {
                GroupbyDataSet sumField = groupbyDataSet[i];
                group.sum((String)sumField);
            }
            pacctDataSet = group.finish().select(selector);
            sumDataSet = sumDataSet == null ? pacctDataSet : sumDataSet.union(pacctDataSet);
        }
        if (sumDataSet != null) {
            GroupbyDataSet group = sumDataSet.groupBy(groupFields);
            for (String sumField : sumFields) {
                group.sum(sumField);
            }
            sumDataSet = group.finish().select(selector);
            if (notSumAssgrp) {
                sumDataSet = sumDataSet.addField("0L", "assgrp");
                List<String> cols = BDUtil.getDataSetCols(balance);
                sumDataSet = sumDataSet.select(cols.toArray(new String[0]));
            }
            return balance.addField("true", TAG_LEAF).union(sumDataSet.addField("false", TAG_LEAF));
        }
        return balance.addField("true", TAG_LEAF);
    }

    private DataSet getGroupBalance(DataSet ds) {
        Field[] fields;
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> sums = new ArrayList<String>();
        for (Field field : fields = ds.getRowMeta().getFields()) {
            String name = field.getName().toLowerCase();
            if (field.getDataType() instanceof BigDecimalType || "count".equals(name)) {
                sums.add(name);
                continue;
            }
            if (name.contains("period")) continue;
            groups.add(name);
        }
        if (this.showPeriod) {
            groups.add("period");
        }
        GroupbyDataSet groupSet = ds.groupBy(groups.toArray(new String[0]));
        if (this.showPeriod) {
            for (String field : sums) {
                groupSet.sum(field);
            }
        } else {
            this.groupSum(sums, groupSet);
        }
        DataSet finish = groupSet.finish();
        return finish;
    }

    private DataSet addAmountFilter(DataSet finish) {
        if (this.param.isZeroAmtNoDisplay()) {
            finish = this.param.isZeroBalNoDisplay() ? finish.filter("count > 0 or endfor <> 0 or endlocal <> 0 or endqty <> 0") : finish.filter("count > 0");
        } else if (this.param.isZeroBalNoDisplay()) {
            finish = finish.filter("endfor <> 0 or endlocal <> 0 or endqty <> 0");
        }
        return finish;
    }

    private void groupSum(List<String> sums, GroupbyDataSet groupSet) {
        for (String field : sums) {
            if (BEGIN_PROP.contains(field)) {
                groupSet.sum("case when period =" + this.beginPeriod + THEN + field + " when period < " + this.beginPeriod + " and endperiod > " + this.beginPeriod + THEN + field.replace("begin", "end") + ELSE0_0END, field);
                continue;
            }
            if (DCP_PROP.contains(field)) {
                groupSet.sum("case when period >=" + this.beginPeriod + THEN + field + ELSE0_0END, field);
                continue;
            }
            if (YEAR_PROP.contains(field)) {
                if (this.endPeriod == 0L) {
                    groupSet.sum(field);
                    continue;
                }
                groupSet.sum("case when endperiod >" + this.endPeriod + " and period <=" + this.endPeriod + " and (period >" + this.endPeriod / PeriodUtil.YEAR_PERIOD_L * PeriodUtil.YEAR_PERIOD_L + ")" + THEN + field + ELSE0_0END, field);
                continue;
            }
            if (END_PROP.contains(field)) {
                groupSet.sum("case when period<=" + this.endPeriod + " and endperiod >" + this.endPeriod + THEN + field + ELSE0_0END, field);
                continue;
            }
            if (!"count".equals(field)) continue;
            groupSet.sum("case when period >=" + this.beginPeriod + " and period <= " + this.endPeriod + THEN + field + ELSE0END, field);
        }
    }

    private QFilter[] getFilters(long bookTypeId, long accountTableId, QueryParam param, boolean isVoucherAcctBalLog) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("booktype", "=", (Object)bookTypeId));
        list.add(new QFilter("org", "in", (Object)this.orgList));
        list.add(new QFilter("accounttable", "=", (Object)accountTableId));
        if (!isVoucherAcctBalLog) {
            if (this.beginPeriod > 0L) {
                list.add(new QFilter("endperiod", "in", PeriodUtil.getAvailableEndPeriodIds(">", this.beginPeriod, this.orgList)));
            }
            if (this.showPeriod) {
                List<Long> periodIds = PeriodUtil.getPeriodIds(this.beginPeriod, (Long)this.endPeriod);
                list.add(new QFilter("period", "in", periodIds));
            } else {
                list.add(new QFilter("period", "<=", (Object)this.endPeriod));
                list.add(new QFilter("period", ">=", (Object)(this.endPeriod / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
            }
        } else {
            list.add(new QFilter("period", ">=", (Object)(this.endPeriod / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
            list.add(new QFilter("period", "<=", (Object)this.endPeriod));
            list.add(new QFilter("calculated", "=", (Object)"0"));
        }
        if (param.getCurrencyIds() != null) {
            list.add(new QFilter("currency", "in", (Object)param.getCurrencyIds()));
        }
        if (param.getAssGrpIds() != null) {
            list.add(new QFilter("assgrp", "in", param.getAssGrpIds()));
        }
        if (param.getMeasureUnitIds() != null) {
            list.add(new QFilter("measureunit", "in", (Object)param.getMeasureUnitIds()));
        }
        if (param.getAccountFilter() != null) {
            if (!this.accountModel.getFilterAccountIds().isEmpty()) {
                list.add(new QFilter("account", "in", this.accountModel.getFilterAccountIds()));
            } else {
                list.add(this.getBalanceAcctFilter(param.getAccountFilter(), "account"));
            }
        }
        if (Objects.nonNull(param.getCustomFilter()) && !param.getCustomFilter().isEmpty()) {
            list.addAll(param.getCustomFilter());
        }
        return list.toArray(new QFilter[0]);
    }

    private QFilter getBalanceAcctFilter(QFilter accountFilter, String prefix) {
        HashSet<Long> set = new HashSet<Long>(0);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".acct"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{accountFilter}, null);){
            for (Row row : dataSet) {
                set.add(row.getLong("id"));
                set.add(row.getLong("masterid"));
            }
        }
        return new QFilter(prefix, "in", set);
    }

    private DataSet getAccountSet(String selector, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)selector, (QFilter[])filter.toArray(), null);
    }

    private DataSet getPeriodSet(String selector, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".period"), (String)"bd_period", (String)selector, (QFilter[])filters, null);
    }

    private long getAccountVersionPeriodId() {
        return this.param.getAccountVersionPeriodId() == 0L ? this.endPeriod : this.param.getAccountVersionPeriodId();
    }
}

