/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.balance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.consts.VoucherStatus;
import kd.fi.bd.indexing.constant.ESTextMatchModeEnum;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.indexing.tasks.GLVoucherTextESIndexQueryTask;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.model.indexing.IExIndexQueryResult;
import kd.fi.bd.service.voucher.TempVoucherIndexAdapter;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.FlexUtils;
import kd.fi.bd.util.PermissonType;
import kd.fi.bd.util.filter.FilterValueMergeContainer;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;
import org.apache.commons.lang3.StringUtils;

public class VoucherQueryUtils {
    private static final Log LOGGER = ExtLogFactory.getLog(VoucherQueryUtils.class);
    private static final String POINT = ".";
    private static final String REGEX = "_";
    private static final String REGEX_POINT = "\\.";
    private static final String GL_ASSIST_TXT = "gl_assist_txt";
    private static final String GL_ASSIST_BD = "gl_assist_bd";
    private static final String ASSVAL = "assval";
    private static final String HG = "hg";
    private static final String ENTRIES_PREFIX = "entries.";
    private static final String Prop_Voucher_Description = "entries.edescription";
    private static final Predicate<QFilter> IS_SINGLE_Q_FILTER = x -> null != x && !x.isJoinFilter() && !x.isExistsFilter() && !x.isExpressValue() && !x.isParseExistsValue() && !x.isOnMetaJoinPropertyFilter() && !x.isJoinSQLFilter();
    private static final String[] ADD_TO_ENTRY_PROPS = new String[]{"org", "period"};
    private static final String E_PREFIX = "e";
    private static final String ID_SUFFIX = ".id";
    private static final int FILTER_LEN_LIMIT = 500;

    private VoucherQueryUtils() {
    }

    @Deprecated
    public static String enhanceOrderBy(String orderBy, boolean existsEntrySelect) {
        return orderBy;
    }

    public static QFilter[] enhanceFilters(QFilter[] originalFilters, boolean selectEntry) {
        return VoucherQueryUtils.enhanceFilters(originalFilters, selectEntry, EntityMetadataCache.getDataEntityType((String)"gl_voucher"));
    }

    public static QFilter[] enhanceFilters(QFilter[] originalFilters, boolean selectEntry, MainEntityType voucherEntityType) {
        if (originalFilters == null || originalFilters.length == 0) {
            return originalFilters;
        }
        LOGGER.info("voucher_filter_enhance original filters is : " + VoucherQueryUtils.formatFilterAsString(Arrays.stream(originalFilters)));
        try {
            boolean isESIndexEnabled;
            List<QFilter> filterList = Arrays.stream(originalFilters).filter(Objects::nonNull).collect(Collectors.toList());
            filterList = VoucherQueryUtils.distinctToFilterList(filterList.toArray(new QFilter[0]));
            VoucherQueryUtils.enhanceSubPropToMainPropIdFilter(filterList, voucherEntityType);
            VoucherQueryUtils.enhancePeriodFilter(filterList);
            VoucherQueryUtils.enhanceVchNumFilterToVchIdFilter(filterList);
            VoucherQueryUtils.enhanceFlexFilter(filterList);
            VoucherQueryUtils.doTempVoucherIndexOptimize(filterList);
            if (OptimizeControlPanel.isFilterAutoOptimizeEnabled()) {
                LOGGER.info("start mergeDuplicateFilters original filters is : {}", filterList);
                filterList = QFilterBuilder.mergeDuplicateFilters(filterList);
                LOGGER.info("Completed mergeDuplicateFilters merged filters is : {}", filterList);
            }
            if (isESIndexEnabled = ExIndexConstant.isESIndexEnabled("bd_regtextinfo")) {
                LOGGER.info("start doFullTextSearchOptimize original filters is : (Enabled={}), {}", (Object)isESIndexEnabled, (Object)QFilterBuilder.dumpQFilters(filterList));
                filterList = VoucherQueryUtils.doFullTextSearchOptimize(filterList, selectEntry).getFilters();
            }
            LOGGER.info("voucher_filter_enhance vch no trans filters is : " + VoucherQueryUtils.formatFilterAsString(filterList.stream()));
            if (VoucherQueryUtils.isEntryRedundantFilterEnable() && filterList.stream().filter(Objects::nonNull).anyMatch(x -> VoucherQueryUtils.isFilterMatchOrNestsAnyMatch(x, y -> y.getProperty().startsWith(ENTRIES_PREFIX)))) {
                VoucherQueryUtils.enhanceOrgPeriodFilterToEntry(filterList);
                LOGGER.info("voucher_filter_enhance add eorg eperioid filters is : " + VoucherQueryUtils.formatFilterAsString(filterList.stream()));
            }
            return filterList.toArray(new QFilter[0]);
        }
        catch (Exception e) {
            LOGGER.error("voucher_filter_enhance failed on:" + e.getMessage(), (Throwable)e);
            return originalFilters;
        }
    }

    private static void doTempVoucherIndexOptimize(List<QFilter> filters) {
        boolean enable = BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.gl.voucher.query.withTempVoucherIndex.enable", true);
        LOGGER.info("fi.gl.voucher.query.withTempVoucherIndex.enable:" + enable);
        if (!enable) {
            return;
        }
        QFilterBuilder qFilterBuilder = QFilterBuilder.modifyFilters(filters, false, filter -> {
            if (!VoucherStatus.isFilterNotSubmittedVoucher(filter)) {
                return filter;
            }
            Optional<Set<Long>> tempIds = TempVoucherIndexAdapter.tryGetTempIdsByVoucherQueryFilter(filters, VoucherQueryUtils.getInThreshold());
            return tempIds.map(ids -> new QFilter("id", "in", ids).and(filter)).orElse((QFilter)filter);
        }, new String[]{"billstatus"});
        filters.clear();
        filters.addAll(qFilterBuilder.getFilters());
    }

    private static int getInThreshold() {
        return HugeInConfig.inThreshold() > 0 ? HugeInConfig.inThreshold() : 1000;
    }

    private static QFilterBuilder doFullTextSearchOptimize(List<QFilter> srcFilterList, boolean selectEntry) throws Exception {
        QFilterBuilder optimizeResult;
        block6: {
            boolean directJoinTextTable;
            IExIndexQueryResult exIndexResult;
            FilterValueMergeContainer mergeContainer;
            HashSet perioIdList;
            HashSet orgIdList;
            block8: {
                block7: {
                    orgIdList = new HashSet(8);
                    perioIdList = new HashSet(8);
                    AtomicBoolean hasDescription = new AtomicBoolean(false);
                    mergeContainer = new FilterValueMergeContainer(2);
                    optimizeResult = QFilterBuilder.modifyFilters(srcFilterList, false, filter -> {
                        switch (filter.getProperty().toLowerCase()) {
                            case "org": 
                            case "orgid": 
                            case "org.id": {
                                QFilterBuilder.parseContainerValues(filter.getValue(), t -> orgIdList.add(t));
                                break;
                            }
                            case "period": 
                            case "periodid": 
                            case "period.id": {
                                QFilterBuilder.parseContainerValues(filter.getValue(), t -> perioIdList.add(t));
                                break;
                            }
                            case "vdescription": 
                            case "entries.edescription": {
                                hasDescription.set(true);
                                mergeContainer.addFilter((QFilter)filter);
                                break;
                            }
                        }
                        return filter;
                    }, new String[]{Prop_Voucher_Description, "vdescription", "org", "orgid", "period", "periodid"});
                    LOGGER.info("doFullTextSearchOptimize hasDescription={}, mergeContainer={}", (Object)hasDescription, (Object)mergeContainer);
                    if (!hasDescription.get()) break block6;
                    srcFilterList = QFilterBuilder.mergeDuplicateFilters(srcFilterList);
                    ESTextMatchModeEnum textMatchModeEnum = ESTextMatchModeEnum.Wildcard;
                    GLVoucherTextESIndexQueryTask queryTask = new GLVoucherTextESIndexQueryTask(null, "bd_regtextinfo", srcFilterList, ExIndexConstant.ES_Query_Page_Size, ExIndexConstant.ES_Query_Max_Cnt / ExIndexConstant.ES_Query_Page_Size, textMatchModeEnum);
                    exIndexResult = (IExIndexQueryResult)queryTask.call();
                    directJoinTextTable = false;
                    if (exIndexResult == null) break block7;
                    switch (exIndexResult.getRecordCheckStatus()) {
                        case Within_Limit: {
                            if (exIndexResult.getActualMatchCnt() > 0) {
                                optimizeResult.add(exIndexResult.buildQFilter()).toArray(new QFilter[0]);
                                break;
                            }
                            break block8;
                        }
                        case No_Record: {
                            optimizeResult.clear().add(QFilterBuilder.getVoidFilter()).toArray(new QFilter[0]);
                            break;
                        }
                        default: {
                            directJoinTextTable = true;
                            break;
                        }
                    }
                    break block8;
                }
                directJoinTextTable = true;
            }
            LOGGER.info("After GLVoucherTextESIndexQueryTask: directJoinTextTable={}, IExIndexQueryResult={}", (Object)directJoinTextTable, (Object)exIndexResult);
            if (selectEntry && directJoinTextTable && !mergeContainer.isEmpty()) {
                String joinSql = String.format(" inner join t_bd_regtextownership ownership on ownership.fownerrecid=A.fid  inner join t_bd_regtextinfo textinfo on textinfo.fid = ownership.fid  and textinfo.forgid in %s and textinfo.fperiodid in %s ", QFilterBuilder.buildSQLParamHolder(orgIdList.size()), QFilterBuilder.buildSQLParamHolder(perioIdList.size()));
                PairTuple<String, List<Object>> joinSQLInfo = QFilterBuilder.convertToJoinSQL(joinSql, mergeContainer.getFilterBuilder(), paramMode -> " and textinfo.fregtext %s %s");
                joinSQLInfo.getValue().addAll(0, perioIdList);
                joinSQLInfo.getValue().addAll(0, orgIdList);
                optimizeResult.add(QFilter.joinSQL((String)"gl_voucher", (String)joinSQLInfo.getKey(), (Object[])joinSQLInfo.getValue().toArray()));
            }
        }
        LOGGER.info("Final doFullTextSearchOptimize Result: directJoinTextTable={}, IExIndexQueryResult={}", (Object)optimizeResult);
        return optimizeResult;
    }

    public static List<QFilter> distinctToFilterList(QFilter[] filters) {
        LinkedHashMap<String, QFilter> filterMap = new LinkedHashMap<String, QFilter>(filters.length);
        for (QFilter filter : filters) {
            if (!IS_SINGLE_Q_FILTER.test(filter) || filter.getNests(false).stream().anyMatch(nest -> !IS_SINGLE_Q_FILTER.test(nest.getFilter()))) {
                filterMap.put(filter.toString(), filter);
                continue;
            }
            List nests = filter.getNests(true);
            if (CollectionUtils.isEmpty((Collection)nests) || nests.stream().anyMatch(x -> !x.isAnd())) {
                filterMap.put(filter.toString(), filter);
                continue;
            }
            QFilter firstFilter = filter.__copy(false);
            filterMap.put(firstFilter.toString(), firstFilter);
            for (QFilter.QFilterNest nest2 : nests) {
                QFilter nestFilter = nest2.getFilter().__copy(false);
                filterMap.put(nestFilter.toString(), nestFilter);
            }
        }
        return new LinkedList<QFilter>(filterMap.values());
    }

    private static void enhanceSubPropToMainPropIdFilter(List<QFilter> filterList, MainEntityType voucherEntityType) {
        QFilterBuilder.RegexFilterNameMatcher mainPropMatcher = new QFilterBuilder.RegexFilterNameMatcher("(?<fullMainProp>(entries\\.)?(?<mainProp>.*?))(?<subProp>\\..*)");
        QFilterBuilder filterBuilder = QFilterBuilder.modifyFilters(filterList, false, srcFilter -> {
            String mainProp = mainPropMatcher.getMatchCacheResult().group("mainProp");
            String fullMainProp = mainPropMatcher.getMatchCacheResult().group("fullMainProp");
            String subProp = mainPropMatcher.getMatchCacheResult().group("subProp");
            if (StringUtils.isNotEmpty((CharSequence)subProp) && subProp.startsWith(POINT)) {
                subProp = subProp.substring(1);
            }
            LOGGER.info("filter transform debug: mainProp={},fullMainProp={},subProp={}", new Object[]{mainProp, fullMainProp, subProp});
            IDataEntityProperty propertyBuf = voucherEntityType.findProperty(mainProp);
            if (propertyBuf != null && propertyBuf instanceof BasedataProp) {
                List<QFilter> filters = VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList(Collections.singletonList(srcFilter), x -> x.getProperty().startsWith(fullMainProp + POINT) && !x.getProperty().equalsIgnoreCase(fullMainProp + POINT + "id"));
                if (filters.isEmpty()) {
                    return srcFilter;
                }
                String mainPropEntity = ((BasedataProp)propertyBuf).getBaseEntityId();
                if (mainPropEntity.startsWith("assgrp_")) {
                    return srcFilter;
                }
                return VoucherQueryUtils.transSubPropFilterToMainPropFilter(srcFilter, mainPropEntity, fullMainProp, subProp);
            }
            return srcFilter;
        }, mainPropMatcher);
        filterList.clear();
        filterList.addAll(filterBuilder.getFilters());
    }

    private static QFilter transSubPropFilterToMainPropFilter(QFilter srcFilter, String filterEntity, String mainProp, String subProp) {
        LOGGER.info("voucher_filter_enhance origianl sub prop filters is : " + srcFilter);
        List<QFilter> mainPropEntityFilterList = VoucherQueryUtils.transFilterList(Collections.singletonList(srcFilter), x -> {
            QFilter filter = x.__copy(false);
            filter.__setProperty(VoucherQueryUtils.getSubProperty(x.getProperty()));
            return filter;
        });
        LOGGER.info("voucher_filter_enhance trans main prop entity filters is : " + mainPropEntityFilterList);
        return VoucherQueryUtils.tryGetMainPropIdsIfLimited(mainPropEntityFilterList, filterEntity, mainProp).map(x -> new QFilter(mainProp, "in", x)).orElse(srcFilter);
    }

    private static String getSubProperty(String origianlProperty) {
        int pointIndex;
        if (origianlProperty.startsWith(ENTRIES_PREFIX)) {
            origianlProperty = origianlProperty.replace(ENTRIES_PREFIX, "");
        }
        if ((pointIndex = origianlProperty.indexOf(POINT)) >= 0) {
            String subProperty = origianlProperty.substring(pointIndex + 1);
            return StringUtils.isNotBlank((CharSequence)subProperty) ? subProperty : "id";
        }
        return "id";
    }

    private static Optional<List<Object>> tryGetMainPropIdsIfLimited(List<QFilter> entityFilters, String filterEntity, String mainProp) {
        QFilter customFilter = VoucherQueryUtils.getCustomFilterOnMainPropEntity(mainProp);
        if (customFilter != null) {
            entityFilters.add(customFilter);
        }
        if ("org".equalsIgnoreCase(mainProp) || "entries.comassist1".equalsIgnoreCase(mainProp) || "entries.comassist2".equalsIgnoreCase(mainProp)) {
            return Optional.of(QueryServiceHelper.queryPrimaryKeys((String)filterEntity, (QFilter[])entityFilters.toArray(new QFilter[0]), null, (int)-1));
        }
        int inThreshold = VoucherQueryUtils.getInThreshold();
        List pkValues = QueryServiceHelper.queryPrimaryKeys((String)filterEntity, (QFilter[])entityFilters.toArray(new QFilter[0]), null, (int)(inThreshold + 1));
        if (pkValues.size() > inThreshold) {
            return Optional.empty();
        }
        return Optional.of(pkValues);
    }

    private static QFilter getCustomFilterOnMainPropEntity(String mainProp) {
        if ("org".equals(mainProp)) {
            return new QFilter("id", "in", BDUtil.getAcctOrgPkList("gl_voucher", PermissonType.VIEW));
        }
        return null;
    }

    private static void enhancePeriodFilter(List<QFilter> filterList) {
        List<QFilter> vchPeriodFilterList = VoucherQueryUtils.getFilterMatchOrNestsAnyMatchFilterList(filterList, x -> x.getProperty().startsWith("period"));
        if (vchPeriodFilterList.isEmpty()) {
            return;
        }
        if (vchPeriodFilterList.size() == 1 && ("in".equalsIgnoreCase(vchPeriodFilterList.get(0).getCP()) || "=".equalsIgnoreCase(vchPeriodFilterList.get(0).getCP()))) {
            return;
        }
        List<QFilter> periodFilterList = VoucherQueryUtils.transFilterList(vchPeriodFilterList, x -> {
            QFilter filter = x.__copy(false);
            filter.__setProperty(VoucherQueryUtils.getSubProperty(x.getProperty()));
            return filter;
        });
        List periodIdList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])periodFilterList.toArray(new QFilter[0]), null, (int)-1);
        filterList.removeAll(vchPeriodFilterList);
        filterList.add(new QFilter("period", "in", (Object)periodIdList));
    }

    private static void enhanceVchNumFilterToVchIdFilter(List<QFilter> filterList) {
        Predicate<QFilter> vchNoFilter = x -> x.getProperty().equalsIgnoreCase("billno") && ("=".equalsIgnoreCase(x.getCP()) || "in".equalsIgnoreCase(x.getCP()));
        List<QFilter> vchNumFilterList = VoucherQueryUtils.getFilterMatchOrNestsAnyMatchFilterList(filterList, vchNoFilter);
        LOGGER.info("voucher_filter_enhance vch num filter is : " + vchNumFilterList);
        if (CollectionUtils.isEmpty(vchNumFilterList)) {
            return;
        }
        int limit = VoucherQueryUtils.getInThreshold();
        try (DataSet vouchers = QueryServiceHelper.queryDataSet((String)VoucherQueryUtils.class.getName(), (String)"gl_voucher", (String)"id", (QFilter[])vchNumFilterList.toArray(new QFilter[0]), (String)"billno", (int)(limit + 1));){
            ArrayList voucherIds = new ArrayList(10);
            vouchers.forEach(x -> voucherIds.add(x.get(0)));
            if (voucherIds.size() > limit) {
                return;
            }
            filterList.removeAll(vchNumFilterList);
            QFilter idFilter = new QFilter("id", "in", voucherIds);
            LOGGER.info("voucher_filter_enhance vch num to id filter is : " + idFilter);
            filterList.add(idFilter);
        }
    }

    private static int getEnhanceFlexFilterGroupIdLimitSize() {
        int limitSize = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.gl.voucher.query.filters.limitsize", 1000);
        LOGGER.info("voucher_filter_enhance flex limt size:" + limitSize);
        return limitSize;
    }

    private static int getEnhanceFlexFilterAddAccountIdLimitSize() {
        int limitSize = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.gl.voucher.query.filters.account.limitsize", 5);
        LOGGER.info("voucher_filter_enhance flex add acount limt size:" + limitSize);
        return limitSize;
    }

    private static void enhanceFlexFilter(List<QFilter> filterList) {
        boolean existsAcctFilter;
        List<Object> flexGroupIds;
        List<QFilter> flexFilterList = VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList(filterList, x -> x.getNests(false).isEmpty() && x.getProperty().startsWith("entries.assgrp_") && ("in".equalsIgnoreCase(x.getCP()) || "=".equalsIgnoreCase(x.getCP())));
        List<FlexFilter> flexFilters = VoucherQueryUtils.transFlexFilterList(flexFilterList);
        if (flexFilters.isEmpty()) {
            return;
        }
        int limitSize = VoucherQueryUtils.getEnhanceFlexFilterGroupIdLimitSize();
        if (limitSize > 0 && (flexGroupIds = VoucherQueryUtils.buildFlexGroupIdList(flexFilters, limitSize)).size() <= limitSize) {
            filterList.removeAll(flexFilterList);
            filterList.add(new QFilter("entries.assgrp", "in", flexGroupIds));
        }
        if (existsAcctFilter = filterList.stream().anyMatch(x -> x.getProperty().startsWith("entries.account"))) {
            return;
        }
        Map<String, FlexProperty> flexPropertyMap = FlexUtils.batchGetFlexProperty((String[])flexFilters.stream().map(FlexFilter::getFlexField).distinct().toArray(String[]::new));
        Set flexPropIdSet = flexPropertyMap.values().stream().map(FlexProperty::getId).collect(Collectors.toSet());
        if (flexPropIdSet.isEmpty()) {
            return;
        }
        QFilter assistFilter = new QFilter("checkitementry.asstactitem", "in", flexPropIdSet);
        List accIdList = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])assistFilter.toArray(), null, (int)-1);
        int accountLimit = VoucherQueryUtils.getEnhanceFlexFilterAddAccountIdLimitSize();
        if (accIdList.size() <= accountLimit) {
            filterList.add(new QFilter("entries.account", "in", (Object)accIdList));
        }
    }

    private static void enhanceOrgPeriodFilterToEntry(List<QFilter> filterList) {
        for (String addToEntryProp : ADD_TO_ENTRY_PROPS) {
            List<QFilter> porpFilterList;
            List originalEntryPropFilterList = filterList.stream().filter(Objects::nonNull).filter(x -> VoucherQueryUtils.isFilterMatchOrNestsAnyMatch(x, y -> y.getProperty().startsWith("entries.e" + addToEntryProp))).collect(Collectors.toList());
            if (!originalEntryPropFilterList.isEmpty() || (porpFilterList = VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList(filterList, x -> x.getProperty().equalsIgnoreCase(addToEntryProp) || x.getProperty().equalsIgnoreCase(addToEntryProp + ID_SUFFIX))).isEmpty()) continue;
            List<QFilter> propOnEntryFilterList = VoucherQueryUtils.transFilterList(porpFilterList, x -> new QFilter("entries.e" + addToEntryProp, x.getCP(), x.getValue()));
            filterList.addAll(propOnEntryFilterList);
        }
    }

    public static boolean isEntryRedundantFilterEnable() {
        boolean isEntryRedundantFilterEnable = BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.gl.voucher.entryredundant.filter.enable", true);
        LOGGER.info("voucher_filter_enhance entry redundant filter enable:" + isEntryRedundantFilterEnable);
        return isEntryRedundantFilterEnable;
    }

    public static List<QFilter> getFilterMatchOrNestsAnyMatchFilterList(List<QFilter> filterList, Predicate<QFilter> matchCondition) {
        return filterList.stream().filter(Objects::nonNull).filter(IS_SINGLE_Q_FILTER).filter(VoucherQueryUtils::isSameFieldFilter).filter(x -> VoucherQueryUtils.isFilterMatchOrNestsAnyMatch(x, matchCondition)).collect(Collectors.toList());
    }

    private static boolean isFilterMatchOrNestsAnyMatchFilterList(QFilter qFilter, Predicate<QFilter> matchCondition) {
        return !VoucherQueryUtils.getFilterMatchOrNestsAnyMatchFilterList(Collections.singletonList(qFilter), matchCondition).isEmpty();
    }

    public static List<QFilter> getFilterMatchAndNestsAllMatchFilterList(List<QFilter> filterList, Predicate<QFilter> matchCondition) {
        return filterList.stream().filter(f -> VoucherQueryUtils.testFilterMatchAndNestsAllMatch(f, matchCondition)).collect(Collectors.toList());
    }

    public static List<QFilter> removeFilterMatchAndNestsAllMatchFilterList(List<QFilter> filterList, Predicate<QFilter> matchCondition) {
        return filterList.stream().filter(x -> !VoucherQueryUtils.testFilterMatchAndNestsAllMatch(x, matchCondition)).collect(Collectors.toList());
    }

    private static boolean testFilterMatchAndNestsAllMatch(QFilter filter, Predicate<QFilter> matchCondition) {
        return Objects.nonNull(filter) && IS_SINGLE_Q_FILTER.test(filter) && VoucherQueryUtils.isSameFieldFilter(filter) && VoucherQueryUtils.isFilterMatchAndNestsAllMatch(filter, matchCondition);
    }

    private static boolean isSameFieldFilter(QFilter filter) {
        if (filter == null) {
            return false;
        }
        List nests = filter.getNests(true);
        if (nests.isEmpty()) {
            return true;
        }
        Set fieldSet = nests.stream().map(x -> VoucherQueryUtils.getFilterMainProp(x.getFilter().getProperty())).collect(Collectors.toSet());
        fieldSet.add(VoucherQueryUtils.getFilterMainProp(filter.getProperty()));
        return fieldSet.size() <= 1;
    }

    private static String getFilterMainProp(String property) {
        String[] split = property.split(REGEX_POINT);
        if (property.startsWith(ENTRIES_PREFIX)) {
            return ENTRIES_PREFIX + split[1];
        }
        return split[0];
    }

    private static boolean isFilterMatchOrNestsAnyMatch(QFilter filter, Predicate<QFilter> matchCondition) {
        if (matchCondition.test(filter)) {
            return true;
        }
        return filter.getNests(true).stream().anyMatch(x -> matchCondition.test(x.getFilter()));
    }

    private static boolean isFilterMatchAndNestsAllMatch(QFilter filter, Predicate<QFilter> matchCondition) {
        List nests = filter.getNests(true);
        if (nests.isEmpty()) {
            return matchCondition.test(filter);
        }
        return matchCondition.test(filter) && filter.getNests(true).stream().allMatch(x -> matchCondition.test(x.getFilter()));
    }

    public static List<QFilter> transFilterList(List<QFilter> originalFilterList, UnaryOperator<QFilter> transFunc) {
        return originalFilterList.stream().map(x -> {
            QFilter transFilter = (QFilter)transFunc.apply((QFilter)x);
            List nestList = x.getNests(true);
            if (!nestList.isEmpty()) {
                for (QFilter.QFilterNest nest : nestList) {
                    QFilter nestFilter = nest.getFilter();
                    QFilter transNestFilter = (QFilter)transFunc.apply(nestFilter);
                    if (nest.isAnd()) {
                        transFilter = transFilter.and(transNestFilter);
                        continue;
                    }
                    transFilter = transFilter.or(transNestFilter);
                }
            }
            return transFilter;
        }).collect(Collectors.toList());
    }

    public static List<Object> queryPrimaryKeys(QFilter[] filters, String orderBys, int top) {
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters(filters, false);
        return QueryServiceHelper.queryPrimaryKeys((String)VoucherQueryUtils.class.getName(), (String)"gl_voucher", (QFilter[])enhanceFilters, (String)orderBys, (int)top);
    }

    public static DataSet queryDataSet(String selectFields, QFilter[] filters, String orderBys, int top) {
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters(filters, VoucherQueryUtils.isContainsEntrySelect(selectFields, orderBys));
        return QueryServiceHelper.queryDataSet((String)VoucherQueryUtils.class.getName(), (String)"gl_voucher", (String)selectFields, (QFilter[])enhanceFilters, (String)orderBys, (int)top);
    }

    public static DataSet ormQueryDataSet(IDataEntityType vchEntityType, String selectFields, QFilter[] filters, String orderBys, int top) {
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", vchEntityType);
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters(filters, VoucherQueryUtils.isContainsEntrySelect(selectFields, orderBys));
        return orm.queryDataSet(VoucherQueryUtils.class.getName(), "gl_voucher", selectFields, enhanceFilters, orderBys, top);
    }

    public static DataSet ormQueryDataSet(ORM orm, String selectFields, QFilter[] filters, String orderBys, int top) {
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters(filters, VoucherQueryUtils.isContainsEntrySelect(selectFields, orderBys));
        return orm.queryDataSet(VoucherQueryUtils.class.getName(), "gl_voucher", selectFields, enhanceFilters, orderBys, top);
    }

    public static boolean exists(QFilter[] filters) {
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters(filters, false);
        return QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])enhanceFilters);
    }

    private static boolean isContainsEntrySelect(String selectFields, String orderBys) {
        return StringUtils.isNotBlank((CharSequence)selectFields) && selectFields.contains(ENTRIES_PREFIX) || StringUtils.isNotBlank((CharSequence)orderBys) && orderBys.contains(ENTRIES_PREFIX);
    }

    public static String formatFilterAsString(Stream<QFilter> filterStream) {
        if (!DebugTrace.enable()) {
            return "Debug trace not enabled";
        }
        if (null == filterStream) {
            return "- null -";
        }
        return StringUtils.join((Iterable)filterStream.map(x -> {
            if (null == x) {
                return "null";
            }
            String fullString = x.toString();
            return fullString.length() <= 500 ? fullString : fullString.substring(0, 500) + String.format("--ignore %s chars -- ", fullString.length() - 500);
        }).collect(Collectors.toList()), (String)" | ");
    }

    private static List<Object> buildFlexGroupIdList(List<FlexFilter> filters, int limitSize) {
        HashMap<String, List<QFilter>> flexFieldFilterMap = new HashMap<String, List<QFilter>>(filters.size());
        HashMap<String, List<Object>> flexTxtValuesMap = new HashMap<String, List<Object>>(filters.size());
        HashMap<String, List<Object>> flexBdValuesMap = new HashMap<String, List<Object>>(filters.size());
        Map<String, String> flexEntityMap = filters.stream().collect(Collectors.toMap(FlexFilter::getFlexField, FlexFilter::getEntity, (oldVal, newVal) -> newVal));
        VoucherQueryUtils.mergetFlexFilter(filters, flexTxtValuesMap, flexBdValuesMap, flexFieldFilterMap);
        VoucherQueryUtils.queryBaseDataFillBdValues(flexBdValuesMap, flexFieldFilterMap, flexEntityMap);
        return VoucherQueryUtils.queryFlexGroupIdList(flexBdValuesMap, flexTxtValuesMap, limitSize + 1);
    }

    private static void mergetFlexFilter(List<FlexFilter> filters, Map<String, List<Object>> txtValuesMap, Map<String, List<Object>> bdValuesMap, Map<String, List<QFilter>> flexFieldFilterMap) {
        for (FlexFilter filter : filters) {
            String cp = filter.getSourceFilter().getCP();
            Object value = filter.getSourceFilter().getValue();
            List<Object> values = VoucherQueryUtils.convertFilterValue(value);
            if (GL_ASSIST_TXT.equalsIgnoreCase(filter.getFlexEntity())) {
                VoucherQueryUtils.collectFlexFilterValues(txtValuesMap, values, filter.getFlexField());
                continue;
            }
            if ("id".equalsIgnoreCase(filter.getFilterProp())) {
                VoucherQueryUtils.collectFlexFilterValues(bdValuesMap, values, filter.getFlexField());
                continue;
            }
            List qFilters = flexFieldFilterMap.computeIfAbsent(filter.getFlexField(), k -> new ArrayList(1));
            qFilters.add(new QFilter(filter.getFilterProp(), cp, value));
        }
    }

    private static void queryBaseDataFillBdValues(Map<String, List<Object>> flexBdValuesMap, Map<String, List<QFilter>> flexFieldFilterMap, Map<String, String> flexEntityMap) {
        if (!flexFieldFilterMap.isEmpty()) {
            for (Map.Entry<String, List<QFilter>> entry : flexFieldFilterMap.entrySet()) {
                String flexField = entry.getKey();
                List entityPkValues = QueryServiceHelper.queryPrimaryKeys((String)flexEntityMap.get(flexField), (QFilter[])entry.getValue().toArray(new QFilter[0]), null, (int)-1);
                VoucherQueryUtils.collectFlexFilterValues(flexBdValuesMap, entityPkValues, flexField);
            }
        }
    }

    private static void collectFlexFilterValues(Map<String, List<Object>> flexFieldFilterValuesMap, List<Object> values, String flexField) {
        List<Object> filterValues = flexFieldFilterValuesMap.get(flexField);
        if (filterValues == null) {
            filterValues = new ArrayList<Object>(values);
            flexFieldFilterValuesMap.put(flexField, filterValues);
        } else {
            filterValues.retainAll(values);
        }
    }

    public static List<Object> convertFilterValue(Object value) {
        if (value == null) {
            return new ArrayList<Object>(1);
        }
        if (DebugTrace.enable()) {
            LOGGER.info("voucher_filter_enhance convertFilterValue value is:{}", (Object)DebugTraceHelper.toString(value));
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().filter(Objects::nonNull).map(x -> {
                if (x instanceof Integer) {
                    return Long.valueOf(((Integer)x).toString());
                }
                return x;
            }).collect(Collectors.toList());
        }
        if (value.getClass().isArray()) {
            return Arrays.stream((Object[])value).filter(Objects::nonNull).map(x -> {
                if (x instanceof Integer) {
                    return Long.valueOf(((Integer)x).toString());
                }
                return x;
            }).collect(Collectors.toList());
        }
        if (value instanceof Integer) {
            return Collections.singletonList(Long.valueOf(value.toString()));
        }
        return Collections.singletonList(value);
    }

    /*
     * Exception decompiling
     */
    private static List<Object> queryFlexGroupIdList(Map<String, List<Object>> bdFlexValuesMap, Map<String, List<Object>> txtFlexValuesMap, int top) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DataSet queryFlexDataSet(Map<String, List<Object>> flexValuesMap, DataSet result, String assistEntity) {
        for (List<Object> values : flexValuesMap.values()) {
            QFilter qFilter = new QFilter(ASSVAL, "in", values);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)VoucherQueryUtils.class.getName(), (String)assistEntity, (String)HG, (QFilter[])qFilter.toArray(), (String)HG);
            if (result == null) {
                result = dataSet;
                continue;
            }
            result = result.join(dataSet, JoinType.INNER).on(HG, HG).select(new String[]{HG}).finish();
        }
        return result;
    }

    private static FlexFilter buildFlexFilter(QFilter sourceFilter) {
        String[] split;
        String property = sourceFilter.getProperty();
        String[] pointSplit = property.split(REGEX_POINT);
        if (pointSplit.length == 4) {
            String[] split2 = pointSplit[1].split(REGEX);
            if (split2.length == 2) {
                return new FlexFilter(split2[1], sourceFilter, GL_ASSIST_BD, pointSplit[2], pointSplit[3]);
            }
        } else if (pointSplit.length == 3 && property.endsWith(".value") && (split = pointSplit[1].split(REGEX)).length == 2) {
            return new FlexFilter(split[1], sourceFilter, GL_ASSIST_TXT, GL_ASSIST_TXT, pointSplit[2]);
        }
        return null;
    }

    private static List<FlexFilter> transFlexFilterList(List<QFilter> sourceFilterList) {
        return sourceFilterList.stream().map(VoucherQueryUtils::buildFlexFilter).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Tuple<String, String> splitHeadAndEntryOrder(String orginalOrder) {
        if (StringUtils.isBlank((CharSequence)orginalOrder)) {
            return Tuple.create((Object)"", (Object)"");
        }
        String[] split = orginalOrder.split(",");
        Map<Boolean, List<String>> collect = Arrays.stream(split).collect(Collectors.groupingBy(x -> x.startsWith(ENTRIES_PREFIX)));
        List<String> headOrders = collect.get(false);
        List<String> entryOrders = collect.get(true);
        return Tuple.create((Object)(CollectionUtils.isNotEmpty(headOrders) ? String.join((CharSequence)",", headOrders) : ""), (Object)(CollectionUtils.isNotEmpty(entryOrders) ? String.join((CharSequence)",", entryOrders) : ""));
    }

    private static class FlexFilter {
        private final String flexField;
        private final QFilter sourceFilter;
        private final String flexEntity;
        private final String entity;
        private final String filterProp;

        private FlexFilter(String flexField, QFilter sourceFilter, String flexEntity, String entity, String filterProp) {
            this.flexField = flexField;
            this.sourceFilter = sourceFilter;
            this.flexEntity = flexEntity;
            this.entity = entity;
            this.filterProp = filterProp;
        }

        public String getFlexField() {
            return this.flexField;
        }

        public QFilter getSourceFilter() {
            return this.sourceFilter;
        }

        public String getFlexEntity() {
            return this.flexEntity;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getFilterProp() {
            return this.filterProp;
        }
    }
}

