/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.balance.mulcur;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.lang3.StringUtils;

public class MulCurrencyUtil {
    public static final MCT[] MCT_BEGIN_AMOUNTS = new MCT[]{MCT.BEGIN};
    public static final MCT[] MCT_PERIOD_AMOUNTS = new MCT[]{MCT.DEBIT, MCT.CREDIT};
    public static final MCT[] MCT_YEAR_AMOUNTS = new MCT[]{MCT.YEAR_DEBIT, MCT.YEAR_CREDIT};
    public static final MCT[] MCT_ENDLOCAL_AMOUNTS = new MCT[]{MCT.END};
    public static final MCT[] MCT_YEAR_PROFIT_AMOUNTS = new MCT[]{MCT.YEAR_PROFIT_DEBIT, MCT.YEAR_PROFIT_CREDIT};

    public static Set<String> getBalanceAllMulCurAmountFields() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> {
            amountSet.addAll(Arrays.stream(MCT_BEGIN_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet()));
            amountSet.addAll(Arrays.stream(MCT_PERIOD_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet()));
            amountSet.addAll(Arrays.stream(MCT_YEAR_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet()));
            amountSet.addAll(Arrays.stream(MCT_ENDLOCAL_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet()));
        });
        return amountSet;
    }

    public static boolean isMulCurQueryBalance(String select) {
        Set<String> amountSet = MulCurrencyUtil.getBalanceAllMulCurAmountFields();
        if (!amountSet.isEmpty() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{select})) {
            return amountSet.stream().anyMatch(x -> select.contains((CharSequence)x));
        }
        return false;
    }

    public static Set<String> getBalanceAllMulCurBeginAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_BEGIN_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }

    public static Set<String> getBalanceAllMulCurPeriodAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_PERIOD_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }

    public static Set<String> getBalanceAllMulCurYearAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_YEAR_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }

    public static Set<String> getBalanceAllMulCurEndlocalAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_ENDLOCAL_AMOUNTS).map(y -> x.getBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }

    public static Set<String> getVoucherAllMulCurPeriodAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_PERIOD_AMOUNTS).map(y -> x.getVoucherField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }

    public static Set<String> getInitBalanceAllMulCurYearAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_YEAR_AMOUNTS).map(y -> x.getInitBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }

    public static Set<String> getInitBalanceAllMulCurProfitYearAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_YEAR_PROFIT_AMOUNTS).map(y -> x.getInitBalanceField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }

    public static Set<String> getBalanceLogAllMulCurPeriodAmounts() {
        HashSet<String> amountSet = new HashSet<String>(8);
        UnmodifiableList<LocalCurrencyConfigVO> voList = LocalCurrencyConfigService.queryEnableCurrencies();
        voList.stream().forEach(x -> amountSet.addAll(Arrays.stream(MCT_PERIOD_AMOUNTS).map(y -> x.getBalanceLogField((MCT)((Object)((Object)y))).getMetaId()).collect(Collectors.toSet())));
        return amountSet;
    }
}

