/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.budgetaccounting.dao;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.service.budgetaccounting.dao.AccountDao;
import kd.fi.bd.service.budgetaccounting.vo.AccountVO;

public class AccountDaoImpl
implements AccountDao {
    private static final AccountDaoImpl INSTANCE = new AccountDaoImpl();

    private AccountDaoImpl() {
    }

    public static AccountDaoImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public List<AccountVO> getBatchByIds(Collection<Long> accountIds) {
        return BusinessDataServiceHelper.loadFromCache((Object[])accountIds.toArray(), (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"bd_accountview", Arrays.asList("id", "masterid", "isqty", "measureunitgroup", "measureunit", "acctcurrency", "currencyentry.currency", "checkitementry.asstactitem"))).values().stream().map(dyn -> new AccountVO(dyn.getLong("id"), dyn.getLong("masterid"), dyn.getBoolean("isqty"), dyn.getLong("measureunitgroup_id"), dyn.getLong("measureunit_id"), dyn.getString("acctcurrency"), dyn.getDynamicObjectCollection("currencyentry").stream().map(row -> row.getLong("currency_id")).collect(Collectors.toSet()), dyn.getDynamicObjectCollection("checkitementry").stream().map(row -> row.getString("asstactitem.flexfield")).collect(Collectors.toSet()))).collect(Collectors.toList());
    }
}

