/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.budgetaccounting.mc;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.enums.ConversionMethod;
import kd.fi.bd.service.budgetaccounting.BudgetAccountingService;
import kd.fi.bd.service.budgetaccounting.BudgetAccountingServiceImpl;
import kd.fi.bd.service.budgetaccounting.IEntryConverter;
import kd.fi.bd.service.budgetaccounting.mc.MCDynamicAdapterConverter;
import kd.fi.bd.service.budgetaccounting.vo.VoucherEntryDynamicObjectAdapter;

public class MCBudgetAccountingServiceImpl
extends BudgetAccountingServiceImpl
implements BudgetAccountingService {
    @Override
    protected IEntryConverter<VoucherEntryDynamicObjectAdapter> getEntryConverter(long orgId, long periodId, DynamicObject voucher) {
        long bookTypeId = voucher.getLong("booktype_id");
        Collection<LocalCurrencyConfigVO> configs = LocalCurrencyConfigService.queryEnableCurrencies(orgId, bookTypeId);
        if (!configs.isEmpty()) {
            String voucherSourceType = voucher.getString("sourcetype");
            LocalCurrencyConfigVO[] usingEntryCurrencyConfigs = (LocalCurrencyConfigVO[])configs.stream().filter(x -> "2".equalsIgnoreCase(voucherSourceType) || x.getConversionMethod(orgId, bookTypeId) == ConversionMethod.ORIGINAL).toArray(LocalCurrencyConfigVO[]::new);
            if (usingEntryCurrencyConfigs.length != 0) {
                return new MCDynamicAdapterConverter(usingEntryCurrencyConfigs, orgId, periodId);
            }
        }
        return super.getEntryConverter(orgId, periodId, voucher);
    }
}

