/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.budgetaccounting.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.accountmap.AccountMappingParam;
import kd.fi.bd.accountmap.AccountMappingReader;
import kd.fi.bd.consts.MeasureUnit;
import kd.fi.bd.enums.CurrencyAccountingType;
import kd.fi.bd.service.account.AccountVersionMatchHelper;
import kd.fi.bd.service.budgetaccounting.dao.AccountDao;
import kd.fi.bd.service.budgetaccounting.dao.AccountDaoImpl;
import kd.fi.bd.service.budgetaccounting.dao.VoucherDao;
import kd.fi.bd.service.budgetaccounting.dao.VoucherDaoImpl;
import kd.fi.bd.service.budgetaccounting.vo.AccountVO;
import kd.fi.bd.service.budgetaccounting.vo.VoucherEntryVO;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.FibdApp;
import kd.fi.bd.util.FlexUtils;
import kd.fi.bd.util.flex.FlexDefaultValueBatchReader;

public class BudgetEntryGeneratorService {
    private final DynamicObject bookDyn;
    private final AccountDao accountDao;
    private final VoucherDao voucherDao;

    public BudgetEntryGeneratorService(Long bookId) {
        this(BusinessDataServiceHelper.loadSingleFromCache((Object)bookId, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"gl_accountbook", Arrays.asList("org", "accounttable", "basecurrency"))));
    }

    public BudgetEntryGeneratorService(DynamicObject bookDyn) {
        this.bookDyn = bookDyn;
        this.accountDao = AccountDaoImpl.getInstance();
        this.voucherDao = VoucherDaoImpl.getInstance();
    }

    public <T extends VoucherEntryVO> List<T> generateBudgetEntries(List<T> financialEntries) {
        List<T> preBudgetEntries = this.preProcessEntries(financialEntries);
        if (preBudgetEntries.isEmpty()) {
            return preBudgetEntries;
        }
        this.correctBudgetEntries(preBudgetEntries);
        return preBudgetEntries;
    }

    private <T extends VoucherEntryVO> List<T> preProcessEntries(List<T> financialEntries) {
        ArrayList<VoucherEntryVO> result = new ArrayList<VoucherEntryVO>(financialEntries.size());
        long bookedPeriodId = ((VoucherEntryVO)financialEntries.get(0)).getePeriodId();
        Set<Long> accountIds = BDUtil.extractToSet(financialEntries, VoucherEntryVO::getAccountId);
        Set<Long> voucherIds = BDUtil.extractToSet(financialEntries, VoucherEntryVO::getVoucherId);
        Map<Long, Long> voucherIdMaxSeqMap = this.voucherDao.getMaxSeqMap(voucherIds);
        AccountIdMapper accountIdMapper = new AccountIdMapper(accountIds, this.bookDyn, bookedPeriodId);
        for (VoucherEntryVO financialEntry : financialEntries) {
            long tarAccountId = accountIdMapper.mapNewAccountId(financialEntry.getAccountId());
            if (tarAccountId == 0L) continue;
            VoucherEntryVO budgetEntry = financialEntry.clone();
            budgetEntry.setAccountId(tarAccountId);
            budgetEntry.setSeq(voucherIdMaxSeqMap.compute(budgetEntry.getVoucherId(), (k, v) -> v == null ? 1L : v + 1L));
            result.add(budgetEntry);
        }
        return result;
    }

    private void correctBudgetEntries(List<? extends VoucherEntryVO> budgetEntries) {
        Set<Long> accountIds = BDUtil.extractToSet(budgetEntries, VoucherEntryVO::getAccountId);
        Set<Long> assgrpIds = BDUtil.extractToSet(budgetEntries, VoucherEntryVO::getAssgrpId);
        Map<Long, AccountVO> accountVoMap = this.accountDao.getBatchByIds(accountIds).stream().collect(Collectors.toMap(AccountVO::getAccountId, vo -> vo));
        Set<Long> orgIds = BDUtil.extractToSet(budgetEntries, VoucherEntryVO::getEorgId);
        long baseCurrencyId = this.bookDyn.getLong("basecurrency_id");
        AssgrpIdMapper assgrpIdMapper = new AssgrpIdMapper(assgrpIds, orgIds);
        for (VoucherEntryVO voucherEntryVO : budgetEntries) {
            AccountVO accountVo = accountVoMap.get(voucherEntryVO.getAccountId());
            if (!accountVo.isQty() || !MeasureUnit.matchGroup(voucherEntryVO.getMeasureUnitId(), accountVo.getMeasureunitGroupId())) {
                voucherEntryVO.setQuantity(BigDecimal.ZERO);
                voucherEntryVO.setMeasureUnitId(0L);
                voucherEntryVO.setPrice(BigDecimal.ZERO);
            }
            if (!CurrencyAccountingType.fromValue(accountVo.getCurrencyType()).getCurrencyChecker().check(voucherEntryVO.getCurrencyId(), baseCurrencyId, accountVo.getCurrencyIds())) {
                voucherEntryVO.setCurrencyId(baseCurrencyId);
                voucherEntryVO.setRate(BigDecimal.ONE);
                voucherEntryVO.setDebitOri(voucherEntryVO.getDebitLocal());
                voucherEntryVO.setCreditOri(voucherEntryVO.getCreditLocal());
            }
            voucherEntryVO.setAssgrpId(assgrpIdMapper.mapNewAssgrpId(voucherEntryVO.getAssgrpId(), accountVo, voucherEntryVO.getCurrencyId()));
        }
    }

    private static class AssgrpIdMapper {
        private final Map<Long, JSONObject> flexValueMap;
        private final FlexDefaultValueBatchReader.FlexDefaultValueMatchCollection defaultValueMatchCollection;

        private AssgrpIdMapper(Collection<Long> assgrpIds, Collection<Long> orgIds) {
            this.defaultValueMatchCollection = FlexDefaultValueBatchReader.init(orgIds);
            this.flexValueMap = new HashMap<Long, JSONObject>(assgrpIds.size());
            this.flexValueMap.put(0L, new JSONObject());
            try (DataSet dataSet = DB.queryDataSet((String)"AssgrpIdMapper#init", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)new SqlBuilder().appendIn("SELECT FID,FVALUE FROM T_GL_ASSIST WHERE FID", assgrpIds.toArray()));){
                for (Row row : dataSet) {
                    this.flexValueMap.put(row.getLong("FID"), JSONObject.parseObject((String)row.getString("FVALUE")));
                }
            }
        }

        private long mapNewAssgrpId(long assgrpId, AccountVO accountVO, long currencyId) {
            boolean changeFlag = false;
            boolean reloadMasterId = false;
            JSONObject flexObj = this.flexValueMap.get(assgrpId).clone();
            HashSet<String> accountFlexs = new HashSet<String>(accountVO.getAssistFlexs());
            Iterator flexIter = flexObj.keySet().iterator();
            while (flexIter.hasNext()) {
                if (accountFlexs.contains(flexIter.next())) continue;
                flexIter.remove();
                changeFlag = true;
            }
            accountFlexs.removeAll(flexObj.keySet());
            for (String extraFlex : accountFlexs) {
                Object defaultValue = this.defaultValueMatchCollection.getDefaultValue(accountVO.getMasterId(), currencyId, extraFlex);
                if (defaultValue == null) continue;
                flexObj.put(extraFlex, defaultValue);
                changeFlag = true;
                reloadMasterId = true;
            }
            boolean finalReloadMasterId = reloadMasterId;
            return changeFlag ? (Long)ThreadCache.get((Object)("Budget.saveFlex." + flexObj.toJSONString()), () -> FlexUtils.saveFlexData((Map<String, Object>)flexObj, finalReloadMasterId)) : assgrpId;
        }
    }

    private static class AccountIdMapper {
        private final AccountVersionMatchHelper.AccountMatchCollection accountMatchCollection;
        private final Long orgId;
        private final Map<Long, Long> idMasterIdMap;
        private final Map<Long, Long> accountMappingMap;
        private final Date periodDate;

        private AccountIdMapper(Collection<Long> oriAccountIds, DynamicObject bookDyn, Long bookedPeriodId) {
            Preconditions.checkArgument((bookedPeriodId != null && bookedPeriodId > 0L ? 1 : 0) != 0, (Object)("illegal bookedPeriodId:" + bookedPeriodId));
            this.orgId = bookDyn.getLong("org_id");
            this.periodDate = BusinessDataServiceHelper.loadSingleFromCache((Object)bookedPeriodId, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", Collections.singletonList("enddate"))).getDate("enddate");
            this.idMasterIdMap = AccountDaoImpl.getInstance().getBatchByIds(oriAccountIds).stream().collect(Collectors.toMap(AccountVO::getAccountId, AccountVO::getMasterId));
            this.accountMappingMap = new AccountMappingReader(AccountMappingReader.MappingType.GOV_ACCOUNTING).readFromCache(new AccountMappingParam(this.orgId, bookDyn.getLong("accounttable_id")));
            this.accountMatchCollection = AccountVersionMatchHelper.init(Collections.singleton(this.orgId), Collections.emptyList(), String.join((CharSequence)",", "id", "enable", "number"));
        }

        private long mapNewAccountId(long accountId) {
            if (accountId == 0L) {
                return 0L;
            }
            Long oriMasterId = this.idMasterIdMap.get(accountId);
            Long tarMasterId = this.accountMappingMap.get(oriMasterId);
            if (tarMasterId == null || tarMasterId == 0L) {
                return 0L;
            }
            DynamicObject tarAccountDyn = this.accountMatchCollection.get(this.orgId, tarMasterId, this.periodDate);
            if (!tarAccountDyn.getBoolean("enable")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5931\u8d25\uff1a\u5bf9\u7167\u79d1\u76ee%s\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u914d\u7f6e\u3002", (String)"BudgetEntryGeneratorService_0", (String)FibdApp.instance.commonModule(), (Object[])new Object[]{tarAccountDyn.getString("number")}), new Object[0]));
            }
            return tarAccountDyn.getLong("id");
        }
    }
}

