/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.voucher;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.bd.util.filter.QFilterBuilder;

public class TempVoucherIndexAdapter {
    protected static Optional<List<QFilter>> tryGetIndexFiltersInVoucherFilters(List<QFilter> voucherFilters) {
        List<QFilter> filters = VoucherQueryUtils.getFilterMatchAndNestsAllMatchFilterList(voucherFilters, f -> {
            switch (f.getProperty()) {
                case "org": 
                case "org.id": 
                case "period": 
                case "period.id": 
                case "entries.account": 
                case "entries.account.id": {
                    return true;
                }
            }
            return false;
        });
        LinkedList<QFilter> modifyFilters = QFilterBuilder.modifyFilters(filters, filter -> {
            switch (filter.getProperty()) {
                case "org": 
                case "org.id": {
                    return new QFilter("org", filter.getCP(), filter.getValue());
                }
                case "period": 
                case "period.id": {
                    return new QFilter("period", filter.getCP(), filter.getValue());
                }
                case "entries.account": 
                case "entries.account.id": {
                    return new QFilter("account", filter.getCP(), filter.getValue());
                }
            }
            return null;
        }, new String[]{"org", "org.id", "period", "period.id", "entries.account", "entries.account.id"}).getFilters();
        if (modifyFilters.stream().noneMatch(x -> "org".equalsIgnoreCase(x.getProperty())) || modifyFilters.stream().noneMatch(x -> "period".equalsIgnoreCase(x.getProperty()))) {
            return Optional.empty();
        }
        return Optional.of(modifyFilters);
    }

    public static Optional<Set<Long>> tryGetTempIdsByVoucherQueryFilter(List<QFilter> voucherFilters, int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Get temp voucherIds must with the limit. ");
        }
        Optional<List<QFilter>> indexFilters = TempVoucherIndexAdapter.tryGetIndexFiltersInVoucherFilters(voucherFilters);
        if (!indexFilters.isPresent()) {
            return Optional.empty();
        }
        try (DataSet dataSet = ORM.create().queryDataSet(TempVoucherService.class.getName(), "gl_tempvoucher_index", "org,period,voucherid", indexFilters.get().toArray(new QFilter[0]), "org,period,voucherid", limit + 1, (Distinctable)WithDistinctable.get());){
            HashSet<Long> voucherIds = new HashSet<Long>(limit + 1);
            while (voucherIds.size() <= limit && dataSet.hasNext()) {
                voucherIds.add(dataSet.next().getLong(2));
            }
            if (voucherIds.size() <= limit) {
                Optional<Set<Long>> optional = Optional.of(voucherIds);
                return optional;
            }
        }
        return Optional.empty();
    }
}

