/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.service.voucher;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import org.apache.commons.lang3.ArrayUtils;

public class TempVoucherService {
    private static final Log LOG = LogFactory.getLog(TempVoucherService.class);
    private static DBRoute ROUNTE_FI = DBRoute.of((String)"fi");
    private static final String ENTITY = "gl_tempvoucher_index";
    private static final String UPDATE_SQL = "UPDATE t_gl_tempvoucher_index SET faccountid = ? WHERE fid = ?;";
    private static final String INSERT_SQL = "INSERT INTO t_gl_tempvoucher_index (fid,fvoucherid,forgid,fperiodid,faccountid) values(?,?,?,?,?);";

    public static void deleteByIds(Long[] voucherIds) {
        if (!ArrayUtils.isEmpty((Object[])voucherIds)) {
            try (TXHandle tx = TX.required();){
                try {
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("delete from t_gl_tempvoucher_index where ", new Object[0]);
                    sqlBuilder.appendIn(" fvoucherid ", (Object[])voucherIds);
                    DB.execute((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDException((Throwable)e, new ErrorCode("TempVoucherService", e.getMessage()), new Object[]{""});
                }
            }
        }
    }

    private static boolean checkConsistentOnOrgAndPeriod(long voucherId, long orgId, long periodId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select TOP 1 fid from t_gl_tempvoucher_index where ", new Object[0]);
        sqlBuilder.append(" fvoucherid = ? ", new Object[]{voucherId});
        sqlBuilder.append(" and (", new Object[0]);
        sqlBuilder.append(" forgid != ? ", new Object[]{orgId});
        sqlBuilder.append(" or fperiodid != ? ", new Object[]{periodId});
        sqlBuilder.append(" ) ", new Object[0]);
        return (Boolean)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        }) == false;
    }

    private static DataSet queryNotExistAccIds(Set<Long> voucherIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid id,fvoucherid voucherid,forgid orgid, fperiodid periodid,faccountid accountid from t_gl_tempvoucher_index where ", new Object[0]);
        sqlBuilder.appendIn(" fvoucherid ", new ArrayList<Long>(voucherIds));
        return DB.queryDataSet((String)(TempVoucherService.class.getName() + "/queryNotExistAccIds"), (DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
    }

    public static void updateOrInsert(Map<Long, Tuple<Long[], Set<Long>>> updateMap) {
        DataSet existAccIdDs = TempVoucherService.queryNotExistAccIds(updateMap.keySet());
        ArrayList<Tuple> dirtyAccPairs = new ArrayList<Tuple>(8);
        HashSet<Long> deleteVchIds = new HashSet<Long>(8);
        while (existAccIdDs.hasNext()) {
            Row row = existAccIdDs.next();
            Long voucherId = row.getLong("voucherid");
            Long orgId = row.getLong("orgid");
            Long l = row.getLong("periodid");
            Long accountId = row.getLong("accountid");
            Tuple<Long[], Set<Long>> tuple = updateMap.get(voucherId);
            Long[] orgId2periodId = (Long[])tuple.item1;
            Set newVersionAccIds = (Set)tuple.item2;
            if (orgId.compareTo(orgId2periodId[0]) != 0 || l.compareTo(orgId2periodId[1]) != 0) {
                deleteVchIds.add(voucherId);
                continue;
            }
            if (!newVersionAccIds.contains(accountId)) {
                dirtyAccPairs.add(Tuple.create((Object)row.getLong("id"), (Object)accountId));
                continue;
            }
            newVersionAccIds.remove(accountId);
        }
        TempVoucherService.deleteByIds(deleteVchIds.toArray(new Long[0]));
        try (TXHandle tx = TX.required();){
            try {
                for (Map.Entry entry : updateMap.entrySet()) {
                    long voucherId = (Long)entry.getKey();
                    Tuple tuple = (Tuple)entry.getValue();
                    Long[] orgId2periodId = (Long[])tuple.item1;
                    long orgId = orgId2periodId[0];
                    long periodId = orgId2periodId[1];
                    Set newVersionAccIds = (Set)tuple.item2;
                    ArrayList newAccIds = new ArrayList(newVersionAccIds);
                    if (DebugTrace.enable()) {
                        LOG.info("new AccIds:" + newAccIds);
                    }
                    long[] newIds = DBServiceHelper.genLongIds((String)"t_gl_tempvoucher_index", (int)newVersionAccIds.size());
                    ArrayList<Object[]> updateParams = new ArrayList<Object[]>(dirtyAccPairs.size());
                    ArrayList<DynamicObject> insertDys = new ArrayList<DynamicObject>(8);
                    for (int i = 0; i < newAccIds.size(); ++i) {
                        long newAcc = (Long)newAccIds.get(i);
                        if (i < dirtyAccPairs.size()) {
                            updateParams.add(new Object[]{newAcc, ((Tuple)dirtyAccPairs.get((int)i)).item1});
                            if (updateParams.size() < 1000) continue;
                            TempVoucherService.updateTempVoucher(updateParams, UPDATE_SQL);
                            if (DebugTrace.enable()) {
                                LOG.info("update account info:" + updateParams);
                            }
                            updateParams.clear();
                            continue;
                        }
                        DynamicObject newDy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
                        newDy.set("id", (Object)newIds[i]);
                        newDy.set("voucherid", (Object)voucherId);
                        newDy.set("org", (Object)orgId);
                        newDy.set("period", (Object)periodId);
                        newDy.set("account", (Object)newAcc);
                        insertDys.add(newDy);
                        if (insertDys.size() < 1000) continue;
                        SaveServiceHelper.save((DynamicObject[])insertDys.toArray(new DynamicObject[insertDys.size()]));
                        if (DebugTrace.enable()) {
                            LOG.info("insert new account info:" + insertDys.size());
                        }
                        insertDys.clear();
                    }
                    if (!updateParams.isEmpty()) {
                        TempVoucherService.updateTempVoucher(updateParams, UPDATE_SQL);
                        if (DebugTrace.enable()) {
                            LOG.info("update account info:" + updateParams);
                        }
                        updateParams.clear();
                    }
                    if (!insertDys.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])insertDys.toArray(new DynamicObject[insertDys.size()]));
                        if (DebugTrace.enable()) {
                            LOG.info("insert new account info:" + insertDys.size());
                        }
                        insertDys.clear();
                    }
                    if (newAccIds.size() >= dirtyAccPairs.size()) continue;
                    List deleteIds = dirtyAccPairs.subList(newAccIds.size(), dirtyAccPairs.size());
                    QFilter filter = new QFilter("id", "in", deleteIds.stream().map(x -> (Long)x.item1).collect(Collectors.toList()));
                    DeleteServiceHelper.delete((String)ENTITY, (QFilter[])filter.toArray());
                    LOG.info("delete account size:" + deleteIds.size());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("TempVoucherService", e.getMessage()), new Object[]{""});
            }
        }
    }

    public static void updateTempVoucher(List<Object[]> updateParams, String updateSql) {
        DB.executeBatch((DBRoute)ROUNTE_FI, (String)updateSql, updateParams);
    }

    public static void batchInsert(List<Long> voucherIds) {
        if (CollectionUtils.isEmpty(voucherIds)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select distinct v.fid fvoucherid,v.forgid,v.fperiodid,ve.faccountid from t_gl_voucher v inner join t_gl_voucherentry ve on v.fid = ve.fid where ", new Object[0]);
                sqlBuilder.appendIn(" v.fid ", voucherIds.toArray(new Object[voucherIds.size()]));
                ArrayList<Object[]> insertParams = new ArrayList<Object[]>(128);
                DataSet ds = DB.queryDataSet((String)(TempVoucherService.class.getName() + "/batchInsert"), (DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
                while (ds.hasNext()) {
                    Row row = ds.next();
                    long voucherId = row.getLong("fvoucherid");
                    long orgId = row.getLong("forgid");
                    long periodId = row.getLong("fperiodid");
                    long accountId = row.getLong("faccountid");
                    insertParams.add(new Object[]{null, voucherId, orgId, periodId, accountId});
                    if (insertParams.size() < 1000) continue;
                    TempVoucherService.batchInsertIntoDB(insertParams);
                }
                if (!insertParams.isEmpty()) {
                    TempVoucherService.batchInsertIntoDB(insertParams);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("TempVoucherService", e.getMessage()), new Object[]{""});
            }
        }
    }

    private static void batchInsertIntoDB(List<Object[]> insertParams) {
        long[] newIds = DBServiceHelper.genLongIds((String)"t_gl_tempvoucher_index", (int)insertParams.size());
        for (int i = 0; i < insertParams.size(); ++i) {
            insertParams.get((int)i)[0] = newIds[i];
        }
        TempVoucherService.updateTempVoucher(insertParams, INSERT_SQL);
        insertParams.clear();
    }

    public static void reInit() {
        long tick = System.currentTimeMillis();
        int loop = 0;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)ROUNTE_FI, (String)"truncate table t_gl_tempvoucher_index;");
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select fid from t_gl_voucher where fbillstatus in ('A', 'D') ", new Object[0]);
                DataSet ds = DB.queryDataSet((String)(TempVoucherService.class.getName() + "reInit"), (DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder);
                ArrayList<Long> vids = new ArrayList<Long>(100);
                while (ds.hasNext()) {
                    vids.add(ds.next().getLong("fid"));
                    if (vids.size() <= 100) continue;
                    long loopTick = System.currentTimeMillis();
                    TempVoucherService.batchInsert(vids);
                    LOG.info("reinit_tempvoucherindex loop: {} cost: {}", (Object)(++loop), (Object)(System.currentTimeMillis() - loopTick));
                    vids.clear();
                }
                if (!vids.isEmpty()) {
                    TempVoucherService.batchInsert(vids);
                }
            }
            catch (Exception e) {
                LOG.error("failed init tempvoucher index on " + e.getMessage(), (Throwable)e);
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("TempVoucherService-Reinit", e.getMessage()), new Object[]{""});
            }
        }
        LOG.info("reinit temp voucher index cost:" + (System.currentTimeMillis() - tick));
    }
}

