/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.tasks;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.tasks.IDataWorkTaskStatusMgr;

public interface ITaskStatusEvent<GRP_ID extends Serializable, TASK_ID extends Serializable> {
    public IDataWorkTaskStatusMgr.StatusModelType getStatusEventType();

    public GRP_ID getGroupId();

    public TASK_ID getTaskId();

    public CDCStageEnum getTaskStatus();

    public int getCompletedPoints();

    public int getTotalPoints();

    @JSONField(serialize=false)
    @JsonIgnore
    default public int getRemainingPoints() {
        return this.getTotalPoints() - this.getCompletedPoints();
    }

    public long getExecutionTime();

    public boolean needMergeStatus();

    public void mergeStatus(ITaskStatusEvent var1);

    @JSONField(serialize=false)
    @JsonIgnore
    default public boolean isCompleted() {
        return this.getTaskStatus() == CDCStageEnum.Completed;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    default public boolean isCancelled() {
        return this.getTaskStatus() == CDCStageEnum.Canceled;
    }

    public boolean hasError();

    public Serializable getStatusMessage();
}

