/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.tasks.common;

import java.io.Serializable;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.tasks.IDataWorkTask;
import kd.fi.bd.tasks.ITaskStatusChangeListener;
import kd.fi.bd.tasks.common.TaskGroupCondition;
import kd.fi.bd.threads.ThreadCategoryEnum;
import kd.fi.bd.util.exception.IExceptionListener;

public abstract class AbstractBaseWorkTask<GRP_KEY extends Serializable, TASK_ID extends Serializable, V>
implements IDataWorkTask<GRP_KEY, TASK_ID, V> {
    protected Supplier<Log> logSupplier;
    protected Log __logger = null;
    protected ThreadCategoryEnum category;
    protected GRP_KEY groupId;
    protected TASK_ID taskId;
    protected String taskTypeCode;
    protected RequestContext requestContext;
    protected V taskResult;
    protected IExceptionListener exceptionListener;
    protected TaskGroupCondition taskGroupCondition;
    protected ITaskStatusChangeListener taskStatusChangeListener;
    protected int totalStatisticsPoints;
    protected boolean canThrowException;
    protected boolean initialized;

    protected AbstractBaseWorkTask(ThreadCategoryEnum category, GRP_KEY groupId, TASK_ID taskId, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition) {
        this.category = category;
        this.groupId = groupId;
        this.taskId = taskId;
        this.taskGroupCondition = taskGroupCondition;
        this.exceptionListener = exceptionListener;
        this.initialized = false;
        this.canThrowException = false;
    }

    protected AbstractBaseWorkTask(ThreadCategoryEnum category, TASK_ID taskId, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition) {
        this(category, null, taskId, exceptionListener, taskGroupCondition);
    }

    protected AbstractBaseWorkTask(ThreadCategoryEnum category, GRP_KEY groupId, TASK_ID taskId) {
        this(category, groupId, taskId, null, new TaskGroupCondition(CDCStageEnum.Waiting_Start));
    }

    protected AbstractBaseWorkTask(GRP_KEY groupId, TASK_ID taskId, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition) {
        this(ThreadCategoryEnum.FI_COMMON, groupId, taskId, exceptionListener, taskGroupCondition);
    }

    protected AbstractBaseWorkTask(TASK_ID taskId, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition) {
        this(ThreadCategoryEnum.FI_COMMON, taskId, exceptionListener, taskGroupCondition);
    }

    protected AbstractBaseWorkTask(GRP_KEY groupId, TASK_ID taskId) {
        this(ThreadCategoryEnum.FI_COMMON, groupId, taskId);
    }

    public String toString() {
        return "AbstractBaseWorkTask{groupId=" + this.groupId + ", taskId=" + this.taskId + ", taskTypeCode='" + this.taskTypeCode + '\'' + ", requestContext=" + this.requestContext + ", taskResult=" + this.taskResult + ", exceptionListener=" + this.exceptionListener + ", taskGroupCondition=" + this.taskGroupCondition + ", taskStatusChangeListener=" + this.taskStatusChangeListener + ", totalStatisticsPoints=" + this.totalStatisticsPoints + ", canThrowException=" + this.canThrowException + ", initialized=" + this.initialized + '}';
    }

    @Override
    public TASK_ID getTaskId() {
        return this.taskId;
    }

    @Override
    public void run() {
        try {
            this.taskResult = this.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initialization() {
        this.initialized = true;
    }

    private Log getLogger() {
        if (this.__logger == null && this.logSupplier != null) {
            this.__logger = this.logSupplier.get();
        }
        return this.__logger;
    }

    protected abstract V doTaskJob() throws Exception;

    @Override
    public CDCStageEnum getTaskStageCode() {
        return this.taskGroupCondition.taskStageCode;
    }

    protected void updateTaskStageCode(CDCStageEnum newStageCode) {
        this.updateTaskStageCode(newStageCode, false);
    }

    protected synchronized void updateTaskStageCode(CDCStageEnum newStageCode, boolean hasError) {
        this.taskGroupCondition.updateGroupCondition(newStageCode, hasError);
    }

    protected int calcTaskTotalStatisticsPoints() {
        return this.totalStatisticsPoints;
    }

    protected boolean onException(Throwable exception) {
        if (this.getLogger() != null) {
            this.__logger.error(String.format("%s doTaskJob Error\uff1aTaskClass=%s", this.getClass().getName(), this));
            this.__logger.error(exception.getMessage(), exception);
        }
        return this.exceptionListener != null ? this.exceptionListener.onError(exception) : true;
    }

    @Override
    public V call() throws Exception {
        block15: {
            if (this.getLogger() != null && this.__logger.isInfoEnabled()) {
                this.__logger.info("Starting WorkTask: " + this);
            }
            if (this.taskStatusChangeListener != null) {
                this.taskStatusChangeListener.beforeTaskStart(this.category, this.groupId, this.taskId, this);
            }
            this.updateTaskStageCode(CDCStageEnum.Started);
            try {
                block14: {
                    block13: {
                        try {
                            this.initialization();
                            this.updateTaskStageCode(CDCStageEnum.Processing);
                            if (!this.isCancelled()) {
                                this.taskResult = this.doTaskJob();
                                this.updateTaskStageCode(CDCStageEnum.Completed);
                            }
                        }
                        catch (Exception ex) {
                            this.updateTaskStageCode(CDCStageEnum.Completed, true);
                            this.onException(ex);
                            if (!this.canThrowException) break block13;
                            throw ex;
                        }
                    }
                    try {
                        this.doTaskFinallyCleanUp(this.isCancelled(), this.taskGroupCondition.isWithError());
                    }
                    catch (Exception ex) {
                        if (!this.taskGroupCondition.isWithError()) {
                            this.updateTaskStageCode(CDCStageEnum.Completed, true);
                        }
                        this.onException(ex);
                        if (!this.canThrowException) break block14;
                        throw ex;
                    }
                }
                if (this.taskStatusChangeListener == null) break block15;
                this.taskStatusChangeListener.afterTaskCompleted(this.category, this.groupId, this.taskId, this, this.taskResult, this.taskGroupCondition.isWithError());
            }
            catch (Throwable throwable) {
                if (this.taskStatusChangeListener != null) {
                    this.taskStatusChangeListener.afterTaskCompleted(this.category, this.groupId, this.taskId, this, this.taskResult, this.taskGroupCondition.isWithError());
                }
                if (this.__logger != null && this.__logger.isInfoEnabled()) {
                    this.__logger.info(String.format("WorkTask[%s, %s] Completed: ", this.getGroupId(), this.getTaskId()));
                }
                throw throwable;
            }
        }
        if (this.__logger != null && this.__logger.isInfoEnabled()) {
            this.__logger.info(String.format("WorkTask[%s, %s] Completed: ", this.getGroupId(), this.getTaskId()));
        }
        return this.taskResult;
    }

    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
    }

    @Override
    public void cancel(boolean deactivateAll) {
        this.taskGroupCondition.cancel(false);
    }

    @Override
    public boolean isCancelled() {
        return this.taskGroupCondition.isCancelled();
    }

    @Override
    public boolean isError() {
        return this.taskGroupCondition.isWithError();
    }

    @Override
    public void isCompleted() {
        this.taskGroupCondition.isCompleted();
    }

    protected void restoreRequestContext(RequestContext tenantRequestContext) {
        RequestContext.copyAndSet((RequestContext)tenantRequestContext);
    }

    @Override
    public RequestContext getTenantRequestContext() {
        return this.requestContext;
    }

    @Override
    public GRP_KEY getGroupId() {
        return this.groupId;
    }

    public void setGroupId(GRP_KEY groupId) {
        this.groupId = groupId;
    }

    @Override
    public V getResult() {
        return this.taskResult;
    }

    public String getTaskTypeCode() {
        return this.taskTypeCode;
    }

    public void setTaskTypeCode(String taskTypeCode) {
        this.taskTypeCode = taskTypeCode;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void refreshRequestContext() {
        this.requestContext = this.requestContext == null ? RequestContext.copyAndSet((RequestContext)RequestContext.get()) : RequestContext.copyAndSet((RequestContext)this.requestContext);
    }

    public IExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public V getTaskResult() {
        return this.taskResult;
    }

    public TaskGroupCondition getTaskGroupCondition() {
        return this.taskGroupCondition;
    }

    public ITaskStatusChangeListener getTaskStatusChangeListener() {
        return this.taskStatusChangeListener;
    }

    @Override
    public void setTaskStatusChangeListener(ITaskStatusChangeListener taskStatusChangeListener) {
        this.taskStatusChangeListener = taskStatusChangeListener;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public ThreadCategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(ThreadCategoryEnum category) {
        this.category = category;
    }

    public Supplier<Log> getLogSupplier() {
        return this.logSupplier;
    }

    public void setLogSupplier(Supplier<Log> logSupplier) {
        this.logSupplier = logSupplier;
    }
}

