/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.tasks.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.model.common.AbstractBaseModel;
import kd.fi.bd.tasks.IDataWorkTaskStatusMgr;
import kd.fi.bd.tasks.ITaskStatusEvent;

public class BaseTaskStatus
extends AbstractBaseModel<String, String, Boolean>
implements ITaskStatusEvent<String, String> {
    protected int[] taskStatisticsPoints;
    protected long[] totalTaskTimeCost;
    protected boolean withError;
    protected String statusMessage;
    protected CDCStageEnum taskStatus;

    public BaseTaskStatus(String groupId, String taskId, boolean needToMerge, int completedPoint, int taskTotalPoints, CDCStageEnum newTaskStatus, String statusMessage) {
        super(groupId, taskId, needToMerge);
        this.initTaskStatistics(completedPoint, taskTotalPoints, newTaskStatus);
        this.statusMessage = statusMessage;
    }

    public BaseTaskStatus(String groupId, String taskId, boolean needToMerge, int taskTotalPoints, String statusMessage) {
        this(groupId, taskId, needToMerge, 0, taskTotalPoints, CDCStageEnum.Waiting_Start, statusMessage);
    }

    public BaseTaskStatus(String groupId, String taskId, int completedPoint, CDCStageEnum newTaskStatus, String statusMessage) {
        this(groupId, taskId, true, completedPoint, completedPoint, newTaskStatus, statusMessage);
    }

    public BaseTaskStatus(String taskId, boolean needToMerge, int taskTotalPoints, String statusMessage) {
        this(taskId, taskId, needToMerge, 0, taskTotalPoints, CDCStageEnum.Waiting_Start, statusMessage);
    }

    public BaseTaskStatus(JSONArray jsonArray) {
        super(jsonArray);
    }

    public BaseTaskStatus(Object[] v) {
        super(v);
    }

    @Override
    public String toString() {
        return "BaseTaskStatus{taskStatisticsPoints=" + Arrays.toString(this.taskStatisticsPoints) + ", totalTaskTimeCost=" + Arrays.toString(this.totalTaskTimeCost) + ", withError=" + this.withError + ", taskStatus=" + (Object)((Object)this.taskStatus) + ", groupId=" + (String)this.v1 + ", taskId=" + (String)this.v2 + ", needToMerge=" + this.v3 + ", statusMessage=" + this.statusMessage + '}';
    }

    protected void initTaskStatistics(int completedPoint, int totalPoints, CDCStageEnum status) {
        this.taskStatisticsPoints = new int[]{completedPoint, totalPoints};
        this.totalTaskTimeCost = new long[2];
        Arrays.fill(this.totalTaskTimeCost, System.currentTimeMillis());
        this.withError = false;
        this.taskStatus = status;
        this.statusMessage = null;
    }

    public void reset(int totalPoints, CDCStageEnum status) {
        this.initTaskStatistics(0, totalPoints, status);
    }

    public BaseTaskStatus copy() {
        BaseTaskStatus newCopy = new BaseTaskStatus((String)this.v1, (String)this.v2, (Boolean)this.v3, this.taskStatisticsPoints[1], this.statusMessage);
        newCopy.taskStatisticsPoints[0] = this.taskStatisticsPoints[0];
        return newCopy;
    }

    public void errorUpdateStatus(String statusMessage) {
        this.setStatusMessage(statusMessage);
        this.setWithError(true);
        this.setTaskStatus(CDCStageEnum.Completed);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return super.getArraySize() + 5;
    }

    @Override
    protected int serializedArrayStartPos() {
        return 1;
    }

    @Override
    protected Object[] appendSerializedArray(int startPos, Object[] targetArray) {
        targetArray = super.appendSerializedArray(startPos, targetArray);
        int idx = super.getArraySize();
        targetArray[0] = this.getClass().getName();
        targetArray[idx++] = this.taskStatus;
        targetArray[idx++] = this.taskStatisticsPoints;
        targetArray[idx++] = this.totalTaskTimeCost;
        targetArray[idx++] = this.withError;
        if (this.taskStatus != null) {
            targetArray[idx] = this.statusMessage;
        }
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        int idx = 1;
        this.v1 = this.getString(v, idx++);
        this.v2 = this.getString(v, idx++);
        this.v3 = this.getBoolean(v, idx++);
        this.taskStatus = CDCStageEnum.valueOf(this.getString(v, idx++));
        this.taskStatisticsPoints = this.getIntArray(v, idx++);
        this.totalTaskTimeCost = this.getLongArray(v, idx++);
        this.withError = this.getBoolean(v, idx++);
        this.statusMessage = this.getString(v, idx);
    }

    @Override
    public void mergeStatus(ITaskStatusEvent targetStatusEvent) {
        if (targetStatusEvent == null) {
            return;
        }
        this.taskStatisticsPoints[0] = this.taskStatisticsPoints[0] + targetStatusEvent.getCompletedPoints();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public long getTaskExecutionTime() {
        return this.totalTaskTimeCost[1] - this.totalTaskTimeCost[0];
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasError() {
        return this.withError;
    }

    public void updateStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public IDataWorkTaskStatusMgr.StatusModelType getStatusEventType() {
        return IDataWorkTaskStatusMgr.StatusModelType.Task_Status;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public String getGroupId() {
        return (String)this.v1;
    }

    public void setGroupKey(String taskKey) {
        this.v1 = taskKey;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public String getTaskId() {
        return (String)this.v2;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public CDCStageEnum getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(CDCStageEnum taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setVersion(String taskId) {
        this.v2 = taskId;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean needMergeStatus() {
        return (Boolean)this.v3;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void setNeedMergeStatus(boolean mergeStatus) {
        this.v3 = mergeStatus;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int getCompletedPoints() {
        return this.taskStatisticsPoints[0];
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int getTotalPoints() {
        return this.taskStatisticsPoints[1];
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public long getExecutionTime() {
        return this.totalTaskTimeCost[1] - this.totalTaskTimeCost[0];
    }

    public void reportCompletedPoints(int completedPoints) {
        this.taskStatisticsPoints[0] = this.taskStatisticsPoints[0] + completedPoints;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isWithError() {
        return this.withError;
    }

    public void setWithError(boolean withError) {
        this.withError = withError;
    }
}

