/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.tasks.common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.tasks.common.AbstractBaseWorkTask;

public class TaskGroupCondition<GRP_KEY extends Serializable, TASK_ID extends Serializable> {
    protected volatile CDCStageEnum taskStageCode;
    protected List<SubTaskErrorInfo<GRP_KEY, TASK_ID>> taskErrorInfos;
    protected volatile boolean active;
    protected volatile boolean withError;
    protected int[] statisticCnt;

    public TaskGroupCondition(CDCStageEnum initialStage) {
        this(initialStage, true);
    }

    public TaskGroupCondition(CDCStageEnum initialStage, boolean active) {
        this.active = active;
        this.withError = false;
        this.taskStageCode = initialStage;
        this.taskErrorInfos = new LinkedList<SubTaskErrorInfo<GRP_KEY, TASK_ID>>();
        this.statisticCnt = new int[CDCStageEnum.values().length];
        Arrays.fill(this.statisticCnt, 0);
    }

    public String toString() {
        return "TaskGroupCondition{taskStageCode=" + (Object)((Object)this.taskStageCode) + ", active=" + this.active + ", withError=" + this.withError + ", statisticCnt=" + Arrays.toString(this.statisticCnt) + '}';
    }

    protected synchronized void updateGroupCondition(CDCStageEnum newCondition, boolean withError) {
        this.withError = withError;
        this.taskStageCode = newCondition;
    }

    protected synchronized void registerTaskError(AbstractBaseWorkTask<GRP_KEY, TASK_ID, ?> subTask, Exception error) {
        this.taskErrorInfos.add(new SubTaskErrorInfo<GRP_KEY, TASK_ID>(subTask, error));
    }

    protected synchronized void updateGroupStatisticCnt(CDCStageEnum newCondition, int cnt) {
        int n = newCondition.getValue();
        this.statisticCnt[n] = this.statisticCnt[n] + cnt;
    }

    public synchronized void setActive(boolean active) {
        this.active = active;
    }

    public void updateStartedCnt(int changeCnt) {
        this.updateGroupStatisticCnt(CDCStageEnum.Started, changeCnt);
    }

    public void updateCompletedCnt(int changeCnt) {
        this.updateGroupStatisticCnt(CDCStageEnum.Completed, changeCnt);
    }

    public void updateCancelledCnt(int changeCnt) {
        this.updateGroupStatisticCnt(CDCStageEnum.Canceled, changeCnt);
    }

    public void cancel(boolean withError) {
        this.updateGroupCondition(CDCStageEnum.Canceled, withError);
    }

    public void markGroupCompleted(boolean withError) {
        this.updateGroupCondition(CDCStageEnum.Completed, withError);
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized boolean isCancelled() {
        return CDCStageEnum.Canceled == this.taskStageCode;
    }

    public boolean isCompleted() {
        if (!this.active) {
            switch (this.taskStageCode) {
                case Completed: 
                case Canceled: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean isWithError() {
        return this.withError;
    }

    public int getStatisticCnt(CDCStageEnum code) {
        return this.statisticCnt[code.getValue()];
    }

    public int getStartedSubTaskCnt() {
        return this.getStatisticCnt(CDCStageEnum.Started);
    }

    public int getCompletedSubTaskCnt() {
        return this.getStatisticCnt(CDCStageEnum.Completed);
    }

    public int getCancelledSubTaskCnt() {
        return this.getStatisticCnt(CDCStageEnum.Canceled);
    }

    public CDCStageEnum getTaskStageCode() {
        return this.taskStageCode;
    }

    public List<SubTaskErrorInfo<GRP_KEY, TASK_ID>> getTaskErrorInfos() {
        return this.taskErrorInfos;
    }

    public static class SubTaskErrorInfo<GRP_KEY extends Serializable, TASK_ID extends Serializable>
    implements Serializable {
        protected GRP_KEY groupId;
        protected TASK_ID taskId;
        protected String taskTypeCode;
        protected Map<String, Object> param;
        protected Exception error;

        public SubTaskErrorInfo(GRP_KEY groupId, TASK_ID taskId, String taskTypeCode, Exception error) {
            this.groupId = groupId;
            this.taskId = taskId;
            this.taskTypeCode = taskTypeCode;
            this.error = error;
        }

        public SubTaskErrorInfo(AbstractBaseWorkTask<GRP_KEY, TASK_ID, ?> task, Exception error) {
            this(task.getGroupId(), task.getTaskId(), task.getTaskTypeCode(), error);
        }

        public synchronized void addParam(String key, Object value) {
            if (this.param == null) {
                this.param = new HashMap<String, Object>(2);
            }
            this.param.put(key, value);
        }

        public GRP_KEY getGroupId() {
            return this.groupId;
        }

        public TASK_ID getTaskId() {
            return this.taskId;
        }

        public String getTaskTypeCode() {
            return this.taskTypeCode;
        }

        public Map<String, Object> getParam() {
            return this.param;
        }

        public Exception getError() {
            return this.error;
        }
    }
}

