/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.threads;

import java.io.Serializable;
import java.util.BitSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.bd.tasks.ITaskStatusChangeListener;
import kd.fi.bd.tasks.common.AbstractBaseWorkTask;
import kd.fi.bd.threads.IConfigurableThreadService;
import kd.fi.bd.threads.IDataFutureWrapper;
import kd.fi.bd.threads.ThreadCategoryConfig;
import kd.fi.bd.threads.ThreadCategoryEnum;

public abstract class AbstractConfigurableThreadService
implements IConfigurableThreadService {
    private Log logger;
    protected String serviceName;
    protected ThreadPool daemonPool;
    protected ThreadPool workerPool;
    protected ConcurrentLinkedDeque<IDataFutureWrapper>[] waitingTaskQueue;
    protected ReentrantLock[] taskQueueLocks;
    protected Condition[] taskQueueConditions;
    protected long Default_WaitTimeOut = 120000L;
    protected long Default_WaitTime = 100L;
    protected long Daemon_Default_WaitTime = 10000L;
    protected int MaxDaemonThread = 1;
    protected long Default_IdleTimeOut = 600000L;
    protected final AtomicBoolean serviceActiveFlag;
    protected final AtomicInteger runningDaemonThreadCnt;
    protected AtomicInteger[] runningThreadCnt;
    protected AtomicInteger[] waitingQueueCnt;
    protected final AtomicInteger totalRunningThreadCnt;
    protected final AtomicInteger totalWaitingQueueCnt;
    protected final AtomicInteger totalSubmittedThreadCnt;
    protected volatile int totalMaxThreadCnt;
    protected volatile int totalMaxDaemonQueueSize;
    protected final BitSet threadPoolLockFlag;
    protected final BitSet threadPoolNewPutFlag;
    protected Function<ThreadPoolInitInfo, ThreadPool> threadPoolFactory;
    protected final ThreadCategoryConfig[] threadCategoryConfigs;
    protected InnerTaskStatusChangeListener _taskStatusChangeListener;

    public Log getLogger() {
        if (this.logger == null) {
            if (this.getLogSupplier() == null) {
                throw new IllegalArgumentException("Logger Supplier cannot be null!");
            }
            this.logger = this.getLogSupplier().get();
        }
        return this.logger;
    }

    protected AbstractConfigurableThreadService(String serviceName, Integer totalMaxThreadCnt, Function<ThreadPoolInitInfo, ThreadPool> threadPoolFactory) {
        int poolCnt = ThreadCategoryEnum.values().length;
        this.totalWaitingQueueCnt = new AtomicInteger(0);
        this.runningDaemonThreadCnt = new AtomicInteger(0);
        this.totalSubmittedThreadCnt = new AtomicInteger(0);
        this._taskStatusChangeListener = new InnerTaskStatusChangeListener();
        this.waitingTaskQueue = new ConcurrentLinkedDeque[poolCnt];
        this.threadCategoryConfigs = new ThreadCategoryConfig[poolCnt];
        this.threadPoolFactory = threadPoolFactory;
        this.runningThreadCnt = new AtomicInteger[poolCnt];
        this.waitingQueueCnt = new AtomicInteger[poolCnt];
        this.taskQueueLocks = new ReentrantLock[poolCnt];
        this.taskQueueConditions = new Condition[poolCnt];
        this.totalRunningThreadCnt = new AtomicInteger(0);
        this.threadPoolLockFlag = new BitSet(poolCnt);
        this.threadPoolNewPutFlag = new BitSet(poolCnt);
        int thread_cnt = 0;
        int queue_Cnt = 0;
        int i = 0;
        for (ThreadCategoryEnum category : ThreadCategoryEnum.values()) {
            this.threadCategoryConfigs[category.registerIndex] = new ThreadCategoryConfig(category).reloadThreadCategoryConfig();
            thread_cnt += this.threadCategoryConfigs[category.registerIndex].getMaxThreadCnt();
            queue_Cnt += this.threadCategoryConfigs[category.registerIndex].getMaxWaitingQueueSize();
            this.runningThreadCnt[i] = new AtomicInteger(0);
            this.waitingQueueCnt[i] = new AtomicInteger(0);
            this.waitingTaskQueue[i] = new ConcurrentLinkedDeque();
            this.taskQueueLocks[i] = new ReentrantLock();
            this.taskQueueConditions[i] = this.taskQueueLocks[i].newCondition();
            ++i;
        }
        this.totalMaxThreadCnt = totalMaxThreadCnt != null ? totalMaxThreadCnt : thread_cnt;
        this.totalMaxDaemonQueueSize = queue_Cnt;
        this.serviceActiveFlag = new AtomicBoolean(true);
        this.daemonPool = threadPoolFactory.apply(ThreadPoolInitInfo.daemonPoolInfo(serviceName, "Daemon Pool - " + serviceName));
        this.workerPool = threadPoolFactory.apply(ThreadPoolInitInfo.workerPoolInfo(serviceName, "Worker Pool - " + serviceName));
    }

    protected AbstractConfigurableThreadService(String serviceName, Function<ThreadPoolInitInfo, ThreadPool> threadPoolFactory) {
        this(serviceName, null, threadPoolFactory);
    }

    protected AbstractConfigurableThreadService(String serviceName, Integer totalMaxThreadCnt) {
        this(serviceName, totalMaxThreadCnt, poolInitInfo -> ThreadPools.newCachedThreadPool((String)poolInitInfo.getFullPoolName(), (int)1, (int)1000));
    }

    protected abstract Supplier<Log> getLogSupplier();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startJobDispatcher(int maxCnt) {
        AtomicInteger atomicInteger = this.runningDaemonThreadCnt;
        synchronized (atomicInteger) {
            if (this.runningDaemonThreadCnt.get() < maxCnt) {
                this.daemonPool.execute((Runnable)new JobDispatcher((Serializable)((Object)this.serviceName), (Serializable)((Object)("JobDispatcher-" + this.runningDaemonThreadCnt.incrementAndGet()))));
            }
        }
    }

    protected <T> Future<T> submitEx(ThreadCategoryEnum category, RunnableWorkTaskWrapper workTask, RequestContext requestContext, long waitTimeout) {
        return this.submitEx(category, workTask, requestContext, waitTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(ThreadCategoryEnum category, Callable<T> workTask, RequestContext requestContext, long waitTimeout, TimeUnit unit) {
        return this.submitEx(category, RunnableWorkTaskWrapper.callable(category, workTask, this._taskStatusChangeListener), requestContext, waitTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(ThreadCategoryEnum category, Callable<T> workTask, RequestContext requestContext) {
        return this.submitEx(category, RunnableWorkTaskWrapper.callable(category, workTask, this._taskStatusChangeListener), requestContext, -1L);
    }

    @Override
    public <T> Future<T> submit(ThreadCategoryEnum category, Callable<T> workTask) {
        return this.submitEx(category, RunnableWorkTaskWrapper.callable(category, workTask, this._taskStatusChangeListener), RequestContext.getOrCreate(), -1L);
    }

    @Override
    public void execute(ThreadCategoryEnum category, Runnable runnable, RequestContext requestContext) {
        this.submitEx(category, RunnableWorkTaskWrapper.runnable(category, runnable, this._taskStatusChangeListener), requestContext, -1L);
    }

    @Override
    public void execute(ThreadCategoryEnum category, Runnable runnable) {
        this.submitEx(category, RunnableWorkTaskWrapper.runnable(category, runnable, this._taskStatusChangeListener), RequestContext.getOrCreate(), -1L);
    }

    @Override
    public <T> void execute(ThreadCategoryEnum category, Runnable runnable, RequestContext requestContext, long waitTimeout, TimeUnit unit) {
        this.submitEx(category, RunnableWorkTaskWrapper.runnable(category, runnable, this._taskStatusChangeListener), requestContext, waitTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isThreadPoolClosed(int threadPoolIndex) {
        return this.threadPoolLockFlag.get(threadPoolIndex);
    }

    @Override
    public long getDefaultWaitTimeOut() {
        return this.Default_WaitTimeOut;
    }

    public void setDefaultWaitTimeOut(long default_WaitTimeOut) {
        this.Default_WaitTimeOut = default_WaitTimeOut;
    }

    @Override
    public int getRunningThreadCnt(ThreadCategoryEnum category) {
        return this.runningThreadCnt[category.getRegisterIndex()].get();
    }

    @Override
    public int getWaitingQueueSize(ThreadCategoryEnum category) {
        return this.waitingQueueCnt[category.getRegisterIndex()].get();
    }

    @Override
    public int getTotalRunningThreadCnt() {
        return this.totalRunningThreadCnt.get();
    }

    @Override
    public int getTotalMaxThreadCnt() {
        return this.totalMaxThreadCnt;
    }

    @Override
    public void setTotalMaxThreadCnt(int totalMaxThreadCnt) {
        this.totalMaxThreadCnt = totalMaxThreadCnt;
    }

    @Override
    public boolean isThreadPoolLocked(ThreadCategoryEnum category) {
        return this.threadPoolLockFlag.get(category.getRegisterIndex());
    }

    public Function<ThreadPoolInitInfo, ThreadPool> getThreadPoolFactory() {
        return this.threadPoolFactory;
    }

    @Override
    public ThreadCategoryConfig getThreadCategoryConfigs(ThreadCategoryEnum category) {
        return this.threadCategoryConfigs[category.getRegisterIndex()].copy();
    }

    @Override
    public int getTotalMaxDaemonQueueSize() {
        return this.totalMaxDaemonQueueSize;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public int getRunningDaemonThreadCnt() {
        return this.runningDaemonThreadCnt.get();
    }

    @Override
    public int getTotalWaitingQueueCnt() {
        return this.totalWaitingQueueCnt.get();
    }

    @Override
    public boolean getServiceActiveFlag() {
        return this.serviceActiveFlag.get();
    }

    @Override
    public int getTotalSubmittedThreadCnt() {
        return this.totalSubmittedThreadCnt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceActiveFlag(boolean activeFlag) {
        this.serviceActiveFlag.set(activeFlag);
        AtomicBoolean atomicBoolean = this.serviceActiveFlag;
        synchronized (atomicBoolean) {
            this.serviceActiveFlag.notifyAll();
        }
    }

    @Override
    public int getTotalActiveThreadPoolCnt() {
        int activeCnt = 0;
        for (int i = 0; i < this.threadCategoryConfigs.length; ++i) {
            if (this.threadPoolLockFlag.get(i)) continue;
            ++activeCnt;
        }
        return activeCnt;
    }

    @Override
    public StringBuilder dumpThreadInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("ThreadService: ").append(this.serviceName).append(", Active:").append(this.serviceActiveFlag.get()).append(", Daemon:").append(this.runningDaemonThreadCnt.get()).append(String.format(", Total [Queueing:%s, Submitted:%s, Running:%s] Thread", this.totalWaitingQueueCnt, this.totalSubmittedThreadCnt, this.totalRunningThreadCnt.get())).append(String.format(", Max Limit [Thread:%s, Queue:%s]", this.totalMaxThreadCnt, this.totalMaxDaemonQueueSize));
        for (int i = 0; i < this.threadCategoryConfigs.length; ++i) {
            builder.append("\n\t").append((Object)this.threadCategoryConfigs[i].getBaseCategory()).append(", is_lock:").append(this.threadPoolLockFlag.get(i)).append(", running:").append(this.runningThreadCnt[i].get()).append(", queuing:").append(this.waitingQueueCnt[i].get());
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _beforeTaskStart(ThreadCategoryEnum category, Object groupId, Object taskId, Callable srcWorkTask) {
        this.totalRunningThreadCnt.incrementAndGet();
        AtomicInteger atomicInteger = this.totalRunningThreadCnt;
        synchronized (atomicInteger) {
            this.totalRunningThreadCnt.notifyAll();
        }
        this.totalSubmittedThreadCnt.decrementAndGet();
        this.notifyTotalSubmittedThreadCnt();
        this.notifyTotalWaitingQueueCnt();
    }

    protected void _afterTaskCompleted(ThreadCategoryEnum category, Object groupId, Object taskId, Callable srcWorkTask, Object taskResult, boolean withError) {
        if (category != null) {
            this.runningThreadCnt[category.getRegisterIndex()].decrementAndGet();
        }
        this.totalRunningThreadCnt.decrementAndGet();
        this.notifyTotalWaitingQueueCnt();
        this.notifyTotalRunningThreadCnt();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Task Completed: category={}, groupId={}\uff0c taskId={}, result={}, withError=%s, totalRunningThreadCnt={}, totalWaitingQueueCnt={}", new Object[]{category, groupId, taskId, taskResult, withError, this.totalRunningThreadCnt.get(), this.totalWaitingQueueCnt.get()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean resetThreadPoolSetting(ThreadCategoryConfig newConfig, boolean updateMaxThreadCnt) {
        if (newConfig == null) {
            return false;
        }
        int index = newConfig.getRegisterIndex();
        BitSet bitSet = this.threadPoolLockFlag;
        // MONITORENTER : bitSet
        this.threadPoolLockFlag.set(index);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("resetThreadPoolSetting: Start newConfig:{}", (Object)newConfig);
        }
        try {
            ReentrantLock queueLock = this.taskQueueLocks[index];
            try {
                queueLock.lock();
                ThreadCategoryConfig prevConfig = this.threadCategoryConfigs[index];
                if (newConfig.isSameConfig(prevConfig)) {
                    boolean bl = false;
                    return bl;
                }
                this.threadCategoryConfigs[index] = newConfig;
                if (updateMaxThreadCnt) {
                    this.totalMaxThreadCnt += newConfig.getMaxThreadCnt() - prevConfig.getMaxThreadCnt();
                }
                this.totalMaxDaemonQueueSize += newConfig.getMaxWaitingQueueSize() - prevConfig.getMaxWaitingQueueSize();
            }
            finally {
                queueLock.unlock();
            }
        }
        finally {
            this.threadPoolLockFlag.clear(index);
        }
        // MONITOREXIT : bitSet
        if (!this.getLogger().isInfoEnabled()) return true;
        this.getLogger().info("resetThreadPoolSetting: Completed newConfig:{}", (Object)newConfig);
        return true;
    }

    public boolean resetThreadPoolSetting(ThreadCategoryConfig newConfig) {
        return this.resetThreadPoolSetting(newConfig, false);
    }

    public int[] getTotalMaxThreadAndQueueCnt() {
        int thread_cnt = 0;
        int queue_Cnt = 0;
        for (ThreadCategoryConfig config : this.threadCategoryConfigs) {
            if (this.threadPoolLockFlag.get(config.getRegisterIndex())) continue;
            thread_cnt += config.getMaxThreadCnt();
            queue_Cnt += config.getMaxWaitingQueueSize();
        }
        return new int[]{thread_cnt, queue_Cnt};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force, long timeOut, TimeUnit timeUnit) {
        BitSet bitSet = this.threadPoolLockFlag;
        synchronized (bitSet) {
            for (int i = 0; i < this.threadCategoryConfigs.length; ++i) {
                this.threadPoolLockFlag.set(i);
            }
        }
        if (force) {
            this.serviceActiveFlag.set(false);
            this.daemonPool.close();
            this.workerPool.close();
        } else {
            boolean infiniteWait = timeOut < 0L;
            long waitTime = infiniteWait ? -1L : timeUnit.toMillis(timeOut);
            long lastStartTime = System.currentTimeMillis();
            AtomicInteger atomicInteger = this.totalSubmittedThreadCnt;
            synchronized (atomicInteger) {
                int checkCnt;
                while ((checkCnt = this.totalSubmittedThreadCnt.get()) > 0) {
                    if (!infiniteWait && waitTime < 0L) {
                        throw new RuntimeException(String.format("Waiting Thread Pool close failed due to time out in (%s), remaining thread cnt=%s, queue=%s", waitTime, checkCnt, this.getTotalWaitingQueueCnt()));
                    }
                    try {
                        if (infiniteWait) {
                            this.totalSubmittedThreadCnt.wait(this.Default_WaitTime);
                        } else {
                            this.totalSubmittedThreadCnt.wait(waitTime);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (infiniteWait) continue;
                    long newStartTime = System.currentTimeMillis();
                    waitTime -= newStartTime - lastStartTime;
                    lastStartTime = newStartTime;
                }
            }
            this.workerPool.close();
            this.serviceActiveFlag.set(false);
            this.notifyCounter(this.totalWaitingQueueCnt);
            this.notifyCounter(this.totalRunningThreadCnt);
            while (this.runningDaemonThreadCnt.get() > 0) {
                try {
                    atomicInteger = this.runningDaemonThreadCnt;
                    synchronized (atomicInteger) {
                        this.runningDaemonThreadCnt.wait(this.Default_WaitTime);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            this.daemonPool.close();
        }
    }

    public void close(boolean force) {
        this.close(force, -1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCounter(AtomicInteger counter) {
        AtomicInteger atomicInteger = counter;
        synchronized (atomicInteger) {
            counter.notifyAll();
        }
    }

    public void notifyTotalRunningThreadCnt() {
        this.notifyCounter(this.totalRunningThreadCnt);
    }

    public void notifyTotalSubmittedThreadCnt() {
        this.notifyCounter(this.totalSubmittedThreadCnt);
    }

    public void notifyTotalWaitingQueueCnt() {
        this.notifyCounter(this.totalWaitingQueueCnt);
    }

    public boolean isChannelFull(int index) {
        ThreadCategoryConfig config = this.threadCategoryConfigs[index];
        return this.totalRunningThreadCnt.get() >= this.totalMaxThreadCnt && this.runningThreadCnt[index].get() >= config.getMaxThreadCnt() && this.waitingQueueCnt[index].get() >= config.getMaxWaitingQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T waitFor(boolean lockInterruptibility, int channelIndex, Supplier<Boolean> needWaitExpression, Supplier<T> process, long waitTimeout, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time Unit is null!");
        }
        boolean infiniteWait = waitTimeout < 0L;
        long waitTime = infiniteWait ? -1L : timeUnit.toNanos(waitTimeout);
        ReentrantLock queueLock = this.taskQueueLocks[channelIndex];
        Condition queueCondition = this.taskQueueConditions[channelIndex];
        try {
            if (lockInterruptibility) {
                queueLock.lockInterruptibly();
            } else {
                queueLock.lock();
            }
            try {
                while (needWaitExpression.get().booleanValue()) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Submit infiniteWait={}, Wait channel: {}, WaitCnt={}, runningCnt={}", new Object[]{infiniteWait, channelIndex, this.waitingQueueCnt[channelIndex].get(), this.runningThreadCnt[channelIndex].get()});
                    }
                    if (infiniteWait) {
                        queueCondition.awaitNanos(1000000000L);
                        continue;
                    }
                    if (waitTime <= 0L) {
                        throw new RuntimeException(String.format("Submit Task time out. Channel:%s, wait time:(%s: %s)", new Object[]{channelIndex, timeUnit, waitTimeout}));
                    }
                    waitTime = queueCondition.awaitNanos(waitTime);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Submit infiniteWait={}, Wait Completed: {}", (Object)infiniteWait, (Object)channelIndex);
                }
                T t = process.get();
                return t;
            }
            finally {
                queueLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public <T> Future<T> submitEx(ThreadCategoryEnum category, RunnableWorkTaskWrapper workTask, RequestContext requestContext, long waitTimeout, TimeUnit unit) {
        if (!this.serviceActiveFlag.get()) {
            throw new RuntimeException(String.format("Thread Pool Service is closed! Category:%s, task:%s", new Object[]{category, workTask}));
        }
        if (workTask == null || category == null) {
            throw new IllegalArgumentException("WorkTask or Category cannot be null!");
        }
        if (requestContext == null) {
            requestContext = RequestContext.getOrCreate();
        }
        workTask.setRequestContext(requestContext);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("submitEx: Start category:{}, task={}", (Object)category, (Object)workTask);
        }
        if (this.runningDaemonThreadCnt.get() <= 0) {
            this.startJobDispatcher(this.MaxDaemonThread);
        }
        IDataFutureWrapper resultWrapper = new IDataFutureWrapper(category, workTask);
        int index = category.getRegisterIndex();
        AtomicInteger wait_counter = this.waitingQueueCnt[index];
        ThreadCategoryConfig config = this.threadCategoryConfigs[index];
        int queueSize = config.getMaxWaitingQueueSize();
        Boolean result = this.waitFor(true, index, () -> {
            boolean r;
            boolean bl = r = wait_counter.get() >= queueSize;
            if (!r && !this.isChannelFull(index)) {
                this.notifyTotalWaitingQueueCnt();
                this.notifyTotalRunningThreadCnt();
                int waitCnt = 5;
                while (!this.isChannelFull(index) && waitCnt-- >= 0) {
                    LockSupport.parkNanos(1000000L);
                }
                r = wait_counter.get() >= queueSize;
            }
            return r;
        }, () -> {
            this.waitingTaskQueue[index].addLast(resultWrapper);
            wait_counter.incrementAndGet();
            this.totalWaitingQueueCnt.incrementAndGet();
            this.threadPoolNewPutFlag.set(index);
            return true;
        }, waitTimeout, unit);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("submitEx: Completed category:{}, result={}", (Object)category, (Object)result);
        }
        if (result != null && result.booleanValue()) {
            this.notifyTotalWaitingQueueCnt();
            return resultWrapper;
        }
        return null;
    }

    public static class ThreadPoolInitInfo
    implements Serializable {
        protected int poolType;
        protected String serviceName;
        protected String poolName;

        protected ThreadPoolInitInfo(int poolType, String serviceName, String poolName) {
            this.poolType = poolType;
            this.serviceName = serviceName;
            this.poolName = poolName;
        }

        public static ThreadPoolInitInfo daemonPoolInfo(String serviceName, String poolName) {
            return new ThreadPoolInitInfo(0, serviceName, poolName);
        }

        public static ThreadPoolInitInfo workerPoolInfo(String serviceName, String poolName) {
            return new ThreadPoolInitInfo(0, serviceName, poolName);
        }

        public String getFullPoolName() {
            return this.serviceName + "|" + this.poolName;
        }
    }

    protected static class RunnableWorkTaskWrapper
    extends AbstractBaseWorkTask<Long, Long, Object> {
        private Callable workTask1;
        private Runnable workTask2;
        private boolean needReturnValue = false;

        private RunnableWorkTaskWrapper(ThreadCategoryEnum category, ITaskStatusChangeListener statusChangeListener) {
            super(System.currentTimeMillis(), System.currentTimeMillis());
            this.category = category;
            this.taskStatusChangeListener = statusChangeListener;
        }

        public static RunnableWorkTaskWrapper runnable(ThreadCategoryEnum category, Runnable workTask, ITaskStatusChangeListener statusChangeListener) {
            RunnableWorkTaskWrapper wrapper = new RunnableWorkTaskWrapper(category, statusChangeListener);
            wrapper.workTask2 = workTask;
            return wrapper;
        }

        public static RunnableWorkTaskWrapper callable(ThreadCategoryEnum category, Callable workTask, ITaskStatusChangeListener statusChangeListener) {
            RunnableWorkTaskWrapper wrapper = new RunnableWorkTaskWrapper(category, statusChangeListener);
            wrapper.workTask1 = workTask;
            wrapper.needReturnValue = true;
            return wrapper;
        }

        @Override
        protected Object doTaskJob() throws Exception {
            if (this.needReturnValue) {
                return this.workTask1.call();
            }
            this.workTask2.run();
            return null;
        }
    }

    protected class JobDispatcher
    extends AbstractBaseWorkTask<Serializable, Serializable, Object> {
        protected JobDispatcher(Serializable groupId, Serializable taskId) {
            super(groupId, taskId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doTaskJob() throws Exception {
            Serializable serializable;
            if (AbstractConfigurableThreadService.this.getLogger().isInfoEnabled()) {
                AbstractConfigurableThreadService.this.getLogger().info("JobDispatcher Started! {} - {}", (Object)this.groupId, (Object)this.taskId);
            }
            long idleTime = AbstractConfigurableThreadService.this.Default_IdleTimeOut + System.currentTimeMillis();
            boolean active = true;
            while (active && AbstractConfigurableThreadService.this.serviceActiveFlag.get()) {
                if (AbstractConfigurableThreadService.this.totalRunningThreadCnt.get() >= AbstractConfigurableThreadService.this.totalMaxThreadCnt) {
                    if (AbstractConfigurableThreadService.this.getLogger().isDebugEnabled()) {
                        AbstractConfigurableThreadService.this.getLogger().debug("JobDispatcher Wait:{} for totalRunningThreadCnt: Running:{}, Max:{}, threadPool={}", new Object[]{AbstractConfigurableThreadService.this.Daemon_Default_WaitTime, AbstractConfigurableThreadService.this.totalRunningThreadCnt.get(), AbstractConfigurableThreadService.this.totalMaxThreadCnt, AbstractConfigurableThreadService.this.dumpThreadInfo()});
                    }
                    serializable = AbstractConfigurableThreadService.this.totalRunningThreadCnt;
                    synchronized (serializable) {
                        AbstractConfigurableThreadService.this.totalRunningThreadCnt.wait(AbstractConfigurableThreadService.this.Daemon_Default_WaitTime);
                    }
                    idleTime = AbstractConfigurableThreadService.this.Default_IdleTimeOut + System.currentTimeMillis();
                    if (AbstractConfigurableThreadService.this.totalWaitingQueueCnt.get() <= 0 || AbstractConfigurableThreadService.this.totalRunningThreadCnt.get() >= AbstractConfigurableThreadService.this.totalMaxThreadCnt) continue;
                }
                if (AbstractConfigurableThreadService.this.totalWaitingQueueCnt.get() <= 0) {
                    if (AbstractConfigurableThreadService.this.getLogger().isDebugEnabled()) {
                        AbstractConfigurableThreadService.this.getLogger().debug("JobDispatcher Start Wait (2).totalWaitingQueueCnt={}, waitTime={}, threadPool={}", new Object[]{AbstractConfigurableThreadService.this.totalWaitingQueueCnt.get(), AbstractConfigurableThreadService.this.Daemon_Default_WaitTime, AbstractConfigurableThreadService.this.dumpThreadInfo()});
                    }
                    try {
                        serializable = AbstractConfigurableThreadService.this.totalWaitingQueueCnt;
                        synchronized (serializable) {
                            AbstractConfigurableThreadService.this.totalWaitingQueueCnt.wait(AbstractConfigurableThreadService.this.Daemon_Default_WaitTime);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (idleTime >= System.currentTimeMillis()) continue;
                    active = false;
                    continue;
                }
                BitSet changedFlags = null;
                serializable = AbstractConfigurableThreadService.this.threadPoolNewPutFlag;
                synchronized (serializable) {
                    if (!AbstractConfigurableThreadService.this.threadPoolNewPutFlag.isEmpty()) {
                        changedFlags = (BitSet)AbstractConfigurableThreadService.this.threadPoolNewPutFlag.clone();
                    }
                }
                if (changedFlags == null) continue;
                int index = -1;
                while ((index = changedFlags.nextSetBit(index + 1)) >= 0) {
                    this.processChannel(index);
                }
            }
            serializable = AbstractConfigurableThreadService.this.runningDaemonThreadCnt;
            synchronized (serializable) {
                AbstractConfigurableThreadService.this.runningDaemonThreadCnt.decrementAndGet();
                AbstractConfigurableThreadService.this.runningDaemonThreadCnt.notifyAll();
            }
            if (AbstractConfigurableThreadService.this.getLogger().isInfoEnabled()) {
                AbstractConfigurableThreadService.this.getLogger().info("JobDispatcher Completed! ServiceInfo={}", (Object)AbstractConfigurableThreadService.this.dumpThreadInfo());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processChannel(int index) {
            AtomicInteger run_counter = AbstractConfigurableThreadService.this.runningThreadCnt[index];
            AtomicInteger wait_counter = AbstractConfigurableThreadService.this.waitingQueueCnt[index];
            ConcurrentLinkedDeque<IDataFutureWrapper> queue = AbstractConfigurableThreadService.this.waitingTaskQueue[index];
            if (run_counter.get() >= AbstractConfigurableThreadService.this.threadCategoryConfigs[index].getMaxThreadCnt()) {
                return;
            }
            ReentrantLock queueLock = AbstractConfigurableThreadService.this.taskQueueLocks[index];
            Condition queueCondition = AbstractConfigurableThreadService.this.taskQueueConditions[index];
            try {
                Serializable serializable;
                block14: {
                    queueLock.lockInterruptibly();
                    try {
                        IDataFutureWrapper taskWrapper;
                        ThreadCategoryConfig config = AbstractConfigurableThreadService.this.threadCategoryConfigs[index];
                        int maxThreadCnt = config.getMaxThreadCnt();
                        int addCnt = 0;
                        while (run_counter.get() < maxThreadCnt && (taskWrapper = queue.pollFirst()) != null) {
                            taskWrapper.setSrcFuture(AbstractConfigurableThreadService.this.workerPool.submit((Callable)taskWrapper.srcWorkTask));
                            run_counter.incrementAndGet();
                            wait_counter.decrementAndGet();
                            AbstractConfigurableThreadService.this.totalSubmittedThreadCnt.incrementAndGet();
                            AbstractConfigurableThreadService.this.totalWaitingQueueCnt.decrementAndGet();
                            ++addCnt;
                            if (!AbstractConfigurableThreadService.this.getLogger().isDebugEnabled()) continue;
                            AbstractConfigurableThreadService.this.getLogger().debug("{}, Submit Task, run_counter={}, wait_counter={}, totalSubmittedThreadCnt={},totalWaitingQueueCnt={}\n", new Object[]{config.getBaseCategory().name(), run_counter.get(), wait_counter.get(), AbstractConfigurableThreadService.this.totalSubmittedThreadCnt.get(), AbstractConfigurableThreadService.this.totalWaitingQueueCnt.get()});
                        }
                        if (addCnt > 0) {
                            queueCondition.signal();
                        }
                        if (wait_counter.get() > 0) break block14;
                        serializable = AbstractConfigurableThreadService.this.threadPoolNewPutFlag;
                        synchronized (serializable) {
                            AbstractConfigurableThreadService.this.threadPoolNewPutFlag.clear(index);
                        }
                    }
                    finally {
                        queueLock.unlock();
                    }
                }
                serializable = AbstractConfigurableThreadService.this.totalSubmittedThreadCnt;
                synchronized (serializable) {
                    AbstractConfigurableThreadService.this.totalSubmittedThreadCnt.notify();
                }
            }
            catch (Exception ignored) {
                AbstractConfigurableThreadService.this.getLogger().error(ignored.getMessage(), (Throwable)ignored);
            }
        }
    }

    protected class InnerTaskStatusChangeListener
    implements ITaskStatusChangeListener {
        protected InnerTaskStatusChangeListener() {
        }

        @Override
        public void beforeTaskStart(ThreadCategoryEnum category, Object groupId, Object taskId, Callable srcWorkTask) {
            AbstractConfigurableThreadService.this._beforeTaskStart(category, groupId, taskId, srcWorkTask);
        }

        @Override
        public void afterTaskCompleted(ThreadCategoryEnum category, Object groupId, Object taskId, Callable srcWorkTask, Object taskResult, boolean withError) {
            AbstractConfigurableThreadService.this._afterTaskCompleted(category, groupId, taskId, srcWorkTask, taskResult, withError);
        }
    }
}

