/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.threads;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.fi.bd.threads.AbstractConfigurableThreadService;
import kd.fi.bd.threads.ThreadCategoryEnum;

public class IDataFutureWrapper<T>
implements Future<T> {
    protected ThreadCategoryEnum category;
    protected Future<T> srcFuture;
    protected boolean waitSrcFutureSubmit;
    protected AbstractConfigurableThreadService.RunnableWorkTaskWrapper srcWorkTask;

    public IDataFutureWrapper(ThreadCategoryEnum category, AbstractConfigurableThreadService.RunnableWorkTaskWrapper srcWorkTask) {
        this.category = category;
        this.waitSrcFutureSubmit = true;
        this.srcFuture = null;
        this.srcWorkTask = srcWorkTask;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.waitSrcFutureSubmit = false;
        Future<T> taskFuture = this.getSrcFuture();
        if (taskFuture != null && !taskFuture.isDone()) {
            return taskFuture.cancel(mayInterruptIfRunning);
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? true : taskFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? false : taskFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? null : (T)taskFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Future<T> taskFuture = this.getSrcFuture();
        return taskFuture == null ? null : (T)taskFuture.get(timeout, unit);
    }

    public boolean testTaskCompleted() {
        if (this.srcFuture != null) {
            return this.srcFuture.isDone() || this.srcFuture.isCancelled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> getSrcFuture(long timeOut, TimeUnit unit) {
        if (this.srcFuture == null) {
            AbstractConfigurableThreadService.RunnableWorkTaskWrapper runnableWorkTaskWrapper = this.srcWorkTask;
            synchronized (runnableWorkTaskWrapper) {
                try {
                    this.srcWorkTask.wait(unit.toMillis(timeOut));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.srcFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T> getSrcFuture() {
        while (this.waitSrcFutureSubmit && this.srcFuture == null) {
            AbstractConfigurableThreadService.RunnableWorkTaskWrapper runnableWorkTaskWrapper = this.srcWorkTask;
            synchronized (runnableWorkTaskWrapper) {
                try {
                    this.srcWorkTask.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.srcFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSrcFuture(Future<T> srcFuture) {
        this.srcFuture = srcFuture;
        AbstractConfigurableThreadService.RunnableWorkTaskWrapper runnableWorkTaskWrapper = this.srcWorkTask;
        synchronized (runnableWorkTaskWrapper) {
            this.srcWorkTask.notifyAll();
        }
    }

    public boolean isWaitSrcFutureSubmit() {
        return this.waitSrcFutureSubmit;
    }

    public void setWaitSrcFutureSubmit(boolean waitSrcFutureSubmit) {
        this.waitSrcFutureSubmit = waitSrcFutureSubmit;
    }

    public ThreadCategoryEnum getCategory() {
        return this.category;
    }
}

