/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.threads;

import java.io.Serializable;
import kd.fi.bd.threads.ThreadCategoryEnum;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;

public class ThreadCategoryConfig
implements Serializable {
    private ThreadCategoryEnum baseCategory;
    protected int registerIndex;
    protected volatile int minThreadCnt;
    protected volatile int maxThreadCnt;
    protected volatile int maxWaitingQueueSize;
    public static final String[] ParamSuffixes = new String[]{"minThreadCnt", "maxThreadCnt", "maxWaitingQueueSize"};

    public ThreadCategoryConfig(ThreadCategoryEnum baseCategory) {
        this.baseCategory = baseCategory;
        this.registerIndex = baseCategory.registerIndex;
        this.minThreadCnt = baseCategory.minThreadCnt;
        this.maxThreadCnt = baseCategory.maxThreadCnt;
        this.maxWaitingQueueSize = baseCategory.maxWaitingQueueSize;
    }

    public ThreadCategoryEnum getBaseCategory() {
        return this.baseCategory;
    }

    public ThreadCategoryConfig setBaseCategory(ThreadCategoryEnum baseCategory) {
        this.baseCategory = baseCategory;
        this.registerIndex = baseCategory.registerIndex;
        this.minThreadCnt = baseCategory.minThreadCnt;
        this.maxThreadCnt = baseCategory.maxThreadCnt;
        this.maxWaitingQueueSize = baseCategory.maxWaitingQueueSize;
        return this;
    }

    private ThreadCategoryConfig(ThreadCategoryEnum baseCategory, int registerIndex, int minThreadCnt, int maxThreadCnt, int maxWaitingQueueSize) {
        this.baseCategory = baseCategory;
        this.registerIndex = registerIndex;
        this.minThreadCnt = minThreadCnt;
        this.maxThreadCnt = maxThreadCnt;
        this.maxWaitingQueueSize = maxWaitingQueueSize;
    }

    public String toString() {
        return "ThreadCategoryConfig{registerIndex=" + this.registerIndex + ", baseCategory=" + (Object)((Object)this.baseCategory) + ", minThreadCnt=" + this.minThreadCnt + ", maxThreadCnt=" + this.maxThreadCnt + ", maxWaitingQueueSize=" + this.maxWaitingQueueSize + '}';
    }

    public ThreadCategoryConfig reloadThreadCategoryConfig() {
        this.minThreadCnt = OptimizeControlPanel.getSysPropertyInteger(this.baseCategory.getParamKey() + ".minThreadCnt", this.baseCategory.getMinThreadCnt());
        this.maxThreadCnt = OptimizeControlPanel.getSysPropertyInteger(this.baseCategory.getParamKey() + ".maxThreadCnt", this.baseCategory.getMaxThreadCnt());
        this.maxWaitingQueueSize = OptimizeControlPanel.getSysPropertyInteger(this.baseCategory.getParamKey() + ".maxWaitingQueueSize", this.baseCategory.getMaxWaitingQueueSize());
        return this;
    }

    public boolean isSameConfig(ThreadCategoryConfig compareTarget) {
        if (compareTarget == null) {
            return true;
        }
        return this.registerIndex == compareTarget.registerIndex && this.maxThreadCnt == compareTarget.maxThreadCnt && this.minThreadCnt == compareTarget.minThreadCnt && this.maxWaitingQueueSize == compareTarget.maxWaitingQueueSize;
    }

    public ThreadCategoryConfig copy() {
        return new ThreadCategoryConfig(this.baseCategory, this.registerIndex, this.minThreadCnt, this.maxThreadCnt, this.maxWaitingQueueSize);
    }

    public int getRegisterIndex() {
        return this.registerIndex;
    }

    public String getParamKey() {
        return this.baseCategory.getParamKey();
    }

    public int getMinThreadCnt() {
        return this.minThreadCnt;
    }

    public void setMinThreadCnt(int minThreadCnt) {
        this.minThreadCnt = minThreadCnt;
    }

    public int getMaxThreadCnt() {
        return this.maxThreadCnt;
    }

    public void setMaxThreadCnt(int maxThreadCnt) {
        this.maxThreadCnt = maxThreadCnt;
    }

    public int getMaxWaitingQueueSize() {
        return this.maxWaitingQueueSize;
    }

    public void setMaxWaitingQueueSize(int maxWaitingQueueSize) {
        this.maxWaitingQueueSize = maxWaitingQueueSize;
    }
}

