/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.service.common.BillParamService;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.BillParamUtil;

public class AccountBookUtil {
    public static boolean isHaveBiz(Collection<Long> bookIds) {
        if (CollectionUtils.isEmpty(bookIds)) {
            return false;
        }
        HashMap<Long, Tuple<Long, Long>> bookInfoMap = new HashMap<Long, Tuple<Long, Long>>(8);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccountBookUtil.class.getName(), (String)"gl_accountbook", (String)String.join((CharSequence)",", "id", "org", "bookstype", "isendinit", "isendinitcashflow"), (QFilter[])new QFilter[]{new QFilter("id", "in", bookIds)}, null);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Tuple orgAndBookTypeTup = new Tuple((Object)row.getLong("org"), (Object)row.getLong("bookstype"));
                bookInfoMap.put(row.getLong("id"), (Tuple<Long, Long>)orgAndBookTypeTup);
                if (!row.getBoolean("isendinit").booleanValue() && !row.getBoolean("isendinitcashflow").booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (AccountBookUtil.checkTempVoucher(bookInfoMap)) {
            return true;
        }
        List<QFilter> filterList = AccountBookUtil.buildAllOrgAndTypeFilter(bookInfoMap.values());
        for (QFilter qFilter : filterList) {
            if (!AccountBookUtil.checkAcctBalance(qFilter) && !AccountBookUtil.checkBalanceInit(qFilter) && !AccountBookUtil.checkCashFlowInit(qFilter) && !AccountBookUtil.checkReciprocalInit(qFilter)) continue;
            return true;
        }
        return false;
    }

    private static List<QFilter> buildAllOrgAndTypeFilter(Collection<Tuple<Long, Long>> orgAndBookTypeTuples) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(orgAndBookTypeTuples.size());
        for (Tuple<Long, Long> orgAndBookTypeTuple : orgAndBookTypeTuples) {
            filterList.add(new QFilter("org", "=", orgAndBookTypeTuple.item1).and(new QFilter("booktype", "=", orgAndBookTypeTuple.item2)));
        }
        int batchSize = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.bd.util.accountbookutil.checkbiz.size", 200);
        return BatchProcessUtil.batchProcess(batchSize, filterList, filters -> {
            QFilter filter = null;
            for (QFilter qFilter : filters) {
                if (Objects.isNull(filter)) {
                    filter = qFilter;
                    continue;
                }
                filter = filter.or(qFilter);
            }
            return filter;
        });
    }

    private static boolean checkTempVoucher(Map<Long, Tuple<Long, Long>> bookInfoMap) {
        Set orgIdSet = bookInfoMap.values().stream().map(tuple -> (Long)tuple.item1).collect(Collectors.toSet());
        return BatchProcessUtil.exist(10000, orgIdSet, batchData -> {
            ArrayList<Long> tempVoucherIdList = new ArrayList<Long>(8);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkTempVoucher.queryTempVoucher", (String)"gl_tempvoucher_index", (String)"voucherid", (QFilter[])new QFilter[]{new QFilter("org", "in", batchData)}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    tempVoucherIdList.add(row.getLong("voucherid"));
                }
            }
            return QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("id", "in", tempVoucherIdList), new QFilter("book", "in", bookInfoMap.keySet())});
        });
    }

    private static boolean checkAcctBalance(QFilter filter) {
        if (BillParamService.getEnableAcctQuery()) {
            return QueryServiceHelper.exists((String)"gl_acctbalance", (QFilter[])new QFilter[]{filter});
        }
        return QueryServiceHelper.exists((String)"gl_balance", (QFilter[])new QFilter[]{filter});
    }

    private static boolean checkBalanceInit(QFilter filter) {
        return QueryServiceHelper.exists((String)"gl_initbalance", (QFilter[])new QFilter[]{filter, new QFilter("isdeleted", "=", (Object)false)});
    }

    private static boolean checkCashFlowInit(QFilter filter) {
        return QueryServiceHelper.exists((String)"gl_initcashflow", (QFilter[])new QFilter[]{filter, new QFilter("tabdelete", "=", (Object)false)});
    }

    private static boolean checkReciprocalInit(QFilter filter) {
        return QueryServiceHelper.exists((String)"gl_initacccurrent", (QFilter[])new QFilter[]{filter}) || QueryServiceHelper.exists((String)"gl_reci_init_state", (QFilter[])new QFilter[]{filter});
    }

    public static boolean isChangedMulLocalCurrencyFields(DynamicObject accountBook) {
        List<LocalCurrencyConfigVO> configVOList = LocalCurrencyConfigService.getCurrencyConfigByEntityId("gl_accountbook");
        StringBuilder selectProperties = new StringBuilder();
        for (LocalCurrencyConfigVO configVO : configVOList) {
            selectProperties.append(",").append(configVO.getCurrencyField()).append(",").append(configVO.getExRateField());
        }
        DynamicObject oldAccountBook = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBook.getLong("id"), (String)"gl_accountbook", (String)selectProperties.toString());
        if (Objects.nonNull(oldAccountBook)) {
            for (LocalCurrencyConfigVO configVO : configVOList) {
                String currencyField = configVO.getCurrencyField();
                String exRateField = configVO.getExRateField();
                if (accountBook.getLong(currencyField + "_id") == oldAccountBook.getLong(currencyField + "_id") && accountBook.getLong(exRateField + "_id") == oldAccountBook.getLong(exRateField + "_id")) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getCurAndExRateTableFields() {
        return AccountBookUtil.getMulCurFields(true, true);
    }

    public static List<String> getCurFields() {
        return AccountBookUtil.getMulCurFields(true, false);
    }

    public static List<String> getExRateTableFields() {
        return AccountBookUtil.getMulCurFields(false, true);
    }

    private static List<String> getMulCurFields(boolean getCurrency, boolean getExRateTable) {
        ArrayList<String> allMulCurFieldList = new ArrayList<String>(8);
        List<LocalCurrencyConfigVO> configVOList = LocalCurrencyConfigService.getCurrencyConfigByEntityId("gl_accountbook");
        for (LocalCurrencyConfigVO configVO : configVOList) {
            if (getCurrency) {
                allMulCurFieldList.add(configVO.getCurrencyField());
            }
            if (!getExRateTable) continue;
            allMulCurFieldList.add(configVO.getExRateField());
        }
        return allMulCurFieldList;
    }
}

