/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLog;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.BillParamUtil;

public class AccountOperationLogUtil {
    private static final Map<String, OperationLog> OPERATION_LOG_MAP = Collections.synchronizedMap(new HashMap(8));
    private static final Log LOGGER = LogFactory.getLog(AccountOperationLogUtil.class);

    public static void initRawOperationLog(Long operationOrgId, AccountOperationType operationType, Long accountTableId, Set<Long> accountIds) {
        try {
            if (!AccountOperationLogUtil.openLog()) {
                return;
            }
            OperationLog operationLog = new OperationLog(operationOrgId, operationType, accountTableId, accountIds);
            OPERATION_LOG_MAP.put(RequestContext.get().getRequestId(), operationLog);
        }
        catch (Exception e) {
            LOGGER.error("AccountOperationLogUtil_initRawOperationLog: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static void addLogEntryRow(OperationLogEntry entryRow) {
        if (!AccountOperationLogUtil.openLog()) {
            return;
        }
        ArrayList<OperationLogEntry> entryList = new ArrayList<OperationLogEntry>();
        entryList.add(entryRow);
        AccountOperationLogUtil.addLogEntryRow(entryList);
    }

    public static void addLogEntryRow(List<OperationLogEntry> entryList) {
        try {
            if (!AccountOperationLogUtil.openLog()) {
                return;
            }
            AccountOperationLogUtil.setOperationLog(operationLog -> operationLog.getEntryEntity().addAll(entryList));
        }
        catch (Exception e) {
            LOGGER.error("AccountOperationLogUtil_addLogEntryRow: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static void persistLog() {
        AccountOperationLogUtil.persistLog("");
    }

    public static void persistLog(String message) {
        try {
            if (!AccountOperationLogUtil.openLog()) {
                return;
            }
            String requestId = RequestContext.get().getRequestId();
            AccountOperationLogUtil.setOperationLog(operationLog -> {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)message)) {
                    operationLog.setLog(message);
                }
            });
            OperationLog operationLog2 = OPERATION_LOG_MAP.remove(requestId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{operationLog2.toDynamicObject()});
        }
        catch (Exception e) {
            LOGGER.error("AccountOperationLogUtil_persistLog: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static void setOperationLog(Consumer<OperationLog> function) {
        try {
            if (!AccountOperationLogUtil.openLog()) {
                return;
            }
            OperationLog operationLog = OPERATION_LOG_MAP.get(RequestContext.get().getRequestId());
            if (operationLog != null && function != null) {
                function.accept(operationLog);
            }
        }
        catch (Exception e) {
            LOGGER.error("AccountOperationLogUtil_setOperationLog: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static void updateFailedEntry(OperationResult operationResult) {
        try {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            if (allErrorOrValidateInfo.size() > 0) {
                AccountOperationLogUtil.setOperationLog(operationLog -> {
                    List<OperationLogEntry> entryEntity = operationLog.getEntryEntity();
                    HashMap<Long, OperationLogEntry> operationLogEntityMap = new HashMap<Long, OperationLogEntry>(8);
                    for (OperationLogEntry entity : entryEntity) {
                        operationLogEntityMap.put(entity.getAccountId(), entity);
                    }
                    for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                        OperationLogEntry entity = (OperationLogEntry)operationLogEntityMap.get(operateInfo.getPkValue());
                        if (entity == null) continue;
                        entity.setSuccess(false);
                        entity.setLog(StringUtils.isNotEmpty((CharSequence)entity.getLog()) ? entity.getLog() + operateInfo.getMessage() + "\n" : operateInfo.getMessage() + "\n");
                    }
                    operationLog.setLog(ResManager.loadKDString((String)"\u5931\u8d25", (String)"AccountTreeList_12", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("AccountOperationLogUtil_updateFailedEntry: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private static boolean openLog() {
        return BillParamUtil.getBooleanValue("P9H6JC5EVP1", "fi.bd.account.operation.log", true);
    }
}

