/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.vo.CommonAssist;

public class AccountTableUtil {
    private static final String COMMON_ASSIST_GROUP = "PRO_GL_FSAB";
    public static final String PREFIX_COMASSIST = "comassist";

    public static Map<Long, DynamicObject> getAccountTableFromDB(Set<Long> accountTableIdSet, String selectProperties) {
        HashMap<Long, DynamicObject> accountTableIdToDyoMap = new HashMap<Long, DynamicObject>(8);
        if (CollectionUtils.isNotEmpty(accountTableIdSet)) {
            DynamicObject[] accountTableDys;
            for (DynamicObject accountTableDyo : accountTableDys = BusinessDataServiceHelper.load((String)"bd_accounttable", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", accountTableIdSet)})) {
                accountTableIdToDyoMap.put(accountTableDyo.getLong("id"), accountTableDyo);
            }
        }
        return accountTableIdToDyoMap;
    }

    public static Set<Long> getUsedAccountTableId(Set<Long> accountTableIdSet) {
        HashSet<Long> usedAccountTableIdSet = new HashSet<Long>(8);
        if (CollectionUtils.isNotEmpty(accountTableIdSet)) {
            DynamicObjectCollection accountBookDys = QueryServiceHelper.query((String)"gl_accountbook", (String)"id, accounttable", (QFilter[])new QFilter[]{new QFilter("accounttable", "in", accountTableIdSet)});
            for (DynamicObject accountBookDyo : accountBookDys) {
                usedAccountTableIdSet.add(accountBookDyo.getLong("accounttable"));
            }
        }
        return usedAccountTableIdSet;
    }

    public static LicenseCheckResult getHasLicense() {
        return LicenseServiceHelper.checkPerformGroup((String)COMMON_ASSIST_GROUP);
    }

    public static List<CommonAssist> createCommonAssist(DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<CommonAssist> comAssistList = new ArrayList<CommonAssist>(8);
        int i = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            comAssistList.add(AccountTableUtil.createCommonAssist(PREFIX_COMASSIST + i, dynamicObject));
            ++i;
        }
        return comAssistList;
    }

    public static CommonAssist createCommonAssist(String key, DynamicObject dynamicObject) {
        int seq = dynamicObject.getInt("seq");
        String number = dynamicObject.getString("comassistnumber");
        String name = dynamicObject.getString("comassistname");
        String valueSourceType = dynamicObject.getString("valuesourcetype");
        long asistTypeId = dynamicObject.getLong("assistantvaluesource.id");
        String valueSource = "1".equals(valueSourceType) ? dynamicObject.getString("valuesource.id") : "bos_assistantdata_detail-" + dynamicObject.getString("assistantvaluesource.id");
        boolean isBalance = dynamicObject.getBoolean("isbalance");
        boolean isRequire = dynamicObject.getBoolean("isrequire");
        return new CommonAssist(key, seq, number, name, valueSourceType, valueSource, asistTypeId, isBalance, isRequire);
    }
}

