/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;

public class AccountVersionOpVars {
    private static final String KEY_AUTO_VERSION_CHILD = "autoAssignChildAfterVersionalized";
    private static final String KEY_OPERATION_IS_ORIGIN = "isOriginOperation";
    private static final String KEY_BATCH_ADDING_ASSIST = "isBatchAddingAssist";
    private static final String KEY_IS_ONLY_VALIDATOR_WORK = "isOnlyValidatorWork";
    public static final String KEY_IS_VERSION_ADD_LEAF = "isversionaddleaf";

    public static boolean isViewSave(OperateOption operateOption) {
        return operateOption.getVariables().containsKey("viewsave");
    }

    public static boolean isVersioning(OperateOption operateOption) {
        return operateOption.getVariables().containsKey("isversion");
    }

    public static void setVersioning(OperateOption operateOption, boolean isVersioning) {
        operateOption.setVariableValue("isversion", isVersioning ? "1" : "0");
    }

    public static boolean isAddingAssist(OperateOption operateOption) {
        return operateOption.getVariables().getOrDefault("isAddAllAssgrps", "1").equals("1");
    }

    public static void setAddingAssist(OperateOption operateOption, boolean isAddingAssist) {
        operateOption.setVariableValue("isAddAllAssgrps", isAddingAssist ? "1" : "0");
    }

    public static boolean isAutoAssignChildAfterVersioned(OperateOption operateOption) {
        return operateOption.getVariables().getOrDefault(KEY_AUTO_VERSION_CHILD, "1").equals("1");
    }

    public static void setAutoAssignChildAfterVersioned(OperateOption operateOption, boolean enable) {
        operateOption.setVariableValue(KEY_AUTO_VERSION_CHILD, enable ? "1" : "0");
    }

    public static boolean isOriginOperation(OperateOption operateOption) {
        return operateOption.getVariables().getOrDefault(KEY_OPERATION_IS_ORIGIN, "1").equals("1");
    }

    public static void setNonOriginOperation(OperateOption operateOption) {
        Preconditions.checkState((!operateOption.getVariables().containsKey(KEY_OPERATION_IS_ORIGIN) || ((String)operateOption.getVariables().get(KEY_OPERATION_IS_ORIGIN)).equals("0") ? 1 : 0) != 0, (Object)("current operation had been tagged, please double check if it needed. " + SerializationUtils.toJsonString((Object)operateOption.getVariables())));
        operateOption.getVariables().put(KEY_OPERATION_IS_ORIGIN, "0");
    }

    public static long getUseOrgId(OperateOption operateOption) {
        return Long.parseLong(operateOption.getVariables().getOrDefault("useOrgID", "0"));
    }

    public static void setUseOrgId(OperateOption operateOption, long useOrgId) {
        operateOption.setVariableValue("useOrgID", String.valueOf(useOrgId));
    }

    public static void setIsBatchAddingAssist(OperateOption operateOption, boolean isBatchAddingAssist) {
        operateOption.setVariableValue(KEY_BATCH_ADDING_ASSIST, isBatchAddingAssist ? "1" : "0");
    }

    public static boolean isBatchAddingAssist(OperateOption operateOption) {
        return operateOption.getVariables().getOrDefault(KEY_BATCH_ADDING_ASSIST, "0").equals("1");
    }

    public static void setIsOnlyValidatorWork(OperateOption operateOption, boolean isOnlyValidatorWork) {
        operateOption.setVariableValue(KEY_IS_ONLY_VALIDATOR_WORK, isOnlyValidatorWork ? "1" : "0");
    }

    public static boolean isOnlyValidatorWork(OperateOption operateOption) {
        return operateOption.getVariables().getOrDefault(KEY_IS_ONLY_VALIDATOR_WORK, "0").equals("1");
    }

    public static boolean isVersionAddLeaf(OperateOption operateOption) {
        return operateOption.getVariables().getOrDefault(KEY_IS_VERSION_ADD_LEAF, "0").equals("1");
    }

    public static void setVersionAddLeaf(OperateOption operateOption, boolean isVersionAddLeaf) {
        operateOption.setVariableValue(KEY_IS_VERSION_ADD_LEAF, isVersionAddLeaf ? "1" : "0");
    }

    public static Map<String, String> getOperateResultInOption(OperateOption option) {
        String operateResultInOption = option.getVariableValue("OperateResultInOption", "");
        if (StringUtils.isBlank((CharSequence)operateResultInOption)) {
            return new HashMap<String, String>(8);
        }
        return (Map)SerializationUtils.fromJsonString((String)operateResultInOption, Map.class);
    }

    public static void setOperateResultToOption(OperateOption option, Map<String, String> errorMap) {
        if (CollectionUtils.isEmpty(errorMap)) {
            return;
        }
        option.setVariableValue("OperateResultInOption", SerializationUtils.toJsonString(errorMap));
    }

    public static void setIsFromRepairOrAssignView(OperateOption operateOption, boolean isFromRepairForCurrAccOp) {
        operateOption.setVariableValue("isFromRepairOrAssignView", isFromRepairForCurrAccOp ? "1" : "0");
    }

    public static boolean isFromRepairOrAssignView(OperateOption option) {
        return option.getVariables().getOrDefault("isFromRepairOrAssignView", "0").equals("1");
    }

    public static void addMessageToOption(OperateOption option, ExtendedDataEntity dataEntity, String content) {
        DynamicObject accDyn = dataEntity.getDataEntity();
        long accountId = accDyn.getLong("id");
        long useOrgId = accDyn.getLong("useorg_id");
        Map<String, String> operateResultInOption = AccountVersionOpVars.getOperateResultInOption(option);
        String errorKey = StringUtils.join((long[])new long[]{useOrgId, accountId}, (char)'_');
        String oldVal = operateResultInOption.computeIfAbsent(errorKey, k -> "");
        if (StringUtils.isNotBlank((CharSequence)oldVal)) {
            oldVal = oldVal + "\n";
        }
        oldVal = oldVal + content;
        operateResultInOption.put(errorKey, oldVal);
        AccountVersionOpVars.setOperateResultToOption(option, operateResultInOption);
    }
}

