/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.OrgVO;

public class AccountVersionPersonalizeUtil {
    private static Log LOG = LogFactory.getLog(AccountVersionPersonalizeUtil.class);

    private AccountVersionPersonalizeUtil() {
    }

    public static Optional<String> autoPersonalizedAccountOnOuterOrg(Set<Long> accIds) {
        BiTreeNode<Long, OrgVO> fullOrgTree = BDUtil.buildSubTreeByOrgId(10, Optional.empty());
        Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap = BiTreeNode.toMap(fullOrgTree);
        ArrayList<DynamicObject> personalizedAccs = new ArrayList<DynamicObject>(8);
        for (Long accId : accIds) {
            List<DynamicObject> partAccs = AccountVersionPersonalizeUtil.checkAndBuildPersonalizedAccounts(accId, nodeIdMap);
            personalizedAccs.addAll(partAccs);
        }
        if (!personalizedAccs.isEmpty()) {
            return AccountVersionPersonalizeUtil.callPersonizedOperation(personalizedAccs, nodeIdMap);
        }
        return Optional.empty();
    }

    public static Optional<String> autoPersonalizedAccountOnOuterOrg(long accId) {
        BiTreeNode<Long, OrgVO> fullOrgTree = BDUtil.buildSubTreeByOrgId(10, Optional.empty());
        Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap = BiTreeNode.toMap(fullOrgTree);
        return AccountVersionPersonalizeUtil.autoPersonalizedAccountOnOuterOrg(accId, nodeIdMap);
    }

    private static Optional<String> autoPersonalizedAccountOnOuterOrg(long accId, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        List<DynamicObject> personalizedAccs = AccountVersionPersonalizeUtil.checkAndBuildPersonalizedAccounts(accId, nodeIdMap);
        if (!personalizedAccs.isEmpty()) {
            return AccountVersionPersonalizeUtil.callPersonizedOperation(personalizedAccs, nodeIdMap);
        }
        return Optional.empty();
    }

    public static List<DynamicObject> checkAndBuildPersonalizedAccounts(long accId, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)String.join((CharSequence)",", "number", "enddate", "createorg_id"), (QFilter[])new QFilter("id", "=", (Object)accId).toArray());
        if (account == null) {
            LOG.info("account not exists id:" + accId);
            return Collections.emptyList();
        }
        if (AccountVersionUtil.getEndDate().compareTo(account.getDate("enddate")) != 0) {
            LOG.info("account is not latest version: " + account.getDate("enddate") + ", give up auto personalized.");
            return Collections.EMPTY_LIST;
        }
        long createOrgId = account.getLong("createorg_id");
        String accNumber = account.getString("number");
        List<Long> workOuterOrgs = AccountVersionPersonalizeUtil.computeNeedPersonalizedOrgs(accId, accNumber, createOrgId, nodeIdMap);
        if (DebugTrace.enable()) {
            LOG.info(String.format("personalize_outer real account: %s(%s) - Orgs: %s", accId, accNumber, String.join((CharSequence)",", workOuterOrgs.stream().map(x -> String.valueOf(x)).collect(Collectors.toList()))));
        }
        if (!CollectionUtils.isEmpty(workOuterOrgs)) {
            return workOuterOrgs.stream().map(orgId -> AccountVersionPersonalizeUtil.buildPersonalizedAccount(accId, orgId)).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private static Optional<String> callPersonizedOperation(List<DynamicObject> personalizedAccs, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        long tick = System.currentTimeMillis();
        OperateOption personalizeOp = OperateOption.create();
        personalizeOp.setVariableValue("isPersonalizeData", "1");
        AccountVersionOpVars.setAutoAssignChildAfterVersioned(personalizeOp, true);
        for (DynamicObject acc : personalizedAccs) {
            long opTick = System.currentTimeMillis();
            OperationResult personalizeResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{acc}, (OperateOption)personalizeOp);
            String orgName = "";
            if (null != nodeIdMap.get(acc.getLong("useorg_id"))) {
                orgName = nodeIdMap.get(acc.getLong("useorg_id")).getData().getName();
            }
            String accNum = acc.getString("number");
            LOG.info(String.format("personalize_outer account done on account: %s on org: %s, cost %s", accNum, orgName, System.currentTimeMillis() - opTick));
            OperationLogEntry entry = new OperationLogEntry(acc.getLong("useorg_id"), acc.getLong("id"), AccountOperationType.PERSONAL, Boolean.TRUE);
            AccountOperationLogUtil.addLogEntryRow(entry);
            if (personalizeResult.isSuccess()) continue;
            String failedMsg = BDUtil.buildOperationResultFailedMsg(personalizeResult, false);
            LOG.info(String.format("batch_personalized_account failed on account: %s on org: %s for %s", accNum, orgName, failedMsg));
            String errMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5bf9\u7ba1\u63a7\u8303\u56f4\u5916\u7ec4\u7ec7%1$s\u7684\u79d1\u76ee%2$s\u4e2a\u6027\u5316\u5904\u7406\u65f6\u5931\u8d25: \"%3$s\"\uff0c\u8bf7\u624b\u52a8\u4e2a\u6027\u5316\u7ec4\u7ec7\uff1a%4$s\uff0c\u79d1\u76ee\uff1a%5$s\u540e\u518d\u91cd\u65b0\u6267\u884c\u672c\u6b21\u7684\u7248\u672c\u5316\u3002", (String)"AccountVersionPersonalizeUtil_1", (String)"fi-bd-common", (Object[])new Object[0]), orgName, accNum, failedMsg, orgName, accNum);
            entry.setSuccess(Boolean.FALSE);
            entry.setLog(errMsg);
            return Optional.of(errMsg);
        }
        LOG.info(String.format("auto_personalized account size: %s cost: %s", personalizedAccs.size(), System.currentTimeMillis() - tick));
        return Optional.empty();
    }

    private static List<Long> computeNeedPersonalizedOrgs(long accId, String accNumber, long createOrgId, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        Set<Long> assignRawOrgIds = AccountVersionUtil.queryAssignedRawOrgIds(accId);
        if (CollectionUtils.isEmpty(assignRawOrgIds)) {
            return Collections.EMPTY_LIST;
        }
        assignRawOrgIds.remove(createOrgId);
        HashSet<Long> childOrgIds = new HashSet<Long>(nodeIdMap.get(createOrgId).collect(BiTreeNode::getId));
        assignRawOrgIds.removeAll(childOrgIds);
        Set<Long> outerOrgs = assignRawOrgIds;
        if (DebugTrace.enable()) {
            LOG.info(String.format("personalize_outer init account: %s(%s) - Orgs: %s", accId, accNumber, String.join((CharSequence)",", outerOrgs.stream().map(x -> String.valueOf(x)).collect(Collectors.toList()))));
        }
        if (!outerOrgs.isEmpty()) {
            List<Long> workOuterOrgs = outerOrgs.stream().filter(outerOrgId -> {
                BiTreeNode outerOrgNode = (BiTreeNode)nodeIdMap.get(outerOrgId);
                if (null == outerOrgNode) {
                    return true;
                }
                List<Long> supervisorOrgIds = outerOrgNode.collectOnAncestors(BiTreeNode::getId);
                supervisorOrgIds.retainAll(outerOrgs);
                return supervisorOrgIds.isEmpty();
            }).collect(Collectors.toList());
            return workOuterOrgs;
        }
        return Collections.EMPTY_LIST;
    }

    private static DynamicObject buildPersonalizedAccount(long accountId, long useOrgId) {
        DynamicObject useOrg;
        DynamicObject accountFromDb = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountview");
        if (DebugTrace.enable()) {
            LOG.info(String.format("check_account_version start: startDate: %s, endDate: %s, full data: %s", DateUtils.formatString((Date)accountFromDb.getDate("startdate"), (String)"yyyy-MM-dd HH:mm:ss"), DateUtils.formatString((Date)accountFromDb.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"), accountFromDb.toString()));
        }
        if (null == (useOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)useOrgId, (String)"bos_org", (String)"id,number,name"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"AccountVersionPersonalizeUtil_2", (String)"fi-bd-common", (Object[])new Object[0]), useOrgId));
        }
        accountFromDb.set("useorg", (Object)useOrg);
        accountFromDb.set("useorg_id", (Object)useOrg.getLong("id"));
        return accountFromDb;
    }
}

