/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountBookUtil;
import kd.fi.bd.util.BatchProcessUtil;

public class AccountingSysUtil {
    private static Comparator<Object> CHINA_COMPARATOR = Collator.getInstance(Locale.CHINA);

    public static TreeNode getTreeNode(Long orgViewSchemaId) {
        Map<String, Map<String, String>> orgTreeMap = AccountingSysUtil.getAllOrgByViewId(orgViewSchemaId);
        Map<String, List<Map<String, String>>> flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap(orgTreeMap);
        TreeNode rootTreeNode = AccountingSysUtil.createTreeNode(orgTreeMap);
        if (rootTreeNode == null) {
            return null;
        }
        AccountingSysUtil.createChildNodes(flatOrgTreeMap, rootTreeNode.getId(), rootTreeNode);
        return rootTreeNode;
    }

    public static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap) {
        Map<String, Map> rootIdMap = orgTreeMap.entrySet().stream().filter(v -> "0".equals(((Map)v.getValue()).get("parentid"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        Set<String> rootIdSet = rootIdMap.keySet();
        if (rootIdSet.isEmpty()) {
            return null;
        }
        String rootId = rootIdSet.toArray(new String[0])[0];
        String rootName = orgTreeMap.get(rootId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(rootId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId) {
        return AccountingSysUtil.getAllOrgByViewId(orgViewSchemaId, null, false);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewIdIncludeDisable(Long orgViewSchemaId) {
        return AccountingSysUtil.getAllOrgByViewId(orgViewSchemaId, null, true);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter, boolean isIncludeDisable) {
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        if (!isIncludeDisable) {
            orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        }
        HashMap<String, Map<String, String>> orgTreeMap = new HashMap<String, Map<String, String>>();
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"kd.bd.AccountingSysViewPlugin.getAllOrgByViewId()", (String)"bos_org_structure", (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, List<Map<String, String>>> getOrgTreeMap(Map<String, Map<String, String>> orgMap) {
        HashMap<String, List<Map<String, String>>> orgTreeMap = new HashMap<String, List<Map<String, String>>>(orgMap.size());
        for (Map.Entry<String, Map<String, String>> entry : orgMap.entrySet()) {
            Map<String, String> org = entry.getValue();
            AccountingSysUtil.buildOrgTree(org, orgMap, orgTreeMap);
        }
        return orgTreeMap;
    }

    public static void buildOrgTree(Map<String, String> org, Map<String, Map<String, String>> orgMap, Map<String, List<Map<String, String>>> orgTreeMap) {
        List<Map<String, String>> parentList;
        String orgid = org.get("id");
        if (orgid == null || orgid.equalsIgnoreCase("0")) {
            return;
        }
        String parentid = org.get("parentid");
        Map<String, String> parentOrg = orgMap.get(parentid);
        if (orgTreeMap.get(orgid) == null) {
            orgTreeMap.put(orgid, new ArrayList());
        }
        if (parentOrg == null) {
            return;
        }
        if (orgTreeMap.get(parentid) == null) {
            AccountingSysUtil.buildOrgTree(parentOrg, orgMap, orgTreeMap);
        }
        if ((parentList = orgTreeMap.get(parentid)) == null) {
            return;
        }
        if (!parentList.contains(org)) {
            parentList.add(org);
        }
    }

    public static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root) {
        if (orgTreeMap == null || rootId == null || orgTreeMap.size() == 0 || root == null) {
            return null;
        }
        AccountingSysUtil.buildTreeNode(orgTreeMap, rootId, root);
        return root;
    }

    public static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        HashMap dataMap = (HashMap)treeNode.getData();
        if (childList == null || childList.size() == 0) {
            dataMap.put("isleaf", "1");
            return;
        }
        String parentLongNumber = treeNode.getLongNumber();
        int parentLevel = Integer.parseInt((String)dataMap.get("level"));
        String parentName = (String)dataMap.get("fullname");
        for (Map<String, String> org : childList) {
            TreeNode childrenTree = new TreeNode();
            String orgid = org.get("id");
            if (Long.valueOf(0L).equals(Long.valueOf(orgid)) || StringUtils.isEmpty((String)org.get("name"))) continue;
            childrenTree.setParentid(org.get("parentid"));
            childrenTree.setId(orgid);
            childrenTree.setText(org.get("name"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(org.get("longnumber"));
            HashMap<String, String> childDataMap = new HashMap<String, String>(3);
            childDataMap.put("isleaf", "0");
            childDataMap.put("level", String.valueOf(childrenTree.getLongNumber().split("!").length));
            childDataMap.put("fullname", parentName + "_" + org.get("name"));
            childrenTree.setData(childDataMap);
            treeNode.addChild(childrenTree);
            AccountingSysUtil.buildTreeNode(orgTreeMap, orgid, childrenTree);
        }
        AccountingSysUtil.sortTreeNode(treeNode.getChildren());
    }

    public static void sortTreeNode(List<TreeNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            nodes.sort(new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode o1, TreeNode o2) {
                    int levelCompareResult = ((String)((Map)o1.getData()).get("level")).compareTo((String)((Map)o2.getData()).get("level"));
                    if (levelCompareResult != 0) {
                        return levelCompareResult;
                    }
                    return o1.getLongNumber().compareTo(o2.getLongNumber());
                }
            });
        }
    }

    public static TreeNode getTreeNodeById(String nodeId, TreeNode unitTreeNode) {
        int j = unitTreeNode.getNodeLevel(nodeId, 0);
        return unitTreeNode.getTreeNode(nodeId, j);
    }

    public static List<TreeNode> buildTreeNodeByList(TreeNode parentTreeNode, List<Map<String, Object>> leftNodes) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(leftNodes.size());
        HashMap parentData = (HashMap)parentTreeNode.getData();
        for (Map<String, Object> treeNode : leftNodes) {
            if (parentTreeNode.getId().equals(treeNode.get("id"))) continue;
            TreeNode childrenTree = new TreeNode();
            childrenTree.setParentid(parentTreeNode.getId());
            childrenTree.setId((String)treeNode.get("id"));
            childrenTree.setText((String)treeNode.get("text"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentTreeNode.getLongNumber() + "!" + treeNode.get("id"));
            HashMap<String, String> childDataMap = new HashMap<String, String>(3);
            childDataMap.put("isleaf", "1");
            int level = Integer.parseInt((String)parentData.get("level")) + 1;
            childDataMap.put("level", String.valueOf(level));
            childDataMap.put("fullname", parentTreeNode.getText() + "_" + treeNode.get("text"));
            childrenTree.setData(childDataMap);
            treeNodes.add(childrenTree);
        }
        return treeNodes;
    }

    public static DynamicObjectCollection getDefaultViewSchemaOrgs() {
        Long schemaInfoId = AccountingSysUtil.getDefaultViewSchemaInfoId();
        QFilter qf = new QFilter("isleaf", "=", (Object)"1");
        QFilter qf2 = new QFilter("view", "=", (Object)schemaInfoId);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{qf2, qf});
        return coll;
    }

    public static Long getDefaultViewSchemaInfoId() {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id", (QFilter[])AccountingSysUtil.getDefaultViewSchemaQFilter(), (String)"id");
        return coll == null ? 0L : ((DynamicObject)coll.get(0)).getLong("id");
    }

    public static QFilter[] getDefaultViewSchemaQFilter() {
        QFilter f = new QFilter("isdefault", "=", (Object)"1");
        QFilter qf = new QFilter("treetype", "=", (Object)"10");
        return new QFilter[]{f, qf};
    }

    public static Optional<String> getNonlegalOrgName(Long orgViewSchemaId, Set<Long> orgIdSet) {
        Preconditions.checkState((!CollectionUtils.isEmpty(orgIdSet) ? 1 : 0) != 0, (Object)"orgIds cannot be empty");
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        QFilter patterntypeFilter = new QFilter("org.orgpattern.patterntype", "=", (Object)"3");
        ArrayList orgNameList = new ArrayList(8);
        try (DataSet dataSet = BatchProcessUtil.batchQueryDataSet(10000, orgIdSet, batchOrgs -> QueryServiceHelper.queryDataSet((String)(AccountingSysUtil.class.getName() + "#getNonlegalOrgName"), (String)"bos_org_structure", (String)"org.name", (QFilter[])new QFilter[]{new QFilter("org", "in", batchOrgs), orgViewIdFilter, patterntypeFilter}, null));){
            dataSet.forEachRemaining(x -> orgNameList.add(x.getString("org.name")));
        }
        return CollectionUtils.isEmpty(orgNameList) ? Optional.empty() : Optional.of(orgNameList.stream().collect(Collectors.joining(",")));
    }

    public static Set<Long> getEffectiveBookTypeIds(long accTableId) {
        return (Set)ThreadCache.get((Object)("booktype_ids_acctable_" + accTableId), () -> {
            QFilter h = new QFilter("accounttable", "=", (Object)accTableId);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{h}, null);
            return cols.stream().map(x -> x.getLong("bookstype")).collect(Collectors.toSet());
        });
    }

    public static boolean isHaveBizByAccountBook(long accountingSysId) {
        List accountBookIdList = QueryServiceHelper.queryPrimaryKeys((String)"gl_accountbook", (QFilter[])new QFilter[]{new QFilter("accountingsys", "=", (Object)accountingSysId)}, null, (int)-1);
        return AccountBookUtil.isHaveBiz(accountBookIdList.stream().map(value -> (Long)value).collect(Collectors.toSet()));
    }

    public static boolean checkOrgInAccountingSys(long accountingSysId, long orgId) {
        DynamicObject mainSys = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountingsys", "=", (Object)accountingSysId), new QFilter("ismainview", "=", (Object)"1")});
        return Objects.nonNull(mainSys) && QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)mainSys.getLong("id")), new QFilter("org", "=", (Object)orgId)});
    }
}

