/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.enums.PeriodStateEnum;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.ContextUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PermissonType;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.OrgAccOwnershipVO;
import kd.fi.bd.vo.OrgVO;

public class BDUtil {
    private static final Log LOGGER = LogFactory.getLog(BDUtil.class);
    private static String selectFields = "id,org.id org,bookstype.id bookstype,curperiod.id curperiod,curperiod.begindate begindate,curperiod.enddate enddate,startperiod.id startperiod,accounttable.id accounttable,periodtype.id periodtype,defaultvouchertype.id defaultvouchertype,basecurrency.id basecurrency,exratetable.id exratetable,bookstype.accounttype accounttype,isbizunit";
    public static final int PRODUCT_CODE_STANDARD = 1;
    public static final int PRODUCT_CODE_GALAXY = 2;
    public static final String INDUSTRY_GALAXY = "Galaxy";
    public static final String FILED_INDUSTRY = "industry";
    public static final String ENTITY_LIC = "lic_license";

    public static DynamicObject getBookFromAccSys(long accorg) {
        QFilter h = new QFilter("org", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        return BDUtil.getBookFromAccSys(selectFields, new QFilter[]{k, h});
    }

    public static Set<Long> getLaterCrossPeriods(Date startDate) {
        QFilter qf = new QFilter("begindate", "<=", (Object)startDate);
        qf.and(new QFilter("enddate", ">=", (Object)startDate));
        qf = qf.or(new QFilter("begindate", ">", (Object)startDate));
        DynamicObjectCollection periodColl = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qf.toArray());
        HashSet<Long> periodIds = new HashSet<Long>(8);
        for (DynamicObject period : periodColl) {
            periodIds.add(period.getLong("id"));
        }
        return periodIds;
    }

    public static DynamicObject getBookFromAccSys(String selectField, QFilter[] qf) {
        return QueryServiceHelper.queryOne((String)"gl_accountbook", (String)selectField, (QFilter[])qf);
    }

    public static DynamicObjectCollection getBizOrgFromAccSys(Long accorg) {
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        QFilter j = new QFilter("toorg", "=", (Object)accorg);
        DynamicObjectCollection bizOrgInfo = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg,toorg,typerelation,typerelation.fromtype orgtype,id", (QFilter[])new QFilter[]{j, k});
        return bizOrgInfo;
    }

    @Deprecated
    public static QFilter getAcctOrgFilter(String orgType) {
        Long userId = ContextUtil.getUserId();
        List orgIds = PermissionServiceHelper.getUserOrgs((long)userId);
        QFilter orgId = new QFilter("id", "in", (Object)orgIds);
        QFilter isScc = new QFilter(orgType, "=", (Object)"1");
        return orgId.and(isScc);
    }

    public static DynamicObject getBookInfoByAccSys(long accSysId, long accorg, long bookstypeid) {
        Long[] bookId = BDUtil.getEntryIdFromAccSys(accSysId, false);
        QFilter j = new QFilter("id", "in", (Object)bookId);
        QFilter h = new QFilter("org", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype", "=", (Object)bookstypeid);
        DynamicObject accountBooksInfo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{j, k, h});
        return accountBooksInfo;
    }

    public static Long[] getEntryIdFromAccSys(long id, boolean isBizEntry) {
        DynamicObject accSys = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_accsys");
        DynamicObjectCollection collection = null;
        String key = "";
        if (isBizEntry) {
            collection = accSys.getDynamicObjectCollection("orgentry");
            key = "orgentryid";
        } else {
            collection = accSys.getDynamicObjectCollection("entryentity");
            key = "bookid";
        }
        int size = collection.size();
        Long[] idArr = new Long[size];
        for (int i = 0; i < size; ++i) {
            idArr[i] = ((DynamicObject)collection.get(i)).getLong(key);
        }
        return idArr;
    }

    public static boolean isBizUnit(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,isbizunit", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            return false;
        }
        return dyn.getBoolean("isbizunit");
    }

    public static DynamicObject getBookFromAccSys(long accorg, String selectField) {
        QFilter h = new QFilter("org", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        return BDUtil.getBookFromAccSys(selectField, new QFilter[]{k, h});
    }

    public static List<Long> getAllBizUnit(List<Long> orgIds, QFilter qFilter) {
        ArrayList<Long> bizUnitIds = new ArrayList<Long>();
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", orgIds, (boolean)true);
        QFilter qisbizunit = new QFilter("isbizunit", "=", (Object)"1");
        if (qFilter != null) {
            qisbizunit.and(qFilter);
        }
        DynamicObjectCollection accountbooks = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org,org.id", (QFilter[])new QFilter[]{qisbizunit});
        for (DynamicObject book : accountbooks) {
            if (!subOrgIds.contains(book.getLong("org.id"))) continue;
            bizUnitIds.add(book.getLong("org.id"));
        }
        return bizUnitIds;
    }

    public static String isRepetition(DynamicObject dynamic, Map<String, String> map) {
        StringBuilder error = new StringBuilder();
        Boolean checknumber = BaseDataServiceHelper.chectDuplicate((String)dynamic.getDataEntityType().getName(), map, (Long)dynamic.getLong("createorg.id"), (Long)dynamic.getLong("id"));
        error.append(checknumber != false ? ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728", (String)"BDUtil_0", (String)"fi-bd-common", (Object[])new Object[0]) : "");
        return error.toString();
    }

    public static HashMap<Long, DynamicObject> getDynamicDatas(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject object = extendedDataEntity.getDataEntity();
            long id = object.getLong("id");
            map.put(id, object);
        }
        return map;
    }

    public static HashMap<Long, DynamicObject> getDynamicDatas(DynamicObject[] dyos) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        for (DynamicObject dyo : dyos) {
            long id = dyo.getLong("id");
            map.put(id, dyo);
        }
        return map;
    }

    public static List<DynamicObject> getAllSubAccts(DynamicObject curAcct, String selectProperties, long curOrgId, boolean bIncludeCurOrg) {
        ArrayList<Long> paramOrg = new ArrayList<Long>();
        paramOrg.add(curOrgId);
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)bIncludeCurOrg);
        QFilter qnumber = new QFilter("longnumber", "like", (Object)(curAcct.get("longnumber") + "%"));
        QFilter qaccttable = new QFilter("accounttable", "=", curAcct.get("accounttable.id"));
        QFilter qorg = new QFilter("createorg", "in", (Object)orgIds);
        DynamicObject[] accts = new DynamicObject[]{};
        if (selectProperties == null) {
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qorg, qaccttable, qnumber}, null, (int)-1);
            if (ids.size() > 0) {
                accts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            }
        } else {
            accts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)selectProperties, (QFilter[])new QFilter[]{qorg, qaccttable, qnumber});
        }
        return Arrays.asList(accts);
    }

    public static String convertListToStringSqlResult(List l) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            Object item = l.get(i);
            result.append(String.valueOf(item));
            if (i + 1 == l.size()) continue;
            result.append(',');
        }
        if (result.length() == 0) {
            return "''";
        }
        return result.toString();
    }

    public static List<DynamicObject> getAllSubAcctsIncludeAssign(DynamicObject curAcct, String selectProperties, long curOrgId, boolean bIncludeCurOrg) {
        ArrayList<Long> paramOrg = new ArrayList<Long>();
        paramOrg.add(curOrgId);
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)bIncludeCurOrg);
        QFilter qnumber = new QFilter("number", "like", (Object)(curAcct.get("number") + "%"));
        QFilter qaccttable = new QFilter("accounttable", "=", curAcct.get("accounttable.id"));
        QFilter qorg = new QFilter("createorg", "in", (Object)orgIds);
        DynamicObject[] accts = new DynamicObject[]{};
        if (selectProperties == null) {
            QFilter qown = new QFilter("id", "!=", curAcct.get("id"));
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qorg, qaccttable, qnumber, qown}, null, (int)-1);
            List allacctIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qaccttable, qnumber}, null, (int)-1);
            String dataidParam = BDUtil.convertListToStringSqlResult(allacctIds);
            String useorgParem = BDUtil.convertListToStringSqlResult(orgIds);
            String sql = "SELECT a.fdataid id FROM t_bd_accountusereg a LEFT JOIN t_bd_accountexc b ON (a.fdataid = b.fdataid AND a.fcreateorgid=b.fcreateorgid AND a.fuseorgid=b.fuseorgid) WHERE b.fdataid IS NULL AND a.fdataid IN (" + dataidParam + ") AND a.fuseorgid IN (" + useorgParem + ") and a.fdataid <> " + curAcct.getLong("id");
            List assignidList = (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)sql, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                public List<Object> handle(ResultSet rs) throws Exception {
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        while (rs.next()) {
                            list.add(rs.getLong("id"));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return list;
                }
            });
            ids.addAll(assignidList);
            if (ids.size() > 0) {
                accts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            }
        } else {
            accts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)selectProperties, (QFilter[])new QFilter[]{qorg, qnumber});
        }
        return Arrays.asList(accts);
    }

    public static DynamicObject getOrgInfo(Object useorgId) {
        QFilter q1 = new QFilter("org", "=", useorgId);
        QFilter q2 = new QFilter("view", "=", (Object)10L);
        QFilter q3 = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent,isleaf", (QFilter[])new QFilter[]{q1, q2});
        return org;
    }

    public static Boolean isLeafOrg(Object useorgId) {
        DynamicObject orgDyo = BDUtil.getOrgInfo(useorgId);
        return orgDyo.getBoolean("isleaf");
    }

    public static List<Long> getAllSuperiorOrgIds(Object orgId, Long view, boolean isIncludeCurOrg) {
        long parentId = 0L;
        QFilter f2 = new QFilter("view", "=", (Object)view);
        QFilter f3 = new QFilter("org", "=", orgId);
        LinkedList<Long> porgIds = new LinkedList<Long>();
        if (isIncludeCurOrg) {
            porgIds.add(Long.parseLong(String.valueOf(orgId)));
        }
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);){
            for (Row row : dt) {
                parentId = row.getLong("parent");
                if (0L == parentId) continue;
                porgIds.add(parentId);
            }
        }
        while (parentId != 0L) {
            dt = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, new QFilter("org", "=", (Object)parentId)}, null);
            var9_8 = null;
            try {
                for (Row row : dt) {
                    parentId = row.getLong("parent");
                    if (0L == parentId) continue;
                    porgIds.add(parentId);
                }
            }
            catch (Throwable throwable) {
                var9_8 = throwable;
                throw throwable;
            }
            finally {
                if (dt == null) continue;
                if (var9_8 != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                    continue;
                }
                dt.close();
            }
        }
        return porgIds;
    }

    public static List<Long> getAllSuperiorOrgIds(Object orgId, boolean isIncludeCurOrg) {
        return BDUtil.getAllSuperiorOrgIds(orgId, 10L, isIncludeCurOrg);
    }

    public static List<Long> getAllSubordinateOrgs(Object useorgId, boolean isIncludeCurOrg) {
        String key = "getsuborgs-" + useorgId + String.valueOf(isIncludeCurOrg);
        ArrayList<Long> result = ThreadCache.get((Object)key);
        if (result == null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            if (isIncludeCurOrg) {
                ids.add(Long.parseLong(String.valueOf(useorgId)));
            }
            HashSet<Long> pids = new HashSet<Long>(100);
            pids.add(Long.parseLong(String.valueOf(useorgId)));
            while (!pids.isEmpty()) {
                QFilter f2 = new QFilter("view.number", "=", (Object)"10");
                QFilter f3 = new QFilter("parent", "in", new HashSet(pids));
                DataSet dt = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);
                Throwable throwable = null;
                try {
                    pids.clear();
                    for (Row row : dt) {
                        ids.add(row.getLong("org"));
                        pids.add(row.getLong("org"));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dt == null) continue;
                    if (throwable != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dt.close();
                }
            }
            result = ids;
            ThreadCache.put((Object)key, result);
        }
        return result;
    }

    public static List<Object[]> getSameNumAcctInParentOrgs(Object useorgId, Object accounttableId, Object number, boolean isIncludeCurOrg) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        DynamicObject[] paccts = BDUtil.getAcctByNumber(accounttableId, number, null);
        if (paccts == null) {
            return result;
        }
        List<Long> porgIds = BDUtil.getAllSuperiorOrgIds(useorgId, isIncludeCurOrg);
        if (porgIds.size() == 0) {
            return result;
        }
        block0: for (long porgid : porgIds) {
            for (DynamicObject pacct : paccts) {
                DynamicObject createorg = pacct.getDynamicObject("createorg");
                if (createorg == null || porgid != createorg.getLong("id")) continue;
                Object[] m = new Object[]{createorg.getLong("id"), pacct};
                result.add(m);
                continue block0;
            }
        }
        return result;
    }

    public static DynamicObject[] getAcctByNumber(Object accounttableId, Object number, Object orgid) {
        List ids;
        QFilter qaccounttable = new QFilter("accounttable", "=", accounttableId);
        QFilter qnumber = new QFilter("number", "=", number);
        if (orgid != null && Long.parseLong(String.valueOf(orgid)) != 0L) {
            qaccounttable.and(new QFilter("createorg", "=", orgid));
        }
        if ((ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qaccounttable, qnumber}, null, (int)-1)).size() > 0) {
            return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        }
        return null;
    }

    public static DynamicObject getDirectParentAcct(DynamicObject acct) {
        List<Object[]> accts;
        long createorgId;
        if (acct.getDynamicObject("parent") != null) {
            return acct.getDynamicObject("parent");
        }
        long id = acct.getLong("id");
        long masterid = acct.getLong("masterid");
        long useorgId = acct.getLong("useorg_id");
        if (useorgId != (createorgId = acct.getLong("createorg_id"))) {
            return acct;
        }
        long accounttableId = acct.getLong("accounttable_id");
        String number = acct.getString("number");
        if (id != masterid && !(accts = BDUtil.getSameNumAcctInParentOrgs(useorgId, accounttableId, number, false)).isEmpty()) {
            DynamicObject pacct = (DynamicObject)accts.get(0)[1];
            return pacct;
        }
        return null;
    }

    public static List<Long> getKeyFieldIdsInEntry(DynamicObjectCollection entry, String keyFieldName) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject d : entry) {
            DynamicObject item = d.getDynamicObject(keyFieldName);
            if (item == null) continue;
            ids.add(item.getLong("id"));
        }
        return ids;
    }

    public static Map<Long, Object> getKeyFieldMapInEntry(DynamicObjectCollection entry, String keyFieldName, String valueName) {
        HashMap<Long, Object> m = new HashMap<Long, Object>();
        for (DynamicObject d : entry) {
            DynamicObject item = d.getDynamicObject(keyFieldName);
            if (item == null) continue;
            m.put(item.getLong("id"), item.get(valueName));
        }
        return m;
    }

    public static Map<Long, Object> getFieldMapInEntry(DynamicObjectCollection entry, String keyFieldName, String valueName) {
        HashMap<Long, Object> m = new HashMap<Long, Object>();
        for (DynamicObject d : entry) {
            DynamicObject item = d.getDynamicObject(keyFieldName);
            if (item == null) continue;
            m.put(item.getLong("id"), d.get(valueName));
        }
        return m;
    }

    public static int getRunModeCode() {
        Log log = LogFactory.getLog((String)"kd.fi.bd.util.BDUtil");
        try {
            QFilter filterGalaxy = new QFilter(FILED_INDUSTRY, "=", (Object)INDUSTRY_GALAXY);
            return QueryServiceHelper.exists((String)ENTITY_LIC, (QFilter[])new QFilter[]{filterGalaxy}) ? 2 : 1;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8bb8\u53ef\u5b57\u6bb5INDUSTRY \u83b7\u53d6\u5f53\u524d\u7684\u4ea7\u54c1\u7801\u6709\u8bef\uff01: ", (Throwable)e);
            return 1;
        }
    }

    public static void fixAccountAssgrp() {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", null, null, (int)-1);
        DynamicObject[] accts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        ArrayList<Long> asstactitems = new ArrayList<Long>();
        for (DynamicObject acct : accts) {
            int i;
            DynamicObjectCollection entry = acct.getDynamicObjectCollection("checkitementry");
            for (i = 0; i < entry.size(); ++i) {
                DynamicObject asstactitem = ((DynamicObject)entry.get(i)).getDynamicObject("asstactitem");
                long asstactitemId = asstactitem.getLong("id");
                if (asstactitems.contains(asstactitemId)) {
                    indexs.add(i);
                    continue;
                }
                asstactitems.add(asstactitemId);
            }
            for (i = indexs.size(); i > 0; --i) {
                int t = (Integer)indexs.get(i - 1);
                entry.remove(t);
            }
            indexs.clear();
            asstactitems.clear();
        }
        SaveServiceHelper.save((DynamicObject[])accts);
    }

    public static void fixAcctLongNumber() {
        DynamicObject[] accts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,number,longnumber,level,parent.id", null, (String)"level asc");
        HashMap<Long, DynamicObject> acctsMap = new HashMap<Long, DynamicObject>(accts.length);
        for (DynamicObject acct : accts) {
            String plongnumber;
            DynamicObject parent;
            long id = acct.getLong("id");
            acctsMap.put(id, acct);
            int level = Integer.parseInt(String.valueOf(acct.get("level")));
            if (level == 1) continue;
            String number = acct.getString("number");
            String longnumber = acct.getString("longnumber");
            long parentId = acct.getLong("parent.id");
            if (parentId == 0L || (parent = (DynamicObject)acctsMap.get(parentId)) == null || longnumber.equals((plongnumber = parent.getString("longnumber")) + "_" + number)) continue;
            acct.set("longnumber", (Object)(plongnumber + "_" + number));
        }
        SaveServiceHelper.save((DynamicObject[])accts);
    }

    public static void assgrpFilter(List<QFilter> filters) {
        filters.add(new QFilter("flexid", "=", (Object)2));
        Iterator<QFilter> filterIter = filters.iterator();
        Long orgId = 0L;
        while (filterIter.hasNext()) {
            QFilter qFilter = filterIter.next();
            if (!"createorg.id".equals(qFilter.getProperty())) continue;
            orgId = Long.valueOf(qFilter.getValue().toString());
            filterIter.remove();
        }
        List<Long> orgIds = BDUtil.getAllSuperiorOrgIdsOrderByLevel(orgId);
        QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (orgIds != null && !orgIds.isEmpty()) {
            QFilter orgFilter = new QFilter("createorg.id", "in", orgIds).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
            filters.add(allCtrl.or(orgFilter));
        } else {
            filters.add(allCtrl);
        }
    }

    private static List<Long> getAllSuperiorOrgIdsOrderByLevel(long orgid) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgid == 0L) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", (Object)orgid);
        String longNumber = "";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi-bd.BDUtil", (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                longNumber = row.getString("longnumber");
            }
        }
        if (StringUtils.isEmpty((CharSequence)longNumber) || longNumber.indexOf(33) == 0) {
            return ids;
        }
        String[] numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
        QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi-bd.BDUtil", (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("org"));
            }
        }
        if (!ids.contains(orgid)) {
            ids.add(orgid);
        }
        return ids;
    }

    public static List<List<Object>> getAllUseOrg(String entityType) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appid = "gl";
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityType, (String)"47150e89000000ac");
        ArrayList<List<Object>> viewOrgIds = new ArrayList<List<Object>>();
        if (result == null) {
            return viewOrgIds;
        }
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        String orgFuncPro = "org.fisaccounting";
        QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)"1");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        String view = null;
        view = null == ctrlview ? "16" : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)"1");
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3, orgFuncFilter} : new QFilter[]{idsFilter, f2, f3, orgFuncFilter};
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getAllUseOrg", (String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])qfilters, null);){
            while (dt.hasNext()) {
                Row row = dt.next();
                ArrayList<Object> par = new ArrayList<Object>(2);
                par.add(row.getLong("org.id"));
                par.add(row.getString("org.name"));
                viewOrgIds.add(par);
            }
        }
        return viewOrgIds;
    }

    public static String getDefaultUseOrg(List<List<Object>> col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(col.get(0).get(0));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (List<Object> obj : col) {
            if (longinOrg != Long.parseLong(String.valueOf(obj.get(0)))) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    public static Long transferStr2Long(Object strID) {
        return Long.parseLong(strID.toString());
    }

    public static Collection<Long> groupTransferStr2Long(Iterable toTrans, Collection<Long> resCol) {
        Objects.requireNonNull(resCol, "illegal method invoke for toTrans param");
        Objects.requireNonNull(toTrans, "illegal method invoke for result collection param");
        toTrans.forEach(objID -> resCol.add(Long.parseLong(objID.toString())));
        return resCol;
    }

    public static void DBexecute(DBRoute route, String sqlStr, Object[] sqlParameter) {
        DB.execute((DBRoute)route, (String)sqlStr, (Object[])sqlParameter);
    }

    public static List<Map<String, Object>> DBquery(DBRoute route, String sqlStr, Object[] sqlParameter, ResultSetHandler<List<Map<String, Object>>> listResultSetHandler) {
        return (List)DB.query((DBRoute)route, (String)sqlStr, (Object[])sqlParameter, listResultSetHandler);
    }

    public static DataSet DBqueryDataSet(String checkIsAssign, DBRoute route, String sqlStr, Object[] sqlParameter) {
        return DB.queryDataSet((String)checkIsAssign, (DBRoute)route, (String)sqlStr, (Object[])sqlParameter);
    }

    public static Set<Long> getAllChildrenOrgIds(long useOrgId, boolean isIncludeSelf) {
        Long[] childOrgIds = BDUtil.getAllChildrenOrgIds(useOrgId);
        HashSet<Long> orgIds = new HashSet<Long>();
        orgIds.addAll(Arrays.asList(childOrgIds));
        if (isIncludeSelf) {
            orgIds.add(useOrgId);
        }
        return orgIds;
    }

    static Long[] getAllChildrenOrgIds(long useOrgId) {
        HashMap<Long, Set> orgSets = new HashMap<Long, Set>(3);
        Set orgIds = orgSets.computeIfAbsent(useOrgId, key -> {
            HashSet<Long> childOrgIds = new HashSet<Long>();
            Set<Long> orgId = new HashSet<Long>(1);
            orgId.add(useOrgId);
            while (!orgId.isEmpty()) {
                orgId = BDUtil.getChildrenOrgIds(orgId);
                childOrgIds.addAll(orgId);
            }
            return childOrgIds;
        });
        return orgIds.toArray(new Long[0]);
    }

    public static Set<Long> getChildrenOrgIds(Set<Long> orgIds) {
        QFilter f2 = new QFilter("view", "=", (Object)10);
        QFilter f3 = new QFilter("parent", "in", orgIds);
        HashSet<Long> orgIdSet = new HashSet<Long>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, f3}, null);){
            for (Row row : dataSet) {
                orgIdSet.add(row.getLong("org"));
            }
        }
        return orgIdSet;
    }

    public static DataSet getAllSubAccts(DynamicObject account, Set<Long> childOrgIds) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder("SELECT a.fid id,a.fcreateorgid createorg,a.fcontrollevel controllevel,a.fmasterid masterid FROM t_bd_account a INNER JOIN t_bd_account_u u ON a.fid=u.fdataid WHERE ");
        if (!CollectionUtils.isEmpty(childOrgIds)) {
            sql.append("u.fuseorgid IN (");
            for (int j = 0; j < childOrgIds.size(); ++j) {
                sql.append(j > 0 ? ",?" : "?");
            }
            sql.append(") AND");
            params.addAll(childOrgIds);
        }
        sql.append(" a.faccounttableid=? ");
        params.add(account.getLong("accounttable_id"));
        sql.append(" AND (a.fnumber=? OR a.flongnumber like ? AND flevel !=?) ");
        params.add(account.getString("number"));
        params.add(account.getString("longnumber") + "_%");
        params.add(account.getInt("level"));
        sql.append(" AND a.fenddate=? ");
        params.add(account.getDate("enddate"));
        sql.append(" GROUP BY a.fid,a.fcreateorgid,a.fmasterid,a.fcontrollevel ");
        sql.append(" union all ");
        sql.append(" SELECT fid id,fcreateorgid createorg,fcontrollevel controllevel,fmasterid masterid FROM t_bd_account where fctrlstrategy = '5' and fstatus ='C' and (fnumber=? OR flongnumber like ?) and faccounttableid=?");
        params.add(account.getString("number"));
        params.add(account.getString("longnumber") + "_%");
        params.add(account.getLong("accounttable_id"));
        DataSet _uDataSet = DB.queryDataSet((String)"BDUtil.getAllSubAccts", (DBRoute)DBRoute.of((String)"gl"), (String)sql.toString(), (Object[])params.toArray());
        return _uDataSet;
    }

    public static DynamicObject getOrgById(long orgId) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
    }

    public static Set<Long> listAllChildOrgs(long rootOrgId, boolean isIncludeSelf) {
        HashSet<Long> childOrgIds = new HashSet<Long>(8);
        BiTreeNode<Long, OrgVO> treeNode = BDUtil.buildSubTreeByOrgId(10, Optional.of(rootOrgId));
        if (Objects.isNull(treeNode)) {
            LOGGER.info("The current organization isn't A accounting organization. orgId: {}", (Object)rootOrgId);
            return childOrgIds;
        }
        childOrgIds = new HashSet<Long>(treeNode.collect(BiTreeNode::getId));
        if (!isIncludeSelf) {
            childOrgIds.remove(rootOrgId);
        }
        return childOrgIds;
    }

    public static BiTreeNode<Long, OrgVO> buildSubTreeByOrgId(Optional<Long> rootOrgId) {
        return BDUtil.buildSubTreeByOrgId(10, rootOrgId);
    }

    public static BiTreeNode<Long, OrgVO> buildSubTreeByOrgId(int orgViewId, Optional<Long> rootOrgId) {
        String cacheKey = String.format("BDUtil.buildSubTreeByOrgId_viewId:%s_rootOrgId:%s", orgViewId, rootOrgId.isPresent() ? rootOrgId.get() : "");
        return (BiTreeNode)ThreadCache.get((Object)cacheKey, () -> {
            HashMap<Long, BiTreeNode<Long, OrgVO>> orgIndex = new HashMap<Long, BiTreeNode<Long, OrgVO>>(8);
            BiTreeNode<Long, OrgVO> _rootNode = null;
            long tick = System.currentTimeMillis();
            if (DebugTrace.enable()) {
                LOGGER.info("BDUtil.buildSubTreeByOrgId param: orgViewId:{}, rootOrgId:{}", (Object)orgViewId, rootOrgId.isPresent() ? rootOrgId.get() : "");
            }
            try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"BDUtil.buildSubTreeByOrgId", (String)"bos_org_structure", (String)"org,parent,level,org.name name", (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"10"), new QFilter("view", "=", (Object)orgViewId)}, (String)"level asc");){
                for (Row row : orgDataSet) {
                    Long orgId = row.getLong("org");
                    if (Objects.nonNull(orgIndex.get(orgId))) continue;
                    if (Objects.isNull(_rootNode)) {
                        if (rootOrgId.isPresent() && !Objects.equals(orgId, rootOrgId.get())) continue;
                        _rootNode = new BiTreeNode<Long, OrgVO>(orgId, new OrgVO(row.getString("name")));
                        orgIndex.put(orgId, _rootNode);
                        continue;
                    }
                    Long parentId = row.getLong("parent");
                    if (!Objects.nonNull(parentId) || !orgIndex.containsKey(parentId)) continue;
                    BiTreeNode parentNode = (BiTreeNode)orgIndex.get(parentId);
                    Preconditions.checkState((boolean)Objects.nonNull(parentNode));
                    BiTreeNode<Long, OrgVO> orgNode = new BiTreeNode<Long, OrgVO>(orgId, new OrgVO(row.getString("name")));
                    orgIndex.put(orgId, orgNode);
                    orgNode.setParent(parentNode);
                }
            }
            if (DebugTrace.enable()) {
                LOGGER.info("BDUtil.buildSubTreeByOrgId result tree: {}", (Object)_rootNode.showFormatTree("\n", x -> x.getData().toString()));
            }
            LOGGER.info("kd.fi.bd.util.BDUtil.buildSubTreeByOrgId cost " + (System.currentTimeMillis() - tick));
            return _rootNode;
        }, (boolean)true);
    }

    public static BiTreeNode<String, AccountVO> buildSubTreeByAccountNumber(long accountTableId, String accountNumber, String longnumber, List<Long> useOrgIdList) {
        HashMap<String, BiTreeNode<String, AccountVO>> accountNumIndexMap = new HashMap<String, BiTreeNode<String, AccountVO>>(8);
        BiTreeNode<String, AccountVO> rootNode = null;
        long tick = System.currentTimeMillis();
        QFBuilder globalBuilder = new QFBuilder();
        QFBuilder orgBuilder = new QFBuilder();
        QFilter accountTableIdFilter = new QFilter("accounttable", "=", (Object)accountTableId);
        QFilter endDateFilter = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
        globalBuilder.add(accountTableIdFilter).add(endDateFilter).add(longnumberFilter);
        orgBuilder.add(accountTableIdFilter).add(endDateFilter).add(longnumberFilter);
        if (useOrgIdList != null && !useOrgIdList.isEmpty()) {
            globalBuilder.add(new QFilter("ctrlstrategy", "=", (Object)"5"));
            orgBuilder.add(QFilter.sqlExpress((String)"id", (String)"in", (String)(" ( select fdataid from t_bd_account_u where fuseorgid in (" + StringUtils.join((Object[])useOrgIdList.toArray(), (String)",") + " ))")));
        }
        DataSet globalAccountDataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bd_accountview", (String)"id, number, name, parent.number parentnumber,level", (QFilter[])globalBuilder.toArray(), null);
        DataSet orgAccountDataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bd_accountview", (String)"id, number, name, parent.number parentnumber,level", (QFilter[])orgBuilder.toArray(), null);
        DataSet accountDataSet = globalAccountDataSet.union(orgAccountDataSet).select("id, number, name, parentnumber, level").orderBy(new String[]{"level asc"});
        for (Row row : accountDataSet) {
            String number = row.getString("number");
            String name = row.getString("name");
            if (Objects.nonNull(accountNumIndexMap.get(number))) continue;
            if (Objects.isNull(rootNode)) {
                if (!accountNumber.equals(number)) continue;
                rootNode = new BiTreeNode<String, AccountVO>(number, new AccountVO(number, name, accountTableId));
                accountNumIndexMap.put(number, rootNode);
                continue;
            }
            String parentNumber = row.getString("parentnumber");
            if (!Objects.nonNull(parentNumber) || !accountNumIndexMap.containsKey(parentNumber)) continue;
            BiTreeNode parentNode = (BiTreeNode)accountNumIndexMap.get(parentNumber);
            Preconditions.checkState((boolean)Objects.nonNull(parentNode));
            BiTreeNode<String, AccountVO> accountNode = new BiTreeNode<String, AccountVO>(number, new AccountVO(number, name, accountTableId));
            accountNumIndexMap.put(number, accountNode);
            accountNode.setParent(parentNode);
        }
        LOGGER.info("kd.fi.bd.util.BDUtil.buildSubTreeByAccountNumber cost " + (System.currentTimeMillis() - tick));
        return rootNode;
    }

    public static Optional<DynamicObject> getAccountDynObj(long accountId, String ... fields) {
        boolean noFields;
        boolean bl = noFields = fields == null || fields.length < 1;
        if (noFields) {
            return Optional.of(BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview"));
        }
        return Optional.of(BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview", (String)String.join((CharSequence)",", fields)));
    }

    public static Map<Long, OrgAccOwnershipVO> getAllSubLatestAccountInfoInUseOrgRange(long rootAccountId, List<Long> unmodifiedUseOrgIds, Date versionDate) {
        Optional<DynamicObject> accountDynObjOption;
        if (unmodifiedUseOrgIds == null || unmodifiedUseOrgIds.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Long> useOrgIdList = new ArrayList<Long>(unmodifiedUseOrgIds);
        if (Objects.isNull(versionDate)) {
            versionDate = AccountVersionUtil.getStartDate();
        }
        if (!(accountDynObjOption = BDUtil.getAccountDynObj(rootAccountId, "number", "masterid", "accounttable_id", "ctrlstrategy")).isPresent()) {
            return Collections.emptyMap();
        }
        DynamicObject accountDynObj = accountDynObjOption.get();
        String number = accountDynObj.getString("number");
        String globalShareStrategy = "5";
        if (!globalShareStrategy.equals(accountDynObj.getString("ctrlstrategy"))) {
            long masterId = accountDynObj.getLong("masterid");
            Set<Long> accountUseOrgRange = BDUtil.getAccountUseOrgRange(masterId, number);
            useOrgIdList.retainAll(accountUseOrgRange);
        }
        if (useOrgIdList.isEmpty()) {
            return Collections.emptyMap();
        }
        long accountTableId = accountDynObj.getLong("accounttable_id");
        HashMap<Long, OrgAccOwnershipVO> orgAccOwnershipMap = new HashMap<Long, OrgAccOwnershipVO>(useOrgIdList.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT a.fid,a.fnumber,a.fctrlstrategy,u.fuseorgid,a.fenddate FROM t_bd_account AS a LEFT JOIN t_bd_account_u AS u ", new Object[0]);
        sqlBuilder.appendIn("ON u.fdataid = a.fid AND u.fuseorgid ", new ArrayList<Long>(useOrgIdList));
        sqlBuilder.append(" where a.faccounttableid = ?", new Object[]{accountTableId});
        sqlBuilder.append(" AND a.fenddate > ?", new Object[]{versionDate});
        sqlBuilder.append(" AND a.fnumber LIKE ?", new Object[]{number + "%"});
        try (DataSet accountDataSet = DB.queryDataSet((String)(BDUtil.class.getName() + "#getAllSubLatestAccountInfoInUseOrgRange"), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : accountDataSet) {
                String ctrlStrategy = row.getString("fctrlstrategy");
                String accountNumber = row.getString("fnumber");
                Long accountId = row.getLong("fid");
                if (globalShareStrategy.equals(ctrlStrategy)) {
                    Iterator iterator = useOrgIdList.iterator();
                    while (iterator.hasNext()) {
                        long useOrgId = (Long)iterator.next();
                        OrgAccOwnershipVO ownershipVO = orgAccOwnershipMap.computeIfAbsent(useOrgId, k -> new OrgAccOwnershipVO(useOrgId));
                        OrgAccOwnershipVO.AccInfo accInfo = ownershipVO.getOrNewAccInfo(accountNumber);
                        accInfo.setLatestVersionId(accountId);
                    }
                    continue;
                }
                Long useOrgId = row.getLong("fuseorgid");
                if (useOrgId == null || useOrgId == 0L) continue;
                OrgAccOwnershipVO ownershipVO = orgAccOwnershipMap.computeIfAbsent(useOrgId, k -> new OrgAccOwnershipVO(useOrgId));
                OrgAccOwnershipVO.AccInfo accInfo = ownershipVO.getOrNewAccInfo(accountNumber);
                if (AccountVersionUtil.getEndDate().equals(row.getDate("fenddate"))) {
                    accInfo.setLatestVersionId(accountId);
                    continue;
                }
                accInfo.getVersionIds().add(accountId);
            }
        }
        return orgAccOwnershipMap;
    }

    public static Set<Long> getAccountUseOrgRange(long accountMasterId, String accountNumber) {
        String sql = String.format("SELECT u.fuseorgid FROM t_bd_account_u AS u inner join t_bd_account AS a ON a.fid = u.fdataid WHERE a.fmasterid = %s AND a.fnumber = '%s'", accountMasterId, accountNumber);
        try (DataSet useOrgDataSet = DB.queryDataSet((String)(BDUtil.class.getName() + "#getAllSubLatestAccountInfoInUseOrgRange"), (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            HashSet<Long> useOrgSet = new HashSet<Long>(16);
            for (Row row : useOrgDataSet) {
                useOrgSet.add(row.getLong("fuseorgid"));
            }
            HashSet<Long> hashSet = useOrgSet;
            return hashSet;
        }
    }

    public static Map<Long, Map<String, Boolean>> isAccountIncludeAssist(Map<Long, OrgAccOwnershipVO> orgAccNumberShip, List<AssistEntryVO> assistList) {
        DynamicObject[] accountDynObjs;
        if (CollectionUtils.isEmpty(orgAccNumberShip)) {
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(assistList)) {
            return Collections.emptyMap();
        }
        Set accountIdSet = orgAccNumberShip.values().stream().flatMap(x -> x.getAllAccIds().stream()).collect(Collectors.toSet());
        if (accountIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, AssistEntryVO> assistIdInfoMap = assistList.stream().collect(Collectors.toMap(AssistEntryVO::getId, x -> x, (oldVal, newVal) -> newVal));
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", accountIdSet);
        qfBuilder.add("enable", "=", Boolean.TRUE);
        HashMap<Long, Boolean> accIdIncludeAssistMap = new HashMap<Long, Boolean>(accountIdSet.size());
        for (DynamicObject accountDynObj : accountDynObjs = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id, checkitementry.asstactitem, checkitementry.isrequire, checkitementry.isdetail, checkitementry.enaccheck", (QFilter[])qfBuilder.toArray())) {
            long id = accountDynObj.getLong("id");
            DynamicObjectCollection assistEntryDynObjCollection = accountDynObj.getDynamicObjectCollection("checkitementry");
            accIdIncludeAssistMap.put(id, BDUtil.isAssistEntryIncludeAssistList(assistEntryDynObjCollection, assistIdInfoMap));
        }
        HashMap<Long, Map<String, Boolean>> resultMap = new HashMap<Long, Map<String, Boolean>>(8);
        for (Map.Entry<Long, OrgAccOwnershipVO> orgAccShipEntry : orgAccNumberShip.entrySet()) {
            long useOrgId = orgAccShipEntry.getKey();
            OrgAccOwnershipVO shipVO = orgAccShipEntry.getValue();
            Map numResults = resultMap.computeIfAbsent(useOrgId, k -> new HashMap(2));
            for (String accNum : shipVO.getAllAccNums()) {
                numResults.put(accNum, shipVO.getOrNewAccInfo(accNum).getVersionIds().stream().allMatch(x -> Boolean.TRUE.equals(accIdIncludeAssistMap.get(x))));
            }
        }
        return resultMap;
    }

    public static boolean isAssistEntryIncludeAssistList(DynamicObjectCollection assistEntryDynObjCollection, Map<Long, AssistEntryVO> assistIdInfoMap) {
        if (assistEntryDynObjCollection.size() >= assistIdInfoMap.size()) {
            Map<Long, DynamicObject> assistIdEntryDynObjMap = assistEntryDynObjCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstactitem.id"), x -> x, (oldVal, newVal) -> newVal));
            int includeCount = 0;
            for (Map.Entry<Long, AssistEntryVO> assistInfoEntry : assistIdInfoMap.entrySet()) {
                DynamicObject assistEntryDynObj = assistIdEntryDynObjMap.remove(assistInfoEntry.getKey());
                if (assistEntryDynObj != null) {
                    boolean isMustInput = assistEntryDynObj.getBoolean("isrequire");
                    if (!isMustInput && assistInfoEntry.getValue().isMustInput()) {
                        return false;
                    }
                    boolean isLeaf = assistEntryDynObj.getBoolean("isdetail");
                    if (!isLeaf && assistInfoEntry.getValue().isLeaf()) {
                        return false;
                    }
                    boolean isAc = assistEntryDynObj.getBoolean("enaccheck");
                    if (!isAc && assistInfoEntry.getValue().isAc()) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (++includeCount != assistIdInfoMap.size()) continue;
                return true;
            }
        }
        return false;
    }

    public static String buildOperationResultFailedMsg(OperationResult operationResult, boolean isOnlyValidateMsg) {
        String validateFailedMsg;
        String errorMsg = "";
        if (!isOnlyValidateMsg && !CollectionUtils.isEmpty((Collection)operationResult.getAllErrorInfo())) {
            errorMsg = operationResult.getAllErrorInfo().stream().map(x -> x.getMessage()).collect(Collectors.joining("\n"));
        }
        if (StringUtils.isNotBlank((CharSequence)(validateFailedMsg = operationResult.getValidateResult().getValidateErrors().stream().filter(x -> !CollectionUtils.isEmpty((Collection)x.getAllErrorInfo())).flatMap(x -> x.getAllErrorInfo().stream().map(OperateInfo::getMessage)).collect(Collectors.joining(","))))) {
            errorMsg = errorMsg + validateFailedMsg;
        }
        return errorMsg;
    }

    public static String buildExceptionMsg(Exception e, int stackLimit, boolean isSimple) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> Objects.nonNull(ele.getClassName()) && ele.getClassName().startsWith("kd.fi")).map(ele -> isSimple ? String.format("%s:%s", ele.getFileName(), ele.getLineNumber()) : ele.toString()).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s,%s", e.getMessage(), String.join((CharSequence)",", stackMsgs));
    }

    public static List<List<DynamicObject>> getGroupByDiffIdAccDynList(List<DynamicObject> accDynList) {
        Map<Long, List<DynamicObject>> accDynListGroupByIdMap = accDynList.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
        List accDynListGroupByIdList = accDynListGroupByIdMap.values().stream().sorted(Comparator.comparing(List::size)).collect(Collectors.toList());
        int maxSize = ((List)accDynListGroupByIdList.get(accDynListGroupByIdList.size() - 1)).size();
        ArrayList<List<DynamicObject>> result = new ArrayList<List<DynamicObject>>(maxSize);
        for (int i = 0; i < maxSize; ++i) {
            ArrayList batchAccDynList = new ArrayList(accDynListGroupByIdList.size());
            for (List sameIdAccDynList : accDynListGroupByIdList) {
                if (sameIdAccDynList.size() <= i) continue;
                batchAccDynList.add(sameIdAccDynList.get(i));
            }
            result.add(batchAccDynList);
        }
        return result;
    }

    public static String printDataSet(DataSet ds) {
        StringBuilder sb = new StringBuilder();
        sb.append("START====================").append("\n");
        DataSet copy = ds.copy();
        sb.append(copy.getRowMeta().toString()).append("\n");
        while (copy.hasNext()) {
            Row next = copy.next();
            sb.append(next).append("\n");
        }
        sb.append("END====================").append("\n");
        return sb.toString();
    }

    public static boolean checkArgumentNonNull(Object ... arguments) {
        if (arguments == null) {
            return true;
        }
        for (Object argument : arguments) {
            if (argument != null) continue;
            return false;
        }
        return true;
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    public static List<AccountBookInfo> getBookFromAccSys(Set<Long> orgSet, long bookType) {
        ArrayList<AccountBookInfo> result = new ArrayList<AccountBookInfo>();
        String selectFields = "id,org,bookstype,bookstype.number,basecurrency,periodtype,startperiod,curperiod,exratetable,accounttable,cashinitperiod,isendinit,enable,isbizunit,accountingsys,yearprofitacct";
        QFilter orgF = new QFilter("org", "in", orgSet);
        QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AccsysUtil.getAccountbooks", (String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{orgF, bookTypeF}, null);){
            for (Row row : ds) {
                AccountBookInfo book = new AccountBookInfo();
                book.setId(row.getLong("id"));
                book.setOrg(row.getLong("org"));
                book.setBookstype(row.getLong("bookstype"));
                book.setBookstypeNum(row.getString("bookstype.number"));
                book.setAccounttable(row.getLong("accounttable"));
                book.setBasecurrency(row.getLong("basecurrency"));
                book.setPeriodtype(row.getLong("periodtype"));
                book.setStartperiod(row.getLong("startperiod"));
                book.setCurPeriodId(row.getLong("curperiod"));
                book.setExratetable(row.getLong("exratetable"));
                book.setCashinitperiod(row.getLong("cashinitperiod"));
                book.setAccountingsys(row.getLong("accountingsys"));
                book.setIsbizunit(row.getBoolean("isbizunit"));
                book.setIsendinit(row.getBoolean("isendinit"));
                book.setEnable(row.getString("enable"));
                book.setYearprofitacct(row.getLong("yearprofitacct"));
                result.add(book);
            }
        }
        return result;
    }

    public static List<Long> getAcctOrgPkList(String entityId, PermissonType permType) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityId, (String)permType.getPermId());
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        QFilter[] bookQF = new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(BDUtil.class.getName() + ".getMainViewOrgBTMap#getBook"), (String)"gl_accountbook", (String)"org", (QFilter[])bookQF, null);){
            for (Row row : bookDataSet) {
                orgSet.add(row.getLong("org"));
            }
        }
        List permOrgs = new ArrayList();
        if (!permOrgRs.hasAllOrgPerm()) {
            permOrgs = permOrgRs.getHasPermOrgs();
            orgSet.retainAll(permOrgs);
        }
        return new ArrayList<Long>(orgSet);
    }

    public static String printManual(long accountId) {
        return BDUtil.printManual(accountId, Optional.empty());
    }

    public static String printManual(DynamicObject account) {
        return BDUtil.printManual(account.getLong("id"), Optional.ofNullable(account.getLong("useorg_id")));
    }

    public static String printManual(long accountId, Optional<Long> useOrgId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"number,startdate,enddate,createorg", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
        long creatorOrgId = account.getLong("createorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        orgIds.add(creatorOrgId);
        if (useOrgId.isPresent()) {
            orgIds.add(useOrgId.get());
        }
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", orgIds).toArray());
        HashMap idNameMap = new HashMap(2);
        orgs.forEach(x -> idNameMap.put(x.getLong("id"), x.getString("name")));
        return new AccountManualInfo(accountId, account.getString("number"), DateUtils.formatString((Date)account.getDate("startdate"), (String)"yyyy-MM-dd"), DateUtils.formatString((Date)account.getDate("enddate"), (String)"yyyy-MM-dd"), useOrgId.isPresent() ? String.valueOf(useOrgId.get()) : "-", useOrgId.isPresent() ? (String)idNameMap.get(useOrgId.get()) : "-", String.valueOf(account.getLong("createorg")), (String)idNameMap.get(account.getLong("createorg"))).toString();
    }

    public static Set<Long> getAccountUseOrgs(long accountId) {
        String sql = "SELECT distinct u.fuseorgid FROM t_bd_account_u AS u  INNER JOIN t_bd_account AS a ON a.fid = u.fdataid  WHERE a.fid = ? ";
        HashSet<Long> orgs = new HashSet<Long>(8);
        try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])new Object[]{accountId});){
            while (dt.hasNext()) {
                Row row = dt.next();
                orgs.add(row.getLong("fuseorgid"));
            }
        }
        return orgs;
    }

    public static boolean dateInRange(Date date, Date startDate, Date endDate) {
        return date.compareTo(startDate) >= 0 && date.compareTo(endDate) < 0;
    }

    public static long getCurrOrgFirstMasterId(final long rootAccountId, long rootOrgId, long accountTableId, String rootAccountNumber) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select TOP 1 fmasterid from t_bd_account a inner join t_bd_account_u b on a.fid = b.fdataid where ", new Object[0]);
        sqlBuilder.append(" a.fnumber = ? ", new Object[]{rootAccountNumber});
        sqlBuilder.append(" and a.faccounttableid = ? ", new Object[]{accountTableId});
        sqlBuilder.append(" and b.fuseorgid = ? ", new Object[]{rootOrgId});
        sqlBuilder.append("order by a.fstartdate asc; ", new Object[0]);
        long masterId = (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getLong("fmasterid");
                }
                return rootAccountId;
            }
        });
        return masterId;
    }

    public static <T, U> Set<T> extractToSet(Collection<U> collection, Function<U, T> mapper) {
        return collection.stream().map(mapper).collect(Collectors.toSet());
    }

    public static <T, U> List<T> extractToList(Collection<U> collection, Function<U, T> mapper) {
        return collection.stream().map(mapper).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> popFromMap(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        HashMap<K, V> result = new HashMap<K, V>(2);
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> nextEntry = iterator.next();
            if (!predicate.test(nextEntry)) continue;
            result.put(nextEntry.getKey(), nextEntry.getValue());
            iterator.remove();
        }
        return result;
    }

    public static void loadMissId(List<ComboItem> comboItems, String defVal) {
        DynamicObject org;
        Set ids = comboItems.stream().map(x -> x.getValue()).collect(Collectors.toSet());
        if (!ids.contains(defVal) && (org = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(defVal), (String)"bos_org", (String)"id,name")) != null) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(org.getString("id"));
            comboItem.setCaption(new LocaleString(org.getLocaleString("name").getLocaleValue()));
            comboItems.add(comboItem);
        }
    }

    public static List<Long> getCustomFilterIds(IFormView view, String fieldName) {
        IListView listView = (IListView)view;
        ControlFilters c = listView.getControlFilters();
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        List result = c.getFilter(fieldName);
        ArrayList<Long> ids = new ArrayList<Long>(result.size());
        for (Object v : result) {
            if ("".equals(v.toString())) continue;
            ids.add(Long.valueOf(v.toString()));
        }
        return ids;
    }

    public static Set<Long> getAllAccountingOrgs() {
        return (Set)ThreadCache.get((Object)"fi.bd.BDUtil.getAllAccountingOrgs_10", () -> {
            QFilter orgFilter = new QFilter("fisaccounting", "=", (Object)"1");
            List accountingOrgs = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])orgFilter.toArray(), null, (int)-1);
            return accountingOrgs.stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toSet());
        });
    }

    public static Set<Long> getValidAccountingOrgs() {
        return (Set)ThreadCache.get((Object)"fi.bd.BDUtil.getValidAccountingOrgs_10", () -> {
            HashSet<Long> enableOrgs = new HashSet<Long>(8);
            QFilter filter = new QFilter("view", "=", (Object)10);
            filter.and(new QFilter("isfreeze", "=", (Object)"0"));
            filter.and(new QFilter("org.enable", "=", (Object)"1"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BDUtil#getValidAccountingOrgs", (String)"bos_org_structure", (String)"org", (QFilter[])filter.toArray(), null);){
                while (dataSet.hasNext()) {
                    enableOrgs.add(dataSet.next().getLong("org"));
                }
            }
            return enableOrgs;
        });
    }

    public static <T, C extends Collection<T>> List<T> popFromCollection(C col, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>(2);
        Iterator<T> iterator = col.iterator();
        while (iterator.hasNext()) {
            T nextBuf = iterator.next();
            if (!predicate.test(nextBuf)) continue;
            result.add(nextBuf);
            iterator.remove();
        }
        return result;
    }

    public static PeriodStateEnum getCurVersionState(Map<String, List<DynamicObject>> periodMap, Set<Long> periodTypeIds, Date curDate, Date startDate) {
        if (AccountVersionUtil.compareDate(curDate, startDate) == 0) {
            return PeriodStateEnum.ALL_SAME;
        }
        if (periodMap == null || periodTypeIds == null) {
            throw new KDBizException("period or periodtype is null");
        }
        boolean logEnable = DebugTrace.enable();
        if (logEnable) {
            LOGGER.info("periodTypeId:{}", periodTypeIds);
        }
        int sum = 0;
        int noNum = 0;
        for (Long periodTypeId : periodTypeIds) {
            String periodTypeDatePeriodMapkey = StringUtils.join((Object[])new Object[]{periodTypeId, curDate.getTime()}, (char)'-');
            List<DynamicObject> periodLists = periodMap.get(periodTypeDatePeriodMapkey);
            if (periodLists == null) {
                QFilter qdate = new QFilter("begindate", "<=", (Object)curDate).and(new QFilter("enddate", ">", (Object)curDate));
                DynamicObjectCollection periodDyos = QueryServiceHelper.query((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), qdate}, (String)"id desc");
                periodLists = new ArrayList<DynamicObject>((Collection<DynamicObject>)periodDyos);
                periodMap.put(periodTypeDatePeriodMapkey, periodLists);
            }
            sum += periodLists.size();
            for (DynamicObject period : periodLists) {
                if (!startDate.before(period.getDate("begindate")) && !startDate.after(period.getDate("enddate"))) continue;
                if (logEnable) {
                    LOGGER.info("in_two_period,curdate:{},startdate:{},periodTypeId:{}", new Object[]{curDate, startDate, periodTypeId});
                }
                ++noNum;
            }
        }
        if (logEnable) {
            LOGGER.info("sum:{},noNum:{}", (Object)sum, (Object)noNum);
        }
        if (sum == noNum) {
            return PeriodStateEnum.ALL_NO;
        }
        if (noNum == 0) {
            return PeriodStateEnum.ALL_SAME;
        }
        return PeriodStateEnum.BOTH;
    }

    public static Set<Long> getPeriodType() {
        DynamicObjectCollection bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"periodtype", null, null);
        return bookColl.stream().map(x -> x.getLong("periodtype")).collect(Collectors.toSet());
    }

    public static class AccountManualInfo {
        private long id;
        private String number;
        private String startDate;
        private String endDate;
        private String useOrgId;
        private String useOrgName;
        private String createOrgId;
        private String createOrgName;

        public AccountManualInfo(long id, String number, String startDate, String endDate, String useOrgId, String useOrgName, String createOrgId, String createOrgName) {
            this.id = id;
            this.number = number;
            this.startDate = startDate;
            this.endDate = endDate;
            this.useOrgId = useOrgId;
            this.useOrgName = useOrgName;
            this.createOrgId = createOrgId;
            this.createOrgName = createOrgName;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public String getUseOrgId() {
            return this.useOrgId;
        }

        public void setUseOrgId(String useOrgId) {
            this.useOrgId = useOrgId;
        }

        public String getUseOrgName() {
            return this.useOrgName;
        }

        public void setUseOrgName(String useOrgName) {
            this.useOrgName = useOrgName;
        }

        public String getCreateOrgId() {
            return this.createOrgId;
        }

        public void setCreateOrgId(String createOrgId) {
            this.createOrgId = createOrgId;
        }

        public String getCreateOrgName() {
            return this.createOrgName;
        }

        public void setCreateOrgName(String createOrgName) {
            this.createOrgName = createOrgName;
        }

        public String toString() {
            return "AccountManualInfo{id=" + this.id + ", number='" + this.number + '\'' + ", startDate='" + this.startDate + '\'' + ", endDate='" + this.endDate + '\'' + ", useOrgId='" + this.useOrgId + '\'' + ", useOrgName='" + this.useOrgName + '\'' + ", createOrgId='" + this.createOrgId + '\'' + ", createOrgName='" + this.createOrgName + '\'' + '}';
        }
    }
}

