/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BillParamUtil;

public class BalancePeriodQueryOptimizer {
    private static final Long MAX_PERIOD = 99999999999L;
    private static final int ORGCOUNT_THRSHOLD_1 = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.gl.BalancePeriodQueryOptimizer.orgcount1", 500);
    private static final int ORGCOUNT_THRSHOLD_2 = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.gl.BalancePeriodQueryOptimizer.orgcount2", 100);

    public static List<Long> getBizHappenPeriods(String balanceTable, Long[] orgIds, List<Long> periodIds) {
        if (CollectionUtils.isEmpty(periodIds)) {
            throw new KDBizException("the parameter 'periodIds' is empty.");
        }
        HashSet<Long> resultPeriods = new HashSet<Long>();
        resultPeriods.add(MAX_PERIOD);
        if (orgIds == null || orgIds.length == 0) {
            resultPeriods.addAll(periodIds);
            return new ArrayList<Long>(resultPeriods);
        }
        periodIds.removeIf(x -> MAX_PERIOD.compareTo((Long)x) == 0);
        Collections.sort(periodIds);
        int latestCount = 10;
        ArrayList<Long> latestPeriods = new ArrayList<Long>(latestCount);
        ArrayList<Long> otherPeriods = new ArrayList<Long>(8);
        for (int i = 0; i < periodIds.size(); ++i) {
            if (i < latestCount) {
                latestPeriods.add(periodIds.get(i));
                continue;
            }
            otherPeriods.add(periodIds.get(i));
        }
        if (!latestPeriods.isEmpty()) {
            if (orgIds.length <= ORGCOUNT_THRSHOLD_1) {
                resultPeriods.addAll(BalancePeriodQueryOptimizer.existFilterByOrgs(balanceTable, latestPeriods, Arrays.asList(orgIds)));
            } else {
                resultPeriods.addAll(BalancePeriodQueryOptimizer.existFilterByOrgs(balanceTable, latestPeriods, Collections.EMPTY_LIST));
            }
        }
        if (!otherPeriods.isEmpty()) {
            if (orgIds.length <= ORGCOUNT_THRSHOLD_2) {
                resultPeriods.addAll(BalancePeriodQueryOptimizer.filterByOrgs(balanceTable, otherPeriods, Arrays.asList(orgIds)));
            } else {
                resultPeriods.addAll(BalancePeriodQueryOptimizer.fuzzyQueryPeriods(balanceTable, otherPeriods));
            }
        }
        return new ArrayList<Long>(resultPeriods);
    }

    protected static List<Long> fuzzyQueryPeriods(String balanceTable, List<Long> periods) {
        if (CollectionUtils.isEmpty(periods)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> resultPeriods = new ArrayList<Long>(8);
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select distinct(fperiodid) from " + balanceTable + " where fperiodid ", (Object[])periods.toArray(new Long[0]));
        try (DataSet ds = DB.queryDataSet((String)"BalancePeriodQueryOptimizer.fuzzyQueryPeriods", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                resultPeriods.add(row.getLong("fperiodid"));
            }
        }
        return resultPeriods;
    }

    protected static List<Long> filterByOrgs(String balanceTable, List<Long> periods, List<Long> orgs) {
        if (CollectionUtils.isEmpty(periods)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> resultPeriods = new ArrayList<Long>(8);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct(fperiodid) from " + balanceTable + " where ", new Object[0]);
        sql.appendIn(" forgid ", orgs.toArray());
        sql.appendIn("and fperiodid ", periods.toArray());
        try (DataSet ds = DB.queryDataSet((String)"BalancePeriodQueryOptimizer.filterByOrgs", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                resultPeriods.add(row.getLong("fperiodid"));
            }
        }
        return resultPeriods;
    }

    protected static List<Long> existFilterByOrgs(String balanceTable, List<Long> periods, List<Long> orgs) {
        if (CollectionUtils.isEmpty(periods)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> resultPeriods = new ArrayList<Long>(8);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select p.fid from t_bd_period p where ", new Object[0]);
        sql.appendIn(" p.fid ", periods.toArray());
        sql.append("and exists ( ", new Object[0]);
        sql.append("  select 1 from " + balanceTable + " where ", new Object[0]).append(" fperiodid = p.fid ", new Object[0]);
        if (!orgs.isEmpty()) {
            sql.append(" and ", new Object[0]).appendIn(" forgid ", orgs.toArray());
        }
        sql.append(" ) ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"BalancePeriodQueryOptimizer.existFilterByOrgs", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                resultPeriods.add(row.getLong("fid"));
            }
        }
        return resultPeriods;
    }
}

