/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;

public class BatchProcessHelper {
    private static final Log logger = LogFactory.getLog(BatchProcessHelper.class);
    private static final int THREAD_POOL_SIZE = 3;
    private static final int BATCH_THRESHOLD = 20;
    private static final int THREAD_PER_TIMEOUTSEC = 10;
    private static final String THREAD_POOL_NAME = "fi/bd/common/threadpool";

    public static <R, DT> List<R> batchHandle(TaskType taskType, List<DT> data, Function<List<DT>, List<R>> processFunction) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        List<Object> itemResults = new ArrayList(data.size());
        if (data.size() > 20) {
            int batchSize = Math.max(1, data.size() / 3);
            ArrayList<Future> futures = new ArrayList<Future>(3);
            int consumListIndex = 0;
            int maxBatchSize = 0;
            for (int k = 0; k < 3; ++k) {
                consumListIndex = k < 2 && (k + 1) * batchSize < data.size() ? (k + 1) * batchSize : data.size();
                List batchData = data.subList(k * batchSize, consumListIndex);
                if (batchData.size() > maxBatchSize) {
                    maxBatchSize = batchData.size();
                }
                futures.add(ThreadService.submit(() -> {
                    try {
                        return (List)processFunction.apply(batchData);
                    }
                    catch (Exception e) {
                        logger.error(THREAD_POOL_NAME + e.getMessage(), (Throwable)e);
                        throw new KDBizException("fi/bd/common/threadpool failed");
                    }
                }, (TaskType)taskType, (RequestContext)RequestContext.get()));
                if (consumListIndex >= data.size()) break;
            }
            if (DebugTrace.enable()) {
                logger.info("maxBatchSize:" + maxBatchSize);
            }
            for (Future future : futures) {
                try {
                    List batchItemResults = (List)future.get();
                    itemResults.addAll(batchItemResults);
                }
                catch (Exception e) {
                    logger.error(THREAD_POOL_NAME + e.getMessage(), (Throwable)e);
                    throw new KDBizException("fi/bd/common/threadpoolget future result failed");
                }
            }
        } else {
            itemResults = processFunction.apply(data);
        }
        return itemResults;
    }
}

