/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BillParamUtil;

public class BatchProcessUtil {
    public static <T, R> List<R> batchProcess(Collection<T> batchCollection, Function<Collection<T>, R> function) {
        return BatchProcessUtil.batchProcess(0, batchCollection, function);
    }

    public static <T> DataSet batchQueryDataSet(Collection<T> batchCollection, Function<Collection<T>, DataSet> function) {
        List<Object> dataSetList = BatchProcessUtil.batchProcess(batchCollection, function);
        dataSetList = dataSetList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        DataSet result = null;
        if (dataSetList.isEmpty()) {
            return function.apply(Collections.emptyList());
        }
        for (DataSet dataSet : dataSetList) {
            result = Objects.isNull(result) ? dataSet : result.union(dataSet);
        }
        return result;
    }

    public static <T> DataSet batchQueryDataSet(int batchSize, Collection<T> batchCollection, Function<Collection<T>, DataSet> function) {
        List<Object> dataSetList = BatchProcessUtil.batchProcess(batchSize, batchCollection, function);
        dataSetList = dataSetList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        DataSet result = null;
        if (dataSetList.isEmpty()) {
            return function.apply(Collections.emptyList());
        }
        for (DataSet dataSet : dataSetList) {
            result = Objects.isNull(result) ? dataSet : result.union(dataSet);
        }
        return result;
    }

    public static <T> DynamicObjectCollection batchQueryDynColl(Collection<T> batchCollection, Function<Collection<T>, DynamicObjectCollection> function) {
        List<Object> dynCollList = BatchProcessUtil.batchProcess(batchCollection, function);
        dynCollList = dynCollList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (!dynCollList.isEmpty()) {
            for (DynamicObjectCollection dynamicObjectCollection : dynCollList) {
                result.addAll((Collection)dynamicObjectCollection);
            }
        }
        return result;
    }

    public static <T, R> List<R> batchProcess(int batchSize, Collection<T> batchCollection, Function<Collection<T>, R> function) {
        R result;
        Objects.requireNonNull(batchCollection);
        Objects.requireNonNull(function);
        if (batchSize <= 0) {
            batchSize = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.bd.util.batchprocessutil.size", 1000);
        }
        ArrayList<T> batchList = new ArrayList<T>(8);
        ArrayList<R> resultList = new ArrayList<R>(1);
        for (T data : batchCollection) {
            batchList.add(data);
            if (batchList.size() != batchSize) continue;
            R result2 = function.apply(batchList);
            if (Objects.nonNull(result2)) {
                resultList.add(result2);
            }
            batchList.clear();
        }
        if (!batchList.isEmpty() && Objects.nonNull(result = function.apply(batchList))) {
            resultList.add(result);
        }
        return resultList;
    }

    public static <T> boolean exist(int batchSize, Collection<T> batchCollection, Predicate<Collection<T>> function) {
        Objects.requireNonNull(function);
        if (CollectionUtils.isEmpty(batchCollection)) {
            return true;
        }
        if (batchSize <= 0) {
            batchSize = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.bd.util.batchprocessutil.size", 1000);
        }
        ArrayList<T> batchList = new ArrayList<T>(8);
        for (T data : batchCollection) {
            if (batchList.size() == batchSize) {
                if (function.test(batchList)) {
                    return true;
                }
                batchList.clear();
            }
            batchList.add(data);
        }
        if (!batchList.isEmpty()) {
            return function.test(batchList);
        }
        return false;
    }
}

