/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheHelper;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.ext.fi.fa.business.util.FiBillParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;

public class BillParamUtil {
    private static final Log LOG = LogFactory.getLog(BillParamUtil.class);
    private static Map<String, String> appNumToIdMap = new HashMap<String, String>(8);
    private static final List<QFilter> defaultFilters = Arrays.asList(new QFilter("org", "=", (Object)0), new QFilter("entity", "=", (Object)Character.valueOf(' ')));
    private static final String INVALID_PARAM_KEY = "invalid_param_key";

    public static String getFIBizAppIdByNumber(String appNumber) {
        if (!appNumToIdMap.containsKey(appNumber)) {
            DynamicObject bizAppInfo = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appNumber), new QFilter("bizcloud", "=", (Object)"83bfebc8000002ac")});
            if (Objects.nonNull(bizAppInfo)) {
                String appId = bizAppInfo.getString("id");
                appNumToIdMap.put(appNumber, appId);
                return appId;
            }
            return "";
        }
        return appNumToIdMap.get(appNumber);
    }

    public static BigDecimal getBigDecimalValue(String appId, String paramKey, BigDecimal defaultVal) {
        return BillParamUtil.getBigDecimalValue(appId, paramKey, null, defaultVal);
    }

    public static BigDecimal getBigDecimalValue(String appId, String paramKey, List<QFilter> customFilter, BigDecimal defaultVal) {
        String value = BillParamUtil.getStringValue(appId, paramKey, BillParamUtil.getCustomFilter(customFilter), null);
        return Objects.nonNull(value) ? new BigDecimal(value) : defaultVal;
    }

    public static boolean getBooleanValue(String appId, String paramKey, boolean defaultVal) {
        return BillParamUtil.getBooleanValue(appId, paramKey, null, defaultVal);
    }

    public static boolean getBooleanValue(String appId, String paramKey, List<QFilter> customFilter, boolean defaultVal) {
        String value = BillParamUtil.getStringValue(appId, paramKey, BillParamUtil.getCustomFilter(customFilter), null);
        return Objects.nonNull(value) ? Boolean.parseBoolean(value) : defaultVal;
    }

    public static int getIntegerValue(String appId, String paramKey, int defaultVal) {
        return BillParamUtil.getIntegerValue(appId, paramKey, null, defaultVal);
    }

    public static int getIntegerValue(String appId, String paramKey, List<QFilter> customFilter, int defaultVal) {
        String value = BillParamUtil.getStringValue(appId, paramKey, BillParamUtil.getCustomFilter(customFilter), null);
        return Objects.nonNull(value) ? Integer.parseInt(value) : defaultVal;
    }

    public static List<String> getListValue(String appId, String paramKey, List<String> defaultVal) {
        return BillParamUtil.getListValue(appId, paramKey, null, defaultVal);
    }

    public static List<String> getListValue(String appId, String paramKey, List<QFilter> customFilter, List<String> defaultVal) {
        String value = BillParamUtil.getStringValue(appId, paramKey, BillParamUtil.getCustomFilter(customFilter), null);
        return Objects.nonNull(value) ? Arrays.stream(value.split(",")).collect(Collectors.toList()) : defaultVal;
    }

    public static long getLongValue(String appId, String paramKey, long defaultVal) {
        return BillParamUtil.getLongValue(appId, paramKey, null, defaultVal);
    }

    public static long getLongValue(String appId, String paramKey, List<QFilter> customFilter, long defaultVal) {
        String value = BillParamUtil.getStringValue(appId, paramKey, BillParamUtil.getCustomFilter(customFilter), null);
        return Objects.nonNull(value) ? Long.parseLong(value) : defaultVal;
    }

    public static String getStringValue(String appId, String paramKey, String defaultVal) {
        return BillParamUtil.getStringValue(appId, paramKey, null, defaultVal);
    }

    public static String getStringValue(String appId, String paramKey, List<QFilter> customFilter, String defaultVal) {
        Object value = BillParamUtil.getValueFromCache(appId, paramKey, customFilter);
        return Objects.nonNull(value) ? (String)value : defaultVal;
    }

    public static List<QFilter> getCustomFilter(List<QFilter> customFilter) {
        if (Objects.isNull(customFilter)) {
            customFilter = defaultFilters;
        }
        return customFilter;
    }

    private static Object getValueFromCache(String appId, String paramKey, List<QFilter> customFilter) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.BD_BILL_PARAM, (Object[])new Object[]{RequestContext.getOrCreate().getTenantId(), paramKey});
        Object value = LocalCacheHelper.get((LocalCacheKey)cacheKey, String.class);
        if (Objects.isNull(value)) {
            value = FiBillParamUtil.getStringValue((String)"83bfebc8000002ac", (String)appId, (String)paramKey, BillParamUtil.getCustomFilter(customFilter), (boolean)false);
            if (Objects.isNull(value)) {
                LocalCacheHelper.put((LocalCacheKey)cacheKey, (Object)INVALID_PARAM_KEY);
            } else {
                LocalCacheHelper.put((LocalCacheKey)cacheKey, (Object)value);
            }
        } else if (INVALID_PARAM_KEY.equals(value.toString())) {
            value = null;
        }
        if (DebugTrace.enable()) {
            LOG.info("get bill param: key = " + paramKey + ", value = " + value);
        }
        return value;
    }

    public static void removeKeyFromCache(String key) {
        LocalCacheHelper.remove((LocalCacheKey)LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.BD_BILL_PARAM, (Object[])new Object[]{RequestContext.get().getTenantId(), key}));
    }
}

