/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountBizCheckUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.AccountingSysUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceMonitor;
import org.apache.commons.lang3.StringUtils;

public class BizHappenUtils {
    private static DBRoute ROUNTE_FI = DBRoute.of((String)"fi");
    private static final Log LOG = LogFactory.getLog(BizHappenUtils.class);
    private static List<BizHappenChecker> BIZ_CHECKERS = new ArrayList<BizHappenChecker>(4);

    private BizHappenUtils() {
    }

    public static AccountBizCheckUtil.BizType checkBizType(long accountId, Set<Long> orgIds, Date startDate) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"masterid,startdate,accounttable_id", (QFilter[])new QFilter("id", "=", (Object)BDUtil.transferStr2Long(accountId)).toArray());
        if (null == account) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u79d1\u76ee(%s)\u4e0d\u5b58\u5728\u3002", (String)"BizHappenUtils_1", (String)"fi-bd-common", (Object[])new Object[0]), accountId));
        }
        return (AccountBizCheckUtil.BizType)((Object)ThreadCache.get((Object)BizHappenUtils.buildCacheKey(accountId, orgIds, startDate), () -> BizHappenUtils.checkBizType(accountId, account, orgIds, startDate), (boolean)true));
    }

    private static String buildCacheKey(long accountId, Set<Long> orgIds, Date date) {
        String orgs = "";
        if (CollectionUtils.isNotEmpty(orgIds)) {
            orgs = String.valueOf(StringUtils.join(orgIds, (String)",").hashCode());
        }
        return String.format("fi.bd.BizHappenUtils_cache_%s_%s_%s", accountId, orgs, null == date ? "null" : date.toString());
    }

    private static String buildDomainExistCacheKey(long masterId, long useOrgId, Date date) {
        return String.format("fi.bd.BizHappenUtils_domainexistcache_%s_%s_%s", masterId, useOrgId, null == date ? "null" : date.toString());
    }

    private static AccountBizCheckUtil.BizType checkBizType(long accountId, Set<Long> orgIds) {
        return BizHappenUtils.checkBizType(accountId, orgIds, null);
    }

    public static boolean exist(long accountId, Set<Long> orgIds) {
        if (DebugTrace.enable()) {
            String callSource = PerformanceMonitor.parseFullCallSource(new Throwable());
            LOG.info("BizHappenUtils.exist param - accountId: {}, orgIds: {}, callsource: {}", new Object[]{accountId, orgIds, callSource});
        }
        return AccountBizCheckUtil.BizType.NONE != BizHappenUtils.checkBizType(accountId, orgIds, null);
    }

    public static boolean existOnLaterPeriods(long accountId, Set<Long> orgIds, Date startDate) {
        if (DebugTrace.enable()) {
            String callSource = PerformanceMonitor.parseFullCallSource(new Throwable());
            LOG.info("BizHappenUtils.existOnLaterPeriods param - accountId: {}, orgIds: {}, startDate: {}, callsource: {}", new Object[]{accountId, orgIds, startDate, callSource});
        }
        return AccountBizCheckUtil.BizType.NONE != BizHappenUtils.checkBizType(accountId, orgIds, startDate);
    }

    public static boolean batchExist(Set<Long> accIds, Set<Long> orgIds) {
        if (DebugTrace.enable()) {
            String callSource = PerformanceMonitor.parseFullCallSource(new Throwable());
            LOG.info("BizHappenUtils.batchExist param - accIds: {}, orgIds: {}, callsource: {}", new Object[]{accIds, orgIds, callSource});
        }
        HashSet<Long> checkOrgIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("isbizunit", "=", (Object)"1");
        if (CollectionUtils.isNotEmpty(orgIds)) {
            qFilter.and("org", "in", orgIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)BizHappenUtils.class.getName(), (String)"gl_accountbook", (String)"org_id", (QFilter[])qFilter.toArray(), null);
        dataSet.forEach(row -> checkOrgIds.add(row.getLong(0)));
        long tick = System.currentTimeMillis();
        int batchSize = 0;
        for (Long accId : accIds) {
            ++batchSize;
            if (!BizHappenUtils.exist(accId, checkOrgIds)) continue;
            if (DebugTrace.enable()) {
                LOG.info("BizHappenUtils_checkBizType batchExist accId: {}, orgs:{}", (Object)accId, null == checkOrgIds ? "null" : checkOrgIds);
            }
            return true;
        }
        LOG.info("BizHappenUtils_checkBizType batchExist cost: {} on batch size: {}", (Object)(System.currentTimeMillis() - tick), (Object)batchSize);
        return false;
    }

    public static boolean existsOnOrgDomain(long masterId, long specificOrg, Date startDate) {
        if (DebugTrace.enable()) {
            String callSource = PerformanceMonitor.parseFullCallSource(new Throwable());
            LOG.info("BizHappenUtils.existsOnOrgDomain param - masterId: {}, specificOrg: {}, startDate: {}, callsource: {}", new Object[]{masterId, specificOrg, startDate, callSource});
        }
        boolean hasBiz = (Boolean)ThreadCache.get((Object)BizHappenUtils.buildDomainExistCacheKey(masterId, specificOrg, startDate), () -> {
            DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"ctrlstrategy", (QFilter[])new QFilter("id", "=", (Object)masterId).toArray());
            boolean _isExistBiz = false;
            if (AccountVersionUtil.CTRL_SHARE_STRATEGY.contains(account.getString("ctrlstrategy"))) {
                Set accIdSet = QueryServiceHelper.query((String)"bd_accountview", (String)"id", (QFilter[])new QFilter("masterid", "=", (Object)masterId).toArray()).stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                Iterator iterator = accIdSet.iterator();
                while (iterator.hasNext()) {
                    long _accId = (Long)iterator.next();
                    if (!BizHappenUtils.existOnLaterPeriods(_accId, Collections.EMPTY_SET, startDate)) continue;
                    _isExistBiz = true;
                    break;
                }
            } else {
                Map<Long, Set<Long>> domainAccRelations = AccountVersionUtil.listAccOrgDomainAccRelation(masterId, specificOrg);
                long checkTick = System.currentTimeMillis();
                for (Map.Entry<Long, Set<Long>> accIdUseOrgsEntry : domainAccRelations.entrySet()) {
                    long _accId = accIdUseOrgsEntry.getKey();
                    if (!BizHappenUtils.existOnLaterPeriods(_accId, accIdUseOrgsEntry.getValue(), startDate)) continue;
                    _isExistBiz = true;
                    break;
                }
                if (DebugTrace.enable()) {
                    LOG.info("BizHappenUtils.existsOnOrgDomain cost: {}, result: {}", (Object)(System.currentTimeMillis() - checkTick), (Object)_isExistBiz);
                }
            }
            return _isExistBiz;
        }, (boolean)true);
        LOG.info("BizHappenUtils.existsOnOrgDomain\uff1a {}\uff0c maybe from cache.", (Object)hasBiz);
        return hasBiz;
    }

    public static boolean batchExistsOnOrgDomain(Collection<Long> accIds, long specificOrg) {
        if (DebugTrace.enable()) {
            String callSource = PerformanceMonitor.parseFullCallSource(new Throwable());
            LOG.info("BizHappenUtils.batchExistsOnOrgDomain param - masterIds: {}, specificOrg: {} callsource: {}", new Object[]{accIds, specificOrg, callSource});
        }
        if (CollectionUtils.isEmpty(accIds)) {
            return false;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fmasterid from t_bd_account where ", new Object[0]);
        sqlBuilder.appendIn(" fid ", new ArrayList<Long>(accIds));
        DataSet masterIdDs = DB.queryDataSet((String)(BizHappenUtils.class.getName() + "/batchExistsOnOrgDomain"), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        while (masterIdDs.hasNext()) {
            long masterId = masterIdDs.next().getLong("fmasterid");
            if (!BizHappenUtils.existsOnOrgDomain(masterId, specificOrg, null)) continue;
            LOG.info("BizHappenUtils.batchExistsOnOrgDomain has biz on masterid: {}.", (Object)masterId);
            return true;
        }
        return false;
    }

    private static AccountBizCheckUtil.BizType checkBizType(long accountId, DynamicObject accountDy, Set<Long> orgIds, Date startDate) {
        AccountBizCheckUtil.BizType result = AccountBizCheckUtil.BizType.NONE;
        long accTableId = accountDy.getLong("accounttable_id");
        Date accStartDate = accountDy.getDate("startdate");
        Set<Long> effectiveBookTypeIds = AccountingSysUtil.getEffectiveBookTypeIds(accTableId);
        if (effectiveBookTypeIds.isEmpty()) {
            return result;
        }
        if (accountId > 0L && accTableId > 0L) {
            Long masterId = accountDy.getLong("masterid");
            Set<Long> laterPeriods = Collections.EMPTY_SET;
            if (null != startDate) {
                laterPeriods = BDUtil.getLaterCrossPeriods(startDate);
            }
            for (BizHappenChecker checker : BIZ_CHECKERS) {
                boolean isHappen;
                if (checker instanceof BalanceChecker && !"1900-01-01".equals(DateUtils.formatString((Date)accStartDate, (String)"yyyy-MM-dd"))) {
                    Set<Long> effectivePeriods;
                    if (laterPeriods.isEmpty()) {
                        effectivePeriods = BDUtil.getLaterCrossPeriods(accStartDate);
                    } else {
                        long minPeriodId = Collections.min(BDUtil.getLaterCrossPeriods(accStartDate));
                        effectivePeriods = laterPeriods.stream().filter(x -> x >= minPeriodId).collect(Collectors.toSet());
                    }
                    isHappen = checker.isExistWrap(accountId, masterId, accTableId, orgIds, effectivePeriods);
                    if (isHappen && DebugTrace.enable()) {
                        LOG.info("BizHappenUtils_checkBizType balance check effective periods as:" + StringUtils.join((Object[])new Set[]{effectivePeriods}));
                    }
                } else {
                    isHappen = checker.isExistWrap(accountId, masterId, accTableId, orgIds, laterPeriods);
                }
                if (!isHappen) continue;
                result = checker.getCheckType();
                break;
            }
        }
        if (DebugTrace.enable()) {
            LOG.info("BizHappenUtils_checkBizType: account:{}, accStartDate: {}, orgIds:{}, startDate: {}, result: {}", new Object[]{accountId, accStartDate, StringUtils.join((Object[])new Set[]{orgIds}), startDate, result});
        }
        return result;
    }

    private static boolean executeCheckSql(SqlBuilder sqlBuilder) {
        return PerformanceMonitor.watch(() -> (Boolean)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        }), 10, sqlBuilder);
    }

    static {
        BIZ_CHECKERS.add(new SaveVoucherChecker());
        BIZ_CHECKERS.add(new BalanceChecker());
        BIZ_CHECKERS.add(new InitAccCurrentChecker());
        BIZ_CHECKERS.add(new ReciInitStateChecker());
        BIZ_CHECKERS.add(new InitBalanceChecker());
        BIZ_CHECKERS.add(new BalanceLogChecker());
    }

    private static class BalanceLogChecker
    implements BizHappenChecker {
        private BalanceLogChecker() {
        }

        @Override
        public AccountBizCheckUtil.BizType getCheckType() {
            return AccountBizCheckUtil.BizType.BALANCE_LOG;
        }

        @Override
        public boolean isExist(long accountId, long masterId, long accTableId, List<Long> orgIds, Set<Long> periods) {
            if (accountId == 0L) {
                return false;
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select TOP 1 fid from t_gl_balance_log where ", new Object[0]);
            sqlBuilder.append("fcalculated = '0' ", new Object[0]);
            sqlBuilder.append(" and faccountid = ?", new Object[]{accountId});
            if (CollectionUtils.isNotEmpty(orgIds)) {
                sqlBuilder.appendIn(" and forgid ", new ArrayList<Long>(orgIds));
            }
            if (CollectionUtils.isNotEmpty(periods)) {
                sqlBuilder.appendIn(" and fperiodid ", new ArrayList<Long>(periods));
            }
            return BizHappenUtils.executeCheckSql(sqlBuilder);
        }
    }

    private static class SaveVoucherChecker
    implements BizHappenChecker {
        private SaveVoucherChecker() {
        }

        @Override
        public AccountBizCheckUtil.BizType getCheckType() {
            return AccountBizCheckUtil.BizType.VOUCHER;
        }

        @Override
        public boolean isExist(long accountId, long masterId, long accTableId, List<Long> orgIds, Set<Long> periods) {
            if (accountId == 0L) {
                return false;
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select TOP 1 fid from t_gl_tempvoucher_index where ", new Object[0]);
            sqlBuilder.append("faccountid = ? ", new Object[]{accountId});
            if (CollectionUtils.isNotEmpty(orgIds)) {
                sqlBuilder.appendIn(" and forgid ", new ArrayList<Long>(orgIds));
            }
            if (CollectionUtils.isNotEmpty(periods)) {
                sqlBuilder.appendIn(" and fperiodid ", new ArrayList<Long>(periods));
            }
            return BizHappenUtils.executeCheckSql(sqlBuilder);
        }
    }

    private static class BalanceChecker
    implements BizHappenChecker {
        private BalanceChecker() {
        }

        @Override
        public AccountBizCheckUtil.BizType getCheckType() {
            return AccountBizCheckUtil.BizType.BALANCE;
        }

        @Override
        public boolean isExist(long accountId, long masterId, long accTableId, List<Long> orgIds, Set<Long> periods) {
            if (accountId == 0L) {
                return false;
            }
            boolean enableAcctBalQuery = BillParamUtil.getBooleanValue("83bfebc8000017ac", "fi.gl.balance.enableacctbalquery", false);
            String table = "t_gl_balance";
            if (enableAcctBalQuery) {
                table = "t_gl_acctbalance";
            }
            SqlBuilder balSql = new SqlBuilder();
            balSql.append("select TOP 1 fid from ", new Object[0]);
            balSql.append(table, new Object[0]);
            balSql.append(" where faccountid = ? ", new Object[]{masterId});
            if (CollectionUtils.isNotEmpty(orgIds)) {
                balSql.appendIn(" and forgid", new ArrayList<Long>(orgIds));
            }
            if (CollectionUtils.isNotEmpty(periods)) {
                balSql.appendIn(" and fperiodid ", new ArrayList<Long>(periods));
            }
            return BizHappenUtils.executeCheckSql(balSql);
        }
    }

    private static class ReciInitStateChecker
    implements BizHappenChecker {
        private ReciInitStateChecker() {
        }

        @Override
        public AccountBizCheckUtil.BizType getCheckType() {
            return AccountBizCheckUtil.BizType.RECISTATE;
        }

        @Override
        public boolean isExist(long accountId, long masterId, long accTableId, List<Long> orgIds, Set<Long> periods) {
            if (accountId == 0L) {
                return false;
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(" select TOP 1 fid from t_gl_reci_init_state", new Object[0]);
            sqlBuilder.append(" where faccountid = ? ", new Object[]{accountId});
            if (CollectionUtils.isNotEmpty(orgIds)) {
                sqlBuilder.appendIn(" and forgid", new ArrayList<Long>(orgIds));
            }
            if (CollectionUtils.isNotEmpty(periods)) {
                sqlBuilder.appendIn("AND fendinitperiod", new ArrayList<Long>(periods));
            }
            sqlBuilder.append("AND fisendinit=?", new Object[]{Character.valueOf('1')});
            return BizHappenUtils.executeCheckSql(sqlBuilder);
        }
    }

    private static class InitAccCurrentChecker
    implements BizHappenChecker {
        private InitAccCurrentChecker() {
        }

        @Override
        public AccountBizCheckUtil.BizType getCheckType() {
            return AccountBizCheckUtil.BizType.RECIINIT;
        }

        @Override
        public boolean isExist(long accountId, long masterId, long accTableId, List<Long> orgIds, Set<Long> periods) {
            if (accountId == 0L) {
                return false;
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select TOP 1 a.fid from t_gl_initacccurrent a ", new Object[0]);
            if (CollectionUtils.isNotEmpty(periods)) {
                sqlBuilder.append(" inner join t_gl_reci_init_state b on a.forgid = b.forgid ", new Object[0]);
                sqlBuilder.append(" and a.fbooktypeid = b.fbooktypeid and a.faccountid= b.faccountid ", new Object[0]);
            }
            sqlBuilder.append(" where a.faccountid = ? ", new Object[]{accountId});
            if (CollectionUtils.isNotEmpty(orgIds)) {
                sqlBuilder.appendIn(" and a.forgid", new ArrayList<Long>(orgIds));
            }
            if (CollectionUtils.isNotEmpty(periods)) {
                sqlBuilder.appendIn("AND b.fendinitperiod", new ArrayList<Long>(periods));
            }
            return BizHappenUtils.executeCheckSql(sqlBuilder);
        }
    }

    public static class InitBalanceChecker
    implements BizHappenChecker {
        @Override
        public AccountBizCheckUtil.BizType getCheckType() {
            return AccountBizCheckUtil.BizType.BALANCE_INIT;
        }

        @Override
        public boolean isExist(long accountId, long masterId, long accTableId, List<Long> orgIds, Set<Long> periods) {
            if (accountId == 0L) {
                return false;
            }
            Set<Long> effectiveBookTypeIds = AccountingSysUtil.getEffectiveBookTypeIds(accTableId);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(" select TOP 1 b.fid from t_gl_initbalance as  b ", new Object[0]);
            sqlBuilder.append(" inner join t_bd_accountbooks as a on b.forgid=a.forgid ", new Object[0]);
            sqlBuilder.append(" and b.fbooktypeid = a.fbookstypeid where ", new Object[0]);
            sqlBuilder.append(" b.faccountid = ? ", new Object[]{accountId});
            sqlBuilder.append(" and b.fisdeleted = ? ", new Object[]{Character.valueOf('0')});
            sqlBuilder.appendIn(" and b.fbooktypeid", new ArrayList<Long>(effectiveBookTypeIds));
            if (CollectionUtils.isNotEmpty(periods)) {
                sqlBuilder.appendIn(" and a.fstartperiodid ", new ArrayList<Long>(periods));
            }
            if (CollectionUtils.isNotEmpty(orgIds)) {
                sqlBuilder.appendIn(" and b.forgid ", new ArrayList<Long>(orgIds));
            }
            return BizHappenUtils.executeCheckSql(sqlBuilder);
        }
    }

    static interface BizHappenChecker {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public boolean isExistWrap(long accountId, long masterId, long accTableId, Set<Long> orgIds, Set<Long> periods) {
            boolean bl;
            ArrayList<Future> futures;
            boolean flag;
            long tick;
            block11: {
                tick = System.currentTimeMillis();
                flag = false;
                futures = new ArrayList<Future>(16);
                if (CollectionUtils.isNotEmpty(orgIds)) {
                    ArrayList<Long> orgList = new ArrayList<Long>(orgIds);
                    int batchSize = BillParamUtil.getIntegerValue("P9H6JC5EVP1", "fi.bd.util.BizHappenUtils.batchOrgSize", 1000);
                    List batchPartition = Lists.partition(orgList, (int)batchSize);
                    for (List batchOrg : batchPartition) {
                        Future future = ThreadService.submit(() -> this.isExist(accountId, masterId, accTableId, batchOrg, periods), (TaskType)TaskType.BD_BIZHAPPENUTILS_ISEXISTWRAP);
                        futures.add(future);
                    }
                    break block11;
                }
                boolean bl2 = this.isExist(accountId, masterId, accTableId, Collections.EMPTY_LIST, periods);
                if (DebugTrace.enable()) {
                    LOG.info("BizHappenUtils_cost: {}, accountId: {}, accTableId: {}, orgIds: {}, periods: {},flag:{}", new Object[]{System.currentTimeMillis() - tick, accountId, accTableId, orgIds, periods, flag});
                }
                return bl2;
            }
            try {
                for (Future future : futures) {
                    try {
                        boolean tempFlag = (Boolean)future.get();
                        if (!tempFlag) continue;
                        flag = true;
                        break;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                bl = flag;
            }
            catch (Throwable throwable) {
                if (DebugTrace.enable()) {
                    LOG.info("BizHappenUtils_cost: {}, accountId: {}, accTableId: {}, orgIds: {}, periods: {},flag:{}", new Object[]{System.currentTimeMillis() - tick, accountId, accTableId, orgIds, periods, flag});
                }
                throw throwable;
            }
            if (DebugTrace.enable()) {
                LOG.info("BizHappenUtils_cost: {}, accountId: {}, accTableId: {}, orgIds: {}, periods: {},flag:{}", new Object[]{System.currentTimeMillis() - tick, accountId, accTableId, orgIds, periods, flag});
            }
            return bl;
        }

        public AccountBizCheckUtil.BizType getCheckType();

        public boolean isExist(long var1, long var3, long var5, List<Long> var7, Set<Long> var8);
    }
}

