/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.ext.version.BaseDataOrgRelExtService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.CashflowItemVo;
import kd.fi.bd.vo.OrgCfitemOwnershipVO;
import kd.fi.bd.vo.OrgVO;

public class CashflowItemVersionUtil {
    private static Log log = LogFactory.getLog(CashflowItemVersionUtil.class);
    public static final String LATEST_VERSION_DATE = "2999-12-31";
    public static final String INIT_VERSION_DATE = "1900-01-01";
    private static final Log LOGGER = LogFactory.getLog(CashflowItemVersionUtil.class);
    private static volatile Date enddate;
    private static volatile Date initBegindate;
    public static final String ISPERSONALIZEDATE = "isPersonalizeData";
    public static final String ISADDINGASSIST = "isaddingassist";
    private static final SimpleDateFormat dt;
    public static final Set<String> CTRL_SHARE_STRATEGY;

    public static boolean isShareCtrlStrategy(DynamicObject account) {
        String controlStrategy = account.getString("ctrlstrategy");
        return CTRL_SHARE_STRATEGY.contains(controlStrategy);
    }

    public static Date getEndDate() {
        if (enddate != null) {
            return enddate;
        }
        try {
            enddate = dt.parse(LATEST_VERSION_DATE);
            return enddate;
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"CashflowItemVersionUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
    }

    public static Date getBeginDate() {
        if (initBegindate != null) {
            return initBegindate;
        }
        try {
            initBegindate = dt.parse(INIT_VERSION_DATE);
            return initBegindate;
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"CashflowItemVersionUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
    }

    public static Date getCurDate() {
        try {
            return dt.parse(dt.format(new Date()));
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"CashflowItemVersionUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
    }

    public static Boolean isPersonalized(long itemId) {
        DynamicObject item = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"masterid,createorg", (QFilter[])new QFilter("id", "=", (Object)itemId).toArray());
        if (null == item) {
            return false;
        }
        QFilter filters = new QFilter("id", "!=", (Object)itemId);
        filters.and(new QFilter("masterid", "=", (Object)item.getLong("masterid")));
        filters.and(new QFilter("createorg", "!=", (Object)item.getLong("createorg")));
        return QueryServiceHelper.exists((String)"gl_cashflowitem", (QFilter[])filters.toArray());
    }

    public static List<AssistEntryVO> getAddingAssistList(DynamicObject cashflowItem, DynamicObject dbItem) {
        DynamicObjectCollection newCollection = cashflowItem.getDynamicObjectCollection("assistentry");
        DynamicObjectCollection dbCollection = dbItem.getDynamicObjectCollection("assistentry");
        Map<Long, DynamicObject> newAssistIdEntryMap = newCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstypeid.id"), x -> x));
        Map<Long, DynamicObject> dbAssistIdEntryMap = dbCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstypeid.id"), x -> x));
        ArrayList<AssistEntryVO> addingAssistList = new ArrayList<AssistEntryVO>(newAssistIdEntryMap.size());
        for (Map.Entry<Long, DynamicObject> newEntry : newAssistIdEntryMap.entrySet()) {
            Long newId = newEntry.getKey();
            DynamicObject newAssistEntry = newEntry.getValue();
            boolean newMustInput = newAssistEntry.getBoolean("isrequire");
            boolean newIsLeaf = newAssistEntry.getBoolean("isdetail");
            DynamicObject dbAssistEntry = dbAssistIdEntryMap.get(newId);
            if (dbAssistEntry == null) {
                addingAssistList.add(new AssistEntryVO(newId, newMustInput, newIsLeaf, false));
                continue;
            }
            boolean dbMustInput = dbAssistEntry.getBoolean("isrequire");
            boolean dbIsLeaf = dbAssistEntry.getBoolean("isdetail");
            boolean noToYes = !dbMustInput && newMustInput || !dbIsLeaf && newIsLeaf;
            if (!noToYes) continue;
            addingAssistList.add(new AssistEntryVO(newId, newMustInput, newIsLeaf, false));
        }
        return addingAssistList;
    }

    public static List<AssistEntryVO> getAllAssistList(DynamicObject cashflowItem) {
        DynamicObjectCollection newCollection = cashflowItem.getDynamicObjectCollection("assistentry");
        HashSet<Long> existAssists = new HashSet<Long>(newCollection.size());
        ArrayList<AssistEntryVO> assistList = new ArrayList<AssistEntryVO>(newCollection.size());
        for (DynamicObject newAssistEntry : newCollection) {
            Long newId = newAssistEntry.getLong("asstypeid.id");
            if (existAssists.contains(newId)) continue;
            existAssists.add(newId);
            boolean newMustInput = newAssistEntry.getBoolean("isrequire");
            boolean newIsLeaf = newAssistEntry.getBoolean("isdetail");
            assistList.add(new AssistEntryVO(newId, newMustInput, newIsLeaf, false));
        }
        return assistList;
    }

    public static Map<Long, Set<Long>> item2UserOrgRelation(long masterId, long useOrgId) {
        HashMap<Long, Set<Long>> accOrgRelation = new HashMap<Long, Set<Long>>(8);
        if (CashflowItemVersionUtil.isNewModel("gl_cashflowitem")) {
            BaseDataOrgRelExtService service = new BaseDataOrgRelExtService("gl_cashflowitem");
            Map dataOrgRelation = service.getDataOrgRelation(Collections.singletonList(masterId));
            if (dataOrgRelation.get(masterId) == null) {
                return accOrgRelation;
            }
            BiTreeNode<Long, OrgVO> useOrgTree = BDUtil.buildSubTreeByOrgId(10, Optional.of(useOrgId));
            ArrayList<Long> useOrgDomain = new ArrayList<Long>(useOrgTree.collect(BiTreeNode::getId));
            for (Map.Entry entry : dataOrgRelation.entrySet()) {
                ((Set)entry.getValue()).retainAll(useOrgDomain);
                accOrgRelation.put((Long)entry.getKey(), (Set<Long>)entry.getValue());
            }
        } else {
            BiTreeNode<Long, OrgVO> useOrgTree = BDUtil.buildSubTreeByOrgId(10, Optional.of(useOrgId));
            ArrayList<Object> useOrgDomain = new ArrayList<Object>(useOrgTree.collect(BiTreeNode::getId));
            SqlBuilder sql = new SqlBuilder();
            sql.append("SELECT u.fdataid id, u.fuseorgid FROM t_gl_cashflowitem_u AS u INNER JOIN t_gl_cashflowitem AS c ON u.fdataid = c.fid WHERE ", new Object[0]);
            sql.append(" c.fmasterid = ?", new Object[]{masterId});
            sql.appendIn(" AND u.fuseorgid ", useOrgDomain);
            try (DataSet dataSet = DB.queryDataSet((String)CashflowItemVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);){
                for (Row row : dataSet) {
                    long accId = row.getLong("id");
                    long orgId = row.getLong("fuseorgid");
                    if (null == accOrgRelation.get(accId)) {
                        accOrgRelation.put(accId, new HashSet(8));
                    }
                    ((Set)accOrgRelation.get(accId)).add(orgId);
                }
            }
            Map<Long, Set<Long>> map = CashflowRelationFactory.get().queryAssignRelationByMid(masterId, useOrgDomain);
            accOrgRelation.putAll(map);
        }
        return accOrgRelation;
    }

    public static BiTreeNode<String, CashflowItemVo> buildSubTreeByCfitemNumber(String cfnumber, String longnumber, List<Long> useOrgIdList) {
        HashMap<String, BiTreeNode<String, CashflowItemVo>> cfNumberIndexMap = new HashMap<String, BiTreeNode<String, CashflowItemVo>>(8);
        BiTreeNode<String, CashflowItemVo> rootNode = null;
        long tick = System.currentTimeMillis();
        QFBuilder globalBuilder = new QFBuilder();
        QFBuilder orgBuilder = new QFBuilder();
        QFilter endDateFilter = new QFilter("enddate", "=", (Object)CashflowItemVersionUtil.getEndDate());
        QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
        globalBuilder.add(endDateFilter).add(longnumberFilter);
        orgBuilder.add(endDateFilter).add(longnumberFilter);
        if (useOrgIdList != null && !useOrgIdList.isEmpty()) {
            globalBuilder.add(new QFilter("ctrlstrategy", "=", (Object)"5"));
            orgBuilder.add(QFilter.sqlExpress((String)"id", (String)"in", (String)(" ( select fdataid from t_gl_cashflowitem_u where fuseorgid in (" + StringUtils.join((Object[])useOrgIdList.toArray(), (String)",") + " ))")));
        }
        DataSet globalDataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"gl_cashflowitem", (String)"id, number, name, parent.number parentnumber,level", (QFilter[])globalBuilder.toArray(), null);
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"gl_cashflowitem", (String)"id, number, name, parent.number parentnumber,level", (QFilter[])orgBuilder.toArray(), null);
        DataSet dataSet = globalDataSet.union(orgDataSet).select("id, number, name, parentnumber, level").orderBy(new String[]{"level asc"});
        for (Row row : dataSet) {
            String number = row.getString("number");
            String name = row.getString("name");
            if (Objects.nonNull(cfNumberIndexMap.get(number))) continue;
            if (Objects.isNull(rootNode)) {
                if (!cfnumber.equals(number)) continue;
                rootNode = new BiTreeNode<String, CashflowItemVo>(number, new CashflowItemVo(number, name));
                cfNumberIndexMap.put(number, rootNode);
                continue;
            }
            String parentNumber = row.getString("parentnumber");
            if (!Objects.nonNull(parentNumber) || !cfNumberIndexMap.containsKey(parentNumber)) continue;
            BiTreeNode parentNode = (BiTreeNode)cfNumberIndexMap.get(parentNumber);
            Preconditions.checkState((boolean)Objects.nonNull(parentNode));
            BiTreeNode<String, CashflowItemVo> accountNode = new BiTreeNode<String, CashflowItemVo>(number, new CashflowItemVo(number, name));
            cfNumberIndexMap.put(number, accountNode);
            accountNode.setParent(parentNode);
        }
        LOGGER.info("CashflowItemVersionUtil#buildSubTreeByCfitemNumber cost " + (System.currentTimeMillis() - tick));
        return rootNode;
    }

    public static Map<Long, OrgCfitemOwnershipVO> getAllSubLatestCfitemInfoInUseOrgRange(long rootCfitemId, List<Long> unmodifiedUseOrgIds, Date versionDate) {
        Optional<DynamicObject> cfitemDynObj;
        if (unmodifiedUseOrgIds == null || unmodifiedUseOrgIds.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Long> useOrgIdList = new ArrayList<Long>(unmodifiedUseOrgIds);
        if (Objects.isNull(versionDate)) {
            versionDate = CashflowItemVersionUtil.getCurDate();
        }
        if (!(cfitemDynObj = CashflowItemVersionUtil.getCfitemDynObj(rootCfitemId, "number", "masterid", "ctrlstrategy")).isPresent()) {
            return Collections.emptyMap();
        }
        DynamicObject cfitem = cfitemDynObj.get();
        String number = cfitem.getString("number");
        String globalShareStrategy = "5";
        if (!globalShareStrategy.equals(cfitem.getString("ctrlstrategy"))) {
            long masterId = cfitem.getLong("masterid");
            Set<Long> itemUseOrgRange = CashflowItemVersionUtil.getCfitemUseOrgRange(masterId, number);
            useOrgIdList.retainAll(itemUseOrgRange);
        }
        if (useOrgIdList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, OrgCfitemOwnershipVO> orgCfitemOwnershipMap = new HashMap<Long, OrgCfitemOwnershipVO>(useOrgIdList.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT a.fid,a.fnumber,a.fctrlstrategy,u.fuseorgid,a.fenddate FROM t_gl_cashflowitem AS a LEFT JOIN t_gl_cashflowitem_u AS u", new Object[0]);
        sqlBuilder.appendIn("ON u.fdataid = a.fid AND u.fuseorgid ", new ArrayList<Long>(useOrgIdList));
        sqlBuilder.append(" where a.fenddate > ?", new Object[]{DateUtils.stringToDate((String)DateUtils.formatString((Date)versionDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd")});
        sqlBuilder.append(" AND a.fnumber LIKE ?", new Object[]{number + "%"});
        try (DataSet dataSet = DB.queryDataSet((String)(BDUtil.class.getName() + "#getAllSubLatestCfitemInfoInUseOrgRange"), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String ctrlStrategy = row.getString("fctrlstrategy");
                String cfnum = row.getString("fnumber");
                Long cfid = row.getLong("fid");
                if (globalShareStrategy.equals(ctrlStrategy)) {
                    Iterator iterator = useOrgIdList.iterator();
                    while (iterator.hasNext()) {
                        long useOrgId = (Long)iterator.next();
                        OrgCfitemOwnershipVO ownershipVO = orgCfitemOwnershipMap.computeIfAbsent(useOrgId, k -> new OrgCfitemOwnershipVO(useOrgId));
                        OrgCfitemOwnershipVO.CfItemInfo cfInfo = ownershipVO.getOrNewCfInfo(cfnum);
                        cfInfo.setLatestVersionId(cfid);
                    }
                    continue;
                }
                Long useOrgId = row.getLong("fuseorgid");
                if (useOrgId == null || useOrgId == 0L) continue;
                OrgCfitemOwnershipVO ownershipVO = orgCfitemOwnershipMap.computeIfAbsent(useOrgId, k -> new OrgCfitemOwnershipVO(useOrgId));
                OrgCfitemOwnershipVO.CfItemInfo cfInfo = ownershipVO.getOrNewCfInfo(cfnum);
                if (CashflowItemVersionUtil.getEndDate().equals(row.getDate("fenddate"))) {
                    cfInfo.setLatestVersionId(cfid);
                    continue;
                }
                cfInfo.getVersionIds().add(cfid);
            }
        }
        return orgCfitemOwnershipMap;
    }

    public static Set<Long> getCfitemUseOrgRange(long masterId, String number) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT u.fuseorgid FROM t_gl_cashflowitem_u AS u inner join t_gl_cashflowitem AS a ON a.fid = u.fdataid WHERE ", new Object[0]);
        sql.append(" a.fmasterid =?", new Object[]{masterId});
        sql.append(" and a.fnumber=?", new Object[]{number});
        return (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql, rs -> {
            HashSet<Long> useOrgSet = new HashSet<Long>(16);
            while (rs.next()) {
                useOrgSet.add(rs.getLong("fuseorgid"));
            }
            return useOrgSet;
        });
    }

    public static Map<Long, Map<String, Boolean>> isCfitemIncludeAssist(Map<Long, OrgCfitemOwnershipVO> orgCfitemNumberShip, List<AssistEntryVO> assistList) {
        DynamicObject[] cfDynObjs;
        if (CollectionUtils.isEmpty(orgCfitemNumberShip)) {
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(assistList)) {
            return Collections.emptyMap();
        }
        Set cfItemIdSet = orgCfitemNumberShip.values().stream().flatMap(x -> x.getAllCfIds().stream()).collect(Collectors.toSet());
        if (cfItemIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, AssistEntryVO> assistIdInfoMap = assistList.stream().collect(Collectors.toMap(AssistEntryVO::getId, x -> x, (oldVal, newVal) -> newVal));
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", cfItemIdSet);
        qfBuilder.add("enable", "=", Boolean.TRUE);
        HashMap<Long, Boolean> cfIdIncludeAssistMap = new HashMap<Long, Boolean>(cfItemIdSet.size());
        for (DynamicObject obj : cfDynObjs = BusinessDataServiceHelper.load((String)"gl_cashflowitem", (String)"id, assistentry.asstypeid, assistentry.isrequire, assistentry.isdetail", (QFilter[])qfBuilder.toArray())) {
            long id = obj.getLong("id");
            DynamicObjectCollection assistEntryDynObjCollection = obj.getDynamicObjectCollection("assistentry");
            cfIdIncludeAssistMap.put(id, CashflowItemVersionUtil.isAssistEntryIncludeAssistList(assistEntryDynObjCollection, assistIdInfoMap));
        }
        HashMap<Long, Map<String, Boolean>> resultMap = new HashMap<Long, Map<String, Boolean>>(8);
        for (Map.Entry<Long, OrgCfitemOwnershipVO> orgAccShipEntry : orgCfitemNumberShip.entrySet()) {
            long useOrgId = orgAccShipEntry.getKey();
            OrgCfitemOwnershipVO shipVO = orgAccShipEntry.getValue();
            Map numResults = resultMap.computeIfAbsent(useOrgId, k -> new HashMap(2));
            for (String accNum : shipVO.getAllCfNums()) {
                numResults.put(accNum, shipVO.getOrNewCfInfo(accNum).getVersionIds().stream().allMatch(x -> Boolean.TRUE.equals(cfIdIncludeAssistMap.get(x))));
            }
        }
        return resultMap;
    }

    public static boolean isAssistEntryIncludeAssistList(DynamicObjectCollection assistEntryDynObjCollection, Map<Long, AssistEntryVO> assistIdInfoMap) {
        if (assistEntryDynObjCollection.size() >= assistIdInfoMap.size()) {
            Map<Long, DynamicObject> assistIdEntryDynObjMap = assistEntryDynObjCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstypeid.id"), x -> x, (oldVal, newVal) -> newVal));
            int includeCount = 0;
            for (Map.Entry<Long, AssistEntryVO> assistInfoEntry : assistIdInfoMap.entrySet()) {
                DynamicObject assistEntryDynObj = assistIdEntryDynObjMap.remove(assistInfoEntry.getKey());
                if (assistEntryDynObj != null) {
                    boolean isMustInput = assistEntryDynObj.getBoolean("isrequire");
                    if (!isMustInput && assistInfoEntry.getValue().isMustInput()) {
                        return false;
                    }
                    boolean isLeaf = assistEntryDynObj.getBoolean("isdetail");
                    if (!isLeaf && assistInfoEntry.getValue().isLeaf()) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (++includeCount != assistIdInfoMap.size()) continue;
                return true;
            }
        }
        return false;
    }

    public static long getCurrOrgFirstMasterId(long rootItemtId, long rootOrgId, String rootItemNumber) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)rootOrgId);
        QFilter fnumber = new QFilter("number", "=", (Object)rootItemNumber);
        long masterId = rootItemtId;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bd.util.CashflowItemVersionUtil.getCurrOrgFirstMasterId", (String)"gl_cashflowitem", (String)"masterid", (QFilter[])new QFilter[]{filter, fnumber}, (String)"startdate asc", (int)1);){
            if (dataSet.hasNext()) {
                masterId = dataSet.next().getLong("masterid");
            }
        }
        return masterId;
    }

    public static Optional<DynamicObject> getCfitemDynObj(long itemId, String ... fields) {
        boolean noFields;
        boolean bl = noFields = fields == null || fields.length < 1;
        if (noFields) {
            return Optional.of(BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"gl_cashflowitem"));
        }
        return Optional.of(BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"gl_cashflowitem", (String)String.join((CharSequence)",", fields)));
    }

    public static Optional<DynamicObject> findPreVersion(DynamicObject item, long curOrgId) {
        QFilter lastAccFilter = new QFilter("masterid", "=", (Object)item.getLong("masterid"));
        lastAccFilter.and("createorg", "=", (Object)curOrgId);
        lastAccFilter.and("number", "=", (Object)item.getString("number"));
        lastAccFilter.and("enddate", "=", (Object)item.getDate("startdate"));
        lastAccFilter.and("id", "!=", (Object)item.getLong("id"));
        DynamicObject lastVersion = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (QFilter[])lastAccFilter.toArray());
        if (Objects.isNull(lastVersion)) {
            String number = item.getString("number");
            return CashflowRelationFactory.get().findPreVersion(curOrgId, number);
        }
        return Optional.ofNullable(lastVersion);
    }

    public static void doAssign(List<Object[]> excParams, List<Object[]> useRegParams) {
        CashflowRelationFactory.get().writeUseRange(excParams, useRegParams);
        useRegParams.clear();
        if (excParams != null) {
            excParams.clear();
        }
    }

    public static void assignAllOldVersionItems(Long itemId, Long assignorgId, Long useOrgId, Map<Long, Long> orgAndParentOrgs) {
        if (orgAndParentOrgs != null && orgAndParentOrgs.entrySet().stream().anyMatch(x -> x.getKey() == x.getValue())) {
            return;
        }
        if (orgAndParentOrgs == null) {
            orgAndParentOrgs = new HashMap<Long, Long>(1);
        }
        HashSet<Long> useOrgIds = new HashSet<Long>();
        if (orgAndParentOrgs.get(useOrgId) == null) {
            useOrgIds.add(useOrgId);
        }
        QFilter f2 = new QFilter("view", "=", (Object)10);
        if (!useOrgIds.isEmpty()) {
            QFilter f3 = new QFilter("org", "in", useOrgIds);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);){
                for (Row row : dt) {
                    orgAndParentOrgs.put(row.getLong("org"), row.getLong("parent"));
                }
            }
        }
        DynamicObject assignCashFlowItem = BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"gl_cashflowitem", (String)"longnumber");
        String longNumber = assignCashFlowItem.getString("longnumber");
        String[] numbers = longNumber.split("@");
        Map<Object, Object> assignOrgUseregDatas = new HashMap<String, Set<Long>>(16);
        assignOrgUseregDatas.computeIfAbsent(assignCashFlowItem.getString("number"), k -> new HashSet()).add(itemId);
        assignOrgUseregDatas.putAll(CashflowRelationFactory.get().queryDataCreateByOrg(assignorgId, numbers));
        assignOrgUseregDatas = CashflowRelationFactory.get().queryAssignDataId(assignorgId, numbers);
        try (DataSet dataSet = CashflowRelationFactory.get().queryDataInfoByNumber(assignorgId, Arrays.asList(numbers), "number,id");){
            for (Row row : dataSet) {
                assignOrgUseregDatas.computeIfAbsent(row.getString("number"), k -> new HashSet()).add(row.getLong("id"));
            }
        }
        Map<String, Set<Long>> assignOrgExcdatas = CashflowRelationFactory.get().queryExcDataId(assignorgId, numbers);
        Map<String, Set<Long>> useOrgCreateItems = CashflowRelationFactory.get().queryDataCreateByOrg(assignorgId, numbers);
        Map<String, Set<Long>> useOrgUseregDatas = CashflowRelationFactory.get().queryAssignDataId(useOrgId, numbers);
        try (DataSet dataSet = CashflowRelationFactory.get().queryDataInfoByNumber(useOrgId, Arrays.asList(numbers), "number,id");){
            for (Row row : dataSet) {
                useOrgUseregDatas.computeIfAbsent(row.getString("number"), k -> new HashSet()).add(row.getLong("id"));
            }
        }
        Map<String, Set<Long>> useOrgExcdatas = CashflowRelationFactory.get().queryExcDataId(assignorgId, numbers);
        List dataIds = assignOrgUseregDatas.entrySet().stream().map(x -> (Set)x.getValue()).flatMap(x -> x.stream()).collect(Collectors.toList());
        Map cashFlowItems = BusinessDataServiceHelper.loadFromCache((Object[])dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"));
        HashMap<String, Object[]> useRegParams = new HashMap<String, Object[]>(16);
        HashMap<String, Object[]> excParams = new HashMap<String, Object[]>(16);
        for (String number : numbers) {
            Object[] exeParam;
            Object[] uparam;
            Long assignOrgId;
            Long createOrgId;
            String ctrlstrategy;
            DynamicObject cashFlowItem;
            Set assignOrgUseregDataIds = (Set)assignOrgUseregDatas.get(number);
            if (assignOrgUseregDataIds == null) {
                log.info("assignAllOldVersionAccts_useOrgUseregDataIds_is_null");
                continue;
            }
            Set<Long> useOrgUseregDataIds = useOrgUseregDatas.get(number);
            if (useOrgUseregDataIds != null) {
                assignOrgUseregDataIds.removeIf(dataid -> useOrgUseregDataIds.contains(dataid));
            }
            if (useOrgCreateItems.containsKey(number)) {
                for (Long assignOrgUseregDataId : assignOrgUseregDataIds) {
                    cashFlowItem = (DynamicObject)cashFlowItems.get(assignOrgUseregDataId);
                    ctrlstrategy = cashFlowItem.getString("ctrlstrategy");
                    createOrgId = cashFlowItem.getLong("createorg_id");
                    if ("1".equals(ctrlstrategy) || "3".equals(ctrlstrategy)) {
                        assignOrgId = orgAndParentOrgs.get(useOrgId);
                        uparam = new Object[]{useOrgId, assignOrgUseregDataId, createOrgId, createOrgId, ctrlstrategy, "1", assignOrgId == null ? createOrgId : assignOrgId};
                    } else {
                        uparam = new Object[]{useOrgId, assignOrgUseregDataId, createOrgId, createOrgId, ctrlstrategy, "1", createOrgId};
                    }
                    useRegParams.putIfAbsent(StringUtils.join((Object[])new Object[]{assignOrgUseregDataId, useOrgId}, (String)"-"), uparam);
                    exeParam = new Object[]{assignOrgUseregDataId, createOrgId, useOrgId};
                    excParams.putIfAbsent(StringUtils.join((Object[])new Object[]{assignOrgUseregDataId, useOrgId}, (String)"-"), exeParam);
                }
                continue;
            }
            for (Long assignOrgUseregDataId : assignOrgUseregDataIds) {
                cashFlowItem = (DynamicObject)cashFlowItems.get(assignOrgUseregDataId);
                ctrlstrategy = cashFlowItem.getString("ctrlstrategy");
                createOrgId = cashFlowItem.getLong("createorg_id");
                if ("1".equals(ctrlstrategy) || "3".equals(ctrlstrategy)) {
                    assignOrgId = orgAndParentOrgs.get(useOrgId);
                    uparam = new Object[]{useOrgId, cashFlowItem.getLong("id"), createOrgId, createOrgId, ctrlstrategy, "1", assignOrgId == null ? createOrgId : assignOrgId};
                } else {
                    uparam = new Object[]{useOrgId, cashFlowItem.getLong("id"), createOrgId, createOrgId, ctrlstrategy, "1", createOrgId};
                }
                useRegParams.putIfAbsent(StringUtils.join((Object[])new Object[]{assignOrgUseregDataId, useOrgId}, (String)"-"), uparam);
            }
            Set<Long> assignOrgExcDataIds = assignOrgExcdatas.get(number);
            Set<Long> useOrgExcdataIds = useOrgExcdatas.get(number);
            if (useOrgExcdataIds != null) {
                assignOrgExcDataIds.removeIf(dataid -> useOrgExcdataIds.contains(dataid));
            }
            if (assignOrgExcDataIds == null) continue;
            for (Long assignOrgExcDataId : assignOrgExcDataIds) {
                DynamicObject cashFlowItem2 = (DynamicObject)cashFlowItems.get(assignOrgExcDataId);
                Long createOrgId2 = cashFlowItem2.getLong("createorg_id");
                exeParam = new Object[]{assignOrgExcDataId, createOrgId2, useOrgId};
                excParams.putIfAbsent(StringUtils.join((Object[])new Object[]{assignOrgExcDataId, useOrgId}, (String)"-"), exeParam);
            }
        }
        CashflowItemVersionUtil.doAssign(new ArrayList<Object[]>(excParams.values()), new ArrayList<Object[]>(useRegParams.values()));
    }

    public static boolean isEnableVersion() {
        return BillParamUtil.getBooleanValue("83bfebc8000017ac", "fi.gl.cashlowitem.enableversion", false) && !CashflowItemVersionUtil.isNewModel("gl_cashflowitem");
    }

    public static boolean personalize(Long orgId, Long masterId, Long dataId, String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("createorg", "=", (Object)orgId));
        qfBuilder.add(new QFilter("masterid", "=", (Object)masterId));
        qfBuilder.add(new QFilter("id", "!=", (Object)dataId));
        qfBuilder.add(new QFilter("number", "=", (Object)number));
        return !QueryServiceHelper.exists((String)"gl_cashflowitem", (QFilter[])qfBuilder.toArray());
    }

    public static boolean isNewModel(String entity) {
        FormConfig config = FormMetadataCache.getFormConfig((String)entity);
        if (null == config) {
            return false;
        }
        entity = config.getEntityTypeId();
        String selectFields = "upgradestatus, checkstatus";
        QFilter[] filters = new QFilter[]{new QFilter("basedataid", "=", (Object)entity)};
        DynamicObject strategyConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
        if (null == strategyConfig) {
            return false;
        }
        return "2".equals(strategyConfig.getString("upgradestatus"));
    }

    static {
        dt = new SimpleDateFormat("yyyy-MM-dd");
        CTRL_SHARE_STRATEGY = new HashSet<String>(Arrays.asList("5", "6"));
    }
}

