/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CashflowLocalSetUtil {
    private static final String LOCAL_SET = "localSet";

    public static boolean isLocalSet(long orgid, Date date) {
        QFilter orgf = new QFilter("org", "=", (Object)orgid);
        QFilter localSetF = new QFilter("localset", "=", (Object)true);
        QFilter loaclSetDateF = new QFilter("localsetdate", "<=", (Object)date);
        return QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])new QFilter[]{orgf, localSetF, loaclSetDateF});
    }

    public static void cacheLocalSet(Set<Long> orgids) {
        Map<Long, Tuple<Boolean, Date>> localSetCur = CashflowLocalSetUtil.getLocalSetInfo(orgids);
        ThreadCache.put((Object)LOCAL_SET, localSetCur);
    }

    public static boolean isLocalSetThread(long orgid, Date date) {
        Map localSetCache = (Map)ThreadCache.get((Object)LOCAL_SET, () -> CashflowLocalSetUtil.getLocalSetInfo(CashflowLocalSetUtil.longToSet(orgid)));
        Tuple<Boolean, Date> curLocalSetInfo = (Tuple<Boolean, Date>)localSetCache.get(orgid);
        if (curLocalSetInfo == null) {
            Map<Long, Tuple<Boolean, Date>> localSetCur = CashflowLocalSetUtil.getLocalSetInfo(CashflowLocalSetUtil.longToSet(orgid));
            curLocalSetInfo = localSetCur.get(orgid);
            localSetCache.putAll(localSetCur);
        }
        if (curLocalSetInfo == null) {
            return false;
        }
        if (((Boolean)curLocalSetInfo.item1).booleanValue()) {
            return ((Date)curLocalSetInfo.item2).getTime() <= date.getTime();
        }
        return false;
    }

    public static Set<Long> longToSet(long value) {
        HashSet<Long> setValue = new HashSet<Long>(1);
        setValue.add(value);
        return setValue;
    }

    public static Map<Long, Tuple<Boolean, Date>> getLocalSetInfo(Set<Long> orgids) {
        HashMap<Long, Tuple<Boolean, Date>> localSetDate = new HashMap<Long, Tuple<Boolean, Date>>(1);
        QFilter orgf = new QFilter("org", "in", orgids);
        Map books = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"org,localset,localsetdate", (QFilter[])new QFilter[]{orgf}, (String)"org");
        for (Map.Entry bookEntry : books.entrySet()) {
            DynamicObject book = (DynamicObject)bookEntry.getValue();
            localSetDate.compute(book.getLong("org_id"), (k, v) -> {
                if (v == null) {
                    v = new Tuple((Object)book.getBoolean("localset"), (Object)book.getDate("localsetdate"));
                }
                return v;
            });
        }
        return localSetDate;
    }
}

