/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class DataSetHelper {
    private static final Log LOG = LogFactory.getLog(DataSetHelper.class);
    public static volatile BiPredicate<RowMeta, String> isExistField = (rm, x) -> -1 != rm.getFieldIndex(x, false);

    public static final List<String> getIndexFieldName(RowMeta rowMeta) {
        ArrayList<String> fieldIndexes = new ArrayList<String>(rowMeta.getFieldCount());
        for (int i = 0; i < rowMeta.getFields().length; ++i) {
            fieldIndexes.add(rowMeta.getFields()[i].getName().toLowerCase());
        }
        return fieldIndexes;
    }

    public static DataSet createDatSet(Class clazz, List<String> fields, List<DataType> dataType, List<List<Object>> fValList) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[fields.size()]), (DataType[])dataType.toArray(new DataType[dataType.size()]));
        Algo algo = Algo.create((String)(Objects.isNull(clazz) ? "" : clazz.getName()));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (List<Object> row : fValList) {
            builder.append(row.toArray(new Object[row.size()]));
        }
        return builder.build();
    }

    public static List<String> getDataSetCols(DataSet ds) {
        return DataSetHelper.getDataSetCols(ds, Collections.EMPTY_LIST);
    }

    public static List<String> getDataSetCols(DataSet ds, List<String> filterFields) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (filterFields.contains(field.getName())) continue;
            list.add(field.getName());
        }
        return list;
    }

    public static Object getFieldIfExist(RowMeta meta, Row row, String field) {
        if (isExistField.test(meta, field)) {
            return row.get(field);
        }
        return null;
    }

    public static void logDataSet(String logKey, DataSet dataSet) {
        if (LOG.isInfoEnabled() && !dataSet.isEmpty()) {
            Field field = dataSet.getRowMeta().getField(0);
            int count = dataSet.copy().count(field.getAlias(), false);
            LOG.info(logKey + "+ dataset_count:" + count);
            LOG.info(logKey + "\n" + String.join((CharSequence)"\n", DataSetHelper.printDataSet(dataSet, null)));
        }
    }

    public static void logDataSet(String logKey, DataSet dataSet, List<String> printCols) {
        if (LOG.isInfoEnabled()) {
            LOG.info(logKey + "\n" + String.join((CharSequence)"\n", DataSetHelper.printDataSet(dataSet, printCols)));
        }
    }

    public static List<String> printDataSet(DataSet dataSet) {
        return DataSetHelper.printDataSet(dataSet, null);
    }

    public static List<String> printDataSet(DataSet dataSet, List<String> printCols) {
        return DataSetHelper.printDataSet(dataSet, null, printCols);
    }

    public static List<String> printDataSet(DataSet dataSet, Integer maxRows, List<String> oriPrintCols) {
        Iterator iter;
        int rowIndex;
        Field[] printFieldArr;
        List<String> printCols;
        if (Objects.isNull(dataSet)) {
            return Collections.singletonList("null");
        }
        if (Objects.isNull(maxRows)) {
            maxRows = 100;
        }
        int[] colWidths = null;
        int[] charMaxSizes = null;
        int colCount = 0;
        try (DataSet dataSetCopy = dataSet.copy();){
            int i;
            RowMeta rowType = dataSetCopy.getRowMeta();
            printCols = Objects.isNull(oriPrintCols) ? Arrays.asList(rowType.getFieldNames()) : new ArrayList<String>(oriPrintCols);
            Iterator<String> it = printCols.iterator();
            while (it.hasNext()) {
                if (Arrays.asList(rowType.getFieldNames()).contains(it.next())) continue;
                it.remove();
            }
            colCount = printCols.size();
            printFieldArr = new Field[colCount];
            for (i = 0; i < printFieldArr.length; ++i) {
                printFieldArr[i] = rowType.getField(printCols.get(i));
            }
            colWidths = new int[colCount];
            charMaxSizes = new int[colCount];
            for (i = 0; i < colCount; ++i) {
                String colAlias = printFieldArr[i].getAlias();
                int colWidth = colAlias.length() > 4 ? colAlias.length() : 4;
                colWidths[i] = StringUtils.isEmpty((String)colAlias) ? 10 : colWidth;
                charMaxSizes[i] = StringUtils.isEmpty((String)colAlias) ? 10 : colWidth;
            }
            rowIndex = 0;
            iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                for (int i2 = 0; i2 < colCount; ++i2) {
                    Object value = row.get(printFieldArr[i2].getAlias());
                    if (!Objects.nonNull(value)) continue;
                    String valueStr = String.valueOf(value);
                    int length = 0;
                    if (!StringUtils.isEmpty((String)valueStr)) {
                        for (char c : valueStr.toCharArray()) {
                            if (!DataSetHelper.isChinese(c)) {
                                ++length;
                                continue;
                            }
                            length += 2;
                        }
                    }
                    if (length > colWidths[i2]) {
                        colWidths[i2] = length;
                    }
                    if (valueStr.length() <= charMaxSizes[i2]) continue;
                    charMaxSizes[i2] = valueStr.length();
                }
            }
        }
        StringBuilder formatBuilder = new StringBuilder();
        for (int i = 0; i < colWidths.length; ++i) {
            formatBuilder.append('%').append(colWidths[i]).append("s|");
        }
        ArrayList<String> lines = new ArrayList<String>(maxRows);
        try (DataSet dataSetCopy = dataSet.copy();){
            lines.add(String.format(formatBuilder.toString(), printCols.toArray()));
            rowIndex = 0;
            iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                Object[] rowValues = new Object[colCount];
                int[] nonEngCharCnts = new int[colCount];
                for (int i = 0; i < colCount; ++i) {
                    Object value = row.get(printFieldArr[i].getAlias());
                    rowValues[i] = Objects.isNull(value) ? "null" : String.valueOf(value);
                    int nonEngCharCnt = 0;
                    for (char c : String.valueOf(rowValues[i]).toCharArray()) {
                        if (!DataSetHelper.isChinese(c)) continue;
                        ++nonEngCharCnt;
                    }
                    nonEngCharCnts[i] = nonEngCharCnt;
                }
                StringBuilder rowFormatBuilder = new StringBuilder();
                for (int i = 0; i < colWidths.length; ++i) {
                    rowFormatBuilder.append('%').append(colWidths[i] - nonEngCharCnts[i]).append("s|");
                }
                lines.add(String.format(rowFormatBuilder.toString(), rowValues));
            }
        }
        return lines;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static DataSet createEmptyDataSet() {
        return DataSetHelper.createDatSet(DataSetHelper.class, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }
}

