/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;

public class Dates {
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_TIME = "yyyy-MM-dd HH:mm:ss";

    private Dates() {
    }

    public static boolean equals(Date date1, Date date2, boolean isJustDate) {
        Preconditions.checkArgument((Objects.nonNull(date1) && Objects.nonNull(date2) ? 1 : 0) != 0);
        String date1Str = isJustDate ? Dates.format(date1) : Dates.formatTime(date1);
        String date2Str = isJustDate ? Dates.format(date2) : Dates.formatTime(date2);
        return date1Str.equals(date2Str);
    }

    public static boolean notEquals(Date date1, Date date2, boolean isJustDate) {
        return !Dates.equals(date1, date2, isJustDate);
    }

    public static String format(Date date) {
        return DateFormatUtils.format((Date)date, (String)FORMAT_DATE);
    }

    public static String formatTime(Date date) {
        return DateFormatUtils.format((Date)date, (String)FORMAT_TIME);
    }
}

