/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ConfigurationUtil;

public class DebugTrace {
    private static final String CACHE_KEY = "fi.bd.debugtrace.enable";
    private static final int DebugTraceCacheSeconds = 30;
    private static final String DebugTraceCacheKey = "fi.bd.debug.traceconfig.active";
    private static final Cache<String, Map<String, Object>> DebugTraceCache = CacheBuilder.newBuilder().initialCapacity(1).maximumSize(1L).concurrencyLevel(8).expireAfterWrite(30L, TimeUnit.SECONDS).recordStats().build();
    private static final Log log = LogFactory.getLog(DebugTrace.class);

    public static boolean enable() {
        try {
            if (ConfigurationUtil.getBoolean((String)CACHE_KEY, (Boolean)true).booleanValue()) {
                return DebugTrace.checkEnable();
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u8c03\u8bd5\u65e5\u5fd7\u7edf\u4e00\u7ba1\u63a7\u5f02\u5e38,", (Throwable)e);
            return false;
        }
    }

    public static void action(Runnable runnable) {
        if (DebugTrace.enable()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                log.error("\u8c03\u8bd5\u65e5\u5fd7\u7edf\u4e00\u7ba1\u63a7\u5f02\u5e38,", (Throwable)e);
            }
        }
    }

    private static boolean checkEnable() {
        Boolean cachedEnable = DebugTrace.getFromThreadCache();
        if (null != cachedEnable) {
            return cachedEnable;
        }
        Map<String, Object> activeConfig = DebugTrace.getActiveConfig();
        boolean enable = false;
        if (null != activeConfig && activeConfig.size() > 0) {
            RequestMetaData requestMetaData = DebugTrace.getRequestMetaData();
            enable = DebugTrace.doCheck(requestMetaData, activeConfig);
        }
        DebugTrace.setToThreadCache(enable);
        return enable;
    }

    private static void setToThreadCache(boolean enable) {
        ThreadCache.put((Object)CACHE_KEY, (Object)enable);
    }

    private static Boolean getFromThreadCache() {
        Boolean cachedEnable = (Boolean)ThreadCache.get((Object)CACHE_KEY);
        return cachedEnable;
    }

    private static Map<String, Object> getActiveConfig() {
        HashMap<String, Object> activeConfig = (HashMap<String, Object>)DebugTraceCache.getIfPresent((Object)DebugTraceCacheKey);
        if (null != activeConfig) {
            return activeConfig;
        }
        activeConfig = new HashMap<String, Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi-bd.DebugTrace", (String)"bd_debugtrace", (String)"id,appnumber,formnumber,action,user,clienttype,requesttimes,expireddate", null, (String)"id desc", (int)1);){
            Row row;
            Date expiredDate;
            if (ds.hasNext() && null != (expiredDate = (row = ds.next()).getDate("expireddate")) && !expiredDate.before(new Date())) {
                activeConfig.put("id", String.valueOf(row.getLong("id")));
                activeConfig.put("appId", row.getString("appnumber"));
                activeConfig.put("form", row.getString("formnumber"));
                activeConfig.put("action", row.getString("action"));
                activeConfig.put("userId", String.valueOf(row.getLong("user")));
                activeConfig.put("clientType", row.getString("clienttype"));
                activeConfig.put("requestTimes", row.getInteger("requesttimes"));
                activeConfig.put("expiredDate", expiredDate.getTime());
            }
            DebugTrace.cacheActiveConfig(activeConfig);
        }
        return activeConfig;
    }

    private static void cacheActiveConfig(Map<String, Object> activeConfig) {
        DebugTraceCache.put((Object)DebugTraceCacheKey, activeConfig);
    }

    private static RequestMetaData getRequestMetaData() {
        RequestMetaData requestMetaData = new RequestMetaData();
        RequestContext requestContext = RequestContext.get();
        requestMetaData.setClientType(requestContext.getClient());
        requestMetaData.setUserId(String.valueOf(requestContext.getCurrUserId()));
        String queryString = requestContext.getQueryString();
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        if (StringUtils.isNotEmpty((String)queryString)) {
            String[] split;
            for (String paramStr : split = queryString.split("&")) {
                String[] paramArr = paramStr.split("=");
                if (!"appId".equals(paramArr[0]) && !"f".equals(paramArr[0]) && !"ac".equals(paramArr[0])) continue;
                if (paramArr.length > 1) {
                    paramMap.put(paramArr[0], paramArr[1]);
                    continue;
                }
                paramMap.put(paramArr[0], "");
            }
        }
        requestMetaData.setAppId((String)paramMap.get("appId"));
        requestMetaData.setForm((String)paramMap.get("f"));
        requestMetaData.setAction((String)paramMap.get("ac"));
        return requestMetaData;
    }

    private static boolean doCheck(RequestMetaData requestMetaData, Map<String, Object> activeConfig) {
        Long expiredDate = (Long)activeConfig.get("expiredDate");
        Long expiredSeconds = (expiredDate - System.currentTimeMillis()) / 1000L + 1L;
        if (expiredSeconds <= 0L) {
            return false;
        }
        String appId = (String)activeConfig.get("appId");
        String form = (String)activeConfig.get("form");
        String action = (String)activeConfig.get("action");
        String userId = (String)activeConfig.get("userId");
        String clientType = (String)activeConfig.get("clientType");
        String id = (String)activeConfig.get("id");
        boolean enable = false;
        if (!(DebugTrace.matchItem(appId, requestMetaData.getAppId()) && DebugTrace.matchItem(form, requestMetaData.getForm()) && DebugTrace.matchItem(action, requestMetaData.getAction()) && DebugTrace.matchUserId(userId, requestMetaData.getUserId()) && DebugTrace.matchItem(clientType, requestMetaData.getClientType()))) {
            return enable;
        }
        enable = true;
        Integer requestTimes = (Integer)activeConfig.get("requestTimes");
        String RequestTimesCacheKey = CacheKeyUtil.getAcctId() + ":fi:bd:debug:trace:requestTimes";
        if (null != requestTimes && requestTimes > 0) {
            DistributeSessionlessCache requestTimesCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(RequestTimesCacheKey);
            long currentRequstTimes = requestTimesCache.inc(RequestTimesCacheKey + ":" + id, expiredSeconds.intValue(), TimeUnit.SECONDS);
            return currentRequstTimes <= (long)requestTimes.intValue();
        }
        return enable;
    }

    private static boolean matchUserId(String configUserId, String requestUserId) {
        if (StringUtils.isEmpty((String)configUserId) || "0".equals(configUserId)) {
            return true;
        }
        return configUserId.equals(requestUserId);
    }

    private static boolean matchItem(String configItem, String requestItem) {
        if (StringUtils.isEmpty((String)configItem)) {
            return true;
        }
        return configItem.equals(requestItem);
    }

    private static class RequestMetaData {
        private String clientType;
        private String userId;
        private String appId;
        private String form;
        private String action;

        private RequestMetaData() {
        }

        public String getClientType() {
            return this.clientType;
        }

        public void setClientType(String clientType) {
            this.clientType = clientType;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getForm() {
            return this.form;
        }

        public void setForm(String form) {
            this.form = form;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }
}

