/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bd.util.MultiLangPunc;

public class MsgBuilder {
    private final int maxLength;
    private final StringBuilder builder;
    private boolean exceeded = false;

    public MsgBuilder(int maxLength) {
        this.maxLength = maxLength;
        this.builder = new StringBuilder();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isExceeded() {
        if (!this.exceeded) {
            this.exceeded = this.maxLength > 0 && this.builder.length() > this.maxLength;
        }
        return this.exceeded;
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public void appendMsg(String msg) {
        if (this.isExceeded()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.builder.append(this.amendMsg(msg));
        }
    }

    private String amendMsg(String msg) {
        String fullStop = MultiLangPunc.fullStop();
        if (msg.charAt(msg.length() - 1) == fullStop.charAt(0)) {
            return msg;
        }
        return msg + fullStop;
    }

    public void clear() {
        this.builder.setLength(0);
        this.exceeded = false;
    }
}

