/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BalancePeriodQueryOptimizer;
import kd.fi.bd.util.PerformanceMonitor;

public class PeriodUtil {
    private static final Log LOG = LogFactory.getLog(PeriodUtil.class);
    public static final String ENTITY_OUTLINE = "bd_periodoutline_tree";
    public static final String GENERATETYPE_CUS = "4";
    public static final String PERIOD_ENTRY = "period_entry";
    public static final String PERIODTYPE = "group";
    public static final String GENERATETYPE = "generatetype";
    public static final String ADJUST_TYPE = "adjusttype";
    public static final String PERIOD_YEAR = "periodyear";
    public static final String PERIOD_YEAR1 = "periodyear1";
    public static final String OUTLINE_BEGIN = "outlinebegindate";
    public static final String OUTLINE_BEGIN1 = "outlinebegindate1";
    public static final String OUTLINE_END = "outlineenddate";
    public static final String PERIOD_NUMBER = "periodnumber";
    public static final String PERIOD_NUMBER2 = "periodnumber2";
    public static final String PERIOD_BEGINDATE = "begindate";
    public static final String PERIOD_ENDDATE = "enddate";
    public static final String PERIOD_NAME = "periodname";
    public static final String PERIOD_QUARTER = "periodquarter";
    public static final String PERIOD_ISADJUSTPERIOD = "isadjustperiod";
    public static final String PERIOD = "period";
    public static final String PERIOD_OUTLINE_QUARTER = "periodoutlinequarter";
    public static final String TIMES = "times";
    public static final String INSERTADJUST = "insertadjust";
    public static final String DELETEADJUST = "deleteadjust";
    public static final String GENPERIOD = "generateperiod_btn";
    private static final String SQL_ReadObjectTypeRef = "select FObjectTypeId, FTableName, FFieldName from t_meta_objecttyperef where FRefObjectTypeId in (%s) ";
    private static final String SQL_EXISTED_BILL = "select %s from %s where ";
    private static final String SQL_FILTER = "%s in (%s)";
    public static final Long MAX_PERIOD = 99999999999L;
    public static final Long TYPE_PERIOD_L = 100000000L;
    public static final Long YEAR_PERIOD_L = 10000L;
    public static final Long NUM_PERIOD_L = 10L;
    private static final String T_ACCT_BALANCE = "t_gl_acctbalance";
    private static final String T_BALANCE = "t_gl_balance";

    public static DynamicObject getPeriodByPeriodId(long periodid, String propertys) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)periodid, (String)"bd_period", (String)propertys);
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        return PeriodUtil.getNextPeriod(curPeriodId, true);
    }

    public static DynamicObject getNextPeriod(Object curPeriodId, boolean isAdjustPeriod) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", ">", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = null;
            if (isAdjustPeriod) {
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id", (int)1);
            } else {
                QFilter filterAdjustPeriod = new QFilter(PERIOD_ISADJUSTPERIOD, "=", (Object)isAdjustPeriod);
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, filterAdjustPeriod}, (String)"id", (int)1);
            }
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return nextPeriod;
    }

    public static DynamicObject getFuturePeriod(Object curPeriodId, int future, boolean isAdjustPeriod) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (String)"bd_period", (String)"periodtype");
            Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
            QFilter filterDate = new QFilter("id", ">=", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = null;
            if (isAdjustPeriod) {
                coll = QueryServiceHelper.query((String)"bd_period", (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id", (int)future);
            } else {
                QFilter filterAdjustPeriod = new QFilter(PERIOD_ISADJUSTPERIOD, "=", (Object)isAdjustPeriod);
                coll = QueryServiceHelper.query((String)"bd_period", (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, filterAdjustPeriod}, (String)"id", (int)future);
            }
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(future - 1);
            }
        }
        return nextPeriod;
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
        QFilter filterDate = new QFilter("id", "<", curPeriodId);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)"bd_period");
        Object periodtypeid = currPeriod.get("periodtype_id");
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)1);
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return (DynamicObject)coll.get(0);
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId, boolean isAdjustPeriod) {
        DynamicObjectCollection coll;
        if (curPeriodId == null) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", curPeriodId);
        String property = "periodtype.id";
        Long periodTypeId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PeriodUtil.class.getName(), (String)"bd_period", (String)property, (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                periodTypeId = row.getLong(property);
            }
        }
        QFilter filterDate = new QFilter("id", "<", curPeriodId);
        QFilter filterType = new QFilter(property, "=", (Object)periodTypeId);
        if (isAdjustPeriod) {
            coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)1);
        } else {
            QFilter filterAdjustPeriod = new QFilter(PERIOD_ISADJUSTPERIOD, "=", (Object)isAdjustPeriod);
            coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{filterDate, filterType, filterAdjustPeriod}, (String)"id desc", (int)1);
        }
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return (DynamicObject)coll.get(0);
    }

    public static String isReferenced(List<Object> ids, String entitykey) {
        if (ids.isEmpty()) {
            return "";
        }
        BasedataEntityType baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entitykey);
        ArrayList<BaseDataRefenceKey> reflist = new ArrayList<BaseDataRefenceKey>();
        ArrayList<String> bdEntityNumbers = new ArrayList<String>();
        bdEntityNumbers.add(entitykey);
        reflist.addAll(PeriodUtil.loadObjectTypeRefs(baseEntityType, bdEntityNumbers));
        HashMap<String, HashSet<String>> tableFieldMap = new HashMap<String, HashSet<String>>(reflist.size());
        HashMap<String, String> tableKeyMap = new HashMap<String, String>(reflist.size());
        for (BaseDataRefenceKey refencekey : reflist) {
            if (refencekey.isRefFlexProperty()) continue;
            String reftable = refencekey.getRefTable();
            String refCol = refencekey.getRefCol();
            String refEntityKey = refencekey.getRefEntityKey();
            HashSet<String> set = (HashSet<String>)tableFieldMap.get(reftable);
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add(refCol);
            tableFieldMap.put(reftable, set);
            tableKeyMap.put(reftable, refEntityKey);
        }
        HashSet<Object> idSets = new HashSet<Object>();
        idSets.addAll(ids);
        String idString = PeriodUtil.getSqlBySet(idSets);
        for (Map.Entry entry : tableKeyMap.entrySet()) {
            try {
                String tableNum = (String)entry.getKey();
                String entityNum = (String)entry.getValue();
                MainEntityType dt = null;
                dt = MetadataServiceHelper.getDataEntityType((String)entityNum);
                String DBRoutekty = dt.getDBRouteKey();
                String pkfield = dt.getPrimaryKey().getAlias();
                Set fieldSet = (Set)tableFieldMap.get(tableNum);
                String sql = PeriodUtil.rebuildSql(String.format(SQL_EXISTED_BILL, pkfield, tableNum), idString, fieldSet);
                String name = PeriodUtil.getRefName(DBRoutekty, sql, dt);
                if (name == null) continue;
                return name;
            }
            catch (Exception exception) {
            }
        }
        return "";
    }

    private static String getRefName(String DBRoutekty, String sql, MainEntityType dt) {
        try (DataSet dataset = DB.queryDataSet((String)"fi.bd.PeriodUtil", (DBRoute)DBRoute.of((String)DBRoutekty), (String)sql);){
            if (dataset.hasNext()) {
                String string = dt.getDisplayName().getLocaleValue();
                return string;
            }
        }
        return null;
    }

    private static String rebuildSql(String SQL_EXISTED_BILL, String ids, Set<String> fieldSet) {
        StringBuilder sb = new StringBuilder(SQL_EXISTED_BILL);
        StringBuilder sb1 = new StringBuilder();
        for (String field : fieldSet) {
            if (sb1.length() != 0) {
                sb1.append(" or ");
            }
            sb1.append(String.format(SQL_FILTER, field, ids));
        }
        return sb.append((CharSequence)sb1).toString();
    }

    public static String getSqlBySet(Set<Object> set) {
        StringBuilder s = new StringBuilder();
        for (Object id : set) {
            if (s.length() != 0) {
                s.append(',');
            }
            s.append('\'');
            s.append(id);
            s.append('\'');
        }
        return s.toString();
    }

    private static List<BaseDataRefenceKey> loadObjectTypeRefs(final BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(refBDTypeNames.size());
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FRefObjectTypeId" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = String.format(SQL_ReadObjectTypeRef, StringUtils.join((Object[])strParams.toArray(), (String)","));
        try {
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<BaseDataRefenceKey>>(){

                public List<BaseDataRefenceKey> handle(ResultSet rs) throws Exception {
                    ArrayList<BaseDataRefenceKey> refs = new ArrayList<BaseDataRefenceKey>(50);
                    while (rs.next()) {
                        BaseDataRefenceKey ref = BaseDataRefenceKey.create((BasedataEntityType)baseEntityType, null);
                        ref.setRefEntityKey(rs.getString("FObjectTypeId"));
                        ref.setRefTable(rs.getString("FTableName"));
                        ref.setRefCol(rs.getString("FFieldName"));
                        refs.add(ref);
                    }
                    return refs;
                }
            });
        }
        catch (Exception exp) {
            return new ArrayList<BaseDataRefenceKey>(0);
        }
    }

    public static long getPkId(long typeId, int year, int periodNum, boolean isAdjust) {
        long pk = typeId * TYPE_PERIOD_L + (long)year * YEAR_PERIOD_L + (long)periodNum * NUM_PERIOD_L;
        if (isAdjust) {
            ++pk;
        }
        return pk;
    }

    public static long retainPeriodType(long period) {
        return period / TYPE_PERIOD_L * TYPE_PERIOD_L;
    }

    public static long retainPeriodYear(long period) {
        return period / YEAR_PERIOD_L * YEAR_PERIOD_L;
    }

    public static long getPeriodNumber(long period) {
        return period / NUM_PERIOD_L % 1000L;
    }

    public static long getTypeid(long periodid) {
        return periodid / TYPE_PERIOD_L;
    }

    public static long getYear(long periodid) {
        return periodid / YEAR_PERIOD_L - periodid / TYPE_PERIOD_L * TYPE_PERIOD_L / YEAR_PERIOD_L;
    }

    public static Set<Long> getPeriodType(Long orgId) {
        HashSet<Long> periodTypes = new HashSet<Long>(10);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PeriodUtil.class.getName(), (String)"gl_accountbook", (String)"org,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)}, null);){
            for (Row row : ds) {
                periodTypes.add(row.getLong("periodtype"));
            }
        }
        return periodTypes;
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        return PeriodUtil.getPeriodByDate(date, periodType, Boolean.TRUE);
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType, Boolean includeAdjust) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = PeriodUtil.getPeriodByDate(date, selectField, periodType, includeAdjust);
        if (!period.isEmpty()) {
            return (DynamicObject)period.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType, Boolean includeAdjust) {
        Calendar c = Calendar.getInstance();
        if (Objects.isNull(date)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PeriodUtil_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        QFilter f = new QFilter("beginDate", "<=", (Object)c.getTime());
        QFilter g = new QFilter(PERIOD_ENDDATE, ">=", (Object)c.getTime());
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        if (!includeAdjust.booleanValue()) {
            t = t.and(new QFilter(PERIOD_ISADJUSTPERIOD, "=", (Object)includeAdjust));
        }
        return QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t}, (String)"id desc");
    }

    public static Set<Long> getPeriodIdSet(Date beginDate, Date endDate) {
        QFilter beginDateFilter = new QFilter(PERIOD_BEGINDATE, "<=", (Object)endDate);
        QFilter endDateFilter = new QFilter(PERIOD_ENDDATE, ">=", (Object)beginDate);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter});
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public static List<Long> getPeriodIds(Long begin, Long end) {
        if (end == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(end / TYPE_PERIOD_L));
        QFilter beginFilter = new QFilter("id", ">=", (Object)begin);
        QFilter endFilter = new QFilter("id", "<=", (Object)end);
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, beginFilter, endFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        return result;
    }

    public static List<Long> getPeriodIds(String compare, Long period) {
        if (period == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(period / TYPE_PERIOD_L));
        QFilter periodFilter = new QFilter("id", compare, (Object)period);
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, periodFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        if (compare.equalsIgnoreCase("<") || compare.equalsIgnoreCase("<=")) {
            result.add(0L);
        } else if (compare.equalsIgnoreCase(">") || compare.equalsIgnoreCase(">=")) {
            result.add(MAX_PERIOD);
        }
        return result;
    }

    public static DynamicObject getCurYearMinPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter(PERIOD_YEAR, "=", currPeriod.get(PERIOD_YEAR));
        QFilter filterNum = new QFilter(PERIOD_NUMBER, "<=", currPeriod.get(PERIOD_NUMBER));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)PERIOD_NUMBER);
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static List<Long> getAvailableEndPeriodIds(String compare, Long period, Long[] orgIds) {
        return (List)ThreadCache.get((Object)String.format("PeriodUtil#getAvailableEndPeriodIds{%s, %s, %s}", compare, period, Arrays.asList(orgIds)), () -> PeriodUtil.getAcctBalEndPeriodIdsInRealTime(compare, period, orgIds), (boolean)true);
    }

    public static List<Long> getAcctBalEndPeriodIdsInRealTime(String compare, Long period, Long[] orgIds) {
        List<Long> rawPeriods = PeriodUtil.getPeriodIds(compare, period);
        return PerformanceMonitor.watch(() -> BalancePeriodQueryOptimizer.getBizHappenPeriods(T_BALANCE, orgIds, rawPeriods), 1000, Arrays.asList(orgIds) + ";" + rawPeriods);
    }

    public static List<Long> getAcctBalEndPeriodIds(String compare, Long period, Long[] orgIds) {
        List<Long> rawPeriods = PeriodUtil.getPeriodIds(compare, period);
        return PerformanceMonitor.watch(() -> BalancePeriodQueryOptimizer.getBizHappenPeriods(T_ACCT_BALANCE, orgIds, rawPeriods), 1000, Arrays.asList(orgIds) + ";" + rawPeriods);
    }

    public static List<Long> getCashflowAvailableEndPeriodIds(String compare, Long period, Long[] orgIds) {
        List<Long> availablePeriodids = PeriodUtil.getCashflowAvailableEndPeriodIds(orgIds, PeriodUtil.getPeriodIds(compare, period));
        if (availablePeriodids.size() == 0) {
            availablePeriodids.add(MAX_PERIOD);
        }
        return availablePeriodids;
    }

    public static List<Long> getCashflowAvailableEndPeriodIds(Long[] orgIds, List<Long> periodid) {
        if (orgIds == null || orgIds.length == 0) {
            return periodid;
        }
        ArrayList<Long> availablePeriodids = new ArrayList<Long>(periodid.size());
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select p.fid from t_bd_period p where p.fid ", periodid.toArray());
        sql.appendIn("and exists (select 1 from t_bd_accountbooks b where b.forgid ", (Object[])orgIds);
        sql.append("and exists (select 1 from t_gl_cashflow where forgid = b.forgid and fendperiodid = p.fid))", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"PeriodUtil.getAvailablePeriod", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                availablePeriodids.add(row.getLong("fid"));
            }
        }
        if (periodid.contains(MAX_PERIOD)) {
            availablePeriodids.add(MAX_PERIOD);
        }
        return availablePeriodids;
    }

    public static DynamicObject getPeriod(Long periodId, String field) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)field, (QFilter[])filter.toArray());
    }
}

