/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;

public class TimerFactory {
    public static Timer getTimer(Class<?> timeOn) {
        return new Timer(timeOn);
    }

    public static class Timer {
        private long time = System.currentTimeMillis();
        private final Log logger;

        protected Timer(Class<?> timeOn) {
            this.logger = LogFactory.getLog(timeOn);
            this.time(timeOn.getSimpleName() + " time begin ===========================================");
        }

        public final void time(String timeAt) {
            if (DebugTrace.enable()) {
                long preTs = this.time;
                this.time = System.currentTimeMillis();
                this.logger.info(timeAt + " cost " + (this.time - preTs) + " ms at ts " + preTs + " .");
            }
        }
    }
}

