/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.collections.queue;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.fi.bd.util.collections.queue.AbstractConcurrentSet;

public class ConcurrentSetCollection<E>
extends AbstractConcurrentSet<E>
implements Collection<E> {
    ConcurrentSetCollection(int capacity) {
        super(capacity);
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public void clear() {
        this.doWriteLockOperation(true, () -> {
            this.set.clear();
            this.count.set(0);
            return true;
        });
    }

    @Override
    public boolean isEmpty() {
        return this.count.get() == 0;
    }

    public boolean offer(E e) {
        if (e == null) {
            return false;
        }
        AtomicInteger count = this.count;
        if (count.get() == this.capacity) {
            return false;
        }
        int addCnt = this.doWriteLockOperation(false, () -> {
            if (!this.set.contains(e) && count.get() < this.capacity && this.set.add(e)) {
                return count.getAndIncrement();
            }
            return -1;
        });
        if (addCnt >= 0) {
            if (addCnt + 1 < this.capacity) {
                this.signalNotFull();
            }
            if (addCnt == 0) {
                this.signalNotEmpty();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        return this.doWriteLockOperation(true, () -> {
            if (this.set.remove(o)) {
                this.count.decrementAndGet();
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        return this.doWriteLockOperation(() -> {
            LinkedHashSet buf = new LinkedHashSet(c);
            buf.retainAll(this.set);
            if (!buf.isEmpty() && this.set.removeAll(buf)) {
                this.count.getAndAdd(-buf.size());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.doWriteLockOperation(() -> {
            LinkedHashSet buf = new LinkedHashSet(this.set);
            buf.removeAll(c);
            if (!buf.isEmpty() && this.set.removeAll(buf)) {
                this.count.getAndAdd(-buf.size());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.doWriteLockOperation(() -> this.set.contains(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.doWriteLockOperation(() -> this.set.containsAll(c));
    }

    @Override
    public Iterator<E> iterator() {
        return new CopyOnWriteArrayList(this.set).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.doWriteLockOperation(this.set::toArray);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.doWriteLockOperation(() -> this.set.toArray(a));
    }
}

