/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.collections.queue;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.fi.bd.util.collections.queue.ConcurrentSetCollection;

public abstract class ConcurrentSetQueue<E>
extends ConcurrentSetCollection<E>
implements Queue<E> {
    ConcurrentSetQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        return super.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        E result = null;
        int prevCnt = -1;
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock;
        writeLock.lock();
        try {
            if (count.get() > 0) {
                Object e = this.set.iterator().next();
                result = e;
                if (this.set.remove(e)) {
                    prevCnt = count.getAndDecrement();
                }
            }
        }
        finally {
            writeLock.unlock();
        }
        if (prevCnt >= 0) {
            if (prevCnt > 1) {
                this.signalNotEmpty();
            }
            if (prevCnt <= this.capacity) {
                this.signalNotFull();
            }
        }
        return result;
    }

    @Override
    public E element() {
        E x = this.peek();
        return (E)(x != null ? x : null);
    }

    @Override
    public E peek() {
        return (E)(this.count.get() <= 0 ? null : this.doWriteLockOperation(() -> this.set.iterator().next()));
    }

    @Override
    public E remove() {
        E x = this.poll();
        return (E)(x != null ? x : null);
    }
}

