/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.fi.bd.consts.DataValueTypeEnum;
import kd.fi.bd.consts.IByteCodeEnum;
import kd.fi.bd.model.common.BasePropModel;
import kd.fi.bd.model.common.IJsonArraySerialization;
import kd.fi.bd.util.bean.IDataBeanUtil;
import kd.fi.bd.util.data.IDataJsonUtil;
import org.apache.commons.beanutils.ConvertUtils;

public class IDataValueUtil {
    static final SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy.MM.dd"), new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM-dd-yyyy"), new SimpleDateFormat("MM.dd.yyyy"), new SimpleDateFormat("dd/MM/yyyy"), new SimpleDateFormat("dd-MM-yyyy"), new SimpleDateFormat("dd.MM.yyyy")};
    private static final Map<String, DynamicObjectPropertyCopyGroup> DynamicObject_CopyPropertyPool = new ConcurrentHashMap<String, DynamicObjectPropertyCopyGroup>(64);

    public static byte[] longToBytes(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public static long longFromByteArray(byte[] bytes) {
        Preconditions.checkArgument((bytes.length >= 8 ? 1 : 0) != 0, (String)"array too small: %s < %s", (int)bytes.length, (int)8);
        return IDataValueUtil.longFromBytes(bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]);
    }

    public static long longFromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    public static byte[] intToBytes(int value) {
        byte[] result = new byte[4];
        for (int i = 3; i >= 0; --i) {
            result[i] = (byte)((long)value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public static int intFromByteArray(byte[] bytes) {
        Preconditions.checkArgument((bytes.length >= 4 ? 1 : 0) != 0, (String)"array too small: %s < %s", (int)bytes.length, (int)4);
        return IDataValueUtil.intFromBytes(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    public static int intFromBytes(byte b1, byte b2, byte b3, byte b4) {
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static void enumerateObject(Object src, BiConsumer<Integer, Object> consumer) {
        if (src == null || consumer == null) {
            return;
        }
        switch (IDataValueUtil.getObjectEnumType(src)) {
            case 0: {
                consumer.accept(0, src);
                break;
            }
            case 1: {
                int i;
                for (Object v : (Collection)src) {
                    consumer.accept(i++, v);
                }
                break;
            }
            case 2: {
                int i;
                int length = Array.getLength(src);
                for (i = 0; i < length; ++i) {
                    consumer.accept(i, Array.get(src, i));
                }
                break;
            }
            case 3: {
                int i;
                Iterator it = (Iterator)src;
                while (it.hasNext()) {
                    consumer.accept(i++, it.next());
                }
            }
            default: {
                throw new IllegalArgumentException("Support Object Enum Type: " + IDataValueUtil.getObjectEnumType(src));
            }
        }
    }

    public static int getObjectEnumType(Object src) {
        if (src == null) {
            return -1;
        }
        if (src instanceof Collection) {
            return 1;
        }
        if (src.getClass().isArray()) {
            return 2;
        }
        if (src instanceof Iterator) {
            return 3;
        }
        return 0;
    }

    public static List<Object> enumerateObjectToList(Object srcValue) {
        if (srcValue == null) {
            return Collections.emptyList();
        }
        LinkedList<Object> result = new LinkedList<Object>();
        IDataValueUtil.enumerateObject(srcValue, (i, v) -> result.add(v));
        return result;
    }

    public static <T> List<T> enumerateObjectToList(Object srcValue, Function<Object, T> convertor) {
        if (srcValue == null) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        if (convertor != null) {
            IDataValueUtil.enumerateObject(srcValue, (i, v) -> result.add(convertor.apply(v)));
        } else {
            IDataValueUtil.enumerateObject(srcValue, (i, v) -> result.add(v));
        }
        return result;
    }

    public static <T> T[] enumerateObjectToArray(Object srcValue, Class<T> outputClass, Function<Object, T> convertor) {
        return IDataValueUtil.enumerateObjectToList(srcValue, convertor).toArray((Object[])Array.newInstance(outputClass, 0));
    }

    public static <T> T[] enumerateObjectToArray(Object srcValue, Class<T> outputClass) {
        return IDataValueUtil.enumerateObjectToList(srcValue, null).toArray((Object[])Array.newInstance(outputClass, 0));
    }

    public static Object[] concatToArray(Object ... params) {
        if (params == null || params.length <= 0) {
            return new Object[0];
        }
        LinkedList result = new LinkedList();
        for (Object obj : params) {
            if (obj == null) continue;
            IDataValueUtil.enumerateObject(obj, (i, v) -> result.add(v));
        }
        return result.toArray();
    }

    public static int[] convertIntListToArray(Collection<Integer> srcList, int defaultValue) {
        if (srcList == null || srcList.isEmpty()) {
            return new int[0];
        }
        int[] result = new int[srcList.size()];
        int i = 0;
        for (Integer v : srcList) {
            result[i++] = v != null ? v : defaultValue;
        }
        return result;
    }

    public static long[] convertLongListToArray(Collection<Long> srcList, long defaultValue) {
        if (srcList == null || srcList.isEmpty()) {
            return new long[0];
        }
        long[] result = new long[srcList.size()];
        int i = 0;
        for (Long v : srcList) {
            result[i++] = v != null ? v : defaultValue;
        }
        return result;
    }

    public static Class<?> getBaseDataTypeClass(String dataType) {
        if (dataType == null) {
            return null;
        }
        switch (dataType.toLowerCase(Locale.ENGLISH)) {
            case "string": {
                return String.class;
            }
            case "long": {
                return Long.class;
            }
            case "int": 
            case "integer": {
                return Integer.class;
            }
            case "date": {
                return Date.class;
            }
            case "double": 
            case "float": {
                return Double.class;
            }
            case "BigDecimal": {
                return BigDecimal.class;
            }
            case "BigInteger": {
                return BigInteger.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "char": {
                return Boolean.class;
            }
            case "character": {
                return Character.class;
            }
        }
        throw new IllegalArgumentException("Not Support Class Type:" + dataType);
    }

    public static String iteratorToString(Iterator<?> sourceIterator, String delimiter, String defaultValue, boolean skipNullValue) {
        if (sourceIterator == null) {
            return defaultValue;
        }
        StringBuilder builder = new StringBuilder();
        boolean defaultSameAsDelimiter = delimiter.equals(defaultValue);
        boolean lastValueIsDelimiter = false;
        while (sourceIterator.hasNext()) {
            Object val = sourceIterator.next();
            if (val != null) {
                if (builder.length() > 0 && !lastValueIsDelimiter) {
                    builder.append(delimiter);
                }
                builder.append(val);
                lastValueIsDelimiter = false;
                continue;
            }
            if (skipNullValue) continue;
            if (builder.length() > 0 && !defaultSameAsDelimiter) {
                builder.append(delimiter);
            }
            builder.append(defaultValue);
            lastValueIsDelimiter = defaultSameAsDelimiter;
        }
        return builder.toString();
    }

    public static String iteratorToString(Iterator<?> sourceIterator, String delimiter) {
        return IDataValueUtil.iteratorToString(sourceIterator, delimiter, null, true);
    }

    public static String arrayToString(Object[] a, char delimiter, boolean skipNullValue) {
        if (a == null) {
            return null;
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            if (a[i] != null || !skipNullValue) {
                b.append(a[i]);
                if (i == iMax) {
                    return b.toString();
                }
                b.append(delimiter);
            }
            ++i;
        }
    }

    public static String arrayToString(Object[] a) {
        return IDataValueUtil.arrayToString(a, ',', true);
    }

    public static boolean isSpliterChar(String srcText, int pos) {
        if (pos < 0 || pos >= srcText.length()) {
            return true;
        }
        char check = srcText.charAt(pos);
        switch (check) {
            case ' ': 
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ';': 
            case '[': 
            case ']': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    public static String replaceIgnoreCase(String srcText, String lookupValue, String replaceValue) {
        if (srcText == null || lookupValue == null || replaceValue == null) {
            return srcText;
        }
        int lookupKeyLength = lookupValue.length();
        lookupValue = lookupValue.toLowerCase();
        String lookText = srcText.toLowerCase();
        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        int lookupIndex = 0;
        while ((lookupIndex = lookText.indexOf(lookupValue, lookupIndex)) >= 0) {
            if (IDataValueUtil.isSpliterChar(srcText, lookupIndex + lookupKeyLength) && startIndex <= lookupIndex) {
                result.append(srcText.substring(startIndex, lookupIndex)).append(replaceValue);
                startIndex = lookupIndex + lookupKeyLength;
            }
            lookupIndex += lookupKeyLength;
        }
        if (startIndex < srcText.length()) {
            result.append(srcText.substring(startIndex));
        }
        return result.toString();
    }

    public static IDataEntityProperty getDataEntityProperty(DynamicObject sourceDyn, String propertyName) {
        return (IDataEntityProperty)sourceDyn.getDataEntityType().getProperties().get((Object)propertyName);
    }

    public static <T> T getDynPropValue(DynamicObject sourceDyn, String propertyName, Class<T> clazzType) {
        IDataEntityProperty prop = IDataValueUtil.getDataEntityProperty(sourceDyn, propertyName);
        if (prop == null) {
            return null;
        }
        return (T)ObjectConverter.convert((Object)prop.getValueFast((Object)sourceDyn), clazzType, (boolean)false);
    }

    public static Object getDynPropValue(DynamicObject sourceDyn, String propertyName) {
        IDataEntityProperty prop = IDataValueUtil.getDataEntityProperty(sourceDyn, propertyName);
        return prop == null ? null : prop.getValueFast((Object)sourceDyn);
    }

    public static BasePropModel getBasePropModel(DynamicObject sourceDynamicObject, String propertyName) {
        return IDataValueUtil.getBasePropObject(sourceDynamicObject, propertyName, BasePropModel.class);
    }

    public static <T> T getBasePropObject(DynamicObject sourceDynamicObject, String propertyName, Class<T> targetClass) {
        if (sourceDynamicObject == null) {
            return null;
        }
        DynamicObject dynBuf = IDataValueUtil.getDynPropValue(sourceDynamicObject, propertyName, DynamicObject.class);
        if (dynBuf != null) {
            try {
                return IDataBeanUtil.getConstructor(targetClass, DynamicObject.class).newInstance(dynBuf);
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, new ErrorCode(null, ex.getMessage()), new Object[0]);
            }
        }
        return null;
    }

    public static final <T> T getClassNewInstance(Class<T> targetClass) {
        try {
            return targetClass.newInstance();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode(null, e.getMessage()), new Object[0]);
        }
    }

    public static <T> Class getEntityPropValueDataType(IDataEntityProperty entityProp) {
        Class dataTypeClass = entityProp.getPropertyType();
        return dataTypeClass;
    }

    public static void setEntityPropValue(IDataEntityProperty entityProp, DynamicObject dataEntity, Object newValue) {
        Class dataTypeClass = entityProp.getPropertyType();
        if (Date.class.isAssignableFrom(dataTypeClass)) {
            newValue = IDataValueUtil.getDate(newValue);
        } else if (Boolean.class.isAssignableFrom(dataTypeClass) || Boolean.TYPE.isAssignableFrom(dataTypeClass)) {
            newValue = IDataValueUtil.getBoolean(newValue);
        }
        entityProp.setValueFast((Object)dataEntity, newValue);
    }

    public static Long dumpDateValue(Date srcDate) {
        return srcDate != null ? Long.valueOf(srcDate.getTime()) : null;
    }

    public static Byte getByteCodeEnumCode(IByteCodeEnum<?> val) {
        return val == null ? null : Byte.valueOf(val.getCode());
    }

    public static String getByteCodeEnumCodeString(IByteCodeEnum<?> val) {
        return val == null ? null : val.getCodeString();
    }

    public static JSONObject toJSONObject(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof JSONObject) {
            return (JSONObject)source;
        }
        throw new IllegalArgumentException(String.format("Expect JSONObject, but accutal=%s", source.getClass().getName()));
    }

    public static JSONArray toJSONArray(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            String jsonStr = source.toString();
            if (IDataJsonUtil.isJSonFormat(jsonStr, new String[0])) {
                return IDataValueUtil.toJSONArray(IDataJsonUtil.parseObject(jsonStr, new Feature[0]));
            }
        } else {
            if (source instanceof JSONArray) {
                return (JSONArray)source;
            }
            if (source instanceof JSONObject) {
                return ((JSONObject)source).getJSONArray("v");
            }
        }
        throw new IllegalArgumentException(String.format("Expect JSONObject or JSONArray, but accutal[Class=%s]=%s", source.getClass().getName(), source));
    }

    public static <T> T toBasePropObject(Object source, Class<T> targetClassType) {
        if (source == null) {
            return null;
        }
        if (targetClassType.isAssignableFrom(source.getClass())) {
            return targetClassType.cast(source);
        }
        if (source instanceof JSONArray) {
            return IDataValueUtil.jsonArrayToObject((JSONArray)source, targetClassType);
        }
        if (source instanceof JSONObject) {
            return IDataValueUtil.jsonArrayToObject(((JSONObject)source).getJSONArray("v"), targetClassType);
        }
        throw new IllegalArgumentException(String.format("Expect JSONObject or JSONArray, but accutal=%s", source.getClass().getName()));
    }

    public static <T> T jsonArrayToObject(JSONArray sourceValue, Class<T> targetClassType) {
        if (sourceValue == null) {
            return null;
        }
        try {
            return IDataBeanUtil.getConstructor(targetClassType, JSONArray.class).newInstance(sourceValue);
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode(null, ex.getMessage()), new Object[0]);
        }
    }

    public static boolean parseFromJSONArray(JSONArray jsonArray, IJsonArraySerialization target) {
        if (target != null && jsonArray != null && !jsonArray.isEmpty()) {
            target.setV(jsonArray.toArray());
            return true;
        }
        return false;
    }

    public static Object getObject(Object[] v, int index) {
        return v == null || index < 0 || index >= v.length ? null : v[index];
    }

    public static BasePropModel getBasePropModel(Object[] objectArray, int index) {
        return IDataValueUtil.getBasePropObject(objectArray, index, BasePropModel.class);
    }

    public static JSONArray getJSONArray(Object[] objectArray, int index) {
        return IDataValueUtil.toJSONArray(objectArray[index]);
    }

    public static JSONObject getJSONObject(Object[] objectArray, int index) {
        return IDataValueUtil.toJSONObject(objectArray[index]);
    }

    public static <T> T getBasePropObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.toBasePropObject(objectArray[index], targetClassType);
    }

    public static <T> T[] getArrayObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.parseArrayObject(objectArray[index], targetClassType);
    }

    public static <T> T[] parseArrayObject(Object sourceObject, Class<T> targetClassType) {
        JSONArray targetJsonArray = IDataValueUtil.toJSONArray(sourceObject);
        return targetJsonArray == null ? null : targetJsonArray.toArray((Object[])Array.newInstance(targetClassType, 0));
    }

    public static <T> T[][] getArraysObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.parseArraysObject(objectArray[index], targetClassType);
    }

    public static <T> T[][] parseArraysObject(Object sourceObject, Class<T> targetClassType) {
        JSONArray targetJsonArray = IDataValueUtil.toJSONArray(sourceObject);
        if (targetJsonArray == null) {
            return null;
        }
        int size = targetJsonArray.size();
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(size);
        Object[] templateClass = (Object[])Array.newInstance(targetClassType, 0);
        for (int i = 0; i < size; ++i) {
            JSONArray subArrayBuf = targetJsonArray.getJSONArray(i);
            if (subArrayBuf == null) continue;
            resultList.add(subArrayBuf.toArray(templateClass));
        }
        return (Object[][])resultList.toArray((T[])((Object[][])Array.newInstance(templateClass.getClass(), 0)));
    }

    public static Map<String, Object> parseMap(JSONObject sourceObject) {
        return sourceObject == null ? new LinkedHashMap<String, Object>(0) : new LinkedHashMap(sourceObject);
    }

    public static Map<String, Object> parseMap(Object[] objectArray, int index) {
        return IDataValueUtil.parseMap(IDataValueUtil.getJSONObject(objectArray, index));
    }

    public static int[] getIntArray(Object[] objectArray, int index) {
        return IDataValueUtil.getIntArray(objectArray[index]);
    }

    public static int[] getIntArray(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        int[] result = new int[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].intValue();
            }
        }
        return result;
    }

    public static long[] getLongArray(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        long[] result = new long[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].longValue();
            }
        }
        return result;
    }

    public static Long[] getLongArrayEx(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        Long[] result = new Long[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].longValue();
            }
        }
        return result;
    }

    public static Long[] getLongArrayEx(Object[] v, int index) {
        return IDataValueUtil.getLongArrayEx(v[index]);
    }

    public static long[] getLongArray(Object[] v, int index) {
        return IDataValueUtil.getLongArray(v[index]);
    }

    public static Boolean getBoolean(Object[] v, int index) {
        return IDataValueUtil.getBoolean(IDataValueUtil.getObject(v, index));
    }

    public static Byte getByte(Object[] v, int index) {
        Object value = IDataValueUtil.getObject(v, index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return Byte.valueOf(value.toString());
    }

    public static String getString(Object[] v, int index, boolean trim) {
        Object value = IDataValueUtil.getObject(v, index);
        if (value == null) {
            return null;
        }
        return trim ? String.valueOf(value).trim() : String.valueOf(value);
    }

    public static String getString(Object[] v, int index) {
        return IDataValueUtil.getString(v, index, false);
    }

    public static String getString(Object value) {
        return IDataValueUtil.getString(value, false);
    }

    public static String getString(Object value, boolean trim) {
        if (value == null) {
            return null;
        }
        return trim ? String.valueOf(value).trim() : String.valueOf(value);
    }

    public static Date getDate(Object[] v, int index) {
        return IDataValueUtil.getDate(IDataValueUtil.getObject(v, index));
    }

    public static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof Date) {
            return (Date)ObjectConverter.convert((Object)value, Date.class, (boolean)false);
        }
        if (value instanceof String) {
            String srcBuf = (String)value;
            if (srcBuf.contains("/") || srcBuf.contains("-") || srcBuf.contains(".")) {
                for (SimpleDateFormat formatter : dateFormats) {
                    try {
                        return formatter.parse(srcBuf);
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                try {
                    return new Date(Long.parseLong((String)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Integer getInteger(Object[] v, int index) {
        return IDataValueUtil.getInteger(IDataValueUtil.getObject(v, index));
    }

    public static Short getShort(Object[] v, int index) {
        return IDataValueUtil.getShort(IDataValueUtil.getObject(v, index));
    }

    public static Long getLong(Object[] v, int index) {
        return IDataValueUtil.getLong(IDataValueUtil.getObject(v, index));
    }

    public static Double getDouble(Object[] v, int index) {
        return IDataValueUtil.getDouble(IDataValueUtil.getObject(v, index));
    }

    public static Float getFloat(Object[] v, int index) {
        return IDataValueUtil.getFloat(IDataValueUtil.getObject(v, index));
    }

    public static <T> T convertValue(DataValueTypeEnum dataValueType, Object source) {
        DataValueTypeEnum v1 = dataValueType;
        Object v2 = null;
        switch (v1) {
            case Date: {
                v2 = IDataValueUtil.getDate(source);
                break;
            }
            case BaseProp: {
                BasePropModel baseProp = null;
                if (IDataJsonUtil.isJSonFormat(String.valueOf(source), "v") && (baseProp = IDataValueUtil.toBasePropObject(source, BasePropModel.class)) != null) {
                    v2 = baseProp;
                }
                if (baseProp != null) break;
                v2 = Long.valueOf(String.valueOf(source));
                break;
            }
            case Double: {
                v2 = Double.valueOf(String.valueOf(source));
                break;
            }
            case Int: {
                v2 = Integer.valueOf(String.valueOf(source));
                break;
            }
            case String: {
                v2 = String.valueOf(source);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Not Support DataValueType:%s, Object=%s", v1, source.toString()));
            }
        }
        return (T)v2;
    }

    public static Long getLong(Object value) {
        return value == null ? null : (Long)ObjectConverter.convert((Object)value, Long.class, (boolean)false);
    }

    public static Long[] parseObjectArray(Object[] value, Class targetClassType) {
        return value == null ? null : (Long[])ConvertUtils.convert((Object)value, Long[].class);
    }

    public static Double getDouble(Object value) {
        return value == null ? null : (Double)ObjectConverter.convert((Object)value, Double.class, (boolean)false);
    }

    public static Boolean getBoolean(Object value) {
        if (value != null) {
            String code;
            switch (code = String.valueOf(value).toLowerCase(Locale.ENGLISH)) {
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "1": {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public static BigDecimal getBigDecimal(Object value) {
        return value == null ? null : (BigDecimal)ObjectConverter.convert((Object)value, BigDecimal.class, (boolean)false);
    }

    public static Byte getByte(Object value) {
        return value == null ? null : (Byte)ObjectConverter.convert((Object)value, Byte.class, (boolean)false);
    }

    public static LocaleString getLocaleString(Object value) {
        return value == null ? null : (LocaleString)ObjectConverter.convert((Object)value, LocaleString.class, (boolean)false);
    }

    public static Float getFloat(Object value) {
        return value == null ? null : (Float)ObjectConverter.convert((Object)value, Float.class, (boolean)false);
    }

    public static Short getShort(Object value) {
        return value == null ? null : (Short)ObjectConverter.convert((Object)value, Short.class, (boolean)false);
    }

    public static Integer getInteger(Object value) {
        return value == null ? null : (Integer)ObjectConverter.convert((Object)value, Integer.class, (boolean)false);
    }

    private static Class getIntegerNumberType(String srcValue) {
        BigInteger temp;
        if (srcValue.toUpperCase().contains("E")) {
            return BigDecimal.class;
        }
        if (srcValue.contains(".")) {
            return srcValue.length() > 9 ? BigDecimal.class : Double.class;
        }
        int len = srcValue.length();
        if (len > 19 || (temp = new BigInteger(srcValue)).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || temp.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            return BigInteger.class;
        }
        if (len > 10 || Long.parseLong(srcValue) > Integer.MAX_VALUE || Long.parseLong(srcValue) < Integer.MIN_VALUE) {
            return Long.class;
        }
        if (srcValue.equals(Integer.valueOf(srcValue).toString())) {
            return Integer.class;
        }
        return BigDecimal.class;
    }

    public static Boolean isBooleanValue(Object value) {
        if (value != null) {
            String code;
            switch (code = String.valueOf(value).toLowerCase(Locale.ENGLISH)) {
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "1": 
                case "n": 
                case "no": 
                case "f": 
                case "false": 
                case "0": {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public static Class parseObjectDataType(Object srcObject) {
        if (srcObject == null) {
            return String.class;
        }
        if (srcObject instanceof String) {
            String srcBuf = ((String)srcObject).trim();
            if (srcBuf.length() <= 0) {
                return String.class;
            }
            try {
                srcBuf = srcBuf.replaceAll(",", "");
                if (srcBuf.length() <= 0) {
                    return String.class;
                }
                IDataValueUtil.getBigDecimal(srcBuf);
                String[] vals = srcBuf.split("\\.");
                switch (vals.length) {
                    case 1: {
                        return IDataValueUtil.getIntegerNumberType(vals[0]);
                    }
                    case 2: {
                        Class high = IDataValueUtil.getIntegerNumberType(vals[0]);
                        Class low = IDataValueUtil.getIntegerNumberType("0." + vals[1]);
                        if (BigInteger.class.isAssignableFrom(high) || BigInteger.class.isAssignableFrom(low) || BigDecimal.class.isAssignableFrom(high) || BigDecimal.class.isAssignableFrom(low)) {
                            return BigDecimal.class;
                        }
                        return Double.class;
                    }
                }
                return String.class;
            }
            catch (Exception ex) {
                if (srcBuf.contains("/") || srcBuf.contains("-") || srcBuf.contains(".")) {
                    for (SimpleDateFormat formatter : dateFormats) {
                        try {
                            formatter.parse(srcBuf);
                            return Date.class;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (IDataValueUtil.isBooleanValue(srcBuf).booleanValue()) {
                    return Boolean.class;
                }
                return String.class;
            }
        }
        return srcObject.getClass();
    }

    public static Date getDate(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        for (SimpleDateFormat formatter : dateFormats) {
            try {
                return formatter.parse(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static boolean isInRange(Integer srcValue, Integer smallValue, Integer bigValue) {
        return srcValue >= smallValue && srcValue <= bigValue;
    }

    public static DataValueTypeEnum getDataType(IDataEntityProperty fieldProp) {
        if (fieldProp != null) {
            Class propType = fieldProp.getPropertyType();
            if (Number.class.isAssignableFrom(propType)) {
                if (Integer.class.isAssignableFrom(propType) || Long.class.isAssignableFrom(propType) || Short.class.isAssignableFrom(propType) || Byte.class.isAssignableFrom(propType)) {
                    return DataValueTypeEnum.Int;
                }
                return DataValueTypeEnum.Double;
            }
            if (Date.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.Date;
            }
            if (Boolean.class.isAssignableFrom(propType) || Boolean.TYPE.isAssignableFrom(propType)) {
                return DataValueTypeEnum.Bool;
            }
            if (DynamicObject.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.BaseProp;
            }
            if (String.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.String;
            }
        }
        return DataValueTypeEnum.String;
    }

    public static IDataEntityProperty[] getDynamicObjectProperty(DataEntityPropertyCollection srcEntityProps, String[] propertyNames) {
        if (propertyNames == null || propertyNames.length <= 0) {
            return new DynamicProperty[0];
        }
        IDataEntityProperty[] pReaders = new IDataEntityProperty[propertyNames.length];
        for (int i = 0; i < pReaders.length; ++i) {
            pReaders[i] = (IDataEntityProperty)srcEntityProps.get((Object)propertyNames[i]);
            if (pReaders[i] != null) continue;
            throw new IllegalArgumentException("Cannot retrieve Property: " + propertyNames[i] + "; PropertyNames=" + Arrays.deepToString(propertyNames));
        }
        return pReaders;
    }

    public static boolean copyDynamicObjectValue(DynamicObject outputTarget, DynamicObject valueSrc, DynamicProperty[][] copyProperties) {
        if (copyProperties == null || outputTarget == null || valueSrc == null) {
            return false;
        }
        for (DynamicProperty[] copyProperty : copyProperties) {
            copyProperty[1].setDTValueFast(outputTarget, copyProperty[0].getDTValueFast(valueSrc));
        }
        return true;
    }

    public static boolean copyDynamicObjectValue(DynamicObject outputTarget, DynamicObject valueSrc, String groupKey, String[][] copyProperties) {
        DynamicProperty[][] _copyProperty;
        if (copyProperties == null || outputTarget == null || valueSrc == null) {
            return false;
        }
        for (DynamicProperty[] copyProperty : _copyProperty = IDataValueUtil.getDynamicObjectCopyPropertyGroup(groupKey, outputTarget.getDataEntityType().getName(), valueSrc.getDataEntityType().getName(), copyProperties)) {
            copyProperty[1].setDTValueFast(outputTarget, copyProperty[0].getDTValueFast(valueSrc));
        }
        return true;
    }

    public static DynamicProperty[][] getDynamicObjectCopyProperty(DataEntityPropertyCollection outputTarget, DataEntityPropertyCollection valueSrc, String[][] copyProperties) {
        if (copyProperties == null || outputTarget == null || valueSrc == null) {
            return null;
        }
        if (copyProperties.length <= 0) {
            return new DynamicProperty[0][];
        }
        DynamicProperty[][] result = new DynamicProperty[copyProperties.length][2];
        int i = 0;
        for (String[] proper : copyProperties) {
            result[i++] = new DynamicProperty[]{(DynamicProperty)valueSrc.get((Object)proper[0]), (DynamicProperty)outputTarget.get((Object)proper[1])};
        }
        return result;
    }

    public static DynamicProperty[][] getDynamicObjectCopyProperty(DynamicObject outputTarget, DynamicObject valueSrc, String[][] copyProperties) {
        if (copyProperties == null || outputTarget == null || valueSrc == null) {
            return null;
        }
        return IDataValueUtil.getDynamicObjectCopyProperty(outputTarget.getDataEntityType().getProperties(), valueSrc.getDataEntityType().getProperties(), copyProperties);
    }

    public static DynamicProperty[][] getDynamicObjectCopyProperty(String outputTargetEntity, String valueSrcEntity, String[][] copyProperties) {
        if (copyProperties == null || outputTargetEntity == null || valueSrcEntity == null) {
            return null;
        }
        return IDataValueUtil.getDynamicObjectCopyProperty(EntityMetadataCache.getDataEntityType((String)outputTargetEntity).getProperties(), EntityMetadataCache.getDataEntityType((String)valueSrcEntity).getProperties(), copyProperties);
    }

    public static DynamicProperty[][] getDynamicObjectCopyPropertyGroup(String groupKey, String outputTargetEntityName, String valueSrcEntityName, String[][] copyPropertyNames) {
        return IDataValueUtil.DynamicObject_CopyPropertyPool.computeIfAbsent((String)groupKey, (Function<String, DynamicObjectPropertyCopyGroup>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getDynamicObjectCopyPropertyGroup$4(java.lang.String java.lang.String java.lang.String java.lang.String[][] java.lang.String ), (Ljava/lang/String;)Lkd/fi/bd/util/data/IDataValueUtil$DynamicObjectPropertyCopyGroup;)((String)groupKey, (String)outputTargetEntityName, (String)valueSrcEntityName, (String[][])copyPropertyNames))._copyProperties;
    }

    private static /* synthetic */ DynamicObjectPropertyCopyGroup lambda$getDynamicObjectCopyPropertyGroup$4(String groupKey, String outputTargetEntityName, String valueSrcEntityName, String[][] copyPropertyNames, String v) {
        return new DynamicObjectPropertyCopyGroup(groupKey, outputTargetEntityName, valueSrcEntityName, copyPropertyNames);
    }

    public static class DynamicObjectPropertyCopyGroup
    implements Serializable {
        String groupKey;
        String outputTargetEntity;
        String valueSrcEntity;
        String[][] copyPropertyNames;
        final DynamicProperty[][] _copyProperties;

        public DynamicObjectPropertyCopyGroup(String groupKey, String outputTargetEntity, String valueSrcEntity, String[][] copyPropertyNames) {
            if (copyPropertyNames == null || outputTargetEntity == null || valueSrcEntity == null) {
                throw new IllegalArgumentException();
            }
            this.groupKey = groupKey;
            this.outputTargetEntity = outputTargetEntity;
            this.valueSrcEntity = valueSrcEntity;
            this.copyPropertyNames = copyPropertyNames;
            this._copyProperties = IDataValueUtil.getDynamicObjectCopyProperty(outputTargetEntity, valueSrcEntity, copyPropertyNames);
        }

        public String getOutputTargetEntity() {
            return this.outputTargetEntity;
        }

        public String getValueSrcEntity() {
            return this.valueSrcEntity;
        }

        public String[][] getCopyPropertyNames() {
            return this.copyPropertyNames;
        }

        public DynamicProperty[][] getCopyProperties() {
            return this._copyProperties;
        }
    }
}

