/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.filter.BaseLookupWildcardKey;
import kd.fi.bd.util.filter.ILookupKeyInfo;
import kd.fi.bd.util.filter.IStoredWildcardKey;
import kd.fi.bd.util.filter.WildcardPositionEnum;

public class WildcardMatcher<T> {
    private boolean allowOverwriteAdd;
    protected Map<IStoredWildcardKey, T> keyMatchMaps;
    protected Set<Integer>[] registeredKeyLengthInfos;
    private static final WildcardPositionEnum[] CanRelength_Positions = new WildcardPositionEnum[]{WildcardPositionEnum.Suffix, WildcardPositionEnum.Prefix};
    private final boolean caseSensitive;
    private char[] wildcardKeys;
    private T globalMatchValue = null;
    public static final char[] Default_WildcardKeys = new char[]{'%', '*'};

    public WildcardMatcher(boolean caseSensitive, boolean allowOverwriteAdd, char ... customWildcardKeys) {
        this(caseSensitive, allowOverwriteAdd);
        if (customWildcardKeys != null && customWildcardKeys.length > 0) {
            this.wildcardKeys = customWildcardKeys;
        }
    }

    public WildcardMatcher(boolean caseSensitive, boolean allowOverwriteAdd) {
        this.caseSensitive = caseSensitive;
        this.allowOverwriteAdd = allowOverwriteAdd;
        this.keyMatchMaps = new HashMap<IStoredWildcardKey, T>(4);
        this.registeredKeyLengthInfos = new LinkedHashSet[CanRelength_Positions.length];
        for (int i = 0; i < this.registeredKeyLengthInfos.length; ++i) {
            this.registeredKeyLengthInfos[i] = new LinkedHashSet<Integer>(2);
        }
        this.wildcardKeys = Default_WildcardKeys;
    }

    public WildcardMatcher(boolean caseSensitive) {
        this(caseSensitive, false);
    }

    public void packBeforeMatch() {
        for (int i = 0; i < this.registeredKeyLengthInfos.length; ++i) {
            ArrayList<Integer> sortBuf = new ArrayList<Integer>(this.registeredKeyLengthInfos[i]);
            Collections.sort(sortBuf);
            this.registeredKeyLengthInfos[i] = new LinkedHashSet<Integer>(sortBuf);
        }
    }

    public boolean isEmpty() {
        return this.keyMatchMaps.isEmpty() && this.globalMatchValue == null;
    }

    public int size() {
        return this.keyMatchMaps.size();
    }

    public int getTotalMatchKeyCnt() {
        return this.keyMatchMaps.size() + (this.globalMatchValue != null ? 1 : 0);
    }

    public String getObjectKey(Object srcObject) {
        return WildcardMatcher.getObjectKey(srcObject, this.caseSensitive);
    }

    public static String getObjectKey(Object srcObject, boolean caseSensitive) {
        String result;
        if (srcObject == null) {
            return null;
        }
        if (srcObject instanceof String) {
            result = (String)srcObject;
        } else {
            LinkedList buf = new LinkedList();
            IDataValueUtil.enumerateObject(srcObject, (i, v) -> buf.add(v));
            result = buf.size() == 1 ? String.valueOf(buf.getFirst()) : Arrays.deepToString(buf.toArray());
        }
        return caseSensitive ? result : result.toLowerCase();
    }

    public static IStoredWildcardKey buildStoredWildcardKey(String srcKey, WildcardPositionEnum wildcardPosition) {
        return WildcardMatcher.buildStoredWildcardKey(srcKey, wildcardPosition, Default_WildcardKeys);
    }

    public static IStoredWildcardKey buildStoredWildcardKey(String srcKey, WildcardPositionEnum wildcardPosition, char[] wildcardKeys) {
        if (srcKey == null) {
            return null;
        }
        switch (wildcardPosition) {
            case Suffix: 
            case Prefix: {
                srcKey = WildcardMatcher.trimWildcardKeys(wildcardPosition, srcKey, wildcardKeys);
                break;
            }
        }
        return new BaseLookupWildcardKey(srcKey, wildcardPosition);
    }

    public ILookupKeyInfo buildLookupKeyInfo(Object srcKey) {
        return srcKey == null ? null : new BaseLookupWildcardKey(this.getObjectKey(srcKey));
    }

    public boolean addMatchKey(IStoredWildcardKey lookupKey, T value) {
        if (lookupKey == null) {
            return false;
        }
        if (!this.allowOverwriteAdd && this.keyMatchMaps.containsKey(lookupKey)) {
            return false;
        }
        this.keyMatchMaps.put(lookupKey, value);
        switch (lookupKey.getWildcardPosition()) {
            case Suffix: {
                this.registeredKeyLengthInfos[0].add(lookupKey.getKeyLength());
                break;
            }
            case Prefix: {
                this.registeredKeyLengthInfos[1].add(lookupKey.getKeyLength());
                break;
            }
        }
        return true;
    }

    public boolean addMatchKey(Object srcKey, T value, WildcardPositionEnum wildcardPosition) {
        boolean result = false;
        if (wildcardPosition == null) {
            if (this.allowOverwriteAdd || this.globalMatchValue == null) {
                this.globalMatchValue = value;
                result = true;
            }
        } else {
            result = this.addMatchKey(WildcardMatcher.buildStoredWildcardKey(this.getObjectKey(srcKey), wildcardPosition), value);
        }
        return result;
    }

    public boolean addMatchKey(Object srcKey, T value) {
        String key = this.getObjectKey(srcKey);
        if (key == null) {
            return false;
        }
        WildcardPositionEnum position = WildcardMatcher.getWildcardPos(key, this.wildcardKeys);
        switch (position) {
            case Suffix: 
            case Prefix: {
                break;
            }
            case Global: {
                if (!this.allowOverwriteAdd && this.globalMatchValue != null) {
                    return false;
                }
                this.globalMatchValue = value;
                return true;
            }
            default: {
                position = WildcardPositionEnum.None;
            }
        }
        return this.addMatchKey(WildcardMatcher.buildStoredWildcardKey(key, position), value);
    }

    public static WildcardPositionEnum getWildcardPos(String srcKey, char ... wildcardKey) {
        if (srcKey == null || srcKey.length() <= 0 || wildcardKey == null || wildcardKey.length <= 0) {
            return WildcardPositionEnum.None;
        }
        int result = 0;
        int flipCnt = 0;
        char prevChar = wildcardKey[0];
        char[] checkArray = srcKey.toCharArray();
        int length = checkArray.length;
        for (int i = 0; i < checkArray.length; ++i) {
            if (WildcardMatcher.isWildCardKey(checkArray[i], wildcardKey)) {
                if (i == 0) {
                    result |= WildcardPositionEnum.Prefix.value;
                } else if (i == length - 1) {
                    result |= WildcardPositionEnum.Suffix.value;
                }
            }
            if (prevChar == checkArray[i] || WildcardMatcher.isWildCardKey(prevChar, wildcardKey) == WildcardMatcher.isWildCardKey(checkArray[i], wildcardKey)) continue;
            prevChar = checkArray[i];
            if (++flipCnt < 3) continue;
            result |= WildcardPositionEnum.Mid.value;
            if (!WildcardMatcher.isWildCardKey(checkArray[length - 1], wildcardKey)) break;
            result |= WildcardPositionEnum.Suffix.value;
            break;
        }
        if (flipCnt == 0) {
            return WildcardPositionEnum.Global;
        }
        return WildcardPositionEnum.parse(result);
    }

    public static WildcardPositionEnum getWildcardPos(String srcKey) {
        return WildcardMatcher.getWildcardPos(srcKey, Default_WildcardKeys);
    }

    protected int getWildcardKeyPosIndex(String srcKey) {
        boolean found = false;
        boolean continueSearch = true;
        int checkIndex = srcKey.length() - 1;
        while (continueSearch && checkIndex >= 0) {
            continueSearch = this.isWildCardKey(srcKey.charAt(checkIndex));
            if (!continueSearch) continue;
            found = true;
            --checkIndex;
        }
        if (found) {
            return checkIndex;
        }
        continueSearch = checkIndex > 0;
        if (continueSearch) {
            for (int i = 0; continueSearch && i < checkIndex; ++i) {
                continueSearch = this.isWildCardKey(srcKey.charAt(i));
                if (!continueSearch) continue;
                found = true;
            }
            if (found) {
                return checkIndex;
            }
        }
        return -1;
    }

    public static String trimWildcardKeys(WildcardPositionEnum direction, String srcString, char ... wildcardKeys) {
        int index;
        if (WildcardPositionEnum.check(WildcardPositionEnum.Suffix, direction)) {
            for (index = srcString.length() - 1; index >= 0; --index) {
                if (WildcardMatcher.isWildCardKey(srcString.charAt(index), wildcardKeys)) continue;
                srcString = srcString.substring(0, index + 1);
                break;
            }
            if (index == -1) {
                return "";
            }
        }
        if (WildcardPositionEnum.check(WildcardPositionEnum.Prefix, direction)) {
            int length = srcString.length();
            for (index = 0; index < length; ++index) {
                if (WildcardMatcher.isWildCardKey(srcString.charAt(index), wildcardKeys)) continue;
                srcString = srcString.substring(index);
                break;
            }
            if (index == length) {
                return "";
            }
        }
        return srcString;
    }

    public static String trimWildcardKeys(WildcardPositionEnum direction, String srcString) {
        return WildcardMatcher.trimWildcardKeys(direction, srcString, Default_WildcardKeys);
    }

    public static String trimWildcardKeys(WildcardPositionEnum direction, Object srcValue) {
        if (srcValue == null) {
            return null;
        }
        return WildcardMatcher.trimWildcardKeys(direction, String.valueOf(srcValue), Default_WildcardKeys);
    }

    public static String addOrRemoveWildcard(WildcardPositionEnum direction, boolean addMode, Object value) {
        if (value == null) {
            return null;
        }
        String strValue = WildcardMatcher.getObjectKey(value, true);
        WildcardPositionEnum pos = WildcardMatcher.getWildcardPos(strValue);
        if (WildcardPositionEnum.check(WildcardPositionEnum.Suffix, direction) && !WildcardPositionEnum.check(WildcardPositionEnum.Suffix, pos)) {
            strValue = addMode ? strValue + Default_WildcardKeys[0] : WildcardMatcher.trimWildcardKeys(WildcardPositionEnum.Suffix, strValue);
        }
        if (WildcardPositionEnum.check(WildcardPositionEnum.Prefix, direction) && !WildcardPositionEnum.check(WildcardPositionEnum.Prefix, pos)) {
            strValue = addMode ? Default_WildcardKeys[0] + strValue : WildcardMatcher.trimWildcardKeys(WildcardPositionEnum.Prefix, strValue);
        }
        return strValue;
    }

    protected boolean isWildCardKey(char checkKey) {
        return WildcardMatcher.isWildCardKey(checkKey, this.wildcardKeys);
    }

    protected static boolean isWildCardKey(char checkKey, char[] wildcardKeys) {
        for (char c : wildcardKeys) {
            if (c != checkKey) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public PairTuple<WildcardPositionEnum, String> parseWildcardKey(String srcKey) {
        if (srcKey.length() == 1) {
            if (this.isWildCardKey(srcKey.charAt(0))) {
                return new PairTuple<WildcardPositionEnum, String>(WildcardPositionEnum.Global, srcKey);
            }
        } else {
            boolean found = false;
            boolean continueSearch = true;
            int checkIndex = srcKey.length() - 1;
            while (continueSearch && checkIndex >= 0) {
                continueSearch = this.isWildCardKey(srcKey.charAt(checkIndex));
                if (!continueSearch) continue;
                found = true;
                --checkIndex;
            }
            if (found) {
                if (checkIndex < 0) {
                    return new PairTuple<WildcardPositionEnum, Object>(WildcardPositionEnum.Global, null);
                }
                return new PairTuple<WildcardPositionEnum, String>(WildcardPositionEnum.Suffix, srcKey.substring(0, checkIndex + 1));
            }
            continueSearch = checkIndex > 0;
            if (continueSearch) {
                int i;
                for (i = 0; continueSearch && i < checkIndex; ++i) {
                    continueSearch = this.isWildCardKey(srcKey.charAt(i));
                    if (!continueSearch) continue;
                    found = true;
                }
                if (found) {
                    return new PairTuple<WildcardPositionEnum, String>(WildcardPositionEnum.Prefix, srcKey.substring(i - 1));
                }
            }
        }
        return new PairTuple<WildcardPositionEnum, String>(WildcardPositionEnum.None, srcKey);
    }

    public T getMatchValue(String targetValue) {
        if (targetValue == null) {
            return null;
        }
        return this.getMatchValue(new BaseLookupWildcardKey(this.caseSensitive ? targetValue : targetValue.toLowerCase()));
    }

    public T getMatchValue(Object targetValue) {
        return this.getMatchValue(this.buildLookupKeyInfo(targetValue));
    }

    public T getMatchValue(ILookupKeyInfo lookupKey) {
        if (lookupKey == null) {
            return null;
        }
        T result = this.keyMatchMaps.get(lookupKey);
        if (result == null) {
            int srcKeyLength = lookupKey.getKeyLength();
            for (int i = 0; i < CanRelength_Positions.length; ++i) {
                Set<Integer> regParseKeyList = this.registeredKeyLengthInfos[i];
                if (regParseKeyList.isEmpty()) continue;
                for (Integer keyLength : regParseKeyList) {
                    if (srcKeyLength < keyLength || !lookupKey.rebuildHashCode(CanRelength_Positions[i], keyLength) || (result = this.keyMatchMaps.get(lookupKey)) == null) continue;
                    return result;
                }
            }
        }
        return result == null ? this.globalMatchValue : result;
    }

    public boolean contains(Object targetValue) {
        return this.getMatchValue(targetValue) != null;
    }

    public boolean remove(ILookupKeyInfo lookupKey) {
        if (this.contains(lookupKey)) {
            this.keyMatchMaps.remove(lookupKey);
            return true;
        }
        return false;
    }

    public boolean remove(Object targetValue) {
        return this.remove(this.buildLookupKeyInfo(targetValue));
    }

    public int getAllMatchValues(ILookupKeyInfo lookupKey, BiConsumer<ILookupKeyInfo, T> matchValueConsumer) {
        int matchCnt = 0;
        T resultBuf = this.keyMatchMaps.get(lookupKey);
        if (resultBuf != null) {
            matchValueConsumer.accept(lookupKey, (ILookupKeyInfo)resultBuf);
            ++matchCnt;
        }
        for (int i = 0; i < CanRelength_Positions.length; ++i) {
            Set<Integer> regParseKeyList = this.registeredKeyLengthInfos[i];
            if (regParseKeyList.isEmpty()) continue;
            for (Integer keyLength : regParseKeyList) {
                if (!lookupKey.rebuildHashCode(CanRelength_Positions[i], keyLength) || (resultBuf = this.keyMatchMaps.get(lookupKey)) == null) continue;
                matchValueConsumer.accept(lookupKey, (ILookupKeyInfo)resultBuf);
                ++matchCnt;
            }
        }
        if (this.globalMatchValue != null) {
            matchValueConsumer.accept((ILookupKeyInfo)null, (ILookupKeyInfo)resultBuf);
            ++matchCnt;
        }
        return matchCnt;
    }

    public List<T> getAllMatchValues(String targetValue) {
        if (targetValue == null) {
            return null;
        }
        LinkedList resultList = new LinkedList();
        this.getAllMatchValues(new BaseLookupWildcardKey(this.caseSensitive ? targetValue : targetValue.toLowerCase()), (k, v) -> resultList.add(v));
        return resultList;
    }

    public List<T> getCloseMatchValues(String targetValue) {
        if (targetValue == null) {
            return null;
        }
        EnumMap matchValueBufMap = new EnumMap(WildcardPositionEnum.class);
        this.getAllMatchValues(new BaseLookupWildcardKey(this.caseSensitive ? targetValue : targetValue.toLowerCase()), (k, v) -> {
            int keyLength;
            WildcardPositionEnum positionEnum;
            if (k == null) {
                positionEnum = WildcardPositionEnum.Global;
                keyLength = 1;
            } else {
                positionEnum = k.getWildcardPosition();
                keyLength = k.getKeyLength();
            }
            matchValueBufMap.computeIfAbsent(positionEnum, x -> new LinkedHashSet()).add(new PairTuple<Integer, Object>(keyLength, v));
        });
        if (!matchValueBufMap.isEmpty()) {
            LinkedList resultList = new LinkedList();
            for (Map.Entry en : matchValueBufMap.entrySet()) {
                if (((Set)en.getValue()).isEmpty()) continue;
                ArrayList sortBuf = new ArrayList((Collection)en.getValue());
                Collections.sort(sortBuf, (oldVal, newVal) -> {
                    if (oldVal == null) {
                        return -1;
                    }
                    if (newVal == null) {
                        return 1;
                    }
                    return (Integer)oldVal.getKey() > (Integer)newVal.getKey() ? 1 : -1;
                });
                resultList.add(((PairTuple)sortBuf.get(sortBuf.size() - 1)).getValue());
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    public static <T> void matchValues(Iterator<T> srcValueIterator, WildcardPositionEnum matchPosition, Set<String> matchNames, Function<T, Boolean> processFunc) {
        if (srcValueIterator == null) {
            return;
        }
        if (matchPosition == null) {
            matchPosition = WildcardPositionEnum.Global;
        }
        if (matchPosition != WildcardPositionEnum.Global && (matchNames == null || matchNames.isEmpty())) {
            return;
        }
        while (srcValueIterator.hasNext()) {
            T val = srcValueIterator.next();
            String name = String.valueOf(val);
            boolean matched = false;
            switch (matchPosition) {
                case None: {
                    matched = matchNames.contains(name);
                    break;
                }
                case Suffix: 
                case Mid_Suffix: {
                    String p;
                    Iterator<String> iterator = matchNames.iterator();
                    while (iterator.hasNext() && !(matched = name.endsWith(p = iterator.next()))) {
                    }
                    break;
                }
                case Prefix: 
                case Pre_Mid: {
                    String p;
                    Iterator<String> iterator = matchNames.iterator();
                    while (iterator.hasNext() && !(matched = name.startsWith(p = iterator.next()))) {
                    }
                    break;
                }
                case Mid: 
                case Pre_Suffix: 
                case Pre_Mid_Suffix: {
                    String p;
                    Iterator<String> iterator = matchNames.iterator();
                    while (iterator.hasNext() && !(matched = name.contains(p = iterator.next()))) {
                    }
                    break;
                }
                default: {
                    matched = true;
                }
            }
            if (!matched || processFunc.apply(val).booleanValue()) continue;
            break;
        }
    }

    public static void filterSystemConfigured(WildcardPositionEnum matchPosition, Set<String> matchNames, BiFunction<String, String, Boolean> processFunc) {
        final Properties properties = System.getProperties();
        Iterator propIterator = new Iterator(){
            Enumeration propNames;
            {
                this.propNames = properties.propertyNames();
            }

            @Override
            public boolean hasNext() {
                return this.propNames.hasMoreElements();
            }

            public String next() {
                return String.valueOf(this.propNames.nextElement());
            }
        };
        WildcardMatcher.matchValues(propIterator, matchPosition, matchNames, name -> (Boolean)processFunc.apply((String)name, properties.getProperty((String)name)));
    }

    public boolean isAllowOverwriteAdd() {
        return this.allowOverwriteAdd;
    }

    public void setAllowOverwriteAdd(boolean allowOverwriteAdd) {
        this.allowOverwriteAdd = allowOverwriteAdd;
    }

    public char[] getWildcardKeys() {
        return this.wildcardKeys;
    }

    public void setWildcardKeys(char[] wildcardKeys) {
        this.wildcardKeys = wildcardKeys;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public T getGlobalMatchValue() {
        return this.globalMatchValue;
    }
}

