/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.filter;

public enum WildcardPositionEnum {
    None(0),
    Suffix(1),
    Mid(2),
    Mid_Suffix(3),
    Prefix(4),
    Pre_Suffix(5),
    Pre_Mid(6),
    Pre_Mid_Suffix(7),
    Global(8);

    int value;

    private WildcardPositionEnum(int value) {
        this.value = value;
    }

    public static WildcardPositionEnum parse(int value) {
        switch (value) {
            case 1: {
                return Suffix;
            }
            case 2: {
                return Mid;
            }
            case 3: {
                return Mid_Suffix;
            }
            case 4: {
                return Prefix;
            }
            case 5: {
                return Pre_Suffix;
            }
            case 6: {
                return Pre_Mid;
            }
            case 7: {
                return Pre_Mid_Suffix;
            }
            case 8: {
                return Global;
            }
        }
        return None;
    }

    public static boolean check(WildcardPositionEnum checkMask, WildcardPositionEnum ... checkTargets) {
        if (checkTargets == null || checkTargets.length <= 0) {
            return false;
        }
        int checkValue = checkMask.value;
        for (WildcardPositionEnum src : checkTargets) {
            if ((src.value & checkValue) == checkValue) continue;
            return false;
        }
        return true;
    }

    public int getValue() {
        return this.value;
    }
}

