/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators;

import java.util.function.BiFunction;
import kd.fi.bd.util.iterators.IBufferContextWrapper;

public abstract class AbstractBufferContextWrapper<BUF, SRC, OUT>
implements IBufferContextWrapper<SRC, OUT> {
    protected int bufferSize;
    protected boolean skipNullValue;
    protected int[] currentPos;
    protected BUF bufferContext;
    protected BiFunction<Integer, SRC, OUT> formatConvertFunc;
    protected boolean isBufferInitialized;

    public AbstractBufferContextWrapper(BUF batchBufferRef, boolean skipNullValue, BiFunction<Integer, SRC, OUT> formatConvertFunc) {
        this.bufferContext = batchBufferRef;
        if (this.bufferContext == null) {
            throw new IllegalArgumentException("Buffer Context Cannot be null!");
        }
        this.formatConvertFunc = formatConvertFunc;
        if (this.formatConvertFunc == null) {
            this.formatConvertFunc = (seq, val) -> val;
        }
        this.isBufferInitialized = true;
        this.currentPos = new int[2];
        this.skipNullValue = skipNullValue;
        this.bufferSize = 0;
    }

    protected AbstractBufferContextWrapper(boolean skipNullValue, BiFunction<Integer, SRC, OUT> formatConvertFunc) {
        this.formatConvertFunc = formatConvertFunc;
        if (this.formatConvertFunc == null) {
            this.formatConvertFunc = (seq, val) -> val;
        }
        this.isBufferInitialized = false;
        this.currentPos = new int[2];
        this.skipNullValue = skipNullValue;
        this.bufferSize = 0;
    }

    protected void lazyInitBuffer(BUF batchBufferRef, int batchSize) {
        this.bufferContext = batchBufferRef;
        if (this.bufferContext == null) {
            throw new IllegalArgumentException("Buffer Context Cannot be null!");
        }
        this.bufferSize = batchSize;
        this.isBufferInitialized = true;
    }

    public AbstractBufferContextWrapper(BUF batchBufferRef, boolean skipNullValue) {
        this(batchBufferRef, skipNullValue, null);
    }

    @Override
    public int getCurrentBatchNum() {
        return this.currentPos[0];
    }

    @Override
    public int getCurrentSeqNum() {
        return this.currentPos[1];
    }

    @Override
    public void reset(int batchNum) {
        this.currentPos[0] = batchNum;
        for (int i = 1; i < this.currentPos.length; ++i) {
            this.currentPos[i] = 0;
        }
    }

    @Override
    public boolean addValue(SRC newValue) {
        if (this.currentPos[1] >= this.bufferSize) {
            throw new IndexOutOfBoundsException(String.format("Buffer is full! (size=%s, new value=%s)", this.bufferContext, newValue));
        }
        if ((newValue != null || this.skipNullValue) && this.addValueIntoBuffer(this.currentPos[1], this.formatConvertFunc.apply(this.currentPos[1], newValue))) {
            this.currentPos[1] = this.currentPos[1] + 1;
            return this.currentPos[1] >= this.bufferSize;
        }
        return false;
    }

    protected abstract boolean addValueIntoBuffer(int var1, OUT var2);

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isSkipNullValue() {
        return this.skipNullValue;
    }

    public void setSkipNullValue(boolean skipNullValue) {
        this.skipNullValue = skipNullValue;
    }

    public BiFunction<Integer, SRC, OUT> getFormatConvertFunc() {
        return this.formatConvertFunc;
    }

    public void setFormatConvertFunc(BiFunction<Integer, SRC, OUT> formatConvertFunc) {
        this.formatConvertFunc = formatConvertFunc;
    }

    @Override
    public boolean isBufferInitialized() {
        return this.isBufferInitialized;
    }
}

