/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiFunction;

public class IteratorFormatConvertWrap<IN, OUT>
implements Iterator<OUT> {
    protected Iterator<IN> sourceIterator;
    protected BiFunction<Long, IN, OUT> formatConvertFunc;
    protected boolean keepNullValue;
    protected long currentPos;
    protected long iteratorCnt;
    protected boolean _hasValue;
    protected boolean needMoveNext;
    protected OUT currentBuffer;

    public IteratorFormatConvertWrap(Iterator<IN> sourceIterator, BiFunction<Long, IN, OUT> formatConvertFunc, boolean keepNullValue) {
        this.formatConvertFunc = formatConvertFunc;
        if (this.formatConvertFunc == null) {
            throw new IllegalArgumentException("Convert Function cannot be null!");
        }
        this.keepNullValue = keepNullValue;
        this.reset(sourceIterator);
    }

    public IteratorFormatConvertWrap(Iterator<IN> sourceIterator, BiFunction<Long, IN, OUT> formatConvertFunc) {
        this(sourceIterator, formatConvertFunc, false);
    }

    @Override
    public boolean hasNext() {
        if (this.keepNullValue) {
            return this._hasValue && this.sourceIterator.hasNext();
        }
        while (!this.needMoveNext && this._hasValue && this.sourceIterator.hasNext()) {
            this.needMoveNext = (this.currentBuffer = this.formatConvertFunc.apply(this.iteratorCnt++, this.sourceIterator.next())) != null;
        }
        return this.currentBuffer != null;
    }

    @Override
    public OUT next() {
        if (this.hasNext()) {
            if (this.keepNullValue) {
                return this.formatConvertFunc.apply(this.currentPos++, this.sourceIterator.next());
            }
            this.needMoveNext = false;
            return this.currentBuffer;
        }
        throw new IndexOutOfBoundsException("EOF");
    }

    public void reset(Iterator<IN> sourceIterator) {
        this.sourceIterator = sourceIterator;
        this._hasValue = this.sourceIterator != null;
        this.currentPos = 0L;
        this.iteratorCnt = 0L;
        this.needMoveNext = false;
    }

    public static void main(String[] args) {
        Integer[] testArray = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        IteratorFormatConvertWrap<Integer, Integer> it = new IteratorFormatConvertWrap<Integer, Integer>(Arrays.asList(testArray).iterator(), (seq, v) -> v % 2 == 0 ? v : null, false);
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

