/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Iterator<E> {
    private E[] sourceArray;
    private int pos;
    private int size;

    public ArrayIterator(E[] array) {
        this.reset(array);
    }

    public ArrayIterator(E[] array, int startPos, int endPos) {
        this.reset(array, startPos, endPos);
    }

    @Override
    public E next() {
        if (this.pos < this.size) {
            return this.sourceArray[this.pos++];
        }
        throw new NoSuchElementException("No more elements: " + this.pos + " / " + this.size);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.size;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset(E[] array) {
        this.sourceArray = array;
        this.size = array != null ? array.length : -1;
        this.pos = 0;
    }

    public void reset(E[] array, int startPos, int endPos) {
        this.pos = startPos;
        if (this.pos < 0) {
            throw new IllegalArgumentException("Position must greater or equal to 0!");
        }
        endPos = endPos < 0 ? array.length - startPos : Math.min(array.length - startPos, endPos);
        this.size = endPos;
    }

    public void reset(int startPos) {
        this.pos = startPos;
        if (this.pos < 0) {
            throw new IllegalArgumentException("Position must greater or equal to 0!");
        }
    }
}

