/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import kd.bos.orm.util.Assert;
import kd.fi.bd.util.iterators.IBufferContextWrapper;
import kd.fi.bd.util.iterators.impl.AbstractIteratorWrapper;
import kd.fi.bd.util.iterators.impl.ArrayBufferContextWrapper;

public class BaseBufferedIterator<E>
extends AbstractIteratorWrapper<Iterator<E>, E[]> {
    protected IBufferContextWrapper<E, E> _bufferContext;
    protected boolean needInitBuffer;
    protected int batchSize;
    protected boolean skipNullValue;

    protected BaseBufferedIterator(Iterator<E> sourceIterator, int batchSize, boolean skipNullValue) {
        super(sourceIterator);
        this.needInitBuffer = true;
        this.batchSize = batchSize;
        this.skipNullValue = skipNullValue;
    }

    public BaseBufferedIterator(Iterator<E> sourceIterator, int batchSize) {
        this(sourceIterator, batchSize, true);
    }

    public BaseBufferedIterator(Iterator<E> sourceIterator, IBufferContextWrapper<E, E> bufferContext, boolean skipNullValue) {
        super(sourceIterator);
        this._bufferContext = bufferContext;
        if (this._bufferContext == null) {
            throw new IllegalArgumentException("Buffer Context cannot be null!");
        }
        this.needInitBuffer = !this._bufferContext.isBufferInitialized();
        this.batchSize = bufferContext.getBufferSize();
        this.skipNullValue = skipNullValue;
    }

    public BaseBufferedIterator(Iterator<E> sourceIterator, IBufferContextWrapper<E, E> bufferContext) {
        this(sourceIterator, bufferContext, true);
    }

    @Override
    public boolean hasNext() {
        return this._hasValue && ((Iterator)this.valSource).hasNext();
    }

    protected boolean initBuffer(Class sourceVal) {
        this.needInitBuffer = false;
        this._bufferContext = new ArrayBufferContextWrapper<E, Object>((Object[])Array.newInstance(sourceVal, this.batchSize), this.skipNullValue);
        return true;
    }

    @Override
    public E[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements!");
        }
        while (((Iterator)this.valSource).hasNext()) {
            Object valBuffer = ((Iterator)this.valSource).next();
            if (valBuffer == null) continue;
            if (this.needInitBuffer) {
                this.initBuffer(valBuffer.getClass());
            }
            if (!this._bufferContext.addValue(valBuffer)) continue;
            break;
        }
        return this._bufferContext.resetToNextBatch();
    }

    public static void main(String[] args) {
        LinkedList<String> source = new LinkedList<String>();
        for (int i = 0; i < 10; ++i) {
            source.add("Test-" + i);
        }
        System.out.println("Test 1: Direct buffer");
        BaseBufferedIterator bufferedIterator = new BaseBufferedIterator(source.iterator(), 3);
        while (bufferedIterator.hasNext()) {
            Object[] buffer = (String[])bufferedIterator.next();
            Assert.notNull((Object)buffer);
            System.out.println(Arrays.deepToString(buffer));
        }
        System.out.println("\nTest 2: With Customized Buffer Context");
        ArrayBufferContextWrapper wrapper = new ArrayBufferContextWrapper(4);
        bufferedIterator = new BaseBufferedIterator(source.iterator(), wrapper);
        while (bufferedIterator.hasNext()) {
            Object[] buffer = (String[])bufferedIterator.next();
            Assert.notNull((Object)buffer);
            System.out.println(Arrays.deepToString(buffer));
        }
        System.out.println("\nTest3: Source is Empty");
        bufferedIterator = new BaseBufferedIterator(Collections.EMPTY_LIST.iterator(), 3);
        Assert.isTrue((!bufferedIterator.hasNext() ? 1 : 0) != 0);
        System.out.println("\nTest4: Source with equal size of batch");
        bufferedIterator = new BaseBufferedIterator(source.iterator(), 5);
        while (bufferedIterator.hasNext()) {
            Object[] buffer = (String[])bufferedIterator.next();
            Assert.notNull((Object)buffer);
            System.out.println(Arrays.deepToString(buffer));
        }
        System.out.println("\nTest5: Source with single batch");
        bufferedIterator = new BaseBufferedIterator(source.iterator(), 10);
        while (bufferedIterator.hasNext()) {
            Object[] buffer = (String[])bufferedIterator.next();
            Assert.notNull((Object)buffer);
            System.out.println(Arrays.deepToString(buffer));
        }
    }
}

